/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolray.seq;

import com.github.wolray.seq.Seq;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public interface Splitter {
    public Seq<String> split(String var1, int var2);

    public static Splitter of(char sep) {
        return (s, limit) -> c -> {
            char[] chars = s.toCharArray();
            int len = chars.length;
            int last = 0;
            int left = limit;
            for (int i = 0; i < len && left > 0; ++i) {
                if (chars[i] != sep) continue;
                c.accept(Splitter.substring(chars, last, i));
                last = i + 1;
                --left;
            }
            if (left > 0) {
                c.accept(Splitter.substring(chars, last, len));
            }
        };
    }

    public static Splitter of(Pattern sep) {
        return (s, limit) -> c -> {
            int left;
            char[] chars = s.toCharArray();
            Matcher matcher = sep.matcher(s);
            int beg = 0;
            for (left = limit; left > 0 && matcher.find(); --left) {
                c.accept(Splitter.substring(chars, beg, matcher.start()));
                beg = matcher.end();
            }
            if (left > 0) {
                c.accept(Splitter.substring(chars, beg, chars.length));
            }
        };
    }

    public static Splitter of(String literal) {
        return literal.length() == 1 ? Splitter.of(literal.charAt(0)) : (literal.isEmpty() ? Splitter.ofEmpty() : (s, limit) -> c -> {
            int index;
            int left;
            char[] chars = s.toCharArray();
            int beg = 0;
            int len = literal.length();
            for (left = limit; left > 0 && (index = s.indexOf(literal, beg)) > 0; --left) {
                c.accept(Splitter.substring(chars, beg, index));
                beg = index + len;
            }
            if (left > 0) {
                c.accept(Splitter.substring(chars, beg, chars.length));
            }
        });
    }

    public static Splitter ofEmpty() {
        return (s, limit) -> Seq.unit(s);
    }

    public static String substring(char[] chars, int start, int end) {
        return start < end ? new String(chars, start, end - start) : "";
    }

    default public Seq<String> split(String s) {
        return this.split(s, Integer.MAX_VALUE);
    }
}

