/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolray.seq;

import com.github.wolray.seq.Mutable;
import com.github.wolray.seq.Reducer;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

public interface Transducer<T, V, E> {
    public Reducer<T, V> reducer();

    public Function<V, E> transformer();

    public static <T, V, E> Transducer<T, V, E> of(Collector<T, V, E> collector) {
        return Transducer.of(Reducer.of(collector.supplier(), collector.accumulator()), collector.finisher());
    }

    public static <T> Transducer<T, ?, T> of(BinaryOperator<T> binaryOperator) {
        return Transducer.of(() -> new Mutable<Object>(null), (m, t) -> {
            if (m.isSet) {
                m.it = binaryOperator.apply(m.it, t);
            } else {
                m.set(t);
            }
        }, Mutable::get);
    }

    public static <T, V, E> Transducer<T, V, E> of(final Reducer<T, V> reducer, final Function<V, E> transformer) {
        return new Transducer<T, V, E>(){

            @Override
            public Reducer<T, V> reducer() {
                return reducer;
            }

            @Override
            public Function<V, E> transformer() {
                return transformer;
            }
        };
    }

    public static <T, V, E> Transducer<T, V, E> of(Supplier<V> supplier, BiConsumer<V, T> accumulator, Function<V, E> transformer) {
        return Transducer.of(Reducer.of(supplier, accumulator), transformer);
    }
}

