/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.identifier;

import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.RemoteException;
import android.os.SystemClock;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.ads.identifier.zzb;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.annotation.KeepForSdkWithMembers;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.zzf;
import com.google.android.gms.internal.zzfp;
import com.google.android.gms.internal.zzfq;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

@KeepForSdkWithMembers
public class AdvertisingIdClient {
    @Nullable
    private com.google.android.gms.common.zza zzams;
    @Nullable
    private zzfp zzamt;
    private boolean zzamu;
    private Object zzamv = new Object();
    @Nullable
    private zza zzamw;
    private final Context mContext;
    private boolean zzamx;
    private long zzamy;

    @Hide
    public AdvertisingIdClient(Context context) {
        this(context, 30000L, false, false);
    }

    @Hide
    public AdvertisingIdClient(Context context, long l2, boolean bl2, boolean bl3) {
        Context context2;
        zzbq.checkNotNull(context);
        this.mContext = bl2 ? ((context2 = context.getApplicationContext()) == null ? context : context2) : context;
        this.zzamu = false;
        this.zzamy = l2;
        this.zzamx = bl3;
    }

    @Hide
    public void start() throws IOException, IllegalStateException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        this.start(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Hide
    private final void start(boolean bl2) throws IOException, IllegalStateException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        zzbq.zzgw("Calling this from your main thread can lead to deadlock");
        AdvertisingIdClient advertisingIdClient = this;
        synchronized (advertisingIdClient) {
            if (this.zzamu) {
                this.finish();
            }
            this.zzams = AdvertisingIdClient.zzc(this.mContext, this.zzamx);
            this.zzamt = AdvertisingIdClient.zza(this.mContext, this.zzams);
            this.zzamu = true;
            if (bl2) {
                this.zzbm();
            }
            return;
        }
    }

    @Hide
    public static void setShouldSkipGmsCoreVersionCheck(boolean bl2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzbm() {
        Object object = this.zzamv;
        synchronized (object) {
            if (this.zzamw != null) {
                this.zzamw.zzanc.countDown();
                try {
                    this.zzamw.join();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.zzamy > 0L) {
                this.zzamw = new zza(this, this.zzamy);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Hide
    public Info getInfo() throws IOException {
        Info info;
        zzbq.zzgw("Calling this from your main thread can lead to deadlock");
        AdvertisingIdClient advertisingIdClient = this;
        synchronized (advertisingIdClient) {
            if (!this.zzamu) {
                Object object = this.zzamv;
                synchronized (object) {
                    if (this.zzamw == null || !this.zzamw.zzand) {
                        throw new IOException("AdvertisingIdClient is not connected.");
                    }
                }
                try {
                    this.start(false);
                }
                catch (Exception exception) {
                    throw new IOException("AdvertisingIdClient cannot reconnect.", exception);
                }
                if (!this.zzamu) {
                    throw new IOException("AdvertisingIdClient cannot reconnect.");
                }
            }
            zzbq.checkNotNull(this.zzams);
            zzbq.checkNotNull(this.zzamt);
            try {
                info = new Info(this.zzamt.getId(), this.zzamt.zzb(true));
            }
            catch (RemoteException remoteException) {
                Log.i((String)"AdvertisingIdClient", (String)"GMS remote exception ", (Throwable)remoteException);
                throw new IOException("Remote exception");
            }
        }
        this.zzbm();
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Hide
    public boolean getIsAdIdFakeForDebugLogging() throws IOException {
        boolean bl2;
        zzbq.zzgw("Calling this from your main thread can lead to deadlock");
        AdvertisingIdClient advertisingIdClient = this;
        synchronized (advertisingIdClient) {
            if (!this.zzamu) {
                Object object = this.zzamv;
                synchronized (object) {
                    if (this.zzamw == null || !this.zzamw.zzand) {
                        throw new IOException("AdvertisingIdClient is not connected.");
                    }
                }
                try {
                    this.start(false);
                }
                catch (Exception exception) {
                    throw new IOException("AdvertisingIdClient cannot reconnect.", exception);
                }
                if (!this.zzamu) {
                    throw new IOException("AdvertisingIdClient cannot reconnect.");
                }
            }
            zzbq.checkNotNull(this.zzams);
            zzbq.checkNotNull(this.zzamt);
            try {
                bl2 = this.zzamt.zzbn();
            }
            catch (RemoteException remoteException) {
                Log.i((String)"AdvertisingIdClient", (String)"GMS remote exception ", (Throwable)remoteException);
                throw new IOException("Remote exception");
            }
        }
        this.zzbm();
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Hide
    public void finish() {
        zzbq.zzgw("Calling this from your main thread can lead to deadlock");
        AdvertisingIdClient advertisingIdClient = this;
        synchronized (advertisingIdClient) {
            if (this.mContext == null || this.zzams == null) {
                return;
            }
            try {
                if (this.zzamu) {
                    com.google.android.gms.common.stats.zza.zzanm();
                    com.google.android.gms.common.zza zza2 = this.zzams;
                    Context context = this.mContext;
                    context.unbindService((ServiceConnection)zza2);
                }
            }
            catch (Throwable throwable) {
                Log.i((String)"AdvertisingIdClient", (String)"AdvertisingIdClient unbindService failed.", (Throwable)throwable);
            }
            this.zzamu = false;
            this.zzamt = null;
            this.zzams = null;
            return;
        }
    }

    @Hide
    protected void finalize() throws Throwable {
        this.finish();
        super.finalize();
    }

    private static com.google.android.gms.common.zza zzc(Context context, boolean bl2) throws IOException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        try {
            context.getPackageManager().getPackageInfo("com.android.vending", 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            throw new GooglePlayServicesNotAvailableException(9);
        }
        switch (zzf.zzahf().isGooglePlayServicesAvailable(context)) {
            case 0: 
            case 2: {
                break;
            }
            default: {
                throw new IOException("Google Play services not available");
            }
        }
        String string2 = bl2 ? "com.google.android.gms.ads.identifier.service.PERSISTENT_START" : "com.google.android.gms.ads.identifier.service.START";
        com.google.android.gms.common.zza zza2 = new com.google.android.gms.common.zza();
        Intent intent = new Intent(string2);
        intent.setPackage("com.google.android.gms");
        try {
            if (com.google.android.gms.common.stats.zza.zzanm().zza(context, intent, zza2, 1)) {
                return zza2;
            }
        }
        catch (Throwable throwable) {
            throw new IOException(throwable);
        }
        throw new IOException("Connection failure");
    }

    public static Info getAdvertisingIdInfo(Context context) throws IOException, IllegalStateException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        zzb zzb2 = new zzb(context);
        boolean bl2 = zzb2.getBoolean("gads:ad_id_app_context:enabled", false);
        float f2 = zzb2.getFloat("gads:ad_id_app_context:ping_ratio", 0.0f);
        String string2 = zzb2.getString("gads:ad_id_use_shared_preference:experiment_id", "");
        boolean bl3 = zzb2.getBoolean("gads:ad_id_use_persistent_service:enabled", false);
        AdvertisingIdClient advertisingIdClient = new AdvertisingIdClient(context, -1L, bl2, bl3);
        try {
            long l2 = SystemClock.elapsedRealtime();
            advertisingIdClient.start(false);
            Info info = advertisingIdClient.getInfo();
            long l3 = SystemClock.elapsedRealtime();
            advertisingIdClient.zza(info, bl2, f2, l3 - l2, string2, null);
            Info info2 = info;
            return info2;
        }
        catch (Throwable throwable) {
            advertisingIdClient.zza(null, bl2, f2, -1L, string2, throwable);
            throw throwable;
        }
        finally {
            advertisingIdClient.finish();
        }
    }

    @Hide
    public static boolean getIsAdIdFakeForDebugLogging(Context context) throws IOException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        zzb zzb2 = new zzb(context);
        boolean bl2 = zzb2.getBoolean("gads:ad_id_app_context:enabled", false);
        boolean bl3 = zzb2.getBoolean("com.google.android.gms.ads.identifier.service.PERSISTENT_START", false);
        AdvertisingIdClient advertisingIdClient = new AdvertisingIdClient(context, -1L, bl2, bl3);
        try {
            advertisingIdClient.start(false);
            boolean bl4 = advertisingIdClient.getIsAdIdFakeForDebugLogging();
            return bl4;
        }
        finally {
            advertisingIdClient.finish();
        }
    }

    private final boolean zza(Info info, boolean bl2, float f2, long l2, String string2, Throwable throwable) {
        if (Math.random() > (double)f2) {
            return false;
        }
        Throwable throwable2 = throwable;
        String string3 = string2;
        long l3 = l2;
        boolean bl3 = bl2;
        Info info2 = info;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("app_context", bl3 ? "1" : "0");
        if (info2 != null) {
            hashMap.put("limit_ad_tracking", info2.isLimitAdTrackingEnabled() ? "1" : "0");
        }
        if (info2 != null && info2.getId() != null) {
            hashMap.put("ad_id_size", Integer.toString(info2.getId().length()));
        }
        if (throwable2 != null) {
            hashMap.put("error", throwable2.getClass().getName());
        }
        if (string3 != null && !string3.isEmpty()) {
            hashMap.put("experiment_id", string3);
        }
        hashMap.put("tag", "AdvertisingIdClient");
        hashMap.put("time_spent", Long.toString(l3));
        HashMap<String, String> hashMap2 = hashMap;
        new com.google.android.gms.ads.identifier.zza(this, hashMap2).start();
        return true;
    }

    @Hide
    private static zzfp zza(Context context, com.google.android.gms.common.zza zza2) throws IOException {
        try {
            return zzfq.zzc(zza2.zza(10000L, TimeUnit.MILLISECONDS));
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("Interrupted exception");
        }
        catch (Throwable throwable) {
            throw new IOException(throwable);
        }
    }

    public static final class Info {
        private final String zzane;
        private final boolean zzanf;

        public Info(String string2, boolean bl2) {
            this.zzane = string2;
            this.zzanf = bl2;
        }

        public final String getId() {
            return this.zzane;
        }

        public final boolean isLimitAdTrackingEnabled() {
            return this.zzanf;
        }

        public final String toString() {
            String string2 = this.zzane;
            boolean bl2 = this.zzanf;
            return new StringBuilder(7 + String.valueOf(string2).length()).append("{").append(string2).append("}").append(bl2).toString();
        }
    }

    @Hide
    static final class zza
    extends Thread {
        private WeakReference<AdvertisingIdClient> zzana;
        private long zzanb;
        CountDownLatch zzanc;
        boolean zzand;

        public zza(AdvertisingIdClient advertisingIdClient, long l2) {
            this.zzana = new WeakReference<AdvertisingIdClient>(advertisingIdClient);
            this.zzanb = l2;
            this.zzanc = new CountDownLatch(1);
            this.zzand = false;
            this.start();
        }

        private final void disconnect() {
            AdvertisingIdClient advertisingIdClient = (AdvertisingIdClient)this.zzana.get();
            if (advertisingIdClient != null) {
                advertisingIdClient.finish();
                this.zzand = true;
            }
        }

        @Override
        public final void run() {
            try {
                if (!this.zzanc.await(this.zzanb, TimeUnit.MILLISECONDS)) {
                    this.disconnect();
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                this.disconnect();
                return;
            }
        }
    }
}

