/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.support.annotation.NonNull;
import android.util.Log;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.Hide;

public abstract class ResultCallbacks<R extends Result>
implements ResultCallback<R> {
    @Override
    @Hide
    @KeepForSdk
    public final void onResult(@NonNull R r2) {
        Status status = r2.getStatus();
        if (status.isSuccess()) {
            this.onSuccess(r2);
            return;
        }
        this.onFailure(status);
        if (r2 instanceof Releasable) {
            try {
                ((Releasable)r2).release();
                return;
            }
            catch (RuntimeException runtimeException) {
                String string2 = String.valueOf(r2);
                Log.w((String)"ResultCallbacks", (String)new StringBuilder(18 + String.valueOf(string2).length()).append("Unable to release ").append(string2).toString(), (Throwable)runtimeException);
            }
        }
    }

    public abstract void onSuccess(@NonNull R var1);

    public abstract void onFailure(@NonNull Status var1);
}

