/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.SystemClock;
import com.google.android.gms.internal.zza;
import com.google.android.gms.internal.zzab;
import com.google.android.gms.internal.zzac;
import com.google.android.gms.internal.zzad;
import com.google.android.gms.internal.zzae;
import com.google.android.gms.internal.zzaf;
import com.google.android.gms.internal.zzah;
import com.google.android.gms.internal.zzai;
import com.google.android.gms.internal.zzak;
import com.google.android.gms.internal.zzap;
import com.google.android.gms.internal.zzaq;
import com.google.android.gms.internal.zzar;
import com.google.android.gms.internal.zzau;
import com.google.android.gms.internal.zzc;
import com.google.android.gms.internal.zzg;
import com.google.android.gms.internal.zzl;
import com.google.android.gms.internal.zzm;
import com.google.android.gms.internal.zzo;
import com.google.android.gms.internal.zzp;
import com.google.android.gms.internal.zzq;
import com.google.android.gms.internal.zzr;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class zzaj
implements zzm {
    private static boolean DEBUG = zzaf.DEBUG;
    @Deprecated
    private zzar zzbo;
    private final zzai zzbp;
    private zzak zzbq;

    @Deprecated
    public zzaj(zzar zzar2) {
        this(zzar2, new zzak(4096));
    }

    @Deprecated
    private zzaj(zzar zzar2, zzak zzak2) {
        this.zzbo = zzar2;
        this.zzbp = new zzah(zzar2);
        this.zzbq = zzak2;
    }

    public zzaj(zzai zzai2) {
        this(zzai2, new zzak(4096));
    }

    private zzaj(zzai zzai2, zzak zzak2) {
        this.zzbp = zzai2;
        this.zzbo = zzai2;
        this.zzbq = zzak2;
    }

    @Override
    public zzp zzc(zzr<?> zzr2) throws zzae {
        long l2 = SystemClock.elapsedRealtime();
        while (true) {
            Object object;
            int n2;
            zzaq zzaq2 = null;
            byte[] byArray = null;
            List<zzl> list = Collections.emptyList();
            try {
                Object object2;
                Map<String, String> map;
                zzc zzc2 = zzr2.zze();
                if (zzc2 == null) {
                    map = Collections.emptyMap();
                } else {
                    object2 = new HashMap<String, String>();
                    if (zzc2.zza != null) {
                        object2.put("If-None-Match", zzc2.zza);
                    }
                    if (zzc2.zzc > 0L) {
                        object2.put((String)"If-Modified-Since", (String)zzap.zzb(zzc2.zzc));
                    }
                    map = object2;
                }
                Map<String, String> map2 = map;
                zzaq2 = this.zzbp.zza(zzr2, map2);
                n2 = zzaq2.getStatusCode();
                list = zzaq2.zzp();
                if (n2 == 304) {
                    object = zzr2.zze();
                    if (object == null) {
                        return new zzp(304, null, true, SystemClock.elapsedRealtime() - l2, list);
                    }
                    List<zzl> list2 = zzaj.zza(list, (zzc)object);
                    return new zzp(304, ((zzc)object).data, true, SystemClock.elapsedRealtime() - l2, list2);
                }
                object = zzaq2.getContent();
                byArray = object != null ? this.zza((InputStream)object, zzaq2.getContentLength()) : new byte[]{};
                int n3 = n2;
                byte[] byArray2 = byArray;
                object2 = zzr2;
                long l3 = SystemClock.elapsedRealtime() - l2;
                if (DEBUG || l3 > 3000L) {
                    zzaf.zzb("HTTP response for request=<%s> [lifetime=%d], [size=%s], [rc=%d], [retryCount=%s]", object2, l3, byArray2 != null ? Integer.valueOf(byArray2.length) : "null", n3, ((zzr)object2).zzi().zzc());
                }
                if (n2 < 200 || n2 > 299) {
                    throw new IOException();
                }
                return new zzp(n2, byArray, false, SystemClock.elapsedRealtime() - l2, list);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                zzaj.zza("socket", zzr2, new zzad());
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                String string2 = String.valueOf(zzr2.getUrl());
                throw new RuntimeException(string2.length() != 0 ? "Bad URL ".concat(string2) : new String("Bad URL "), malformedURLException);
            }
            catch (IOException iOException) {
                if (zzaq2 == null) {
                    throw new zzq(iOException);
                }
                n2 = zzaq2.getStatusCode();
                zzaf.zzc("Unexpected response code %d for %s", n2, zzr2.getUrl());
                if (byArray != null) {
                    object = new zzp(n2, byArray, false, SystemClock.elapsedRealtime() - l2, list);
                    if (n2 == 401 || n2 == 403) {
                        zzaj.zza("auth", zzr2, new zza((zzp)object));
                        continue;
                    }
                    if (n2 >= 400 && n2 <= 499) {
                        throw new zzg((zzp)object);
                    }
                    if (n2 >= 500 && n2 <= 599) {
                        throw new zzac((zzp)object);
                    }
                    throw new zzac((zzp)object);
                }
                zzaj.zza("network", zzr2, new zzo());
                continue;
            }
            break;
        }
    }

    private static void zza(String string2, zzr<?> zzr2, zzae zzae2) throws zzae {
        zzab zzab2 = zzr2.zzi();
        int n2 = zzr2.zzh();
        try {
            zzab2.zza(zzae2);
        }
        catch (zzae zzae3) {
            zzr2.zzb(String.format("%s-timeout-giveup [timeout=%s]", string2, n2));
            throw zzae3;
        }
        zzr2.zzb(String.format("%s-retry [timeout=%s]", string2, n2));
    }

    private final byte[] zza(InputStream inputStream, int n2) throws IOException, zzac {
        byte[] byArray;
        zzau zzau2 = new zzau(this.zzbq, n2);
        byte[] byArray2 = null;
        try {
            int n3;
            if (inputStream == null) {
                throw new zzac();
            }
            byArray2 = this.zzbq.zzb(1024);
            while ((n3 = inputStream.read(byArray2)) != -1) {
                zzau2.write(byArray2, 0, n3);
            }
            byArray = zzau2.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                zzaf.zza("Error occurred when closing InputStream", new Object[0]);
            }
            this.zzbq.zza(byArray2);
            zzau2.close();
            throw throwable;
        }
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            zzaf.zza("Error occurred when closing InputStream", new Object[0]);
        }
        this.zzbq.zza(byArray2);
        zzau2.close();
        return byArray;
    }

    private static List<zzl> zza(List<zzl> list, zzc zzc2) {
        ArrayList<zzl> arrayList;
        block6: {
            TreeSet<String> treeSet;
            block5: {
                treeSet = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
                if (!list.isEmpty()) {
                    for (zzl iterator : list) {
                        treeSet.add(iterator.getName());
                    }
                }
                arrayList = new ArrayList<zzl>(list);
                if (zzc2.zzg == null) break block5;
                if (zzc2.zzg.isEmpty()) break block6;
                for (zzl zzl2 : zzc2.zzg) {
                    if (treeSet.contains(zzl2.getName())) continue;
                    arrayList.add(zzl2);
                }
                break block6;
            }
            if (!zzc2.zzf.isEmpty()) {
                for (Map.Entry<String, String> entry : zzc2.zzf.entrySet()) {
                    if (treeSet.contains(entry.getKey())) continue;
                    arrayList.add(new zzl(entry.getKey(), entry.getValue()));
                }
            }
        }
        return arrayList;
    }
}

