/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzfll;
import com.google.android.gms.internal.zzfls;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;

public final class zzflk {
    private final ByteBuffer buffer;

    private zzflk(byte[] byArray, int n2, int n3) {
        this(ByteBuffer.wrap(byArray, n2, n3));
    }

    private zzflk(ByteBuffer byteBuffer) {
        this.buffer = byteBuffer;
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    public static zzflk zzbf(byte[] byArray) {
        return zzflk.zzp(byArray, 0, byArray.length);
    }

    public static zzflk zzp(byte[] byArray, int n2, int n3) {
        return new zzflk(byArray, 0, n3);
    }

    public final void zza(int n2, double d2) throws IOException {
        this.zzac(n2, 1);
        double d3 = d2;
        this.zzdk(Double.doubleToLongBits(d3));
    }

    public final void zzd(int n2, float f2) throws IOException {
        this.zzac(n2, 5);
        float f3 = f2;
        int n3 = Float.floatToIntBits(f3);
        zzflk zzflk2 = this;
        if (zzflk2.buffer.remaining() < 4) {
            throw new zzfll(zzflk2.buffer.position(), zzflk2.buffer.limit());
        }
        zzflk2.buffer.putInt(n3);
    }

    public final void zza(int n2, long l2) throws IOException {
        this.zzac(n2, 0);
        long l3 = l2;
        this.zzdi(l3);
    }

    public final void zzf(int n2, long l2) throws IOException {
        this.zzac(n2, 0);
        long l3 = l2;
        this.zzdi(l3);
    }

    public final void zzad(int n2, int n3) throws IOException {
        this.zzac(n2, 0);
        int n4 = n3;
        zzflk zzflk2 = this;
        if (n4 >= 0) {
            zzflk2.zzmy(n4);
            return;
        }
        zzflk2.zzdi(n4);
    }

    public final void zzb(int n2, long l2) throws IOException {
        this.zzac(n2, 1);
        long l3 = l2;
        this.zzdk(l3);
    }

    public final void zzl(int n2, boolean bl2) throws IOException {
        this.zzac(n2, 0);
        boolean bl3 = bl2;
        boolean bl4 = bl3;
        byte by2 = (byte)(bl4 ? 1 : 0);
        zzflk zzflk2 = this;
        if (!zzflk2.buffer.hasRemaining()) {
            throw new zzfll(zzflk2.buffer.position(), zzflk2.buffer.limit());
        }
        zzflk2.buffer.put(by2);
    }

    public final void zzp(int n2, String string2) throws IOException {
        this.zzac(n2, 2);
        String string3 = string2;
        zzflk zzflk2 = this;
        try {
            int n3 = zzflk.zzmf(string3.length());
            int n4 = zzflk.zzmf(string3.length() * 3);
            if (n3 == n4) {
                int n5 = zzflk2.buffer.position();
                if (zzflk2.buffer.remaining() < n3) {
                    throw new zzfll(n5 + n3, zzflk2.buffer.limit());
                }
                zzflk2.buffer.position(n5 + n3);
                zzflk.zza(string3, zzflk2.buffer);
                int n6 = zzflk2.buffer.position();
                zzflk2.buffer.position(n5);
                zzflk2.zzmy(n6 - n5 - n3);
                zzflk2.buffer.position(n6);
                return;
            }
            zzflk2.zzmy(zzflk.zzd(string3));
            zzflk.zza(string3, zzflk2.buffer);
            return;
        }
        catch (BufferOverflowException bufferOverflowException) {
            zzfll zzfll2 = new zzfll(zzflk2.buffer.position(), zzflk2.buffer.limit());
            zzfll2.initCause(bufferOverflowException);
            throw zzfll2;
        }
    }

    public final void zza(int n2, zzfls zzfls2) throws IOException {
        this.zzac(n2, 2);
        this.zzb(zzfls2);
    }

    public final void zzc(int n2, byte[] byArray) throws IOException {
        this.zzac(n2, 2);
        byte[] byArray2 = byArray;
        zzflk zzflk2 = this;
        zzflk2.zzmy(byArray2.length);
        zzflk2.zzbh(byArray2);
    }

    public final void zzg(int n2, long l2) throws IOException {
        this.zzac(n2, 0);
        long l3 = l2;
        this.zzdi(zzflk.zzdc(l3));
    }

    private static int zzd(CharSequence charSequence) {
        int n2;
        int n3;
        int n4 = n3 = charSequence.length();
        for (n2 = 0; n2 < n3 && charSequence.charAt(n2) < '\u0080'; ++n2) {
        }
        while (n2 < n3) {
            char c2 = charSequence.charAt(n2);
            if (c2 < '\u0800') {
                n4 += 127 - c2 >>> 31;
            } else {
                int n5 = n2;
                CharSequence charSequence2 = charSequence;
                int n6 = charSequence2.length();
                int n7 = 0;
                for (int i2 = n5; i2 < n6; ++i2) {
                    char c3 = charSequence2.charAt(i2);
                    if (c3 < '\u0800') {
                        n7 += 127 - c3 >>> 31;
                        continue;
                    }
                    n7 += 2;
                    if ('\ud800' > c3 || c3 > '\udfff') continue;
                    if (Character.codePointAt(charSequence2, i2) < 65536) {
                        int n8 = i2;
                        throw new IllegalArgumentException(new StringBuilder(39).append("Unpaired surrogate at index ").append(n8).toString());
                    }
                    ++i2;
                }
                n4 += n7;
                break;
            }
            ++n2;
        }
        if (n4 < n3) {
            long l2 = (long)n4 + 0x100000000L;
            throw new IllegalArgumentException(new StringBuilder(54).append("UTF-8 length does not fit in int: ").append(l2).toString());
        }
        return n4;
    }

    private static void zza(CharSequence charSequence, ByteBuffer byteBuffer) {
        if (byteBuffer.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        if (byteBuffer.hasArray()) {
            try {
                int n2 = zzflk.zza(charSequence, byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
                byteBuffer.position(n2 - byteBuffer.arrayOffset());
                return;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                BufferOverflowException bufferOverflowException = new BufferOverflowException();
                bufferOverflowException.initCause(arrayIndexOutOfBoundsException);
                throw bufferOverflowException;
            }
        }
        zzflk.zzb(charSequence, byteBuffer);
    }

    private static void zzb(CharSequence charSequence, ByteBuffer byteBuffer) {
        int n2 = charSequence.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3;
            char c2;
            char c3 = charSequence.charAt(i2);
            if (c3 < '\u0080') {
                byteBuffer.put((byte)c3);
                continue;
            }
            if (c3 < '\u0800') {
                byteBuffer.put((byte)(0x3C0 | c3 >>> 6));
                byteBuffer.put((byte)(0x80 | 0x3F & c3));
                continue;
            }
            if (c3 < '\ud800' || '\udfff' < c3) {
                byteBuffer.put((byte)(0x1E0 | c3 >>> 12));
                byteBuffer.put((byte)(0x80 | 0x3F & c3 >>> 6));
                byteBuffer.put((byte)(0x80 | 0x3F & c3));
                continue;
            }
            if (i2 + 1 == charSequence.length() || !Character.isSurrogatePair(c3, c2 = charSequence.charAt(++i2))) {
                n3 = i2 - 1;
                throw new IllegalArgumentException(new StringBuilder(39).append("Unpaired surrogate at index ").append(n3).toString());
            }
            n3 = Character.toCodePoint(c3, c2);
            byteBuffer.put((byte)(0xF0 | n3 >>> 18));
            byteBuffer.put((byte)(0x80 | 0x3F & n3 >>> 12));
            byteBuffer.put((byte)(0x80 | 0x3F & n3 >>> 6));
            byteBuffer.put((byte)(0x80 | 0x3F & n3));
        }
    }

    private static int zza(CharSequence charSequence, byte[] byArray, int n2, int n3) {
        char c2;
        int n4;
        int n5 = charSequence.length();
        int n6 = n2;
        int n7 = n2 + n3;
        for (n4 = 0; n4 < n5 && n4 + n6 < n7 && (c2 = charSequence.charAt(n4)) < '\u0080'; ++n4) {
            byArray[n6 + n4] = (byte)c2;
        }
        if (n4 == n5) {
            return n6 + n5;
        }
        n6 += n4;
        while (n4 < n5) {
            int n8;
            char c3;
            c2 = charSequence.charAt(n4);
            if (c2 < '\u0080' && n6 < n7) {
                byArray[n6++] = (byte)c2;
            } else if (c2 < '\u0800' && n6 <= n7 - 2) {
                byArray[n6++] = (byte)(0x3C0 | c2 >>> 6);
                byArray[n6++] = (byte)(0x80 | 0x3F & c2);
            } else if ((c2 < '\ud800' || '\udfff' < c2) && n6 <= n7 - 3) {
                byArray[n6++] = (byte)(0x1E0 | c2 >>> 12);
                byArray[n6++] = (byte)(0x80 | 0x3F & c2 >>> 6);
                byArray[n6++] = (byte)(0x80 | 0x3F & c2);
            } else if (n6 <= n7 - 4) {
                if (n4 + 1 == charSequence.length() || !Character.isSurrogatePair(c2, c3 = charSequence.charAt(++n4))) {
                    n8 = n4 - 1;
                    throw new IllegalArgumentException(new StringBuilder(39).append("Unpaired surrogate at index ").append(n8).toString());
                }
                n8 = Character.toCodePoint(c2, c3);
                byArray[n6++] = (byte)(0xF0 | n8 >>> 18);
                byArray[n6++] = (byte)(0x80 | 0x3F & n8 >>> 12);
                byArray[n6++] = (byte)(0x80 | 0x3F & n8 >>> 6);
                byArray[n6++] = (byte)(0x80 | 0x3F & n8);
            } else {
                c3 = c2;
                n8 = n6;
                throw new ArrayIndexOutOfBoundsException(new StringBuilder(37).append("Failed writing ").append(c3).append(" at index ").append(n8).toString());
            }
            ++n4;
        }
        return n6;
    }

    public final void zzb(zzfls zzfls2) throws IOException {
        this.zzmy(zzfls2.zzdcr());
        zzfls2.zza(this);
    }

    public static int zzc(int n2, long l2) {
        return zzflk.zzlw(n2) + zzflk.zzdj(l2);
    }

    public static int zzag(int n2, int n3) {
        return zzflk.zzlw(n2) + zzflk.zzlx(n3);
    }

    public static int zzq(int n2, String string2) {
        return zzflk.zzlw(n2) + zzflk.zztx(string2);
    }

    public static int zzb(int n2, zzfls zzfls2) {
        int n3 = zzfls2.zzhs();
        return zzflk.zzlw(n2) + (zzflk.zzmf(n3) + n3);
    }

    public static int zzd(int n2, byte[] byArray) {
        return zzflk.zzlw(n2) + zzflk.zzbg(byArray);
    }

    public static int zzh(int n2, long l2) {
        return zzflk.zzlw(n2) + zzflk.zzdj(zzflk.zzdc(l2));
    }

    public static int zzlx(int n2) {
        if (n2 >= 0) {
            return zzflk.zzmf(n2);
        }
        return 10;
    }

    public static int zztx(String string2) {
        int n2 = zzflk.zzd(string2);
        return zzflk.zzmf(n2) + n2;
    }

    public static int zzbg(byte[] byArray) {
        return zzflk.zzmf(byArray.length) + byArray.length;
    }

    public final void zzcyx() {
        if (this.buffer.remaining() != 0) {
            throw new IllegalStateException(String.format("Did not write as much data as expected, %s bytes remaining.", this.buffer.remaining()));
        }
    }

    private final void zzmx(int n2) throws IOException {
        byte by2 = (byte)n2;
        zzflk zzflk2 = this;
        if (!zzflk2.buffer.hasRemaining()) {
            throw new zzfll(zzflk2.buffer.position(), zzflk2.buffer.limit());
        }
        zzflk2.buffer.put(by2);
    }

    public final void zzbh(byte[] byArray) throws IOException {
        int n2 = byArray.length;
        byte[] byArray2 = byArray;
        zzflk zzflk2 = this;
        if (zzflk2.buffer.remaining() >= n2) {
            zzflk2.buffer.put(byArray2, 0, n2);
            return;
        }
        throw new zzfll(zzflk2.buffer.position(), zzflk2.buffer.limit());
    }

    public final void zzac(int n2, int n3) throws IOException {
        int n4 = n3;
        this.zzmy(n2 << 3 | n4);
    }

    public static int zzlw(int n2) {
        return zzflk.zzmf(n2 << 3);
    }

    public final void zzmy(int n2) throws IOException {
        while (true) {
            if ((n2 & 0xFFFFFF80) == 0) {
                this.zzmx(n2);
                return;
            }
            this.zzmx(n2 & 0x7F | 0x80);
            n2 >>>= 7;
        }
    }

    public static int zzmf(int n2) {
        if ((n2 & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((n2 & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((n2 & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n2 & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    private final void zzdi(long l2) throws IOException {
        while (true) {
            if ((l2 & 0xFFFFFFFFFFFFFF80L) == 0L) {
                this.zzmx((int)l2);
                return;
            }
            this.zzmx((int)l2 & 0x7F | 0x80);
            l2 >>>= 7;
        }
    }

    public static int zzdj(long l2) {
        if ((l2 & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if ((l2 & 0xFFFFFFFFFFFFC000L) == 0L) {
            return 2;
        }
        if ((l2 & 0xFFFFFFFFFFE00000L) == 0L) {
            return 3;
        }
        if ((l2 & 0xFFFFFFFFF0000000L) == 0L) {
            return 4;
        }
        if ((l2 & 0xFFFFFFF800000000L) == 0L) {
            return 5;
        }
        if ((l2 & 0xFFFFFC0000000000L) == 0L) {
            return 6;
        }
        if ((l2 & 0xFFFE000000000000L) == 0L) {
            return 7;
        }
        if ((l2 & 0xFF00000000000000L) == 0L) {
            return 8;
        }
        if ((l2 & Long.MIN_VALUE) == 0L) {
            return 9;
        }
        return 10;
    }

    private final void zzdk(long l2) throws IOException {
        if (this.buffer.remaining() < 8) {
            throw new zzfll(this.buffer.position(), this.buffer.limit());
        }
        this.buffer.putLong(l2);
    }

    public static int zzme(int n2) {
        return n2 << 1 ^ n2 >> 31;
    }

    private static long zzdc(long l2) {
        return l2 << 1 ^ l2 >> 63;
    }
}

