/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.BooleanArrayList;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.DoubleArrayList;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.FieldSet;
import com.google.protobuf.FloatArrayList;
import com.google.protobuf.GeneratedMessageLite;
import com.google.protobuf.IntArrayList;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.LongArrayList;
import com.google.protobuf.MessageLite;
import com.google.protobuf.MessageSchema;
import com.google.protobuf.Protobuf;
import com.google.protobuf.Schema;
import com.google.protobuf.SchemaUtil;
import com.google.protobuf.UnknownFieldSchema;
import com.google.protobuf.UnknownFieldSetLite;
import com.google.protobuf.Utf8;
import com.google.protobuf.WireFormat;
import java.io.IOException;
import java.util.List;

final class ArrayDecoders {
    ArrayDecoders() {
    }

    static int decodeVarint32(byte[] byArray, int n2, Registers registers) {
        int n3;
        if ((n3 = byArray[n2++]) >= 0) {
            registers.int1 = n3;
            return n2;
        }
        return ArrayDecoders.decodeVarint32(n3, byArray, n2, registers);
    }

    static int decodeVarint32(int n2, byte[] byArray, int n3, Registers registers) {
        byte by2;
        byte by3;
        byte by4;
        byte by5;
        int n4 = n2 & 0x7F;
        if ((by5 = byArray[n3++]) >= 0) {
            registers.int1 = n4 | by5 << 7;
            return n3;
        }
        n4 |= (by5 & 0x7F) << 7;
        if ((by4 = byArray[n3++]) >= 0) {
            registers.int1 = n4 | by4 << 14;
            return n3;
        }
        n4 |= (by4 & 0x7F) << 14;
        if ((by3 = byArray[n3++]) >= 0) {
            registers.int1 = n4 | by3 << 21;
            return n3;
        }
        n4 |= (by3 & 0x7F) << 21;
        if ((by2 = byArray[n3++]) >= 0) {
            registers.int1 = n4 | by2 << 28;
            return n3;
        }
        n4 |= (by2 & 0x7F) << 28;
        while (byArray[n3++] < 0) {
        }
        registers.int1 = n4;
        return n3;
    }

    static int decodeVarint64(byte[] byArray, int n2, Registers registers) {
        long l2;
        if ((l2 = (long)byArray[n2++]) >= 0L) {
            registers.long1 = l2;
            return n2;
        }
        return ArrayDecoders.decodeVarint64(l2, byArray, n2, registers);
    }

    static int decodeVarint64(long l2, byte[] byArray, int n2, Registers registers) {
        long l3 = l2 & 0x7FL;
        byte by2 = byArray[n2++];
        int n3 = 7;
        l3 |= (long)(by2 & 0x7F) << 7;
        while (by2 < 0) {
            by2 = byArray[n2++];
            l3 |= (long)(by2 & 0x7F) << (n3 += 7);
        }
        registers.long1 = l3;
        return n2;
    }

    static int decodeFixed32(byte[] byArray, int n2) {
        return byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8 | (byArray[n2 + 2] & 0xFF) << 16 | (byArray[n2 + 3] & 0xFF) << 24;
    }

    static long decodeFixed64(byte[] byArray, int n2) {
        return (long)byArray[n2] & 0xFFL | ((long)byArray[n2 + 1] & 0xFFL) << 8 | ((long)byArray[n2 + 2] & 0xFFL) << 16 | ((long)byArray[n2 + 3] & 0xFFL) << 24 | ((long)byArray[n2 + 4] & 0xFFL) << 32 | ((long)byArray[n2 + 5] & 0xFFL) << 40 | ((long)byArray[n2 + 6] & 0xFFL) << 48 | ((long)byArray[n2 + 7] & 0xFFL) << 56;
    }

    static double decodeDouble(byte[] byArray, int n2) {
        return Double.longBitsToDouble(ArrayDecoders.decodeFixed64(byArray, n2));
    }

    static float decodeFloat(byte[] byArray, int n2) {
        return Float.intBitsToFloat(ArrayDecoders.decodeFixed32(byArray, n2));
    }

    static int decodeString(byte[] byArray, int n2, Registers registers) throws InvalidProtocolBufferException {
        n2 = ArrayDecoders.decodeVarint32(byArray, n2, registers);
        int n3 = registers.int1;
        if (n3 < 0) {
            throw InvalidProtocolBufferException.negativeSize();
        }
        if (n3 == 0) {
            registers.object1 = "";
            return n2;
        }
        registers.object1 = new String(byArray, n2, n3, Internal.UTF_8);
        return n2 + n3;
    }

    static int decodeStringRequireUtf8(byte[] byArray, int n2, Registers registers) throws InvalidProtocolBufferException {
        n2 = ArrayDecoders.decodeVarint32(byArray, n2, registers);
        int n3 = registers.int1;
        if (n3 < 0) {
            throw InvalidProtocolBufferException.negativeSize();
        }
        if (n3 == 0) {
            registers.object1 = "";
            return n2;
        }
        registers.object1 = Utf8.decodeUtf8(byArray, n2, n3);
        return n2 + n3;
    }

    static int decodeBytes(byte[] byArray, int n2, Registers registers) throws InvalidProtocolBufferException {
        n2 = ArrayDecoders.decodeVarint32(byArray, n2, registers);
        int n3 = registers.int1;
        if (n3 < 0) {
            throw InvalidProtocolBufferException.negativeSize();
        }
        if (n3 > byArray.length - n2) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        if (n3 == 0) {
            registers.object1 = ByteString.EMPTY;
            return n2;
        }
        registers.object1 = ByteString.copyFrom(byArray, n2, n3);
        return n2 + n3;
    }

    static int decodeMessageField(Schema schema, byte[] byArray, int n2, int n3, Registers registers) throws IOException {
        int n4;
        if ((n4 = byArray[n2++]) < 0) {
            n2 = ArrayDecoders.decodeVarint32(n4, byArray, n2, registers);
            n4 = registers.int1;
        }
        if (n4 < 0 || n4 > n3 - n2) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        Object t2 = schema.newInstance();
        schema.mergeFrom(t2, byArray, n2, n2 + n4, registers);
        schema.makeImmutable(t2);
        registers.object1 = t2;
        return n2 + n4;
    }

    static int decodeGroupField(Schema schema, byte[] byArray, int n2, int n3, int n4, Registers registers) throws IOException {
        MessageSchema messageSchema = (MessageSchema)schema;
        Object t2 = messageSchema.newInstance();
        int n5 = messageSchema.parseProto2Message(t2, byArray, n2, n3, n4, registers);
        messageSchema.makeImmutable(t2);
        registers.object1 = t2;
        return n5;
    }

    static int decodeVarint32List(int n2, byte[] byArray, int n3, int n4, Internal.ProtobufList<?> protobufList, Registers registers) {
        IntArrayList intArrayList = (IntArrayList)protobufList;
        n3 = ArrayDecoders.decodeVarint32(byArray, n3, registers);
        intArrayList.addInt(registers.int1);
        while (n3 < n4) {
            int n5 = ArrayDecoders.decodeVarint32(byArray, n3, registers);
            if (n2 != registers.int1) break;
            n3 = ArrayDecoders.decodeVarint32(byArray, n5, registers);
            intArrayList.addInt(registers.int1);
        }
        return n3;
    }

    static int decodeVarint64List(int n2, byte[] byArray, int n3, int n4, Internal.ProtobufList<?> protobufList, Registers registers) {
        LongArrayList longArrayList = (LongArrayList)protobufList;
        n3 = ArrayDecoders.decodeVarint64(byArray, n3, registers);
        longArrayList.addLong(registers.long1);
        while (n3 < n4) {
            int n5 = ArrayDecoders.decodeVarint32(byArray, n3, registers);
            if (n2 != registers.int1) break;
            n3 = ArrayDecoders.decodeVarint64(byArray, n5, registers);
            longArrayList.addLong(registers.long1);
        }
        return n3;
    }

    static int decodeFixed32List(int n2, byte[] byArray, int n3, int n4, Internal.ProtobufList<?> protobufList, Registers registers) {
        IntArrayList intArrayList = (IntArrayList)protobufList;
        intArrayList.addInt(ArrayDecoders.decodeFixed32(byArray, n3));
        n3 += 4;
        while (n3 < n4) {
            int n5 = ArrayDecoders.decodeVarint32(byArray, n3, registers);
            if (n2 != registers.int1) break;
            intArrayList.addInt(ArrayDecoders.decodeFixed32(byArray, n5));
            n3 = n5 + 4;
        }
        return n3;
    }

    static int decodeFixed64List(int n2, byte[] byArray, int n3, int n4, Internal.ProtobufList<?> protobufList, Registers registers) {
        LongArrayList longArrayList = (LongArrayList)protobufList;
        longArrayList.addLong(ArrayDecoders.decodeFixed64(byArray, n3));
        n3 += 8;
        while (n3 < n4) {
            int n5 = ArrayDecoders.decodeVarint32(byArray, n3, registers);
            if (n2 != registers.int1) break;
            longArrayList.addLong(ArrayDecoders.decodeFixed64(byArray, n5));
            n3 = n5 + 8;
        }
        return n3;
    }

    static int decodeFloatList(int n2, byte[] byArray, int n3, int n4, Internal.ProtobufList<?> protobufList, Registers registers) {
        FloatArrayList floatArrayList = (FloatArrayList)protobufList;
        floatArrayList.addFloat(ArrayDecoders.decodeFloat(byArray, n3));
        n3 += 4;
        while (n3 < n4) {
            int n5 = ArrayDecoders.decodeVarint32(byArray, n3, registers);
            if (n2 != registers.int1) break;
            floatArrayList.addFloat(ArrayDecoders.decodeFloat(byArray, n5));
            n3 = n5 + 4;
        }
        return n3;
    }

    static int decodeDoubleList(int n2, byte[] byArray, int n3, int n4, Internal.ProtobufList<?> protobufList, Registers registers) {
        DoubleArrayList doubleArrayList = (DoubleArrayList)protobufList;
        doubleArrayList.addDouble(ArrayDecoders.decodeDouble(byArray, n3));
        n3 += 8;
        while (n3 < n4) {
            int n5 = ArrayDecoders.decodeVarint32(byArray, n3, registers);
            if (n2 != registers.int1) break;
            doubleArrayList.addDouble(ArrayDecoders.decodeDouble(byArray, n5));
            n3 = n5 + 8;
        }
        return n3;
    }

    static int decodeBoolList(int n2, byte[] byArray, int n3, int n4, Internal.ProtobufList<?> protobufList, Registers registers) {
        BooleanArrayList booleanArrayList = (BooleanArrayList)protobufList;
        n3 = ArrayDecoders.decodeVarint64(byArray, n3, registers);
        booleanArrayList.addBoolean(registers.long1 != 0L);
        while (n3 < n4) {
            int n5 = ArrayDecoders.decodeVarint32(byArray, n3, registers);
            if (n2 != registers.int1) break;
            n3 = ArrayDecoders.decodeVarint64(byArray, n5, registers);
            booleanArrayList.addBoolean(registers.long1 != 0L);
        }
        return n3;
    }

    static int decodeSInt32List(int n2, byte[] byArray, int n3, int n4, Internal.ProtobufList<?> protobufList, Registers registers) {
        IntArrayList intArrayList = (IntArrayList)protobufList;
        n3 = ArrayDecoders.decodeVarint32(byArray, n3, registers);
        intArrayList.addInt(CodedInputStream.decodeZigZag32(registers.int1));
        while (n3 < n4) {
            int n5 = ArrayDecoders.decodeVarint32(byArray, n3, registers);
            if (n2 != registers.int1) break;
            n3 = ArrayDecoders.decodeVarint32(byArray, n5, registers);
            intArrayList.addInt(CodedInputStream.decodeZigZag32(registers.int1));
        }
        return n3;
    }

    static int decodeSInt64List(int n2, byte[] byArray, int n3, int n4, Internal.ProtobufList<?> protobufList, Registers registers) {
        LongArrayList longArrayList = (LongArrayList)protobufList;
        n3 = ArrayDecoders.decodeVarint64(byArray, n3, registers);
        longArrayList.addLong(CodedInputStream.decodeZigZag64(registers.long1));
        while (n3 < n4) {
            int n5 = ArrayDecoders.decodeVarint32(byArray, n3, registers);
            if (n2 != registers.int1) break;
            n3 = ArrayDecoders.decodeVarint64(byArray, n5, registers);
            longArrayList.addLong(CodedInputStream.decodeZigZag64(registers.long1));
        }
        return n3;
    }

    static int decodePackedVarint32List(byte[] byArray, int n2, Internal.ProtobufList<?> protobufList, Registers registers) throws IOException {
        IntArrayList intArrayList = (IntArrayList)protobufList;
        n2 = ArrayDecoders.decodeVarint32(byArray, n2, registers);
        int n3 = n2 + registers.int1;
        while (n2 < n3) {
            n2 = ArrayDecoders.decodeVarint32(byArray, n2, registers);
            intArrayList.addInt(registers.int1);
        }
        if (n2 != n3) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        return n2;
    }

    static int decodePackedVarint64List(byte[] byArray, int n2, Internal.ProtobufList<?> protobufList, Registers registers) throws IOException {
        LongArrayList longArrayList = (LongArrayList)protobufList;
        n2 = ArrayDecoders.decodeVarint32(byArray, n2, registers);
        int n3 = n2 + registers.int1;
        while (n2 < n3) {
            n2 = ArrayDecoders.decodeVarint64(byArray, n2, registers);
            longArrayList.addLong(registers.long1);
        }
        if (n2 != n3) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        return n2;
    }

    static int decodePackedFixed32List(byte[] byArray, int n2, Internal.ProtobufList<?> protobufList, Registers registers) throws IOException {
        IntArrayList intArrayList = (IntArrayList)protobufList;
        int n3 = n2 + registers.int1;
        for (n2 = ArrayDecoders.decodeVarint32(byArray, n2, registers); n2 < n3; n2 += 4) {
            intArrayList.addInt(ArrayDecoders.decodeFixed32(byArray, n2));
        }
        if (n2 != n3) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        return n2;
    }

    static int decodePackedFixed64List(byte[] byArray, int n2, Internal.ProtobufList<?> protobufList, Registers registers) throws IOException {
        LongArrayList longArrayList = (LongArrayList)protobufList;
        int n3 = n2 + registers.int1;
        for (n2 = ArrayDecoders.decodeVarint32(byArray, n2, registers); n2 < n3; n2 += 8) {
            longArrayList.addLong(ArrayDecoders.decodeFixed64(byArray, n2));
        }
        if (n2 != n3) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        return n2;
    }

    static int decodePackedFloatList(byte[] byArray, int n2, Internal.ProtobufList<?> protobufList, Registers registers) throws IOException {
        FloatArrayList floatArrayList = (FloatArrayList)protobufList;
        int n3 = n2 + registers.int1;
        for (n2 = ArrayDecoders.decodeVarint32(byArray, n2, registers); n2 < n3; n2 += 4) {
            floatArrayList.addFloat(ArrayDecoders.decodeFloat(byArray, n2));
        }
        if (n2 != n3) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        return n2;
    }

    static int decodePackedDoubleList(byte[] byArray, int n2, Internal.ProtobufList<?> protobufList, Registers registers) throws IOException {
        DoubleArrayList doubleArrayList = (DoubleArrayList)protobufList;
        int n3 = n2 + registers.int1;
        for (n2 = ArrayDecoders.decodeVarint32(byArray, n2, registers); n2 < n3; n2 += 8) {
            doubleArrayList.addDouble(ArrayDecoders.decodeDouble(byArray, n2));
        }
        if (n2 != n3) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        return n2;
    }

    static int decodePackedBoolList(byte[] byArray, int n2, Internal.ProtobufList<?> protobufList, Registers registers) throws IOException {
        BooleanArrayList booleanArrayList = (BooleanArrayList)protobufList;
        n2 = ArrayDecoders.decodeVarint32(byArray, n2, registers);
        int n3 = n2 + registers.int1;
        while (n2 < n3) {
            n2 = ArrayDecoders.decodeVarint64(byArray, n2, registers);
            booleanArrayList.addBoolean(registers.long1 != 0L);
        }
        if (n2 != n3) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        return n2;
    }

    static int decodePackedSInt32List(byte[] byArray, int n2, Internal.ProtobufList<?> protobufList, Registers registers) throws IOException {
        IntArrayList intArrayList = (IntArrayList)protobufList;
        n2 = ArrayDecoders.decodeVarint32(byArray, n2, registers);
        int n3 = n2 + registers.int1;
        while (n2 < n3) {
            n2 = ArrayDecoders.decodeVarint32(byArray, n2, registers);
            intArrayList.addInt(CodedInputStream.decodeZigZag32(registers.int1));
        }
        if (n2 != n3) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        return n2;
    }

    static int decodePackedSInt64List(byte[] byArray, int n2, Internal.ProtobufList<?> protobufList, Registers registers) throws IOException {
        LongArrayList longArrayList = (LongArrayList)protobufList;
        n2 = ArrayDecoders.decodeVarint32(byArray, n2, registers);
        int n3 = n2 + registers.int1;
        while (n2 < n3) {
            n2 = ArrayDecoders.decodeVarint64(byArray, n2, registers);
            longArrayList.addLong(CodedInputStream.decodeZigZag64(registers.long1));
        }
        if (n2 != n3) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        return n2;
    }

    static int decodeStringList(int n2, byte[] byArray, int n3, int n4, Internal.ProtobufList<?> protobufList, Registers registers) throws InvalidProtocolBufferException {
        Internal.ProtobufList<?> protobufList2 = protobufList;
        n3 = ArrayDecoders.decodeVarint32(byArray, n3, registers);
        int n5 = registers.int1;
        if (n5 < 0) {
            throw InvalidProtocolBufferException.negativeSize();
        }
        if (n5 == 0) {
            protobufList2.add("");
        } else {
            String string2 = new String(byArray, n3, n5, Internal.UTF_8);
            protobufList2.add(string2);
            n3 += n5;
        }
        while (n3 < n4) {
            int n6 = ArrayDecoders.decodeVarint32(byArray, n3, registers);
            if (n2 != registers.int1) break;
            n3 = ArrayDecoders.decodeVarint32(byArray, n6, registers);
            int n7 = registers.int1;
            if (n7 < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            if (n7 == 0) {
                protobufList2.add("");
                continue;
            }
            String string3 = new String(byArray, n3, n7, Internal.UTF_8);
            protobufList2.add(string3);
            n3 += n7;
        }
        return n3;
    }

    static int decodeStringListRequireUtf8(int n2, byte[] byArray, int n3, int n4, Internal.ProtobufList<?> protobufList, Registers registers) throws InvalidProtocolBufferException {
        Internal.ProtobufList<?> protobufList2 = protobufList;
        n3 = ArrayDecoders.decodeVarint32(byArray, n3, registers);
        int n5 = registers.int1;
        if (n5 < 0) {
            throw InvalidProtocolBufferException.negativeSize();
        }
        if (n5 == 0) {
            protobufList2.add("");
        } else {
            if (!Utf8.isValidUtf8(byArray, n3, n3 + n5)) {
                throw InvalidProtocolBufferException.invalidUtf8();
            }
            String string2 = new String(byArray, n3, n5, Internal.UTF_8);
            protobufList2.add(string2);
            n3 += n5;
        }
        while (n3 < n4) {
            int n6 = ArrayDecoders.decodeVarint32(byArray, n3, registers);
            if (n2 != registers.int1) break;
            n3 = ArrayDecoders.decodeVarint32(byArray, n6, registers);
            int n7 = registers.int1;
            if (n7 < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            if (n7 == 0) {
                protobufList2.add("");
                continue;
            }
            if (!Utf8.isValidUtf8(byArray, n3, n3 + n7)) {
                throw InvalidProtocolBufferException.invalidUtf8();
            }
            String string3 = new String(byArray, n3, n7, Internal.UTF_8);
            protobufList2.add(string3);
            n3 += n7;
        }
        return n3;
    }

    static int decodeBytesList(int n2, byte[] byArray, int n3, int n4, Internal.ProtobufList<?> protobufList, Registers registers) throws InvalidProtocolBufferException {
        Internal.ProtobufList<?> protobufList2 = protobufList;
        n3 = ArrayDecoders.decodeVarint32(byArray, n3, registers);
        int n5 = registers.int1;
        if (n5 < 0) {
            throw InvalidProtocolBufferException.negativeSize();
        }
        if (n5 > byArray.length - n3) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        if (n5 == 0) {
            protobufList2.add(ByteString.EMPTY);
        } else {
            protobufList2.add(ByteString.copyFrom(byArray, n3, n5));
            n3 += n5;
        }
        while (n3 < n4) {
            int n6 = ArrayDecoders.decodeVarint32(byArray, n3, registers);
            if (n2 != registers.int1) break;
            n3 = ArrayDecoders.decodeVarint32(byArray, n6, registers);
            int n7 = registers.int1;
            if (n7 < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            if (n7 > byArray.length - n3) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            if (n7 == 0) {
                protobufList2.add(ByteString.EMPTY);
                continue;
            }
            protobufList2.add(ByteString.copyFrom(byArray, n3, n7));
            n3 += n7;
        }
        return n3;
    }

    static int decodeMessageList(Schema<?> schema, int n2, byte[] byArray, int n3, int n4, Internal.ProtobufList<?> protobufList, Registers registers) throws IOException {
        Internal.ProtobufList<?> protobufList2 = protobufList;
        n3 = ArrayDecoders.decodeMessageField(schema, byArray, n3, n4, registers);
        protobufList2.add(registers.object1);
        while (n3 < n4) {
            int n5 = ArrayDecoders.decodeVarint32(byArray, n3, registers);
            if (n2 != registers.int1) break;
            n3 = ArrayDecoders.decodeMessageField(schema, byArray, n5, n4, registers);
            protobufList2.add(registers.object1);
        }
        return n3;
    }

    static int decodeGroupList(Schema schema, int n2, byte[] byArray, int n3, int n4, Internal.ProtobufList<?> protobufList, Registers registers) throws IOException {
        Internal.ProtobufList<?> protobufList2 = protobufList;
        int n5 = n2 & 0xFFFFFFF8 | 4;
        n3 = ArrayDecoders.decodeGroupField(schema, byArray, n3, n4, n5, registers);
        protobufList2.add(registers.object1);
        while (n3 < n4) {
            int n6 = ArrayDecoders.decodeVarint32(byArray, n3, registers);
            if (n2 != registers.int1) break;
            n3 = ArrayDecoders.decodeGroupField(schema, byArray, n6, n4, n5, registers);
            protobufList2.add(registers.object1);
        }
        return n3;
    }

    static int decodeExtensionOrUnknownField(int n2, byte[] byArray, int n3, int n4, Object object, MessageLite messageLite, UnknownFieldSchema<UnknownFieldSetLite, UnknownFieldSetLite> unknownFieldSchema, Registers registers) throws IOException {
        int n5 = n2 >>> 3;
        GeneratedMessageLite.GeneratedExtension<MessageLite, ?> generatedExtension = registers.extensionRegistry.findLiteExtensionByNumber(messageLite, n5);
        if (generatedExtension == null) {
            return ArrayDecoders.decodeUnknownField(n2, byArray, n3, n4, MessageSchema.getMutableUnknownFields(object), registers);
        }
        ((GeneratedMessageLite.ExtendableMessage)object).ensureExtensionsAreMutable();
        return ArrayDecoders.decodeExtension(n2, byArray, n3, n4, (GeneratedMessageLite.ExtendableMessage)object, generatedExtension, unknownFieldSchema, registers);
    }

    static int decodeExtension(int n2, byte[] byArray, int n3, int n4, GeneratedMessageLite.ExtendableMessage<?, ?> extendableMessage, GeneratedMessageLite.GeneratedExtension<?, ?> generatedExtension, UnknownFieldSchema<UnknownFieldSetLite, UnknownFieldSetLite> unknownFieldSchema, Registers registers) throws IOException {
        block40: {
            int n5;
            FieldSet<GeneratedMessageLite.ExtensionDescriptor> fieldSet;
            block39: {
                fieldSet = extendableMessage.extensions;
                n5 = n2 >>> 3;
                if (!generatedExtension.descriptor.isRepeated() || !generatedExtension.descriptor.isPacked()) break block39;
                switch (generatedExtension.getLiteType()) {
                    case DOUBLE: {
                        DoubleArrayList doubleArrayList = new DoubleArrayList();
                        n3 = ArrayDecoders.decodePackedDoubleList(byArray, n3, doubleArrayList, registers);
                        fieldSet.setField(generatedExtension.descriptor, doubleArrayList);
                        break block40;
                    }
                    case FLOAT: {
                        FloatArrayList floatArrayList = new FloatArrayList();
                        n3 = ArrayDecoders.decodePackedFloatList(byArray, n3, floatArrayList, registers);
                        fieldSet.setField(generatedExtension.descriptor, floatArrayList);
                        break block40;
                    }
                    case INT64: 
                    case UINT64: {
                        LongArrayList longArrayList = new LongArrayList();
                        n3 = ArrayDecoders.decodePackedVarint64List(byArray, n3, longArrayList, registers);
                        fieldSet.setField(generatedExtension.descriptor, longArrayList);
                        break block40;
                    }
                    case INT32: 
                    case UINT32: {
                        IntArrayList intArrayList = new IntArrayList();
                        n3 = ArrayDecoders.decodePackedVarint32List(byArray, n3, intArrayList, registers);
                        fieldSet.setField(generatedExtension.descriptor, intArrayList);
                        break block40;
                    }
                    case FIXED64: 
                    case SFIXED64: {
                        LongArrayList longArrayList = new LongArrayList();
                        n3 = ArrayDecoders.decodePackedFixed64List(byArray, n3, longArrayList, registers);
                        fieldSet.setField(generatedExtension.descriptor, longArrayList);
                        break block40;
                    }
                    case FIXED32: 
                    case SFIXED32: {
                        IntArrayList intArrayList = new IntArrayList();
                        n3 = ArrayDecoders.decodePackedFixed32List(byArray, n3, intArrayList, registers);
                        fieldSet.setField(generatedExtension.descriptor, intArrayList);
                        break block40;
                    }
                    case BOOL: {
                        BooleanArrayList booleanArrayList = new BooleanArrayList();
                        n3 = ArrayDecoders.decodePackedBoolList(byArray, n3, booleanArrayList, registers);
                        fieldSet.setField(generatedExtension.descriptor, booleanArrayList);
                        break block40;
                    }
                    case SINT32: {
                        IntArrayList intArrayList = new IntArrayList();
                        n3 = ArrayDecoders.decodePackedSInt32List(byArray, n3, intArrayList, registers);
                        fieldSet.setField(generatedExtension.descriptor, intArrayList);
                        break block40;
                    }
                    case SINT64: {
                        LongArrayList longArrayList = new LongArrayList();
                        n3 = ArrayDecoders.decodePackedSInt64List(byArray, n3, longArrayList, registers);
                        fieldSet.setField(generatedExtension.descriptor, longArrayList);
                        break block40;
                    }
                    case ENUM: {
                        IntArrayList intArrayList = new IntArrayList();
                        n3 = ArrayDecoders.decodePackedVarint32List(byArray, n3, intArrayList, registers);
                        UnknownFieldSetLite unknownFieldSetLite = extendableMessage.unknownFields;
                        if (unknownFieldSetLite == UnknownFieldSetLite.getDefaultInstance()) {
                            unknownFieldSetLite = null;
                        }
                        if ((unknownFieldSetLite = SchemaUtil.filterUnknownEnumList(n5, (List<Integer>)intArrayList, generatedExtension.descriptor.getEnumType(), unknownFieldSetLite, unknownFieldSchema)) != null) {
                            extendableMessage.unknownFields = unknownFieldSetLite;
                        }
                        fieldSet.setField(generatedExtension.descriptor, intArrayList);
                        break block40;
                    }
                    default: {
                        throw new IllegalStateException("Type cannot be packed: " + (Object)((Object)generatedExtension.descriptor.getLiteType()));
                    }
                }
            }
            Object object = null;
            if (generatedExtension.getLiteType() == WireFormat.FieldType.ENUM) {
                n3 = ArrayDecoders.decodeVarint32(byArray, n3, registers);
                Object obj = generatedExtension.descriptor.getEnumType().findValueByNumber(registers.int1);
                if (obj == null) {
                    UnknownFieldSetLite unknownFieldSetLite = extendableMessage.unknownFields;
                    if (unknownFieldSetLite == UnknownFieldSetLite.getDefaultInstance()) {
                        extendableMessage.unknownFields = unknownFieldSetLite = UnknownFieldSetLite.newInstance();
                    }
                    SchemaUtil.storeUnknownEnum(n5, registers.int1, unknownFieldSetLite, unknownFieldSchema);
                    return n3;
                }
                object = registers.int1;
            } else {
                switch (generatedExtension.getLiteType()) {
                    case DOUBLE: {
                        object = ArrayDecoders.decodeDouble(byArray, n3);
                        n3 += 8;
                        break;
                    }
                    case FLOAT: {
                        object = Float.valueOf(ArrayDecoders.decodeFloat(byArray, n3));
                        n3 += 4;
                        break;
                    }
                    case INT64: 
                    case UINT64: {
                        n3 = ArrayDecoders.decodeVarint64(byArray, n3, registers);
                        object = registers.long1;
                        break;
                    }
                    case INT32: 
                    case UINT32: {
                        n3 = ArrayDecoders.decodeVarint32(byArray, n3, registers);
                        object = registers.int1;
                        break;
                    }
                    case FIXED64: 
                    case SFIXED64: {
                        object = ArrayDecoders.decodeFixed64(byArray, n3);
                        n3 += 8;
                        break;
                    }
                    case FIXED32: 
                    case SFIXED32: {
                        object = ArrayDecoders.decodeFixed32(byArray, n3);
                        n3 += 4;
                        break;
                    }
                    case BOOL: {
                        n3 = ArrayDecoders.decodeVarint64(byArray, n3, registers);
                        object = registers.long1 != 0L;
                        break;
                    }
                    case BYTES: {
                        n3 = ArrayDecoders.decodeBytes(byArray, n3, registers);
                        object = registers.object1;
                        break;
                    }
                    case SINT32: {
                        n3 = ArrayDecoders.decodeVarint32(byArray, n3, registers);
                        object = CodedInputStream.decodeZigZag32(registers.int1);
                        break;
                    }
                    case SINT64: {
                        n3 = ArrayDecoders.decodeVarint64(byArray, n3, registers);
                        object = CodedInputStream.decodeZigZag64(registers.long1);
                        break;
                    }
                    case STRING: {
                        n3 = ArrayDecoders.decodeString(byArray, n3, registers);
                        object = registers.object1;
                        break;
                    }
                    case GROUP: {
                        int n6 = n5 << 3 | 4;
                        n3 = ArrayDecoders.decodeGroupField(Protobuf.getInstance().schemaFor(generatedExtension.getMessageDefaultInstance().getClass()), byArray, n3, n4, n6, registers);
                        object = registers.object1;
                        break;
                    }
                    case MESSAGE: {
                        n3 = ArrayDecoders.decodeMessageField(Protobuf.getInstance().schemaFor(generatedExtension.getMessageDefaultInstance().getClass()), byArray, n3, n4, registers);
                        object = registers.object1;
                        break;
                    }
                    case ENUM: {
                        throw new IllegalStateException("Shouldn't reach here.");
                    }
                }
            }
            if (generatedExtension.isRepeated()) {
                fieldSet.addRepeatedField(generatedExtension.descriptor, object);
            } else {
                switch (generatedExtension.getLiteType()) {
                    case GROUP: 
                    case MESSAGE: {
                        Object object2 = fieldSet.getField(generatedExtension.descriptor);
                        if (object2 == null) break;
                        object = Internal.mergeMessage(object2, object);
                        break;
                    }
                }
                fieldSet.setField(generatedExtension.descriptor, object);
            }
        }
        return n3;
    }

    static int decodeUnknownField(int n2, byte[] byArray, int n3, int n4, UnknownFieldSetLite unknownFieldSetLite, Registers registers) throws InvalidProtocolBufferException {
        if (WireFormat.getTagFieldNumber(n2) == 0) {
            throw InvalidProtocolBufferException.invalidTag();
        }
        switch (WireFormat.getTagWireType(n2)) {
            case 0: {
                n3 = ArrayDecoders.decodeVarint64(byArray, n3, registers);
                unknownFieldSetLite.storeField(n2, registers.long1);
                return n3;
            }
            case 5: {
                unknownFieldSetLite.storeField(n2, ArrayDecoders.decodeFixed32(byArray, n3));
                return n3 + 4;
            }
            case 1: {
                unknownFieldSetLite.storeField(n2, ArrayDecoders.decodeFixed64(byArray, n3));
                return n3 + 8;
            }
            case 2: {
                n3 = ArrayDecoders.decodeVarint32(byArray, n3, registers);
                int n5 = registers.int1;
                if (n5 < 0) {
                    throw InvalidProtocolBufferException.negativeSize();
                }
                if (n5 > byArray.length - n3) {
                    throw InvalidProtocolBufferException.truncatedMessage();
                }
                if (n5 == 0) {
                    unknownFieldSetLite.storeField(n2, ByteString.EMPTY);
                } else {
                    unknownFieldSetLite.storeField(n2, ByteString.copyFrom(byArray, n3, n5));
                }
                return n3 + n5;
            }
            case 3: {
                UnknownFieldSetLite unknownFieldSetLite2 = UnknownFieldSetLite.newInstance();
                int n6 = n2 & 0xFFFFFFF8 | 4;
                int n7 = 0;
                while (n3 < n4) {
                    n3 = ArrayDecoders.decodeVarint32(byArray, n3, registers);
                    n7 = registers.int1;
                    if (n7 == n6) break;
                    n3 = ArrayDecoders.decodeUnknownField(n7, byArray, n3, n4, unknownFieldSetLite2, registers);
                }
                if (n3 > n4 || n7 != n6) {
                    throw InvalidProtocolBufferException.parseFailure();
                }
                unknownFieldSetLite.storeField(n2, unknownFieldSetLite2);
                return n3;
            }
        }
        throw InvalidProtocolBufferException.invalidTag();
    }

    static int skipField(int n2, byte[] byArray, int n3, int n4, Registers registers) throws InvalidProtocolBufferException {
        if (WireFormat.getTagFieldNumber(n2) == 0) {
            throw InvalidProtocolBufferException.invalidTag();
        }
        switch (WireFormat.getTagWireType(n2)) {
            case 0: {
                n3 = ArrayDecoders.decodeVarint64(byArray, n3, registers);
                return n3;
            }
            case 5: {
                return n3 + 4;
            }
            case 1: {
                return n3 + 8;
            }
            case 2: {
                n3 = ArrayDecoders.decodeVarint32(byArray, n3, registers);
                return n3 + registers.int1;
            }
            case 3: {
                int n5 = n2 & 0xFFFFFFF8 | 4;
                int n6 = 0;
                while (n3 < n4) {
                    n3 = ArrayDecoders.decodeVarint32(byArray, n3, registers);
                    n6 = registers.int1;
                    if (n6 == n5) break;
                    n3 = ArrayDecoders.skipField(n6, byArray, n3, n4, registers);
                }
                if (n3 > n4 || n6 != n5) {
                    throw InvalidProtocolBufferException.parseFailure();
                }
                return n3;
            }
        }
        throw InvalidProtocolBufferException.invalidTag();
    }

    static final class Registers {
        public int int1;
        public long long1;
        public Object object1;
        public final ExtensionRegistryLite extensionRegistry;

        Registers() {
            this.extensionRegistry = ExtensionRegistryLite.getEmptyRegistry();
        }

        Registers(ExtensionRegistryLite extensionRegistryLite) {
            if (extensionRegistryLite == null) {
                throw new NullPointerException();
            }
            this.extensionRegistry = extensionRegistryLite;
        }
    }
}

