/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.AllocatedBuffer;
import com.google.protobuf.BooleanArrayList;
import com.google.protobuf.BufferAllocator;
import com.google.protobuf.ByteOutput;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.DoubleArrayList;
import com.google.protobuf.FloatArrayList;
import com.google.protobuf.IntArrayList;
import com.google.protobuf.Internal;
import com.google.protobuf.LazyStringList;
import com.google.protobuf.LongArrayList;
import com.google.protobuf.MapEntryLite;
import com.google.protobuf.Protobuf;
import com.google.protobuf.Schema;
import com.google.protobuf.UnsafeUtil;
import com.google.protobuf.Utf8;
import com.google.protobuf.WireFormat;
import com.google.protobuf.Writer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Map;
import java.util.Queue;

abstract class BinaryWriter
extends ByteOutput
implements Writer {
    public static final int DEFAULT_CHUNK_SIZE = 4096;
    private final BufferAllocator alloc;
    private final int chunkSize;
    final ArrayDeque<AllocatedBuffer> buffers = new ArrayDeque(4);
    int totalDoneBytes;
    private static final int MAP_KEY_NUMBER = 1;
    private static final int MAP_VALUE_NUMBER = 2;

    public static BinaryWriter newHeapInstance(BufferAllocator bufferAllocator) {
        return BinaryWriter.newHeapInstance(bufferAllocator, 4096);
    }

    public static BinaryWriter newHeapInstance(BufferAllocator bufferAllocator, int n2) {
        return BinaryWriter.isUnsafeHeapSupported() ? BinaryWriter.newUnsafeHeapInstance(bufferAllocator, n2) : BinaryWriter.newSafeHeapInstance(bufferAllocator, n2);
    }

    public static BinaryWriter newDirectInstance(BufferAllocator bufferAllocator) {
        return BinaryWriter.newDirectInstance(bufferAllocator, 4096);
    }

    public static BinaryWriter newDirectInstance(BufferAllocator bufferAllocator, int n2) {
        return BinaryWriter.isUnsafeDirectSupported() ? BinaryWriter.newUnsafeDirectInstance(bufferAllocator, n2) : BinaryWriter.newSafeDirectInstance(bufferAllocator, n2);
    }

    static boolean isUnsafeHeapSupported() {
        return UnsafeHeapWriter.isSupported();
    }

    static boolean isUnsafeDirectSupported() {
        return UnsafeDirectWriter.isSupported();
    }

    static BinaryWriter newSafeHeapInstance(BufferAllocator bufferAllocator, int n2) {
        return new SafeHeapWriter(bufferAllocator, n2);
    }

    static BinaryWriter newUnsafeHeapInstance(BufferAllocator bufferAllocator, int n2) {
        if (!BinaryWriter.isUnsafeHeapSupported()) {
            throw new UnsupportedOperationException("Unsafe operations not supported");
        }
        return new UnsafeHeapWriter(bufferAllocator, n2);
    }

    static BinaryWriter newSafeDirectInstance(BufferAllocator bufferAllocator, int n2) {
        return new SafeDirectWriter(bufferAllocator, n2);
    }

    static BinaryWriter newUnsafeDirectInstance(BufferAllocator bufferAllocator, int n2) {
        if (!BinaryWriter.isUnsafeDirectSupported()) {
            throw new UnsupportedOperationException("Unsafe operations not supported");
        }
        return new UnsafeDirectWriter(bufferAllocator, n2);
    }

    private BinaryWriter(BufferAllocator bufferAllocator, int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("chunkSize must be > 0");
        }
        this.alloc = Internal.checkNotNull(bufferAllocator, "alloc");
        this.chunkSize = n2;
    }

    @Override
    public final Writer.FieldOrder fieldOrder() {
        return Writer.FieldOrder.DESCENDING;
    }

    public final Queue<AllocatedBuffer> complete() {
        this.finishCurrentBuffer();
        return this.buffers;
    }

    @Override
    public final void writeSFixed32(int n2, int n3) throws IOException {
        this.writeFixed32(n2, n3);
    }

    @Override
    public final void writeInt64(int n2, long l2) throws IOException {
        this.writeUInt64(n2, l2);
    }

    @Override
    public final void writeSFixed64(int n2, long l2) throws IOException {
        this.writeFixed64(n2, l2);
    }

    @Override
    public final void writeFloat(int n2, float f2) throws IOException {
        this.writeFixed32(n2, Float.floatToRawIntBits(f2));
    }

    @Override
    public final void writeDouble(int n2, double d2) throws IOException {
        this.writeFixed64(n2, Double.doubleToRawLongBits(d2));
    }

    @Override
    public final void writeEnum(int n2, int n3) throws IOException {
        this.writeInt32(n2, n3);
    }

    @Override
    public final void writeInt32List(int n2, List<Integer> list, boolean bl2) throws IOException {
        if (list instanceof IntArrayList) {
            this.writeInt32List_Internal(n2, (IntArrayList)list, bl2);
        } else {
            this.writeInt32List_Internal(n2, list, bl2);
        }
    }

    private final void writeInt32List_Internal(int n2, List<Integer> list, boolean bl2) throws IOException {
        if (bl2) {
            int n3;
            this.requireSpace(10 + list.size() * 10);
            int n4 = this.getTotalBytesWritten();
            for (n3 = list.size() - 1; n3 >= 0; --n3) {
                this.writeInt32(list.get(n3));
            }
            n3 = this.getTotalBytesWritten() - n4;
            this.writeVarint32(n3);
            this.writeTag(n2, 2);
        } else {
            for (int i2 = list.size() - 1; i2 >= 0; --i2) {
                this.writeInt32(n2, list.get(i2));
            }
        }
    }

    private final void writeInt32List_Internal(int n2, IntArrayList intArrayList, boolean bl2) throws IOException {
        if (bl2) {
            int n3;
            this.requireSpace(10 + intArrayList.size() * 10);
            int n4 = this.getTotalBytesWritten();
            for (n3 = intArrayList.size() - 1; n3 >= 0; --n3) {
                this.writeInt32(intArrayList.getInt(n3));
            }
            n3 = this.getTotalBytesWritten() - n4;
            this.writeVarint32(n3);
            this.writeTag(n2, 2);
        } else {
            for (int i2 = intArrayList.size() - 1; i2 >= 0; --i2) {
                this.writeInt32(n2, intArrayList.getInt(i2));
            }
        }
    }

    @Override
    public final void writeFixed32List(int n2, List<Integer> list, boolean bl2) throws IOException {
        if (list instanceof IntArrayList) {
            this.writeFixed32List_Internal(n2, (IntArrayList)list, bl2);
        } else {
            this.writeFixed32List_Internal(n2, list, bl2);
        }
    }

    private final void writeFixed32List_Internal(int n2, List<Integer> list, boolean bl2) throws IOException {
        if (bl2) {
            int n3;
            this.requireSpace(10 + list.size() * 4);
            int n4 = this.getTotalBytesWritten();
            for (n3 = list.size() - 1; n3 >= 0; --n3) {
                this.writeFixed32(list.get(n3));
            }
            n3 = this.getTotalBytesWritten() - n4;
            this.writeVarint32(n3);
            this.writeTag(n2, 2);
        } else {
            for (int i2 = list.size() - 1; i2 >= 0; --i2) {
                this.writeFixed32(n2, list.get(i2));
            }
        }
    }

    private final void writeFixed32List_Internal(int n2, IntArrayList intArrayList, boolean bl2) throws IOException {
        if (bl2) {
            int n3;
            this.requireSpace(10 + intArrayList.size() * 4);
            int n4 = this.getTotalBytesWritten();
            for (n3 = intArrayList.size() - 1; n3 >= 0; --n3) {
                this.writeFixed32(intArrayList.getInt(n3));
            }
            n3 = this.getTotalBytesWritten() - n4;
            this.writeVarint32(n3);
            this.writeTag(n2, 2);
        } else {
            for (int i2 = intArrayList.size() - 1; i2 >= 0; --i2) {
                this.writeFixed32(n2, intArrayList.getInt(i2));
            }
        }
    }

    @Override
    public final void writeInt64List(int n2, List<Long> list, boolean bl2) throws IOException {
        this.writeUInt64List(n2, list, bl2);
    }

    @Override
    public final void writeUInt64List(int n2, List<Long> list, boolean bl2) throws IOException {
        if (list instanceof LongArrayList) {
            this.writeUInt64List_Internal(n2, (LongArrayList)list, bl2);
        } else {
            this.writeUInt64List_Internal(n2, list, bl2);
        }
    }

    private final void writeUInt64List_Internal(int n2, List<Long> list, boolean bl2) throws IOException {
        if (bl2) {
            int n3;
            this.requireSpace(10 + list.size() * 10);
            int n4 = this.getTotalBytesWritten();
            for (n3 = list.size() - 1; n3 >= 0; --n3) {
                this.writeVarint64(list.get(n3));
            }
            n3 = this.getTotalBytesWritten() - n4;
            this.writeVarint32(n3);
            this.writeTag(n2, 2);
        } else {
            for (int i2 = list.size() - 1; i2 >= 0; --i2) {
                this.writeUInt64(n2, list.get(i2));
            }
        }
    }

    private final void writeUInt64List_Internal(int n2, LongArrayList longArrayList, boolean bl2) throws IOException {
        if (bl2) {
            int n3;
            this.requireSpace(10 + longArrayList.size() * 10);
            int n4 = this.getTotalBytesWritten();
            for (n3 = longArrayList.size() - 1; n3 >= 0; --n3) {
                this.writeVarint64(longArrayList.getLong(n3));
            }
            n3 = this.getTotalBytesWritten() - n4;
            this.writeVarint32(n3);
            this.writeTag(n2, 2);
        } else {
            for (int i2 = longArrayList.size() - 1; i2 >= 0; --i2) {
                this.writeUInt64(n2, longArrayList.getLong(i2));
            }
        }
    }

    @Override
    public final void writeFixed64List(int n2, List<Long> list, boolean bl2) throws IOException {
        if (list instanceof LongArrayList) {
            this.writeFixed64List_Internal(n2, (LongArrayList)list, bl2);
        } else {
            this.writeFixed64List_Internal(n2, list, bl2);
        }
    }

    private final void writeFixed64List_Internal(int n2, List<Long> list, boolean bl2) throws IOException {
        if (bl2) {
            int n3;
            this.requireSpace(10 + list.size() * 8);
            int n4 = this.getTotalBytesWritten();
            for (n3 = list.size() - 1; n3 >= 0; --n3) {
                this.writeFixed64(list.get(n3));
            }
            n3 = this.getTotalBytesWritten() - n4;
            this.writeVarint32(n3);
            this.writeTag(n2, 2);
        } else {
            for (int i2 = list.size() - 1; i2 >= 0; --i2) {
                this.writeFixed64(n2, list.get(i2));
            }
        }
    }

    private final void writeFixed64List_Internal(int n2, LongArrayList longArrayList, boolean bl2) throws IOException {
        if (bl2) {
            int n3;
            this.requireSpace(10 + longArrayList.size() * 8);
            int n4 = this.getTotalBytesWritten();
            for (n3 = longArrayList.size() - 1; n3 >= 0; --n3) {
                this.writeFixed64(longArrayList.getLong(n3));
            }
            n3 = this.getTotalBytesWritten() - n4;
            this.writeVarint32(n3);
            this.writeTag(n2, 2);
        } else {
            for (int i2 = longArrayList.size() - 1; i2 >= 0; --i2) {
                this.writeFixed64(n2, longArrayList.getLong(i2));
            }
        }
    }

    @Override
    public final void writeFloatList(int n2, List<Float> list, boolean bl2) throws IOException {
        if (list instanceof FloatArrayList) {
            this.writeFloatList_Internal(n2, (FloatArrayList)list, bl2);
        } else {
            this.writeFloatList_Internal(n2, list, bl2);
        }
    }

    private final void writeFloatList_Internal(int n2, List<Float> list, boolean bl2) throws IOException {
        if (bl2) {
            int n3;
            this.requireSpace(10 + list.size() * 4);
            int n4 = this.getTotalBytesWritten();
            for (n3 = list.size() - 1; n3 >= 0; --n3) {
                this.writeFixed32(Float.floatToRawIntBits(list.get(n3).floatValue()));
            }
            n3 = this.getTotalBytesWritten() - n4;
            this.writeVarint32(n3);
            this.writeTag(n2, 2);
        } else {
            for (int i2 = list.size() - 1; i2 >= 0; --i2) {
                this.writeFloat(n2, list.get(i2).floatValue());
            }
        }
    }

    private final void writeFloatList_Internal(int n2, FloatArrayList floatArrayList, boolean bl2) throws IOException {
        if (bl2) {
            int n3;
            this.requireSpace(10 + floatArrayList.size() * 4);
            int n4 = this.getTotalBytesWritten();
            for (n3 = floatArrayList.size() - 1; n3 >= 0; --n3) {
                this.writeFixed32(Float.floatToRawIntBits(floatArrayList.getFloat(n3)));
            }
            n3 = this.getTotalBytesWritten() - n4;
            this.writeVarint32(n3);
            this.writeTag(n2, 2);
        } else {
            for (int i2 = floatArrayList.size() - 1; i2 >= 0; --i2) {
                this.writeFloat(n2, floatArrayList.getFloat(i2));
            }
        }
    }

    @Override
    public final void writeDoubleList(int n2, List<Double> list, boolean bl2) throws IOException {
        if (list instanceof DoubleArrayList) {
            this.writeDoubleList_Internal(n2, (DoubleArrayList)list, bl2);
        } else {
            this.writeDoubleList_Internal(n2, list, bl2);
        }
    }

    private final void writeDoubleList_Internal(int n2, List<Double> list, boolean bl2) throws IOException {
        if (bl2) {
            int n3;
            this.requireSpace(10 + list.size() * 8);
            int n4 = this.getTotalBytesWritten();
            for (n3 = list.size() - 1; n3 >= 0; --n3) {
                this.writeFixed64(Double.doubleToRawLongBits(list.get(n3)));
            }
            n3 = this.getTotalBytesWritten() - n4;
            this.writeVarint32(n3);
            this.writeTag(n2, 2);
        } else {
            for (int i2 = list.size() - 1; i2 >= 0; --i2) {
                this.writeDouble(n2, list.get(i2));
            }
        }
    }

    private final void writeDoubleList_Internal(int n2, DoubleArrayList doubleArrayList, boolean bl2) throws IOException {
        if (bl2) {
            int n3;
            this.requireSpace(10 + doubleArrayList.size() * 8);
            int n4 = this.getTotalBytesWritten();
            for (n3 = doubleArrayList.size() - 1; n3 >= 0; --n3) {
                this.writeFixed64(Double.doubleToRawLongBits(doubleArrayList.getDouble(n3)));
            }
            n3 = this.getTotalBytesWritten() - n4;
            this.writeVarint32(n3);
            this.writeTag(n2, 2);
        } else {
            for (int i2 = doubleArrayList.size() - 1; i2 >= 0; --i2) {
                this.writeDouble(n2, doubleArrayList.getDouble(i2));
            }
        }
    }

    @Override
    public final void writeEnumList(int n2, List<Integer> list, boolean bl2) throws IOException {
        this.writeInt32List(n2, list, bl2);
    }

    @Override
    public final void writeBoolList(int n2, List<Boolean> list, boolean bl2) throws IOException {
        if (list instanceof BooleanArrayList) {
            this.writeBoolList_Internal(n2, (BooleanArrayList)list, bl2);
        } else {
            this.writeBoolList_Internal(n2, list, bl2);
        }
    }

    private final void writeBoolList_Internal(int n2, List<Boolean> list, boolean bl2) throws IOException {
        if (bl2) {
            int n3;
            this.requireSpace(10 + list.size());
            int n4 = this.getTotalBytesWritten();
            for (n3 = list.size() - 1; n3 >= 0; --n3) {
                this.writeBool(list.get(n3));
            }
            n3 = this.getTotalBytesWritten() - n4;
            this.writeVarint32(n3);
            this.writeTag(n2, 2);
        } else {
            for (int i2 = list.size() - 1; i2 >= 0; --i2) {
                this.writeBool(n2, list.get(i2));
            }
        }
    }

    private final void writeBoolList_Internal(int n2, BooleanArrayList booleanArrayList, boolean bl2) throws IOException {
        if (bl2) {
            int n3;
            this.requireSpace(10 + booleanArrayList.size());
            int n4 = this.getTotalBytesWritten();
            for (n3 = booleanArrayList.size() - 1; n3 >= 0; --n3) {
                this.writeBool(booleanArrayList.getBoolean(n3));
            }
            n3 = this.getTotalBytesWritten() - n4;
            this.writeVarint32(n3);
            this.writeTag(n2, 2);
        } else {
            for (int i2 = booleanArrayList.size() - 1; i2 >= 0; --i2) {
                this.writeBool(n2, booleanArrayList.getBoolean(i2));
            }
        }
    }

    @Override
    public final void writeStringList(int n2, List<String> list) throws IOException {
        if (list instanceof LazyStringList) {
            LazyStringList lazyStringList = (LazyStringList)list;
            for (int i2 = list.size() - 1; i2 >= 0; --i2) {
                this.writeLazyString(n2, lazyStringList.getRaw(i2));
            }
        } else {
            for (int i3 = list.size() - 1; i3 >= 0; --i3) {
                this.writeString(n2, list.get(i3));
            }
        }
    }

    private void writeLazyString(int n2, Object object) throws IOException {
        if (object instanceof String) {
            this.writeString(n2, (String)object);
        } else {
            this.writeBytes(n2, (ByteString)object);
        }
    }

    @Override
    public final void writeBytesList(int n2, List<ByteString> list) throws IOException {
        for (int i2 = list.size() - 1; i2 >= 0; --i2) {
            this.writeBytes(n2, list.get(i2));
        }
    }

    @Override
    public final void writeUInt32List(int n2, List<Integer> list, boolean bl2) throws IOException {
        if (list instanceof IntArrayList) {
            this.writeUInt32List_Internal(n2, (IntArrayList)list, bl2);
        } else {
            this.writeUInt32List_Internal(n2, list, bl2);
        }
    }

    private final void writeUInt32List_Internal(int n2, List<Integer> list, boolean bl2) throws IOException {
        if (bl2) {
            int n3;
            this.requireSpace(10 + list.size() * 5);
            int n4 = this.getTotalBytesWritten();
            for (n3 = list.size() - 1; n3 >= 0; --n3) {
                this.writeVarint32(list.get(n3));
            }
            n3 = this.getTotalBytesWritten() - n4;
            this.writeVarint32(n3);
            this.writeTag(n2, 2);
        } else {
            for (int i2 = list.size() - 1; i2 >= 0; --i2) {
                this.writeUInt32(n2, list.get(i2));
            }
        }
    }

    private final void writeUInt32List_Internal(int n2, IntArrayList intArrayList, boolean bl2) throws IOException {
        if (bl2) {
            int n3;
            this.requireSpace(10 + intArrayList.size() * 5);
            int n4 = this.getTotalBytesWritten();
            for (n3 = intArrayList.size() - 1; n3 >= 0; --n3) {
                this.writeVarint32(intArrayList.getInt(n3));
            }
            n3 = this.getTotalBytesWritten() - n4;
            this.writeVarint32(n3);
            this.writeTag(n2, 2);
        } else {
            for (int i2 = intArrayList.size() - 1; i2 >= 0; --i2) {
                this.writeUInt32(n2, intArrayList.getInt(i2));
            }
        }
    }

    @Override
    public final void writeSFixed32List(int n2, List<Integer> list, boolean bl2) throws IOException {
        this.writeFixed32List(n2, list, bl2);
    }

    @Override
    public final void writeSFixed64List(int n2, List<Long> list, boolean bl2) throws IOException {
        this.writeFixed64List(n2, list, bl2);
    }

    @Override
    public final void writeSInt32List(int n2, List<Integer> list, boolean bl2) throws IOException {
        if (list instanceof IntArrayList) {
            this.writeSInt32List_Internal(n2, (IntArrayList)list, bl2);
        } else {
            this.writeSInt32List_Internal(n2, list, bl2);
        }
    }

    private final void writeSInt32List_Internal(int n2, List<Integer> list, boolean bl2) throws IOException {
        if (bl2) {
            int n3;
            this.requireSpace(10 + list.size() * 5);
            int n4 = this.getTotalBytesWritten();
            for (n3 = list.size() - 1; n3 >= 0; --n3) {
                this.writeSInt32(list.get(n3));
            }
            n3 = this.getTotalBytesWritten() - n4;
            this.writeVarint32(n3);
            this.writeTag(n2, 2);
        } else {
            for (int i2 = list.size() - 1; i2 >= 0; --i2) {
                this.writeSInt32(n2, list.get(i2));
            }
        }
    }

    private final void writeSInt32List_Internal(int n2, IntArrayList intArrayList, boolean bl2) throws IOException {
        if (bl2) {
            int n3;
            this.requireSpace(10 + intArrayList.size() * 5);
            int n4 = this.getTotalBytesWritten();
            for (n3 = intArrayList.size() - 1; n3 >= 0; --n3) {
                this.writeSInt32(intArrayList.getInt(n3));
            }
            n3 = this.getTotalBytesWritten() - n4;
            this.writeVarint32(n3);
            this.writeTag(n2, 2);
        } else {
            for (int i2 = intArrayList.size() - 1; i2 >= 0; --i2) {
                this.writeSInt32(n2, intArrayList.getInt(i2));
            }
        }
    }

    @Override
    public final void writeSInt64List(int n2, List<Long> list, boolean bl2) throws IOException {
        if (list instanceof LongArrayList) {
            this.writeSInt64List_Internal(n2, (LongArrayList)list, bl2);
        } else {
            this.writeSInt64List_Internal(n2, list, bl2);
        }
    }

    @Override
    public <K, V> void writeMap(int n2, MapEntryLite.Metadata<K, V> metadata, Map<K, V> map) throws IOException {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            int n3 = this.getTotalBytesWritten();
            BinaryWriter.writeMapEntryField(this, 2, metadata.valueType, entry.getValue());
            BinaryWriter.writeMapEntryField(this, 1, metadata.keyType, entry.getKey());
            int n4 = this.getTotalBytesWritten() - n3;
            this.writeVarint32(n4);
            this.writeTag(n2, 2);
        }
    }

    static final void writeMapEntryField(Writer writer, int n2, WireFormat.FieldType fieldType, Object object) throws IOException {
        switch (fieldType) {
            case BOOL: {
                writer.writeBool(n2, (Boolean)object);
                break;
            }
            case FIXED32: {
                writer.writeFixed32(n2, (Integer)object);
                break;
            }
            case FIXED64: {
                writer.writeFixed64(n2, (Long)object);
                break;
            }
            case INT32: {
                writer.writeInt32(n2, (Integer)object);
                break;
            }
            case INT64: {
                writer.writeInt64(n2, (Long)object);
                break;
            }
            case SFIXED32: {
                writer.writeSFixed32(n2, (Integer)object);
                break;
            }
            case SFIXED64: {
                writer.writeSFixed64(n2, (Long)object);
                break;
            }
            case SINT32: {
                writer.writeSInt32(n2, (Integer)object);
                break;
            }
            case SINT64: {
                writer.writeSInt64(n2, (Long)object);
                break;
            }
            case STRING: {
                writer.writeString(n2, (String)object);
                break;
            }
            case UINT32: {
                writer.writeUInt32(n2, (Integer)object);
                break;
            }
            case UINT64: {
                writer.writeUInt64(n2, (Long)object);
                break;
            }
            case FLOAT: {
                writer.writeFloat(n2, ((Float)object).floatValue());
                break;
            }
            case DOUBLE: {
                writer.writeDouble(n2, (Double)object);
                break;
            }
            case MESSAGE: {
                writer.writeMessage(n2, object);
                break;
            }
            case BYTES: {
                writer.writeBytes(n2, (ByteString)object);
                break;
            }
            case ENUM: {
                if (object instanceof Internal.EnumLite) {
                    writer.writeEnum(n2, ((Internal.EnumLite)object).getNumber());
                    break;
                }
                if (object instanceof Integer) {
                    writer.writeEnum(n2, (Integer)object);
                    break;
                }
                throw new IllegalArgumentException("Unexpected type for enum in map.");
            }
            default: {
                throw new IllegalArgumentException("Unsupported map value type for: " + (Object)((Object)fieldType));
            }
        }
    }

    private final void writeSInt64List_Internal(int n2, List<Long> list, boolean bl2) throws IOException {
        if (bl2) {
            int n3;
            this.requireSpace(10 + list.size() * 10);
            int n4 = this.getTotalBytesWritten();
            for (n3 = list.size() - 1; n3 >= 0; --n3) {
                this.writeSInt64(list.get(n3));
            }
            n3 = this.getTotalBytesWritten() - n4;
            this.writeVarint32(n3);
            this.writeTag(n2, 2);
        } else {
            for (int i2 = list.size() - 1; i2 >= 0; --i2) {
                this.writeSInt64(n2, list.get(i2));
            }
        }
    }

    private final void writeSInt64List_Internal(int n2, LongArrayList longArrayList, boolean bl2) throws IOException {
        if (bl2) {
            int n3;
            this.requireSpace(10 + longArrayList.size() * 10);
            int n4 = this.getTotalBytesWritten();
            for (n3 = longArrayList.size() - 1; n3 >= 0; --n3) {
                this.writeSInt64(longArrayList.getLong(n3));
            }
            n3 = this.getTotalBytesWritten() - n4;
            this.writeVarint32(n3);
            this.writeTag(n2, 2);
        } else {
            for (int i2 = longArrayList.size() - 1; i2 >= 0; --i2) {
                this.writeSInt64(n2, longArrayList.getLong(i2));
            }
        }
    }

    @Override
    public final void writeMessageList(int n2, List<?> list) throws IOException {
        for (int i2 = list.size() - 1; i2 >= 0; --i2) {
            this.writeMessage(n2, list.get(i2));
        }
    }

    @Override
    public final void writeMessageList(int n2, List<?> list, Schema schema) throws IOException {
        for (int i2 = list.size() - 1; i2 >= 0; --i2) {
            this.writeMessage(n2, list.get(i2), schema);
        }
    }

    @Override
    public final void writeGroupList(int n2, List<?> list) throws IOException {
        for (int i2 = list.size() - 1; i2 >= 0; --i2) {
            this.writeGroup(n2, list.get(i2));
        }
    }

    @Override
    public final void writeGroupList(int n2, List<?> list, Schema schema) throws IOException {
        for (int i2 = list.size() - 1; i2 >= 0; --i2) {
            this.writeGroup(n2, list.get(i2), schema);
        }
    }

    @Override
    public final void writeMessageSetItem(int n2, Object object) throws IOException {
        this.writeTag(1, 4);
        if (object instanceof ByteString) {
            this.writeBytes(3, (ByteString)object);
        } else {
            this.writeMessage(3, object);
        }
        this.writeUInt32(2, n2);
        this.writeTag(1, 3);
    }

    final AllocatedBuffer newHeapBuffer() {
        return this.alloc.allocateHeapBuffer(this.chunkSize);
    }

    final AllocatedBuffer newHeapBuffer(int n2) {
        return this.alloc.allocateHeapBuffer(Math.max(n2, this.chunkSize));
    }

    final AllocatedBuffer newDirectBuffer() {
        return this.alloc.allocateDirectBuffer(this.chunkSize);
    }

    final AllocatedBuffer newDirectBuffer(int n2) {
        return this.alloc.allocateDirectBuffer(Math.max(n2, this.chunkSize));
    }

    public abstract int getTotalBytesWritten();

    abstract void requireSpace(int var1);

    abstract void finishCurrentBuffer();

    abstract void writeTag(int var1, int var2);

    abstract void writeVarint32(int var1);

    abstract void writeInt32(int var1);

    abstract void writeSInt32(int var1);

    abstract void writeFixed32(int var1);

    abstract void writeVarint64(long var1);

    abstract void writeSInt64(long var1);

    abstract void writeFixed64(long var1);

    abstract void writeBool(boolean var1);

    abstract void writeString(String var1);

    private static byte computeUInt64SizeNoTag(long l2) {
        if ((l2 & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if (l2 < 0L) {
            return 10;
        }
        byte by2 = 2;
        if ((l2 & 0xFFFFFFF800000000L) != 0L) {
            by2 = (byte)(by2 + 4);
            l2 >>>= 28;
        }
        if ((l2 & 0xFFFFFFFFFFE00000L) != 0L) {
            by2 = (byte)(by2 + 2);
            l2 >>>= 14;
        }
        if ((l2 & 0xFFFFFFFFFFFFC000L) != 0L) {
            by2 = (byte)(by2 + 1);
        }
        return by2;
    }

    private static final class UnsafeDirectWriter
    extends BinaryWriter {
        private ByteBuffer buffer;
        private long bufferOffset;
        private long limitMinusOne;
        private long pos;

        UnsafeDirectWriter(BufferAllocator bufferAllocator, int n2) {
            super(bufferAllocator, n2);
            this.nextBuffer();
        }

        private static boolean isSupported() {
            return UnsafeUtil.hasUnsafeByteBufferOperations();
        }

        private void nextBuffer() {
            this.nextBuffer(this.newDirectBuffer());
        }

        private void nextBuffer(int n2) {
            this.nextBuffer(this.newDirectBuffer(n2));
        }

        private void nextBuffer(AllocatedBuffer allocatedBuffer) {
            if (!allocatedBuffer.hasNioBuffer()) {
                throw new RuntimeException("Allocated buffer does not have NIO buffer");
            }
            ByteBuffer byteBuffer = allocatedBuffer.nioBuffer();
            if (!byteBuffer.isDirect()) {
                throw new RuntimeException("Allocator returned non-direct buffer");
            }
            this.finishCurrentBuffer();
            this.buffers.addFirst(allocatedBuffer);
            this.buffer = byteBuffer;
            this.buffer.limit(this.buffer.capacity());
            this.buffer.position(0);
            this.bufferOffset = UnsafeUtil.addressOffset(this.buffer);
            this.pos = this.limitMinusOne = this.bufferOffset + (long)(this.buffer.limit() - 1);
        }

        @Override
        public int getTotalBytesWritten() {
            return this.totalDoneBytes + this.bytesWrittenToCurrentBuffer();
        }

        private int bytesWrittenToCurrentBuffer() {
            return (int)(this.limitMinusOne - this.pos);
        }

        private int spaceLeft() {
            return this.bufferPos() + 1;
        }

        @Override
        void finishCurrentBuffer() {
            if (this.buffer != null) {
                this.totalDoneBytes += this.bytesWrittenToCurrentBuffer();
                this.buffer.position(this.bufferPos() + 1);
                this.buffer = null;
                this.pos = 0L;
                this.limitMinusOne = 0L;
            }
        }

        private int bufferPos() {
            return (int)(this.pos - this.bufferOffset);
        }

        @Override
        public void writeUInt32(int n2, int n3) {
            this.requireSpace(10);
            this.writeVarint32(n3);
            this.writeTag(n2, 0);
        }

        @Override
        public void writeInt32(int n2, int n3) {
            this.requireSpace(15);
            this.writeInt32(n3);
            this.writeTag(n2, 0);
        }

        @Override
        public void writeSInt32(int n2, int n3) {
            this.requireSpace(10);
            this.writeSInt32(n3);
            this.writeTag(n2, 0);
        }

        @Override
        public void writeFixed32(int n2, int n3) {
            this.requireSpace(9);
            this.writeFixed32(n3);
            this.writeTag(n2, 5);
        }

        @Override
        public void writeUInt64(int n2, long l2) {
            this.requireSpace(15);
            this.writeVarint64(l2);
            this.writeTag(n2, 0);
        }

        @Override
        public void writeSInt64(int n2, long l2) {
            this.requireSpace(15);
            this.writeSInt64(l2);
            this.writeTag(n2, 0);
        }

        @Override
        public void writeFixed64(int n2, long l2) {
            this.requireSpace(13);
            this.writeFixed64(l2);
            this.writeTag(n2, 1);
        }

        @Override
        public void writeBool(int n2, boolean bl2) {
            this.requireSpace(6);
            this.write((byte)(bl2 ? 1 : 0));
            this.writeTag(n2, 0);
        }

        @Override
        public void writeString(int n2, String string2) {
            int n3 = this.getTotalBytesWritten();
            this.writeString(string2);
            int n4 = this.getTotalBytesWritten() - n3;
            this.requireSpace(10);
            this.writeVarint32(n4);
            this.writeTag(n2, 2);
        }

        @Override
        public void writeBytes(int n2, ByteString byteString) {
            try {
                byteString.writeToReverse(this);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            this.requireSpace(10);
            this.writeVarint32(byteString.size());
            this.writeTag(n2, 2);
        }

        @Override
        public void writeMessage(int n2, Object object) throws IOException {
            int n3 = this.getTotalBytesWritten();
            Protobuf.getInstance().writeTo(object, this);
            int n4 = this.getTotalBytesWritten() - n3;
            this.requireSpace(10);
            this.writeVarint32(n4);
            this.writeTag(n2, 2);
        }

        @Override
        public void writeMessage(int n2, Object object, Schema schema) throws IOException {
            int n3 = this.getTotalBytesWritten();
            schema.writeTo(object, this);
            int n4 = this.getTotalBytesWritten() - n3;
            this.requireSpace(10);
            this.writeVarint32(n4);
            this.writeTag(n2, 2);
        }

        @Override
        public void writeGroup(int n2, Object object) throws IOException {
            this.writeTag(n2, 4);
            Protobuf.getInstance().writeTo(object, this);
            this.writeTag(n2, 3);
        }

        @Override
        public void writeGroup(int n2, Object object, Schema schema) throws IOException {
            this.writeTag(n2, 4);
            schema.writeTo(object, this);
            this.writeTag(n2, 3);
        }

        @Override
        public void writeStartGroup(int n2) {
            this.writeTag(n2, 3);
        }

        @Override
        public void writeEndGroup(int n2) {
            this.writeTag(n2, 4);
        }

        @Override
        void writeInt32(int n2) {
            if (n2 >= 0) {
                this.writeVarint32(n2);
            } else {
                this.writeVarint64(n2);
            }
        }

        @Override
        void writeSInt32(int n2) {
            this.writeVarint32(CodedOutputStream.encodeZigZag32(n2));
        }

        @Override
        void writeSInt64(long l2) {
            this.writeVarint64(CodedOutputStream.encodeZigZag64(l2));
        }

        @Override
        void writeBool(boolean bl2) {
            this.write((byte)(bl2 ? 1 : 0));
        }

        @Override
        void writeTag(int n2, int n3) {
            this.writeVarint32(WireFormat.makeTag(n2, n3));
        }

        @Override
        void writeVarint32(int n2) {
            if ((n2 & 0xFFFFFF80) == 0) {
                this.writeVarint32OneByte(n2);
            } else if ((n2 & 0xFFFFC000) == 0) {
                this.writeVarint32TwoBytes(n2);
            } else if ((n2 & 0xFFE00000) == 0) {
                this.writeVarint32ThreeBytes(n2);
            } else if ((n2 & 0xF0000000) == 0) {
                this.writeVarint32FourBytes(n2);
            } else {
                this.writeVarint32FiveBytes(n2);
            }
        }

        private void writeVarint32OneByte(int n2) {
            UnsafeUtil.putByte(this.pos--, (byte)n2);
        }

        private void writeVarint32TwoBytes(int n2) {
            UnsafeUtil.putByte(this.pos--, (byte)(n2 >>> 7));
            UnsafeUtil.putByte(this.pos--, (byte)(n2 & 0x7F | 0x80));
        }

        private void writeVarint32ThreeBytes(int n2) {
            UnsafeUtil.putByte(this.pos--, (byte)(n2 >>> 14));
            UnsafeUtil.putByte(this.pos--, (byte)(n2 >>> 7 & 0x7F | 0x80));
            UnsafeUtil.putByte(this.pos--, (byte)(n2 & 0x7F | 0x80));
        }

        private void writeVarint32FourBytes(int n2) {
            UnsafeUtil.putByte(this.pos--, (byte)(n2 >>> 21));
            UnsafeUtil.putByte(this.pos--, (byte)(n2 >>> 14 & 0x7F | 0x80));
            UnsafeUtil.putByte(this.pos--, (byte)(n2 >>> 7 & 0x7F | 0x80));
            UnsafeUtil.putByte(this.pos--, (byte)(n2 & 0x7F | 0x80));
        }

        private void writeVarint32FiveBytes(int n2) {
            UnsafeUtil.putByte(this.pos--, (byte)(n2 >>> 28));
            UnsafeUtil.putByte(this.pos--, (byte)(n2 >>> 21 & 0x7F | 0x80));
            UnsafeUtil.putByte(this.pos--, (byte)(n2 >>> 14 & 0x7F | 0x80));
            UnsafeUtil.putByte(this.pos--, (byte)(n2 >>> 7 & 0x7F | 0x80));
            UnsafeUtil.putByte(this.pos--, (byte)(n2 & 0x7F | 0x80));
        }

        @Override
        void writeVarint64(long l2) {
            switch (BinaryWriter.computeUInt64SizeNoTag(l2)) {
                case 1: {
                    this.writeVarint64OneByte(l2);
                    break;
                }
                case 2: {
                    this.writeVarint64TwoBytes(l2);
                    break;
                }
                case 3: {
                    this.writeVarint64ThreeBytes(l2);
                    break;
                }
                case 4: {
                    this.writeVarint64FourBytes(l2);
                    break;
                }
                case 5: {
                    this.writeVarint64FiveBytes(l2);
                    break;
                }
                case 6: {
                    this.writeVarint64SixBytes(l2);
                    break;
                }
                case 7: {
                    this.writeVarint64SevenBytes(l2);
                    break;
                }
                case 8: {
                    this.writeVarint64EightBytes(l2);
                    break;
                }
                case 9: {
                    this.writeVarint64NineBytes(l2);
                    break;
                }
                case 10: {
                    this.writeVarint64TenBytes(l2);
                }
            }
        }

        private void writeVarint64OneByte(long l2) {
            UnsafeUtil.putByte(this.pos--, (byte)l2);
        }

        private void writeVarint64TwoBytes(long l2) {
            UnsafeUtil.putByte(this.pos--, (byte)(l2 >>> 7));
            UnsafeUtil.putByte(this.pos--, (byte)((int)l2 & 0x7F | 0x80));
        }

        private void writeVarint64ThreeBytes(long l2) {
            UnsafeUtil.putByte(this.pos--, (byte)((int)l2 >>> 14));
            UnsafeUtil.putByte(this.pos--, (byte)(l2 >>> 7 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(l2 & 0x7FL | 0x80L));
        }

        private void writeVarint64FourBytes(long l2) {
            UnsafeUtil.putByte(this.pos--, (byte)(l2 >>> 21));
            UnsafeUtil.putByte(this.pos--, (byte)(l2 >>> 14 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(l2 >>> 7 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(l2 & 0x7FL | 0x80L));
        }

        private void writeVarint64FiveBytes(long l2) {
            UnsafeUtil.putByte(this.pos--, (byte)(l2 >>> 28));
            UnsafeUtil.putByte(this.pos--, (byte)(l2 >>> 21 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(l2 >>> 14 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(l2 >>> 7 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(l2 & 0x7FL | 0x80L));
        }

        private void writeVarint64SixBytes(long l2) {
            UnsafeUtil.putByte(this.pos--, (byte)(l2 >>> 35));
            UnsafeUtil.putByte(this.pos--, (byte)(l2 >>> 28 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(l2 >>> 21 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(l2 >>> 14 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(l2 >>> 7 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(l2 & 0x7FL | 0x80L));
        }

        private void writeVarint64SevenBytes(long l2) {
            UnsafeUtil.putByte(this.pos--, (byte)(l2 >>> 42));
            UnsafeUtil.putByte(this.pos--, (byte)(l2 >>> 35 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(l2 >>> 28 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(l2 >>> 21 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(l2 >>> 14 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(l2 >>> 7 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(l2 & 0x7FL | 0x80L));
        }

        private void writeVarint64EightBytes(long l2) {
            UnsafeUtil.putByte(this.pos--, (byte)(l2 >>> 49));
            UnsafeUtil.putByte(this.pos--, (byte)(l2 >>> 42 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(l2 >>> 35 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(l2 >>> 28 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(l2 >>> 21 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(l2 >>> 14 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(l2 >>> 7 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(l2 & 0x7FL | 0x80L));
        }

        private void writeVarint64NineBytes(long l2) {
            UnsafeUtil.putByte(this.pos--, (byte)(l2 >>> 56));
            UnsafeUtil.putByte(this.pos--, (byte)(l2 >>> 49 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(l2 >>> 42 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(l2 >>> 35 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(l2 >>> 28 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(l2 >>> 21 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(l2 >>> 14 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(l2 >>> 7 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(l2 & 0x7FL | 0x80L));
        }

        private void writeVarint64TenBytes(long l2) {
            UnsafeUtil.putByte(this.pos--, (byte)(l2 >>> 63));
            UnsafeUtil.putByte(this.pos--, (byte)(l2 >>> 56 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(l2 >>> 49 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(l2 >>> 42 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(l2 >>> 35 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(l2 >>> 28 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(l2 >>> 21 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(l2 >>> 14 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(l2 >>> 7 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(l2 & 0x7FL | 0x80L));
        }

        @Override
        void writeFixed32(int n2) {
            UnsafeUtil.putByte(this.pos--, (byte)(n2 >> 24 & 0xFF));
            UnsafeUtil.putByte(this.pos--, (byte)(n2 >> 16 & 0xFF));
            UnsafeUtil.putByte(this.pos--, (byte)(n2 >> 8 & 0xFF));
            UnsafeUtil.putByte(this.pos--, (byte)(n2 & 0xFF));
        }

        @Override
        void writeFixed64(long l2) {
            UnsafeUtil.putByte(this.pos--, (byte)((int)(l2 >> 56) & 0xFF));
            UnsafeUtil.putByte(this.pos--, (byte)((int)(l2 >> 48) & 0xFF));
            UnsafeUtil.putByte(this.pos--, (byte)((int)(l2 >> 40) & 0xFF));
            UnsafeUtil.putByte(this.pos--, (byte)((int)(l2 >> 32) & 0xFF));
            UnsafeUtil.putByte(this.pos--, (byte)((int)(l2 >> 24) & 0xFF));
            UnsafeUtil.putByte(this.pos--, (byte)((int)(l2 >> 16) & 0xFF));
            UnsafeUtil.putByte(this.pos--, (byte)((int)(l2 >> 8) & 0xFF));
            UnsafeUtil.putByte(this.pos--, (byte)((int)l2 & 0xFF));
        }

        @Override
        void writeString(String string2) {
            char c2;
            int n2;
            this.requireSpace(string2.length());
            for (n2 = string2.length() - 1; n2 >= 0 && (c2 = string2.charAt(n2)) < '\u0080'; --n2) {
                UnsafeUtil.putByte(this.pos--, (byte)c2);
            }
            if (n2 == -1) {
                return;
            }
            while (n2 >= 0) {
                c2 = string2.charAt(n2);
                if (c2 < '\u0080' && this.pos >= this.bufferOffset) {
                    UnsafeUtil.putByte(this.pos--, (byte)c2);
                } else if (c2 < '\u0800' && this.pos > this.bufferOffset) {
                    UnsafeUtil.putByte(this.pos--, (byte)(0x80 | 0x3F & c2));
                    UnsafeUtil.putByte(this.pos--, (byte)(0x3C0 | c2 >>> 6));
                } else if ((c2 < '\ud800' || '\udfff' < c2) && this.pos > this.bufferOffset + 1L) {
                    UnsafeUtil.putByte(this.pos--, (byte)(0x80 | 0x3F & c2));
                    UnsafeUtil.putByte(this.pos--, (byte)(0x80 | 0x3F & c2 >>> 6));
                    UnsafeUtil.putByte(this.pos--, (byte)(0x1E0 | c2 >>> 12));
                } else if (this.pos > this.bufferOffset + 2L) {
                    char c3;
                    if (n2 == 0 || !Character.isSurrogatePair(c3 = string2.charAt(n2 - 1), c2)) {
                        throw new Utf8.UnpairedSurrogateException(n2 - 1, n2);
                    }
                    --n2;
                    int n3 = Character.toCodePoint(c3, c2);
                    UnsafeUtil.putByte(this.pos--, (byte)(0x80 | 0x3F & n3));
                    UnsafeUtil.putByte(this.pos--, (byte)(0x80 | 0x3F & n3 >>> 6));
                    UnsafeUtil.putByte(this.pos--, (byte)(0x80 | 0x3F & n3 >>> 12));
                    UnsafeUtil.putByte(this.pos--, (byte)(0xF0 | n3 >>> 18));
                } else {
                    this.requireSpace(n2);
                    ++n2;
                }
                --n2;
            }
        }

        @Override
        public void write(byte by2) {
            UnsafeUtil.putByte(this.pos--, by2);
        }

        @Override
        public void write(byte[] byArray, int n2, int n3) {
            if (this.spaceLeft() < n3) {
                this.nextBuffer(n3);
            }
            this.pos -= (long)n3;
            this.buffer.position(this.bufferPos() + 1);
            this.buffer.put(byArray, n2, n3);
        }

        @Override
        public void writeLazy(byte[] byArray, int n2, int n3) {
            if (this.spaceLeft() < n3) {
                this.totalDoneBytes += n3;
                this.buffers.addFirst(AllocatedBuffer.wrap(byArray, n2, n3));
                this.nextBuffer();
                return;
            }
            this.pos -= (long)n3;
            this.buffer.position(this.bufferPos() + 1);
            this.buffer.put(byArray, n2, n3);
        }

        @Override
        public void write(ByteBuffer byteBuffer) {
            int n2 = byteBuffer.remaining();
            if (this.spaceLeft() < n2) {
                this.nextBuffer(n2);
            }
            this.pos -= (long)n2;
            this.buffer.position(this.bufferPos() + 1);
            this.buffer.put(byteBuffer);
        }

        @Override
        public void writeLazy(ByteBuffer byteBuffer) {
            int n2 = byteBuffer.remaining();
            if (this.spaceLeft() < n2) {
                this.totalDoneBytes += n2;
                this.buffers.addFirst(AllocatedBuffer.wrap(byteBuffer));
                this.nextBuffer();
                return;
            }
            this.pos -= (long)n2;
            this.buffer.position(this.bufferPos() + 1);
            this.buffer.put(byteBuffer);
        }

        @Override
        void requireSpace(int n2) {
            if (this.spaceLeft() < n2) {
                this.nextBuffer(n2);
            }
        }
    }

    private static final class SafeDirectWriter
    extends BinaryWriter {
        private ByteBuffer buffer;
        private int limitMinusOne;
        private int pos;

        SafeDirectWriter(BufferAllocator bufferAllocator, int n2) {
            super(bufferAllocator, n2);
            this.nextBuffer();
        }

        private void nextBuffer() {
            this.nextBuffer(this.newDirectBuffer());
        }

        private void nextBuffer(int n2) {
            this.nextBuffer(this.newDirectBuffer(n2));
        }

        private void nextBuffer(AllocatedBuffer allocatedBuffer) {
            if (!allocatedBuffer.hasNioBuffer()) {
                throw new RuntimeException("Allocated buffer does not have NIO buffer");
            }
            ByteBuffer byteBuffer = allocatedBuffer.nioBuffer();
            if (!byteBuffer.isDirect()) {
                throw new RuntimeException("Allocator returned non-direct buffer");
            }
            this.finishCurrentBuffer();
            this.buffers.addFirst(allocatedBuffer);
            this.buffer = byteBuffer;
            this.buffer.limit(this.buffer.capacity());
            this.buffer.position(0);
            this.buffer.order(ByteOrder.LITTLE_ENDIAN);
            this.pos = this.limitMinusOne = this.buffer.limit() - 1;
        }

        @Override
        public int getTotalBytesWritten() {
            return this.totalDoneBytes + this.bytesWrittenToCurrentBuffer();
        }

        private int bytesWrittenToCurrentBuffer() {
            return this.limitMinusOne - this.pos;
        }

        private int spaceLeft() {
            return this.pos + 1;
        }

        @Override
        void finishCurrentBuffer() {
            if (this.buffer != null) {
                this.totalDoneBytes += this.bytesWrittenToCurrentBuffer();
                this.buffer.position(this.pos + 1);
                this.buffer = null;
                this.pos = 0;
                this.limitMinusOne = 0;
            }
        }

        @Override
        public void writeUInt32(int n2, int n3) {
            this.requireSpace(10);
            this.writeVarint32(n3);
            this.writeTag(n2, 0);
        }

        @Override
        public void writeInt32(int n2, int n3) {
            this.requireSpace(15);
            this.writeInt32(n3);
            this.writeTag(n2, 0);
        }

        @Override
        public void writeSInt32(int n2, int n3) {
            this.requireSpace(10);
            this.writeSInt32(n3);
            this.writeTag(n2, 0);
        }

        @Override
        public void writeFixed32(int n2, int n3) {
            this.requireSpace(9);
            this.writeFixed32(n3);
            this.writeTag(n2, 5);
        }

        @Override
        public void writeUInt64(int n2, long l2) {
            this.requireSpace(15);
            this.writeVarint64(l2);
            this.writeTag(n2, 0);
        }

        @Override
        public void writeSInt64(int n2, long l2) {
            this.requireSpace(15);
            this.writeSInt64(l2);
            this.writeTag(n2, 0);
        }

        @Override
        public void writeFixed64(int n2, long l2) {
            this.requireSpace(13);
            this.writeFixed64(l2);
            this.writeTag(n2, 1);
        }

        @Override
        public void writeBool(int n2, boolean bl2) {
            this.requireSpace(6);
            this.write((byte)(bl2 ? 1 : 0));
            this.writeTag(n2, 0);
        }

        @Override
        public void writeString(int n2, String string2) {
            int n3 = this.getTotalBytesWritten();
            this.writeString(string2);
            int n4 = this.getTotalBytesWritten() - n3;
            this.requireSpace(10);
            this.writeVarint32(n4);
            this.writeTag(n2, 2);
        }

        @Override
        public void writeBytes(int n2, ByteString byteString) {
            try {
                byteString.writeToReverse(this);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            this.requireSpace(10);
            this.writeVarint32(byteString.size());
            this.writeTag(n2, 2);
        }

        @Override
        public void writeMessage(int n2, Object object) throws IOException {
            int n3 = this.getTotalBytesWritten();
            Protobuf.getInstance().writeTo(object, this);
            int n4 = this.getTotalBytesWritten() - n3;
            this.requireSpace(10);
            this.writeVarint32(n4);
            this.writeTag(n2, 2);
        }

        @Override
        public void writeMessage(int n2, Object object, Schema schema) throws IOException {
            int n3 = this.getTotalBytesWritten();
            schema.writeTo(object, this);
            int n4 = this.getTotalBytesWritten() - n3;
            this.requireSpace(10);
            this.writeVarint32(n4);
            this.writeTag(n2, 2);
        }

        @Override
        public void writeGroup(int n2, Object object) throws IOException {
            this.writeTag(n2, 4);
            Protobuf.getInstance().writeTo(object, this);
            this.writeTag(n2, 3);
        }

        @Override
        public void writeGroup(int n2, Object object, Schema schema) throws IOException {
            this.writeTag(n2, 4);
            schema.writeTo(object, this);
            this.writeTag(n2, 3);
        }

        @Override
        public void writeStartGroup(int n2) {
            this.writeTag(n2, 3);
        }

        @Override
        public void writeEndGroup(int n2) {
            this.writeTag(n2, 4);
        }

        @Override
        void writeInt32(int n2) {
            if (n2 >= 0) {
                this.writeVarint32(n2);
            } else {
                this.writeVarint64(n2);
            }
        }

        @Override
        void writeSInt32(int n2) {
            this.writeVarint32(CodedOutputStream.encodeZigZag32(n2));
        }

        @Override
        void writeSInt64(long l2) {
            this.writeVarint64(CodedOutputStream.encodeZigZag64(l2));
        }

        @Override
        void writeBool(boolean bl2) {
            this.write((byte)(bl2 ? 1 : 0));
        }

        @Override
        void writeTag(int n2, int n3) {
            this.writeVarint32(WireFormat.makeTag(n2, n3));
        }

        @Override
        void writeVarint32(int n2) {
            if ((n2 & 0xFFFFFF80) == 0) {
                this.writeVarint32OneByte(n2);
            } else if ((n2 & 0xFFFFC000) == 0) {
                this.writeVarint32TwoBytes(n2);
            } else if ((n2 & 0xFFE00000) == 0) {
                this.writeVarint32ThreeBytes(n2);
            } else if ((n2 & 0xF0000000) == 0) {
                this.writeVarint32FourBytes(n2);
            } else {
                this.writeVarint32FiveBytes(n2);
            }
        }

        private void writeVarint32OneByte(int n2) {
            this.buffer.put(this.pos--, (byte)n2);
        }

        private void writeVarint32TwoBytes(int n2) {
            this.pos -= 2;
            this.buffer.putShort(this.pos + 1, (short)((n2 & 0x3F80) << 1 | (n2 & 0x7F | 0x80)));
        }

        private void writeVarint32ThreeBytes(int n2) {
            this.pos -= 3;
            this.buffer.putInt(this.pos, (n2 & 0x1FC000) << 10 | (n2 & 0x3F80 | 0x4000) << 9 | (n2 & 0x7F | 0x80) << 8);
        }

        private void writeVarint32FourBytes(int n2) {
            this.pos -= 4;
            this.buffer.putInt(this.pos + 1, (n2 & 0xFE00000) << 3 | (n2 & 0x1FC000 | 0x200000) << 2 | (n2 & 0x3F80 | 0x4000) << 1 | (n2 & 0x7F | 0x80));
        }

        private void writeVarint32FiveBytes(int n2) {
            this.buffer.put(this.pos--, (byte)(n2 >>> 28));
            this.pos -= 4;
            this.buffer.putInt(this.pos + 1, (n2 >>> 21 & 0x7F | 0x80) << 24 | (n2 >>> 14 & 0x7F | 0x80) << 16 | (n2 >>> 7 & 0x7F | 0x80) << 8 | (n2 & 0x7F | 0x80));
        }

        @Override
        void writeVarint64(long l2) {
            switch (BinaryWriter.computeUInt64SizeNoTag(l2)) {
                case 1: {
                    this.writeVarint64OneByte(l2);
                    break;
                }
                case 2: {
                    this.writeVarint64TwoBytes(l2);
                    break;
                }
                case 3: {
                    this.writeVarint64ThreeBytes(l2);
                    break;
                }
                case 4: {
                    this.writeVarint64FourBytes(l2);
                    break;
                }
                case 5: {
                    this.writeVarint64FiveBytes(l2);
                    break;
                }
                case 6: {
                    this.writeVarint64SixBytes(l2);
                    break;
                }
                case 7: {
                    this.writeVarint64SevenBytes(l2);
                    break;
                }
                case 8: {
                    this.writeVarint64EightBytes(l2);
                    break;
                }
                case 9: {
                    this.writeVarint64NineBytes(l2);
                    break;
                }
                case 10: {
                    this.writeVarint64TenBytes(l2);
                }
            }
        }

        private void writeVarint64OneByte(long l2) {
            this.writeVarint32OneByte((int)l2);
        }

        private void writeVarint64TwoBytes(long l2) {
            this.writeVarint32TwoBytes((int)l2);
        }

        private void writeVarint64ThreeBytes(long l2) {
            this.writeVarint32ThreeBytes((int)l2);
        }

        private void writeVarint64FourBytes(long l2) {
            this.writeVarint32FourBytes((int)l2);
        }

        private void writeVarint64FiveBytes(long l2) {
            this.pos -= 5;
            this.buffer.putLong(this.pos - 2, (l2 & 0x7F0000000L) << 28 | (l2 & 0xFE00000L | 0x10000000L) << 27 | (l2 & 0x1FC000L | 0x200000L) << 26 | (l2 & 0x3F80L | 0x4000L) << 25 | (l2 & 0x7FL | 0x80L) << 24);
        }

        private void writeVarint64SixBytes(long l2) {
            this.pos -= 6;
            this.buffer.putLong(this.pos - 1, (l2 & 0x3F800000000L) << 21 | (l2 & 0x7F0000000L | 0x800000000L) << 20 | (l2 & 0xFE00000L | 0x10000000L) << 19 | (l2 & 0x1FC000L | 0x200000L) << 18 | (l2 & 0x3F80L | 0x4000L) << 17 | (l2 & 0x7FL | 0x80L) << 16);
        }

        private void writeVarint64SevenBytes(long l2) {
            this.pos -= 7;
            this.buffer.putLong(this.pos, (l2 & 0x1FC0000000000L) << 14 | (l2 & 0x3F800000000L | 0x40000000000L) << 13 | (l2 & 0x7F0000000L | 0x800000000L) << 12 | (l2 & 0xFE00000L | 0x10000000L) << 11 | (l2 & 0x1FC000L | 0x200000L) << 10 | (l2 & 0x3F80L | 0x4000L) << 9 | (l2 & 0x7FL | 0x80L) << 8);
        }

        private void writeVarint64EightBytes(long l2) {
            this.pos -= 8;
            this.buffer.putLong(this.pos + 1, (l2 & 0xFE000000000000L) << 7 | (l2 & 0x1FC0000000000L | 0x2000000000000L) << 6 | (l2 & 0x3F800000000L | 0x40000000000L) << 5 | (l2 & 0x7F0000000L | 0x800000000L) << 4 | (l2 & 0xFE00000L | 0x10000000L) << 3 | (l2 & 0x1FC000L | 0x200000L) << 2 | (l2 & 0x3F80L | 0x4000L) << 1 | (l2 & 0x7FL | 0x80L));
        }

        private void writeVarint64EightBytesWithSign(long l2) {
            this.pos -= 8;
            this.buffer.putLong(this.pos + 1, (l2 & 0xFE000000000000L | 0x100000000000000L) << 7 | (l2 & 0x1FC0000000000L | 0x2000000000000L) << 6 | (l2 & 0x3F800000000L | 0x40000000000L) << 5 | (l2 & 0x7F0000000L | 0x800000000L) << 4 | (l2 & 0xFE00000L | 0x10000000L) << 3 | (l2 & 0x1FC000L | 0x200000L) << 2 | (l2 & 0x3F80L | 0x4000L) << 1 | (l2 & 0x7FL | 0x80L));
        }

        private void writeVarint64NineBytes(long l2) {
            this.buffer.put(this.pos--, (byte)(l2 >>> 56));
            this.writeVarint64EightBytesWithSign(l2 & 0xFFFFFFFFFFFFFFL);
        }

        private void writeVarint64TenBytes(long l2) {
            this.buffer.put(this.pos--, (byte)(l2 >>> 63));
            this.buffer.put(this.pos--, (byte)(l2 >>> 56 & 0x7FL | 0x80L));
            this.writeVarint64EightBytesWithSign(l2 & 0xFFFFFFFFFFFFFFL);
        }

        @Override
        void writeFixed32(int n2) {
            this.pos -= 4;
            this.buffer.putInt(this.pos + 1, n2);
        }

        @Override
        void writeFixed64(long l2) {
            this.pos -= 8;
            this.buffer.putLong(this.pos + 1, l2);
        }

        @Override
        void writeString(String string2) {
            char c2;
            int n2;
            this.requireSpace(string2.length());
            this.pos -= n2;
            for (n2 = string2.length() - 1; n2 >= 0 && (c2 = string2.charAt(n2)) < '\u0080'; --n2) {
                this.buffer.put(this.pos + n2, (byte)c2);
            }
            if (n2 == -1) {
                --this.pos;
                return;
            }
            this.pos += n2;
            while (n2 >= 0) {
                c2 = string2.charAt(n2);
                if (c2 < '\u0080' && this.pos >= 0) {
                    this.buffer.put(this.pos--, (byte)c2);
                } else if (c2 < '\u0800' && this.pos > 0) {
                    this.buffer.put(this.pos--, (byte)(0x80 | 0x3F & c2));
                    this.buffer.put(this.pos--, (byte)(0x3C0 | c2 >>> 6));
                } else if ((c2 < '\ud800' || '\udfff' < c2) && this.pos > 1) {
                    this.buffer.put(this.pos--, (byte)(0x80 | 0x3F & c2));
                    this.buffer.put(this.pos--, (byte)(0x80 | 0x3F & c2 >>> 6));
                    this.buffer.put(this.pos--, (byte)(0x1E0 | c2 >>> 12));
                } else if (this.pos > 2) {
                    char c3 = '\u0000';
                    if (n2 == 0 || !Character.isSurrogatePair(c3 = string2.charAt(n2 - 1), c2)) {
                        throw new Utf8.UnpairedSurrogateException(n2 - 1, n2);
                    }
                    --n2;
                    int n3 = Character.toCodePoint(c3, c2);
                    this.buffer.put(this.pos--, (byte)(0x80 | 0x3F & n3));
                    this.buffer.put(this.pos--, (byte)(0x80 | 0x3F & n3 >>> 6));
                    this.buffer.put(this.pos--, (byte)(0x80 | 0x3F & n3 >>> 12));
                    this.buffer.put(this.pos--, (byte)(0xF0 | n3 >>> 18));
                } else {
                    this.requireSpace(n2);
                    ++n2;
                }
                --n2;
            }
        }

        @Override
        public void write(byte by2) {
            this.buffer.put(this.pos--, by2);
        }

        @Override
        public void write(byte[] byArray, int n2, int n3) {
            if (this.spaceLeft() < n3) {
                this.nextBuffer(n3);
            }
            this.pos -= n3;
            this.buffer.position(this.pos + 1);
            this.buffer.put(byArray, n2, n3);
        }

        @Override
        public void writeLazy(byte[] byArray, int n2, int n3) {
            if (this.spaceLeft() < n3) {
                this.totalDoneBytes += n3;
                this.buffers.addFirst(AllocatedBuffer.wrap(byArray, n2, n3));
                this.nextBuffer();
                return;
            }
            this.pos -= n3;
            this.buffer.position(this.pos + 1);
            this.buffer.put(byArray, n2, n3);
        }

        @Override
        public void write(ByteBuffer byteBuffer) {
            int n2 = byteBuffer.remaining();
            if (this.spaceLeft() < n2) {
                this.nextBuffer(n2);
            }
            this.pos -= n2;
            this.buffer.position(this.pos + 1);
            this.buffer.put(byteBuffer);
        }

        @Override
        public void writeLazy(ByteBuffer byteBuffer) {
            int n2 = byteBuffer.remaining();
            if (this.spaceLeft() < n2) {
                this.totalDoneBytes += n2;
                this.buffers.addFirst(AllocatedBuffer.wrap(byteBuffer));
                this.nextBuffer();
                return;
            }
            this.pos -= n2;
            this.buffer.position(this.pos + 1);
            this.buffer.put(byteBuffer);
        }

        @Override
        void requireSpace(int n2) {
            if (this.spaceLeft() < n2) {
                this.nextBuffer(n2);
            }
        }
    }

    private static final class UnsafeHeapWriter
    extends BinaryWriter {
        private AllocatedBuffer allocatedBuffer;
        private byte[] buffer;
        private long offset;
        private long limit;
        private long offsetMinusOne;
        private long limitMinusOne;
        private long pos;

        UnsafeHeapWriter(BufferAllocator bufferAllocator, int n2) {
            super(bufferAllocator, n2);
            this.nextBuffer();
        }

        static boolean isSupported() {
            return UnsafeUtil.hasUnsafeArrayOperations();
        }

        @Override
        void finishCurrentBuffer() {
            if (this.allocatedBuffer != null) {
                this.totalDoneBytes += this.bytesWrittenToCurrentBuffer();
                this.allocatedBuffer.position(this.arrayPos() - this.allocatedBuffer.arrayOffset() + 1);
                this.allocatedBuffer = null;
                this.pos = 0L;
                this.limitMinusOne = 0L;
            }
        }

        private int arrayPos() {
            return (int)this.pos;
        }

        private void nextBuffer() {
            this.nextBuffer(this.newHeapBuffer());
        }

        private void nextBuffer(int n2) {
            this.nextBuffer(this.newHeapBuffer(n2));
        }

        private void nextBuffer(AllocatedBuffer allocatedBuffer) {
            if (!allocatedBuffer.hasArray()) {
                throw new RuntimeException("Allocator returned non-heap buffer");
            }
            this.finishCurrentBuffer();
            this.buffers.addFirst(allocatedBuffer);
            this.allocatedBuffer = allocatedBuffer;
            this.buffer = allocatedBuffer.array();
            int n2 = allocatedBuffer.arrayOffset();
            this.limit = n2 + allocatedBuffer.limit();
            this.offset = n2 + allocatedBuffer.position();
            this.offsetMinusOne = this.offset - 1L;
            this.pos = this.limitMinusOne = this.limit - 1L;
        }

        @Override
        public int getTotalBytesWritten() {
            return this.totalDoneBytes + this.bytesWrittenToCurrentBuffer();
        }

        int bytesWrittenToCurrentBuffer() {
            return (int)(this.limitMinusOne - this.pos);
        }

        int spaceLeft() {
            return (int)(this.pos - this.offsetMinusOne);
        }

        @Override
        public void writeUInt32(int n2, int n3) {
            this.requireSpace(10);
            this.writeVarint32(n3);
            this.writeTag(n2, 0);
        }

        @Override
        public void writeInt32(int n2, int n3) {
            this.requireSpace(15);
            this.writeInt32(n3);
            this.writeTag(n2, 0);
        }

        @Override
        public void writeSInt32(int n2, int n3) {
            this.requireSpace(10);
            this.writeSInt32(n3);
            this.writeTag(n2, 0);
        }

        @Override
        public void writeFixed32(int n2, int n3) {
            this.requireSpace(9);
            this.writeFixed32(n3);
            this.writeTag(n2, 5);
        }

        @Override
        public void writeUInt64(int n2, long l2) {
            this.requireSpace(15);
            this.writeVarint64(l2);
            this.writeTag(n2, 0);
        }

        @Override
        public void writeSInt64(int n2, long l2) {
            this.requireSpace(15);
            this.writeSInt64(l2);
            this.writeTag(n2, 0);
        }

        @Override
        public void writeFixed64(int n2, long l2) {
            this.requireSpace(13);
            this.writeFixed64(l2);
            this.writeTag(n2, 1);
        }

        @Override
        public void writeBool(int n2, boolean bl2) {
            this.requireSpace(6);
            this.write((byte)(bl2 ? 1 : 0));
            this.writeTag(n2, 0);
        }

        @Override
        public void writeString(int n2, String string2) {
            int n3 = this.getTotalBytesWritten();
            this.writeString(string2);
            int n4 = this.getTotalBytesWritten() - n3;
            this.requireSpace(10);
            this.writeVarint32(n4);
            this.writeTag(n2, 2);
        }

        @Override
        public void writeBytes(int n2, ByteString byteString) {
            try {
                byteString.writeToReverse(this);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            this.requireSpace(10);
            this.writeVarint32(byteString.size());
            this.writeTag(n2, 2);
        }

        @Override
        public void writeMessage(int n2, Object object) throws IOException {
            int n3 = this.getTotalBytesWritten();
            Protobuf.getInstance().writeTo(object, this);
            int n4 = this.getTotalBytesWritten() - n3;
            this.requireSpace(10);
            this.writeVarint32(n4);
            this.writeTag(n2, 2);
        }

        @Override
        public void writeMessage(int n2, Object object, Schema schema) throws IOException {
            int n3 = this.getTotalBytesWritten();
            schema.writeTo(object, this);
            int n4 = this.getTotalBytesWritten() - n3;
            this.requireSpace(10);
            this.writeVarint32(n4);
            this.writeTag(n2, 2);
        }

        @Override
        public void writeGroup(int n2, Object object) throws IOException {
            this.writeTag(n2, 4);
            Protobuf.getInstance().writeTo(object, this);
            this.writeTag(n2, 3);
        }

        @Override
        public void writeGroup(int n2, Object object, Schema schema) throws IOException {
            this.writeTag(n2, 4);
            schema.writeTo(object, this);
            this.writeTag(n2, 3);
        }

        @Override
        public void writeStartGroup(int n2) {
            this.writeTag(n2, 3);
        }

        @Override
        public void writeEndGroup(int n2) {
            this.writeTag(n2, 4);
        }

        @Override
        void writeInt32(int n2) {
            if (n2 >= 0) {
                this.writeVarint32(n2);
            } else {
                this.writeVarint64(n2);
            }
        }

        @Override
        void writeSInt32(int n2) {
            this.writeVarint32(CodedOutputStream.encodeZigZag32(n2));
        }

        @Override
        void writeSInt64(long l2) {
            this.writeVarint64(CodedOutputStream.encodeZigZag64(l2));
        }

        @Override
        void writeBool(boolean bl2) {
            this.write((byte)(bl2 ? 1 : 0));
        }

        @Override
        void writeTag(int n2, int n3) {
            this.writeVarint32(WireFormat.makeTag(n2, n3));
        }

        @Override
        void writeVarint32(int n2) {
            if ((n2 & 0xFFFFFF80) == 0) {
                this.writeVarint32OneByte(n2);
            } else if ((n2 & 0xFFFFC000) == 0) {
                this.writeVarint32TwoBytes(n2);
            } else if ((n2 & 0xFFE00000) == 0) {
                this.writeVarint32ThreeBytes(n2);
            } else if ((n2 & 0xF0000000) == 0) {
                this.writeVarint32FourBytes(n2);
            } else {
                this.writeVarint32FiveBytes(n2);
            }
        }

        private void writeVarint32OneByte(int n2) {
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)n2);
        }

        private void writeVarint32TwoBytes(int n2) {
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(n2 >>> 7));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(n2 & 0x7F | 0x80));
        }

        private void writeVarint32ThreeBytes(int n2) {
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(n2 >>> 14));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(n2 >>> 7 & 0x7F | 0x80));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(n2 & 0x7F | 0x80));
        }

        private void writeVarint32FourBytes(int n2) {
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(n2 >>> 21));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(n2 >>> 14 & 0x7F | 0x80));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(n2 >>> 7 & 0x7F | 0x80));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(n2 & 0x7F | 0x80));
        }

        private void writeVarint32FiveBytes(int n2) {
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(n2 >>> 28));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(n2 >>> 21 & 0x7F | 0x80));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(n2 >>> 14 & 0x7F | 0x80));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(n2 >>> 7 & 0x7F | 0x80));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(n2 & 0x7F | 0x80));
        }

        @Override
        void writeVarint64(long l2) {
            switch (BinaryWriter.computeUInt64SizeNoTag(l2)) {
                case 1: {
                    this.writeVarint64OneByte(l2);
                    break;
                }
                case 2: {
                    this.writeVarint64TwoBytes(l2);
                    break;
                }
                case 3: {
                    this.writeVarint64ThreeBytes(l2);
                    break;
                }
                case 4: {
                    this.writeVarint64FourBytes(l2);
                    break;
                }
                case 5: {
                    this.writeVarint64FiveBytes(l2);
                    break;
                }
                case 6: {
                    this.writeVarint64SixBytes(l2);
                    break;
                }
                case 7: {
                    this.writeVarint64SevenBytes(l2);
                    break;
                }
                case 8: {
                    this.writeVarint64EightBytes(l2);
                    break;
                }
                case 9: {
                    this.writeVarint64NineBytes(l2);
                    break;
                }
                case 10: {
                    this.writeVarint64TenBytes(l2);
                }
            }
        }

        private void writeVarint64OneByte(long l2) {
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)l2);
        }

        private void writeVarint64TwoBytes(long l2) {
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l2 >>> 7));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)((int)l2 & 0x7F | 0x80));
        }

        private void writeVarint64ThreeBytes(long l2) {
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)((int)l2 >>> 14));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l2 >>> 7 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l2 & 0x7FL | 0x80L));
        }

        private void writeVarint64FourBytes(long l2) {
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l2 >>> 21));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l2 >>> 14 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l2 >>> 7 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l2 & 0x7FL | 0x80L));
        }

        private void writeVarint64FiveBytes(long l2) {
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l2 >>> 28));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l2 >>> 21 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l2 >>> 14 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l2 >>> 7 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l2 & 0x7FL | 0x80L));
        }

        private void writeVarint64SixBytes(long l2) {
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l2 >>> 35));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l2 >>> 28 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l2 >>> 21 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l2 >>> 14 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l2 >>> 7 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l2 & 0x7FL | 0x80L));
        }

        private void writeVarint64SevenBytes(long l2) {
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l2 >>> 42));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l2 >>> 35 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l2 >>> 28 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l2 >>> 21 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l2 >>> 14 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l2 >>> 7 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l2 & 0x7FL | 0x80L));
        }

        private void writeVarint64EightBytes(long l2) {
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l2 >>> 49));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l2 >>> 42 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l2 >>> 35 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l2 >>> 28 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l2 >>> 21 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l2 >>> 14 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l2 >>> 7 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l2 & 0x7FL | 0x80L));
        }

        private void writeVarint64NineBytes(long l2) {
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l2 >>> 56));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l2 >>> 49 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l2 >>> 42 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l2 >>> 35 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l2 >>> 28 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l2 >>> 21 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l2 >>> 14 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l2 >>> 7 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l2 & 0x7FL | 0x80L));
        }

        private void writeVarint64TenBytes(long l2) {
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l2 >>> 63));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l2 >>> 56 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l2 >>> 49 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l2 >>> 42 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l2 >>> 35 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l2 >>> 28 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l2 >>> 21 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l2 >>> 14 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l2 >>> 7 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l2 & 0x7FL | 0x80L));
        }

        @Override
        void writeFixed32(int n2) {
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(n2 >> 24 & 0xFF));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(n2 >> 16 & 0xFF));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(n2 >> 8 & 0xFF));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(n2 & 0xFF));
        }

        @Override
        void writeFixed64(long l2) {
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)((int)(l2 >> 56) & 0xFF));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)((int)(l2 >> 48) & 0xFF));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)((int)(l2 >> 40) & 0xFF));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)((int)(l2 >> 32) & 0xFF));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)((int)(l2 >> 24) & 0xFF));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)((int)(l2 >> 16) & 0xFF));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)((int)(l2 >> 8) & 0xFF));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)((int)l2 & 0xFF));
        }

        @Override
        void writeString(String string2) {
            char c2;
            int n2;
            this.requireSpace(string2.length());
            for (n2 = string2.length() - 1; n2 >= 0 && (c2 = string2.charAt(n2)) < '\u0080'; --n2) {
                UnsafeUtil.putByte(this.buffer, this.pos--, (byte)c2);
            }
            if (n2 == -1) {
                return;
            }
            while (n2 >= 0) {
                c2 = string2.charAt(n2);
                if (c2 < '\u0080' && this.pos > this.offsetMinusOne) {
                    UnsafeUtil.putByte(this.buffer, this.pos--, (byte)c2);
                } else if (c2 < '\u0800' && this.pos > this.offset) {
                    UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(0x80 | 0x3F & c2));
                    UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(0x3C0 | c2 >>> 6));
                } else if ((c2 < '\ud800' || '\udfff' < c2) && this.pos > this.offset + 1L) {
                    UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(0x80 | 0x3F & c2));
                    UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(0x80 | 0x3F & c2 >>> 6));
                    UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(0x1E0 | c2 >>> 12));
                } else if (this.pos > this.offset + 2L) {
                    char c3;
                    if (n2 == 0 || !Character.isSurrogatePair(c3 = string2.charAt(n2 - 1), c2)) {
                        throw new Utf8.UnpairedSurrogateException(n2 - 1, n2);
                    }
                    --n2;
                    int n3 = Character.toCodePoint(c3, c2);
                    UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(0x80 | 0x3F & n3));
                    UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(0x80 | 0x3F & n3 >>> 6));
                    UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(0x80 | 0x3F & n3 >>> 12));
                    UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(0xF0 | n3 >>> 18));
                } else {
                    this.requireSpace(n2);
                    ++n2;
                }
                --n2;
            }
        }

        @Override
        public void write(byte by2) {
            UnsafeUtil.putByte(this.buffer, this.pos--, by2);
        }

        @Override
        public void write(byte[] byArray, int n2, int n3) {
            if (n2 < 0 || n2 + n3 > byArray.length) {
                throw new ArrayIndexOutOfBoundsException(String.format("value.length=%d, offset=%d, length=%d", byArray.length, n2, n3));
            }
            this.requireSpace(n3);
            this.pos -= (long)n3;
            System.arraycopy(byArray, n2, this.buffer, this.arrayPos() + 1, n3);
        }

        @Override
        public void writeLazy(byte[] byArray, int n2, int n3) {
            if (n2 < 0 || n2 + n3 > byArray.length) {
                throw new ArrayIndexOutOfBoundsException(String.format("value.length=%d, offset=%d, length=%d", byArray.length, n2, n3));
            }
            if (this.spaceLeft() < n3) {
                this.totalDoneBytes += n3;
                this.buffers.addFirst(AllocatedBuffer.wrap(byArray, n2, n3));
                this.nextBuffer();
                return;
            }
            this.pos -= (long)n3;
            System.arraycopy(byArray, n2, this.buffer, this.arrayPos() + 1, n3);
        }

        @Override
        public void write(ByteBuffer byteBuffer) {
            int n2 = byteBuffer.remaining();
            this.requireSpace(n2);
            this.pos -= (long)n2;
            byteBuffer.get(this.buffer, this.arrayPos() + 1, n2);
        }

        @Override
        public void writeLazy(ByteBuffer byteBuffer) {
            int n2 = byteBuffer.remaining();
            if (this.spaceLeft() < n2) {
                this.totalDoneBytes += n2;
                this.buffers.addFirst(AllocatedBuffer.wrap(byteBuffer));
                this.nextBuffer();
            }
            this.pos -= (long)n2;
            byteBuffer.get(this.buffer, this.arrayPos() + 1, n2);
        }

        @Override
        void requireSpace(int n2) {
            if (this.spaceLeft() < n2) {
                this.nextBuffer(n2);
            }
        }
    }

    private static final class SafeHeapWriter
    extends BinaryWriter {
        private AllocatedBuffer allocatedBuffer;
        private byte[] buffer;
        private int offset;
        private int limit;
        private int offsetMinusOne;
        private int limitMinusOne;
        private int pos;

        SafeHeapWriter(BufferAllocator bufferAllocator, int n2) {
            super(bufferAllocator, n2);
            this.nextBuffer();
        }

        @Override
        void finishCurrentBuffer() {
            if (this.allocatedBuffer != null) {
                this.totalDoneBytes += this.bytesWrittenToCurrentBuffer();
                this.allocatedBuffer.position(this.pos - this.allocatedBuffer.arrayOffset() + 1);
                this.allocatedBuffer = null;
                this.pos = 0;
                this.limitMinusOne = 0;
            }
        }

        private void nextBuffer() {
            this.nextBuffer(this.newHeapBuffer());
        }

        private void nextBuffer(int n2) {
            this.nextBuffer(this.newHeapBuffer(n2));
        }

        private void nextBuffer(AllocatedBuffer allocatedBuffer) {
            if (!allocatedBuffer.hasArray()) {
                throw new RuntimeException("Allocator returned non-heap buffer");
            }
            this.finishCurrentBuffer();
            this.buffers.addFirst(allocatedBuffer);
            this.allocatedBuffer = allocatedBuffer;
            this.buffer = allocatedBuffer.array();
            int n2 = allocatedBuffer.arrayOffset();
            this.limit = n2 + allocatedBuffer.limit();
            this.offset = n2 + allocatedBuffer.position();
            this.offsetMinusOne = this.offset - 1;
            this.pos = this.limitMinusOne = this.limit - 1;
        }

        @Override
        public int getTotalBytesWritten() {
            return this.totalDoneBytes + this.bytesWrittenToCurrentBuffer();
        }

        int bytesWrittenToCurrentBuffer() {
            return this.limitMinusOne - this.pos;
        }

        int spaceLeft() {
            return this.pos - this.offsetMinusOne;
        }

        @Override
        public void writeUInt32(int n2, int n3) throws IOException {
            this.requireSpace(10);
            this.writeVarint32(n3);
            this.writeTag(n2, 0);
        }

        @Override
        public void writeInt32(int n2, int n3) throws IOException {
            this.requireSpace(15);
            this.writeInt32(n3);
            this.writeTag(n2, 0);
        }

        @Override
        public void writeSInt32(int n2, int n3) throws IOException {
            this.requireSpace(10);
            this.writeSInt32(n3);
            this.writeTag(n2, 0);
        }

        @Override
        public void writeFixed32(int n2, int n3) throws IOException {
            this.requireSpace(9);
            this.writeFixed32(n3);
            this.writeTag(n2, 5);
        }

        @Override
        public void writeUInt64(int n2, long l2) throws IOException {
            this.requireSpace(15);
            this.writeVarint64(l2);
            this.writeTag(n2, 0);
        }

        @Override
        public void writeSInt64(int n2, long l2) throws IOException {
            this.requireSpace(15);
            this.writeSInt64(l2);
            this.writeTag(n2, 0);
        }

        @Override
        public void writeFixed64(int n2, long l2) throws IOException {
            this.requireSpace(13);
            this.writeFixed64(l2);
            this.writeTag(n2, 1);
        }

        @Override
        public void writeBool(int n2, boolean bl2) throws IOException {
            this.requireSpace(6);
            this.write((byte)(bl2 ? 1 : 0));
            this.writeTag(n2, 0);
        }

        @Override
        public void writeString(int n2, String string2) throws IOException {
            int n3 = this.getTotalBytesWritten();
            this.writeString(string2);
            int n4 = this.getTotalBytesWritten() - n3;
            this.requireSpace(10);
            this.writeVarint32(n4);
            this.writeTag(n2, 2);
        }

        @Override
        public void writeBytes(int n2, ByteString byteString) throws IOException {
            try {
                byteString.writeToReverse(this);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            this.requireSpace(10);
            this.writeVarint32(byteString.size());
            this.writeTag(n2, 2);
        }

        @Override
        public void writeMessage(int n2, Object object) throws IOException {
            int n3 = this.getTotalBytesWritten();
            Protobuf.getInstance().writeTo(object, this);
            int n4 = this.getTotalBytesWritten() - n3;
            this.requireSpace(10);
            this.writeVarint32(n4);
            this.writeTag(n2, 2);
        }

        @Override
        public void writeMessage(int n2, Object object, Schema schema) throws IOException {
            int n3 = this.getTotalBytesWritten();
            schema.writeTo(object, this);
            int n4 = this.getTotalBytesWritten() - n3;
            this.requireSpace(10);
            this.writeVarint32(n4);
            this.writeTag(n2, 2);
        }

        @Override
        public void writeGroup(int n2, Object object) throws IOException {
            this.writeTag(n2, 4);
            Protobuf.getInstance().writeTo(object, this);
            this.writeTag(n2, 3);
        }

        @Override
        public void writeGroup(int n2, Object object, Schema schema) throws IOException {
            this.writeTag(n2, 4);
            schema.writeTo(object, this);
            this.writeTag(n2, 3);
        }

        @Override
        public void writeStartGroup(int n2) {
            this.writeTag(n2, 3);
        }

        @Override
        public void writeEndGroup(int n2) {
            this.writeTag(n2, 4);
        }

        @Override
        void writeInt32(int n2) {
            if (n2 >= 0) {
                this.writeVarint32(n2);
            } else {
                this.writeVarint64(n2);
            }
        }

        @Override
        void writeSInt32(int n2) {
            this.writeVarint32(CodedOutputStream.encodeZigZag32(n2));
        }

        @Override
        void writeSInt64(long l2) {
            this.writeVarint64(CodedOutputStream.encodeZigZag64(l2));
        }

        @Override
        void writeBool(boolean bl2) {
            this.write((byte)(bl2 ? 1 : 0));
        }

        @Override
        void writeTag(int n2, int n3) {
            this.writeVarint32(WireFormat.makeTag(n2, n3));
        }

        @Override
        void writeVarint32(int n2) {
            if ((n2 & 0xFFFFFF80) == 0) {
                this.writeVarint32OneByte(n2);
            } else if ((n2 & 0xFFFFC000) == 0) {
                this.writeVarint32TwoBytes(n2);
            } else if ((n2 & 0xFFE00000) == 0) {
                this.writeVarint32ThreeBytes(n2);
            } else if ((n2 & 0xF0000000) == 0) {
                this.writeVarint32FourBytes(n2);
            } else {
                this.writeVarint32FiveBytes(n2);
            }
        }

        private void writeVarint32OneByte(int n2) {
            this.buffer[this.pos--] = (byte)n2;
        }

        private void writeVarint32TwoBytes(int n2) {
            this.buffer[this.pos--] = (byte)(n2 >>> 7);
            this.buffer[this.pos--] = (byte)(n2 & 0x7F | 0x80);
        }

        private void writeVarint32ThreeBytes(int n2) {
            this.buffer[this.pos--] = (byte)(n2 >>> 14);
            this.buffer[this.pos--] = (byte)(n2 >>> 7 & 0x7F | 0x80);
            this.buffer[this.pos--] = (byte)(n2 & 0x7F | 0x80);
        }

        private void writeVarint32FourBytes(int n2) {
            this.buffer[this.pos--] = (byte)(n2 >>> 21);
            this.buffer[this.pos--] = (byte)(n2 >>> 14 & 0x7F | 0x80);
            this.buffer[this.pos--] = (byte)(n2 >>> 7 & 0x7F | 0x80);
            this.buffer[this.pos--] = (byte)(n2 & 0x7F | 0x80);
        }

        private void writeVarint32FiveBytes(int n2) {
            this.buffer[this.pos--] = (byte)(n2 >>> 28);
            this.buffer[this.pos--] = (byte)(n2 >>> 21 & 0x7F | 0x80);
            this.buffer[this.pos--] = (byte)(n2 >>> 14 & 0x7F | 0x80);
            this.buffer[this.pos--] = (byte)(n2 >>> 7 & 0x7F | 0x80);
            this.buffer[this.pos--] = (byte)(n2 & 0x7F | 0x80);
        }

        @Override
        void writeVarint64(long l2) {
            switch (BinaryWriter.computeUInt64SizeNoTag(l2)) {
                case 1: {
                    this.writeVarint64OneByte(l2);
                    break;
                }
                case 2: {
                    this.writeVarint64TwoBytes(l2);
                    break;
                }
                case 3: {
                    this.writeVarint64ThreeBytes(l2);
                    break;
                }
                case 4: {
                    this.writeVarint64FourBytes(l2);
                    break;
                }
                case 5: {
                    this.writeVarint64FiveBytes(l2);
                    break;
                }
                case 6: {
                    this.writeVarint64SixBytes(l2);
                    break;
                }
                case 7: {
                    this.writeVarint64SevenBytes(l2);
                    break;
                }
                case 8: {
                    this.writeVarint64EightBytes(l2);
                    break;
                }
                case 9: {
                    this.writeVarint64NineBytes(l2);
                    break;
                }
                case 10: {
                    this.writeVarint64TenBytes(l2);
                }
            }
        }

        private void writeVarint64OneByte(long l2) {
            this.buffer[this.pos--] = (byte)l2;
        }

        private void writeVarint64TwoBytes(long l2) {
            this.buffer[this.pos--] = (byte)(l2 >>> 7);
            this.buffer[this.pos--] = (byte)((int)l2 & 0x7F | 0x80);
        }

        private void writeVarint64ThreeBytes(long l2) {
            this.buffer[this.pos--] = (byte)((int)l2 >>> 14);
            this.buffer[this.pos--] = (byte)(l2 >>> 7 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(l2 & 0x7FL | 0x80L);
        }

        private void writeVarint64FourBytes(long l2) {
            this.buffer[this.pos--] = (byte)(l2 >>> 21);
            this.buffer[this.pos--] = (byte)(l2 >>> 14 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(l2 >>> 7 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(l2 & 0x7FL | 0x80L);
        }

        private void writeVarint64FiveBytes(long l2) {
            this.buffer[this.pos--] = (byte)(l2 >>> 28);
            this.buffer[this.pos--] = (byte)(l2 >>> 21 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(l2 >>> 14 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(l2 >>> 7 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(l2 & 0x7FL | 0x80L);
        }

        private void writeVarint64SixBytes(long l2) {
            this.buffer[this.pos--] = (byte)(l2 >>> 35);
            this.buffer[this.pos--] = (byte)(l2 >>> 28 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(l2 >>> 21 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(l2 >>> 14 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(l2 >>> 7 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(l2 & 0x7FL | 0x80L);
        }

        private void writeVarint64SevenBytes(long l2) {
            this.buffer[this.pos--] = (byte)(l2 >>> 42);
            this.buffer[this.pos--] = (byte)(l2 >>> 35 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(l2 >>> 28 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(l2 >>> 21 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(l2 >>> 14 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(l2 >>> 7 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(l2 & 0x7FL | 0x80L);
        }

        private void writeVarint64EightBytes(long l2) {
            this.buffer[this.pos--] = (byte)(l2 >>> 49);
            this.buffer[this.pos--] = (byte)(l2 >>> 42 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(l2 >>> 35 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(l2 >>> 28 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(l2 >>> 21 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(l2 >>> 14 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(l2 >>> 7 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(l2 & 0x7FL | 0x80L);
        }

        private void writeVarint64NineBytes(long l2) {
            this.buffer[this.pos--] = (byte)(l2 >>> 56);
            this.buffer[this.pos--] = (byte)(l2 >>> 49 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(l2 >>> 42 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(l2 >>> 35 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(l2 >>> 28 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(l2 >>> 21 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(l2 >>> 14 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(l2 >>> 7 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(l2 & 0x7FL | 0x80L);
        }

        private void writeVarint64TenBytes(long l2) {
            this.buffer[this.pos--] = (byte)(l2 >>> 63);
            this.buffer[this.pos--] = (byte)(l2 >>> 56 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(l2 >>> 49 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(l2 >>> 42 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(l2 >>> 35 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(l2 >>> 28 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(l2 >>> 21 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(l2 >>> 14 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(l2 >>> 7 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(l2 & 0x7FL | 0x80L);
        }

        @Override
        void writeFixed32(int n2) {
            this.buffer[this.pos--] = (byte)(n2 >> 24 & 0xFF);
            this.buffer[this.pos--] = (byte)(n2 >> 16 & 0xFF);
            this.buffer[this.pos--] = (byte)(n2 >> 8 & 0xFF);
            this.buffer[this.pos--] = (byte)(n2 & 0xFF);
        }

        @Override
        void writeFixed64(long l2) {
            this.buffer[this.pos--] = (byte)((int)(l2 >> 56) & 0xFF);
            this.buffer[this.pos--] = (byte)((int)(l2 >> 48) & 0xFF);
            this.buffer[this.pos--] = (byte)((int)(l2 >> 40) & 0xFF);
            this.buffer[this.pos--] = (byte)((int)(l2 >> 32) & 0xFF);
            this.buffer[this.pos--] = (byte)((int)(l2 >> 24) & 0xFF);
            this.buffer[this.pos--] = (byte)((int)(l2 >> 16) & 0xFF);
            this.buffer[this.pos--] = (byte)((int)(l2 >> 8) & 0xFF);
            this.buffer[this.pos--] = (byte)((int)l2 & 0xFF);
        }

        @Override
        void writeString(String string2) {
            char c2;
            int n2;
            this.requireSpace(string2.length());
            this.pos -= n2;
            for (n2 = string2.length() - 1; n2 >= 0 && (c2 = string2.charAt(n2)) < '\u0080'; --n2) {
                this.buffer[this.pos + n2] = (byte)c2;
            }
            if (n2 == -1) {
                --this.pos;
                return;
            }
            this.pos += n2;
            while (n2 >= 0) {
                c2 = string2.charAt(n2);
                if (c2 < '\u0080' && this.pos > this.offsetMinusOne) {
                    this.buffer[this.pos--] = (byte)c2;
                } else if (c2 < '\u0800' && this.pos > this.offset) {
                    this.buffer[this.pos--] = (byte)(0x80 | 0x3F & c2);
                    this.buffer[this.pos--] = (byte)(0x3C0 | c2 >>> 6);
                } else if ((c2 < '\ud800' || '\udfff' < c2) && this.pos > this.offset + 1) {
                    this.buffer[this.pos--] = (byte)(0x80 | 0x3F & c2);
                    this.buffer[this.pos--] = (byte)(0x80 | 0x3F & c2 >>> 6);
                    this.buffer[this.pos--] = (byte)(0x1E0 | c2 >>> 12);
                } else if (this.pos > this.offset + 2) {
                    char c3 = '\u0000';
                    if (n2 == 0 || !Character.isSurrogatePair(c3 = string2.charAt(n2 - 1), c2)) {
                        throw new Utf8.UnpairedSurrogateException(n2 - 1, n2);
                    }
                    --n2;
                    int n3 = Character.toCodePoint(c3, c2);
                    this.buffer[this.pos--] = (byte)(0x80 | 0x3F & n3);
                    this.buffer[this.pos--] = (byte)(0x80 | 0x3F & n3 >>> 6);
                    this.buffer[this.pos--] = (byte)(0x80 | 0x3F & n3 >>> 12);
                    this.buffer[this.pos--] = (byte)(0xF0 | n3 >>> 18);
                } else {
                    this.requireSpace(n2);
                    ++n2;
                }
                --n2;
            }
        }

        @Override
        public void write(byte by2) {
            this.buffer[this.pos--] = by2;
        }

        @Override
        public void write(byte[] byArray, int n2, int n3) {
            if (this.spaceLeft() < n3) {
                this.nextBuffer(n3);
            }
            this.pos -= n3;
            System.arraycopy(byArray, n2, this.buffer, this.pos + 1, n3);
        }

        @Override
        public void writeLazy(byte[] byArray, int n2, int n3) {
            if (this.spaceLeft() < n3) {
                this.totalDoneBytes += n3;
                this.buffers.addFirst(AllocatedBuffer.wrap(byArray, n2, n3));
                this.nextBuffer();
                return;
            }
            this.pos -= n3;
            System.arraycopy(byArray, n2, this.buffer, this.pos + 1, n3);
        }

        @Override
        public void write(ByteBuffer byteBuffer) {
            int n2 = byteBuffer.remaining();
            if (this.spaceLeft() < n2) {
                this.nextBuffer(n2);
            }
            this.pos -= n2;
            byteBuffer.get(this.buffer, this.pos + 1, n2);
        }

        @Override
        public void writeLazy(ByteBuffer byteBuffer) {
            int n2 = byteBuffer.remaining();
            if (this.spaceLeft() < n2) {
                this.totalDoneBytes += n2;
                this.buffers.addFirst(AllocatedBuffer.wrap(byteBuffer));
                this.nextBuffer();
            }
            this.pos -= n2;
            byteBuffer.get(this.buffer, this.pos + 1, n2);
        }

        @Override
        void requireSpace(int n2) {
            if (this.spaceLeft() < n2) {
                this.nextBuffer(n2);
            }
        }
    }
}

