/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.FieldSet;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.TextFormat;
import com.google.protobuf.WireFormat;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Logger;

public final class Descriptors {
    private static final Logger logger = Logger.getLogger(Descriptors.class.getName());

    private static String computeFullName(FileDescriptor fileDescriptor, Descriptor descriptor, String string2) {
        if (descriptor != null) {
            return descriptor.getFullName() + '.' + string2;
        }
        String string3 = fileDescriptor.getPackage();
        if (!string3.isEmpty()) {
            return string3 + '.' + string2;
        }
        return string2;
    }

    public static final class OneofDescriptor
    extends GenericDescriptor {
        private final int index;
        private DescriptorProtos.OneofDescriptorProto proto;
        private final String fullName;
        private final FileDescriptor file;
        private Descriptor containingType;
        private int fieldCount;
        private FieldDescriptor[] fields;

        public int getIndex() {
            return this.index;
        }

        @Override
        public String getName() {
            return this.proto.getName();
        }

        @Override
        public FileDescriptor getFile() {
            return this.file;
        }

        @Override
        public String getFullName() {
            return this.fullName;
        }

        public Descriptor getContainingType() {
            return this.containingType;
        }

        public int getFieldCount() {
            return this.fieldCount;
        }

        public DescriptorProtos.OneofOptions getOptions() {
            return this.proto.getOptions();
        }

        public boolean isSynthetic() {
            return this.fields.length == 1 && this.fields[0].isProto3Optional;
        }

        public List<FieldDescriptor> getFields() {
            return Collections.unmodifiableList(Arrays.asList(this.fields));
        }

        public FieldDescriptor getField(int n2) {
            return this.fields[n2];
        }

        @Override
        public DescriptorProtos.OneofDescriptorProto toProto() {
            return this.proto;
        }

        private void setProto(DescriptorProtos.OneofDescriptorProto oneofDescriptorProto) {
            this.proto = oneofDescriptorProto;
        }

        private OneofDescriptor(DescriptorProtos.OneofDescriptorProto oneofDescriptorProto, FileDescriptor fileDescriptor, Descriptor descriptor, int n2) throws DescriptorValidationException {
            this.proto = oneofDescriptorProto;
            this.fullName = Descriptors.computeFullName(fileDescriptor, descriptor, oneofDescriptorProto.getName());
            this.file = fileDescriptor;
            this.index = n2;
            this.containingType = descriptor;
            this.fieldCount = 0;
        }

        static /* synthetic */ FieldDescriptor[] access$1902(OneofDescriptor oneofDescriptor, FieldDescriptor[] fieldDescriptorArray) {
            oneofDescriptor.fields = fieldDescriptorArray;
            return fieldDescriptorArray;
        }
    }

    private static final class DescriptorPool {
        private final Set<FileDescriptor> dependencies;
        private boolean allowUnknownDependencies;
        private final Map<String, GenericDescriptor> descriptorsByName = new HashMap<String, GenericDescriptor>();
        private final Map<DescriptorIntPair, FieldDescriptor> fieldsByNumber = new HashMap<DescriptorIntPair, FieldDescriptor>();
        private final Map<DescriptorIntPair, EnumValueDescriptor> enumValuesByNumber = new HashMap<DescriptorIntPair, EnumValueDescriptor>();

        DescriptorPool(FileDescriptor[] fileDescriptorArray, boolean bl2) {
            this.dependencies = new HashSet<FileDescriptor>();
            this.allowUnknownDependencies = bl2;
            for (int i2 = 0; i2 < fileDescriptorArray.length; ++i2) {
                this.dependencies.add(fileDescriptorArray[i2]);
                this.importPublicDependencies(fileDescriptorArray[i2]);
            }
            for (FileDescriptor fileDescriptor : this.dependencies) {
                try {
                    this.addPackage(fileDescriptor.getPackage(), fileDescriptor);
                }
                catch (DescriptorValidationException descriptorValidationException) {
                    throw new AssertionError((Object)descriptorValidationException);
                }
            }
        }

        private void importPublicDependencies(FileDescriptor fileDescriptor) {
            for (FileDescriptor fileDescriptor2 : fileDescriptor.getPublicDependencies()) {
                if (!this.dependencies.add(fileDescriptor2)) continue;
                this.importPublicDependencies(fileDescriptor2);
            }
        }

        GenericDescriptor findSymbol(String string2) {
            return this.findSymbol(string2, SearchFilter.ALL_SYMBOLS);
        }

        GenericDescriptor findSymbol(String string2, SearchFilter searchFilter) {
            GenericDescriptor genericDescriptor = this.descriptorsByName.get(string2);
            if (genericDescriptor != null && (searchFilter == SearchFilter.ALL_SYMBOLS || searchFilter == SearchFilter.TYPES_ONLY && this.isType(genericDescriptor) || searchFilter == SearchFilter.AGGREGATES_ONLY && this.isAggregate(genericDescriptor))) {
                return genericDescriptor;
            }
            for (FileDescriptor fileDescriptor : this.dependencies) {
                genericDescriptor = ((FileDescriptor)fileDescriptor).pool.descriptorsByName.get(string2);
                if (genericDescriptor == null || searchFilter != SearchFilter.ALL_SYMBOLS && (searchFilter != SearchFilter.TYPES_ONLY || !this.isType(genericDescriptor)) && (searchFilter != SearchFilter.AGGREGATES_ONLY || !this.isAggregate(genericDescriptor))) continue;
                return genericDescriptor;
            }
            return null;
        }

        boolean isType(GenericDescriptor genericDescriptor) {
            return genericDescriptor instanceof Descriptor || genericDescriptor instanceof EnumDescriptor;
        }

        boolean isAggregate(GenericDescriptor genericDescriptor) {
            return genericDescriptor instanceof Descriptor || genericDescriptor instanceof EnumDescriptor || genericDescriptor instanceof PackageDescriptor || genericDescriptor instanceof ServiceDescriptor;
        }

        GenericDescriptor lookupSymbol(String string2, GenericDescriptor genericDescriptor, SearchFilter searchFilter) throws DescriptorValidationException {
            GenericDescriptor genericDescriptor2;
            String string3;
            if (string2.startsWith(".")) {
                string3 = string2.substring(1);
                genericDescriptor2 = this.findSymbol(string3, searchFilter);
            } else {
                int n2 = string2.indexOf(46);
                String string4 = n2 == -1 ? string2 : string2.substring(0, n2);
                StringBuilder stringBuilder = new StringBuilder(genericDescriptor.getFullName());
                while (true) {
                    int n3;
                    if ((n3 = stringBuilder.lastIndexOf(".")) == -1) {
                        string3 = string2;
                        genericDescriptor2 = this.findSymbol(string2, searchFilter);
                        break;
                    }
                    stringBuilder.setLength(n3 + 1);
                    stringBuilder.append(string4);
                    genericDescriptor2 = this.findSymbol(stringBuilder.toString(), SearchFilter.AGGREGATES_ONLY);
                    if (genericDescriptor2 != null) {
                        if (n2 != -1) {
                            stringBuilder.setLength(n3 + 1);
                            stringBuilder.append(string2);
                            genericDescriptor2 = this.findSymbol(stringBuilder.toString(), searchFilter);
                        }
                        string3 = stringBuilder.toString();
                        break;
                    }
                    stringBuilder.setLength(n3);
                }
            }
            if (genericDescriptor2 == null) {
                if (this.allowUnknownDependencies && searchFilter == SearchFilter.TYPES_ONLY) {
                    logger.warning("The descriptor for message type \"" + string2 + "\" can not be found and a placeholder is created for it");
                    genericDescriptor2 = new Descriptor(string3);
                    this.dependencies.add(genericDescriptor2.getFile());
                    return genericDescriptor2;
                }
                throw new DescriptorValidationException(genericDescriptor, '\"' + string2 + "\" is not defined.");
            }
            return genericDescriptor2;
        }

        void addSymbol(GenericDescriptor genericDescriptor) throws DescriptorValidationException {
            DescriptorPool.validateSymbolName(genericDescriptor);
            String string2 = genericDescriptor.getFullName();
            GenericDescriptor genericDescriptor2 = this.descriptorsByName.put(string2, genericDescriptor);
            if (genericDescriptor2 != null) {
                this.descriptorsByName.put(string2, genericDescriptor2);
                if (genericDescriptor.getFile() == genericDescriptor2.getFile()) {
                    int n2 = string2.lastIndexOf(46);
                    if (n2 == -1) {
                        throw new DescriptorValidationException(genericDescriptor, '\"' + string2 + "\" is already defined.");
                    }
                    throw new DescriptorValidationException(genericDescriptor, '\"' + string2.substring(n2 + 1) + "\" is already defined in \"" + string2.substring(0, n2) + "\".");
                }
                throw new DescriptorValidationException(genericDescriptor, '\"' + string2 + "\" is already defined in file \"" + genericDescriptor2.getFile().getName() + "\".");
            }
        }

        void addPackage(String string2, FileDescriptor fileDescriptor) throws DescriptorValidationException {
            String string3;
            int n2 = string2.lastIndexOf(46);
            if (n2 == -1) {
                string3 = string2;
            } else {
                this.addPackage(string2.substring(0, n2), fileDescriptor);
                string3 = string2.substring(n2 + 1);
            }
            GenericDescriptor genericDescriptor = this.descriptorsByName.put(string2, new PackageDescriptor(string3, string2, fileDescriptor));
            if (genericDescriptor != null) {
                this.descriptorsByName.put(string2, genericDescriptor);
                if (!(genericDescriptor instanceof PackageDescriptor)) {
                    throw new DescriptorValidationException(fileDescriptor, '\"' + string3 + "\" is already defined (as something other than a package) in file \"" + genericDescriptor.getFile().getName() + "\".");
                }
            }
        }

        void addFieldByNumber(FieldDescriptor fieldDescriptor) throws DescriptorValidationException {
            DescriptorIntPair descriptorIntPair = new DescriptorIntPair(fieldDescriptor.getContainingType(), fieldDescriptor.getNumber());
            FieldDescriptor fieldDescriptor2 = this.fieldsByNumber.put(descriptorIntPair, fieldDescriptor);
            if (fieldDescriptor2 != null) {
                this.fieldsByNumber.put(descriptorIntPair, fieldDescriptor2);
                throw new DescriptorValidationException((GenericDescriptor)fieldDescriptor, "Field number " + fieldDescriptor.getNumber() + " has already been used in \"" + fieldDescriptor.getContainingType().getFullName() + "\" by field \"" + fieldDescriptor2.getName() + "\".");
            }
        }

        void addEnumValueByNumber(EnumValueDescriptor enumValueDescriptor) {
            DescriptorIntPair descriptorIntPair = new DescriptorIntPair(enumValueDescriptor.getType(), enumValueDescriptor.getNumber());
            EnumValueDescriptor enumValueDescriptor2 = this.enumValuesByNumber.put(descriptorIntPair, enumValueDescriptor);
            if (enumValueDescriptor2 != null) {
                this.enumValuesByNumber.put(descriptorIntPair, enumValueDescriptor2);
            }
        }

        static void validateSymbolName(GenericDescriptor genericDescriptor) throws DescriptorValidationException {
            String string2 = genericDescriptor.getName();
            if (string2.length() == 0) {
                throw new DescriptorValidationException(genericDescriptor, "Missing name.");
            }
            for (int i2 = 0; i2 < string2.length(); ++i2) {
                char c2 = string2.charAt(i2);
                if ('a' <= c2 && c2 <= 'z' || 'A' <= c2 && c2 <= 'Z' || c2 == '_' || '0' <= c2 && c2 <= '9' && i2 > 0) continue;
                throw new DescriptorValidationException(genericDescriptor, '\"' + string2 + "\" is not a valid identifier.");
            }
        }

        private static final class DescriptorIntPair {
            private final GenericDescriptor descriptor;
            private final int number;

            DescriptorIntPair(GenericDescriptor genericDescriptor, int n2) {
                this.descriptor = genericDescriptor;
                this.number = n2;
            }

            public int hashCode() {
                return this.descriptor.hashCode() * 65535 + this.number;
            }

            public boolean equals(Object object) {
                if (!(object instanceof DescriptorIntPair)) {
                    return false;
                }
                DescriptorIntPair descriptorIntPair = (DescriptorIntPair)object;
                return this.descriptor == descriptorIntPair.descriptor && this.number == descriptorIntPair.number;
            }
        }

        private static final class PackageDescriptor
        extends GenericDescriptor {
            private final String name;
            private final String fullName;
            private final FileDescriptor file;

            @Override
            public Message toProto() {
                return this.file.toProto();
            }

            @Override
            public String getName() {
                return this.name;
            }

            @Override
            public String getFullName() {
                return this.fullName;
            }

            @Override
            public FileDescriptor getFile() {
                return this.file;
            }

            PackageDescriptor(String string2, String string3, FileDescriptor fileDescriptor) {
                this.file = fileDescriptor;
                this.fullName = string3;
                this.name = string2;
            }
        }

        static enum SearchFilter {
            TYPES_ONLY,
            AGGREGATES_ONLY,
            ALL_SYMBOLS;

        }
    }

    public static class DescriptorValidationException
    extends Exception {
        private static final long serialVersionUID = 5750205775490483148L;
        private final String name;
        private final Message proto;
        private final String description;

        public String getProblemSymbolName() {
            return this.name;
        }

        public Message getProblemProto() {
            return this.proto;
        }

        public String getDescription() {
            return this.description;
        }

        private DescriptorValidationException(GenericDescriptor genericDescriptor, String string2) {
            super(genericDescriptor.getFullName() + ": " + string2);
            this.name = genericDescriptor.getFullName();
            this.proto = genericDescriptor.toProto();
            this.description = string2;
        }

        private DescriptorValidationException(GenericDescriptor genericDescriptor, String string2, Throwable throwable) {
            this(genericDescriptor, string2);
            this.initCause(throwable);
        }

        private DescriptorValidationException(FileDescriptor fileDescriptor, String string2) {
            super(fileDescriptor.getName() + ": " + string2);
            this.name = fileDescriptor.getName();
            this.proto = fileDescriptor.toProto();
            this.description = string2;
        }
    }

    public static abstract class GenericDescriptor {
        private GenericDescriptor() {
        }

        public abstract Message toProto();

        public abstract String getName();

        public abstract String getFullName();

        public abstract FileDescriptor getFile();
    }

    public static final class MethodDescriptor
    extends GenericDescriptor {
        private final int index;
        private DescriptorProtos.MethodDescriptorProto proto;
        private final String fullName;
        private final FileDescriptor file;
        private final ServiceDescriptor service;
        private Descriptor inputType;
        private Descriptor outputType;

        public int getIndex() {
            return this.index;
        }

        @Override
        public DescriptorProtos.MethodDescriptorProto toProto() {
            return this.proto;
        }

        @Override
        public String getName() {
            return this.proto.getName();
        }

        @Override
        public String getFullName() {
            return this.fullName;
        }

        @Override
        public FileDescriptor getFile() {
            return this.file;
        }

        public ServiceDescriptor getService() {
            return this.service;
        }

        public Descriptor getInputType() {
            return this.inputType;
        }

        public Descriptor getOutputType() {
            return this.outputType;
        }

        public boolean isClientStreaming() {
            return this.proto.getClientStreaming();
        }

        public boolean isServerStreaming() {
            return this.proto.getServerStreaming();
        }

        public DescriptorProtos.MethodOptions getOptions() {
            return this.proto.getOptions();
        }

        private MethodDescriptor(DescriptorProtos.MethodDescriptorProto methodDescriptorProto, FileDescriptor fileDescriptor, ServiceDescriptor serviceDescriptor, int n2) throws DescriptorValidationException {
            this.index = n2;
            this.proto = methodDescriptorProto;
            this.file = fileDescriptor;
            this.service = serviceDescriptor;
            this.fullName = serviceDescriptor.getFullName() + '.' + methodDescriptorProto.getName();
            fileDescriptor.pool.addSymbol(this);
        }

        private void crossLink() throws DescriptorValidationException {
            GenericDescriptor genericDescriptor = this.file.pool.lookupSymbol(this.proto.getInputType(), this, DescriptorPool.SearchFilter.TYPES_ONLY);
            if (!(genericDescriptor instanceof Descriptor)) {
                throw new DescriptorValidationException((GenericDescriptor)this, '\"' + this.proto.getInputType() + "\" is not a message type.");
            }
            this.inputType = (Descriptor)genericDescriptor;
            GenericDescriptor genericDescriptor2 = this.file.pool.lookupSymbol(this.proto.getOutputType(), this, DescriptorPool.SearchFilter.TYPES_ONLY);
            if (!(genericDescriptor2 instanceof Descriptor)) {
                throw new DescriptorValidationException((GenericDescriptor)this, '\"' + this.proto.getOutputType() + "\" is not a message type.");
            }
            this.outputType = (Descriptor)genericDescriptor2;
        }

        private void setProto(DescriptorProtos.MethodDescriptorProto methodDescriptorProto) {
            this.proto = methodDescriptorProto;
        }
    }

    public static final class ServiceDescriptor
    extends GenericDescriptor {
        private final int index;
        private DescriptorProtos.ServiceDescriptorProto proto;
        private final String fullName;
        private final FileDescriptor file;
        private MethodDescriptor[] methods;

        public int getIndex() {
            return this.index;
        }

        @Override
        public DescriptorProtos.ServiceDescriptorProto toProto() {
            return this.proto;
        }

        @Override
        public String getName() {
            return this.proto.getName();
        }

        @Override
        public String getFullName() {
            return this.fullName;
        }

        @Override
        public FileDescriptor getFile() {
            return this.file;
        }

        public DescriptorProtos.ServiceOptions getOptions() {
            return this.proto.getOptions();
        }

        public List<MethodDescriptor> getMethods() {
            return Collections.unmodifiableList(Arrays.asList(this.methods));
        }

        public MethodDescriptor findMethodByName(String string2) {
            GenericDescriptor genericDescriptor = this.file.pool.findSymbol(this.fullName + '.' + string2);
            if (genericDescriptor != null && genericDescriptor instanceof MethodDescriptor) {
                return (MethodDescriptor)genericDescriptor;
            }
            return null;
        }

        private ServiceDescriptor(DescriptorProtos.ServiceDescriptorProto serviceDescriptorProto, FileDescriptor fileDescriptor, int n2) throws DescriptorValidationException {
            this.index = n2;
            this.proto = serviceDescriptorProto;
            this.fullName = Descriptors.computeFullName(fileDescriptor, null, serviceDescriptorProto.getName());
            this.file = fileDescriptor;
            this.methods = new MethodDescriptor[serviceDescriptorProto.getMethodCount()];
            for (int i2 = 0; i2 < serviceDescriptorProto.getMethodCount(); ++i2) {
                this.methods[i2] = new MethodDescriptor(serviceDescriptorProto.getMethod(i2), fileDescriptor, this, i2);
            }
            fileDescriptor.pool.addSymbol(this);
        }

        private void crossLink() throws DescriptorValidationException {
            for (MethodDescriptor methodDescriptor : this.methods) {
                methodDescriptor.crossLink();
            }
        }

        private void setProto(DescriptorProtos.ServiceDescriptorProto serviceDescriptorProto) {
            this.proto = serviceDescriptorProto;
            for (int i2 = 0; i2 < this.methods.length; ++i2) {
                this.methods[i2].setProto(serviceDescriptorProto.getMethod(i2));
            }
        }
    }

    public static final class EnumValueDescriptor
    extends GenericDescriptor
    implements Internal.EnumLite {
        private final int index;
        private DescriptorProtos.EnumValueDescriptorProto proto;
        private final String fullName;
        private final FileDescriptor file;
        private final EnumDescriptor type;

        public int getIndex() {
            return this.index;
        }

        @Override
        public DescriptorProtos.EnumValueDescriptorProto toProto() {
            return this.proto;
        }

        @Override
        public String getName() {
            return this.proto.getName();
        }

        @Override
        public int getNumber() {
            return this.proto.getNumber();
        }

        public String toString() {
            return this.proto.getName();
        }

        @Override
        public String getFullName() {
            return this.fullName;
        }

        @Override
        public FileDescriptor getFile() {
            return this.file;
        }

        public EnumDescriptor getType() {
            return this.type;
        }

        public DescriptorProtos.EnumValueOptions getOptions() {
            return this.proto.getOptions();
        }

        private EnumValueDescriptor(DescriptorProtos.EnumValueDescriptorProto enumValueDescriptorProto, FileDescriptor fileDescriptor, EnumDescriptor enumDescriptor, int n2) throws DescriptorValidationException {
            this.index = n2;
            this.proto = enumValueDescriptorProto;
            this.file = fileDescriptor;
            this.type = enumDescriptor;
            this.fullName = enumDescriptor.getFullName() + '.' + enumValueDescriptorProto.getName();
            fileDescriptor.pool.addSymbol(this);
            fileDescriptor.pool.addEnumValueByNumber(this);
        }

        private EnumValueDescriptor(FileDescriptor fileDescriptor, EnumDescriptor enumDescriptor, Integer n2) {
            String string2 = "UNKNOWN_ENUM_VALUE_" + enumDescriptor.getName() + "_" + n2;
            DescriptorProtos.EnumValueDescriptorProto enumValueDescriptorProto = DescriptorProtos.EnumValueDescriptorProto.newBuilder().setName(string2).setNumber(n2).build();
            this.index = -1;
            this.proto = enumValueDescriptorProto;
            this.file = fileDescriptor;
            this.type = enumDescriptor;
            this.fullName = enumDescriptor.getFullName() + '.' + enumValueDescriptorProto.getName();
        }

        private void setProto(DescriptorProtos.EnumValueDescriptorProto enumValueDescriptorProto) {
            this.proto = enumValueDescriptorProto;
        }
    }

    public static final class EnumDescriptor
    extends GenericDescriptor
    implements Internal.EnumLiteMap<EnumValueDescriptor> {
        private final int index;
        private DescriptorProtos.EnumDescriptorProto proto;
        private final String fullName;
        private final FileDescriptor file;
        private final Descriptor containingType;
        private EnumValueDescriptor[] values;
        private final WeakHashMap<Integer, WeakReference<EnumValueDescriptor>> unknownValues = new WeakHashMap();

        public int getIndex() {
            return this.index;
        }

        @Override
        public DescriptorProtos.EnumDescriptorProto toProto() {
            return this.proto;
        }

        @Override
        public String getName() {
            return this.proto.getName();
        }

        @Override
        public String getFullName() {
            return this.fullName;
        }

        @Override
        public FileDescriptor getFile() {
            return this.file;
        }

        public Descriptor getContainingType() {
            return this.containingType;
        }

        public DescriptorProtos.EnumOptions getOptions() {
            return this.proto.getOptions();
        }

        public List<EnumValueDescriptor> getValues() {
            return Collections.unmodifiableList(Arrays.asList(this.values));
        }

        public EnumValueDescriptor findValueByName(String string2) {
            GenericDescriptor genericDescriptor = this.file.pool.findSymbol(this.fullName + '.' + string2);
            if (genericDescriptor != null && genericDescriptor instanceof EnumValueDescriptor) {
                return (EnumValueDescriptor)genericDescriptor;
            }
            return null;
        }

        @Override
        public EnumValueDescriptor findValueByNumber(int n2) {
            return (EnumValueDescriptor)this.file.pool.enumValuesByNumber.get(new DescriptorPool.DescriptorIntPair(this, n2));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public EnumValueDescriptor findValueByNumberCreatingIfUnknown(int n2) {
            EnumValueDescriptor enumValueDescriptor = this.findValueByNumber(n2);
            if (enumValueDescriptor != null) {
                return enumValueDescriptor;
            }
            EnumDescriptor enumDescriptor = this;
            synchronized (enumDescriptor) {
                Integer n3 = new Integer(n2);
                WeakReference<EnumValueDescriptor> weakReference = this.unknownValues.get(n3);
                if (weakReference != null) {
                    enumValueDescriptor = (EnumValueDescriptor)weakReference.get();
                }
                if (enumValueDescriptor == null) {
                    enumValueDescriptor = new EnumValueDescriptor(this.file, this, n3);
                    this.unknownValues.put(n3, new WeakReference<EnumValueDescriptor>(enumValueDescriptor));
                }
            }
            return enumValueDescriptor;
        }

        int getUnknownEnumValueDescriptorCount() {
            return this.unknownValues.size();
        }

        private EnumDescriptor(DescriptorProtos.EnumDescriptorProto enumDescriptorProto, FileDescriptor fileDescriptor, Descriptor descriptor, int n2) throws DescriptorValidationException {
            this.index = n2;
            this.proto = enumDescriptorProto;
            this.fullName = Descriptors.computeFullName(fileDescriptor, descriptor, enumDescriptorProto.getName());
            this.file = fileDescriptor;
            this.containingType = descriptor;
            if (enumDescriptorProto.getValueCount() == 0) {
                throw new DescriptorValidationException((GenericDescriptor)this, "Enums must contain at least one value.");
            }
            this.values = new EnumValueDescriptor[enumDescriptorProto.getValueCount()];
            for (int i2 = 0; i2 < enumDescriptorProto.getValueCount(); ++i2) {
                this.values[i2] = new EnumValueDescriptor(enumDescriptorProto.getValue(i2), fileDescriptor, this, i2);
            }
            fileDescriptor.pool.addSymbol(this);
        }

        private void setProto(DescriptorProtos.EnumDescriptorProto enumDescriptorProto) {
            this.proto = enumDescriptorProto;
            for (int i2 = 0; i2 < this.values.length; ++i2) {
                this.values[i2].setProto(enumDescriptorProto.getValue(i2));
            }
        }
    }

    public static final class FieldDescriptor
    extends GenericDescriptor
    implements FieldSet.FieldDescriptorLite<FieldDescriptor>,
    Comparable<FieldDescriptor> {
        private static final WireFormat.FieldType[] table = WireFormat.FieldType.values();
        private final int index;
        private DescriptorProtos.FieldDescriptorProto proto;
        private final String fullName;
        private final String jsonName;
        private final FileDescriptor file;
        private final Descriptor extensionScope;
        private final boolean isProto3Optional;
        private Type type;
        private Descriptor containingType;
        private Descriptor messageType;
        private OneofDescriptor containingOneof;
        private EnumDescriptor enumType;
        private Object defaultValue;

        public int getIndex() {
            return this.index;
        }

        @Override
        public DescriptorProtos.FieldDescriptorProto toProto() {
            return this.proto;
        }

        @Override
        public String getName() {
            return this.proto.getName();
        }

        @Override
        public int getNumber() {
            return this.proto.getNumber();
        }

        @Override
        public String getFullName() {
            return this.fullName;
        }

        public String getJsonName() {
            return this.jsonName;
        }

        public JavaType getJavaType() {
            return this.type.getJavaType();
        }

        @Override
        public WireFormat.JavaType getLiteJavaType() {
            return this.getLiteType().getJavaType();
        }

        @Override
        public FileDescriptor getFile() {
            return this.file;
        }

        public Type getType() {
            return this.type;
        }

        @Override
        public WireFormat.FieldType getLiteType() {
            return table[this.type.ordinal()];
        }

        public boolean needsUtf8Check() {
            if (this.type != Type.STRING) {
                return false;
            }
            if (this.getContainingType().getOptions().getMapEntry()) {
                return true;
            }
            if (this.getFile().getSyntax() == FileDescriptor.Syntax.PROTO3) {
                return true;
            }
            return this.getFile().getOptions().getJavaStringCheckUtf8();
        }

        public boolean isMapField() {
            return this.getType() == Type.MESSAGE && this.isRepeated() && this.getMessageType().getOptions().getMapEntry();
        }

        public boolean isRequired() {
            return this.proto.getLabel() == DescriptorProtos.FieldDescriptorProto.Label.LABEL_REQUIRED;
        }

        public boolean isOptional() {
            return this.proto.getLabel() == DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL;
        }

        @Override
        public boolean isRepeated() {
            return this.proto.getLabel() == DescriptorProtos.FieldDescriptorProto.Label.LABEL_REPEATED;
        }

        @Override
        public boolean isPacked() {
            if (!this.isPackable()) {
                return false;
            }
            if (this.getFile().getSyntax() == FileDescriptor.Syntax.PROTO2) {
                return this.getOptions().getPacked();
            }
            return !this.getOptions().hasPacked() || this.getOptions().getPacked();
        }

        public boolean isPackable() {
            return this.isRepeated() && this.getLiteType().isPackable();
        }

        public boolean hasDefaultValue() {
            return this.proto.hasDefaultValue();
        }

        public Object getDefaultValue() {
            if (this.getJavaType() == JavaType.MESSAGE) {
                throw new UnsupportedOperationException("FieldDescriptor.getDefaultValue() called on an embedded message field.");
            }
            return this.defaultValue;
        }

        public DescriptorProtos.FieldOptions getOptions() {
            return this.proto.getOptions();
        }

        public boolean isExtension() {
            return this.proto.hasExtendee();
        }

        public Descriptor getContainingType() {
            return this.containingType;
        }

        public OneofDescriptor getContainingOneof() {
            return this.containingOneof;
        }

        public OneofDescriptor getRealContainingOneof() {
            return this.containingOneof != null && !this.containingOneof.isSynthetic() ? this.containingOneof : null;
        }

        public boolean hasOptionalKeyword() {
            return this.isProto3Optional || this.file.getSyntax() == FileDescriptor.Syntax.PROTO2 && this.isOptional() && this.getContainingOneof() == null;
        }

        boolean hasPresence() {
            if (this.isRepeated()) {
                return false;
            }
            return this.getType() == Type.MESSAGE || this.getType() == Type.GROUP || this.getContainingOneof() != null || this.file.getSyntax() == FileDescriptor.Syntax.PROTO2;
        }

        public Descriptor getExtensionScope() {
            if (!this.isExtension()) {
                throw new UnsupportedOperationException(String.format("This field is not an extension. (%s)", this.fullName));
            }
            return this.extensionScope;
        }

        public Descriptor getMessageType() {
            if (this.getJavaType() != JavaType.MESSAGE) {
                throw new UnsupportedOperationException(String.format("This field is not of message type. (%s)", this.fullName));
            }
            return this.messageType;
        }

        public EnumDescriptor getEnumType() {
            if (this.getJavaType() != JavaType.ENUM) {
                throw new UnsupportedOperationException(String.format("This field is not of enum type. (%s)", this.fullName));
            }
            return this.enumType;
        }

        @Override
        public int compareTo(FieldDescriptor fieldDescriptor) {
            if (fieldDescriptor.containingType != this.containingType) {
                throw new IllegalArgumentException("FieldDescriptors can only be compared to other FieldDescriptors for fields of the same message type.");
            }
            return this.getNumber() - fieldDescriptor.getNumber();
        }

        public String toString() {
            return this.getFullName();
        }

        private static String fieldNameToJsonName(String string2) {
            int n2 = string2.length();
            StringBuilder stringBuilder = new StringBuilder(n2);
            boolean bl2 = false;
            for (int i2 = 0; i2 < n2; ++i2) {
                char c2 = string2.charAt(i2);
                if (c2 == '_') {
                    bl2 = true;
                    continue;
                }
                if (bl2) {
                    if ('a' <= c2 && c2 <= 'z') {
                        c2 = (char)(c2 - 97 + 65);
                    }
                    stringBuilder.append(c2);
                    bl2 = false;
                    continue;
                }
                stringBuilder.append(c2);
            }
            return stringBuilder.toString();
        }

        private FieldDescriptor(DescriptorProtos.FieldDescriptorProto fieldDescriptorProto, FileDescriptor fileDescriptor, Descriptor descriptor, int n2, boolean bl2) throws DescriptorValidationException {
            this.index = n2;
            this.proto = fieldDescriptorProto;
            this.fullName = Descriptors.computeFullName(fileDescriptor, descriptor, fieldDescriptorProto.getName());
            this.file = fileDescriptor;
            this.jsonName = fieldDescriptorProto.hasJsonName() ? fieldDescriptorProto.getJsonName() : FieldDescriptor.fieldNameToJsonName(fieldDescriptorProto.getName());
            if (fieldDescriptorProto.hasType()) {
                this.type = Type.valueOf(fieldDescriptorProto.getType());
            }
            this.isProto3Optional = fieldDescriptorProto.getProto3Optional();
            if (this.getNumber() <= 0) {
                throw new DescriptorValidationException((GenericDescriptor)this, "Field numbers must be positive integers.");
            }
            if (bl2) {
                if (!fieldDescriptorProto.hasExtendee()) {
                    throw new DescriptorValidationException((GenericDescriptor)this, "FieldDescriptorProto.extendee not set for extension field.");
                }
                this.containingType = null;
                this.extensionScope = descriptor != null ? descriptor : null;
                if (fieldDescriptorProto.hasOneofIndex()) {
                    throw new DescriptorValidationException((GenericDescriptor)this, "FieldDescriptorProto.oneof_index set for extension field.");
                }
                this.containingOneof = null;
            } else {
                if (fieldDescriptorProto.hasExtendee()) {
                    throw new DescriptorValidationException((GenericDescriptor)this, "FieldDescriptorProto.extendee set for non-extension field.");
                }
                this.containingType = descriptor;
                if (fieldDescriptorProto.hasOneofIndex()) {
                    if (fieldDescriptorProto.getOneofIndex() < 0 || fieldDescriptorProto.getOneofIndex() >= descriptor.toProto().getOneofDeclCount()) {
                        throw new DescriptorValidationException((GenericDescriptor)this, "FieldDescriptorProto.oneof_index is out of range for type " + descriptor.getName());
                    }
                    this.containingOneof = descriptor.getOneofs().get(fieldDescriptorProto.getOneofIndex());
                    this.containingOneof.fieldCount++;
                } else {
                    this.containingOneof = null;
                }
                this.extensionScope = null;
            }
            fileDescriptor.pool.addSymbol(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void crossLink() throws DescriptorValidationException {
            GenericDescriptor genericDescriptor;
            if (this.proto.hasExtendee()) {
                genericDescriptor = this.file.pool.lookupSymbol(this.proto.getExtendee(), this, DescriptorPool.SearchFilter.TYPES_ONLY);
                if (!(genericDescriptor instanceof Descriptor)) {
                    throw new DescriptorValidationException((GenericDescriptor)this, '\"' + this.proto.getExtendee() + "\" is not a message type.");
                }
                this.containingType = (Descriptor)genericDescriptor;
                if (!this.getContainingType().isExtensionNumber(this.getNumber())) {
                    throw new DescriptorValidationException((GenericDescriptor)this, '\"' + this.getContainingType().getFullName() + "\" does not declare " + this.getNumber() + " as an extension number.");
                }
            }
            if (this.proto.hasTypeName()) {
                genericDescriptor = this.file.pool.lookupSymbol(this.proto.getTypeName(), this, DescriptorPool.SearchFilter.TYPES_ONLY);
                if (!this.proto.hasType()) {
                    if (genericDescriptor instanceof Descriptor) {
                        this.type = Type.MESSAGE;
                    } else {
                        if (!(genericDescriptor instanceof EnumDescriptor)) throw new DescriptorValidationException((GenericDescriptor)this, '\"' + this.proto.getTypeName() + "\" is not a type.");
                        this.type = Type.ENUM;
                    }
                }
                if (this.getJavaType() == JavaType.MESSAGE) {
                    if (!(genericDescriptor instanceof Descriptor)) {
                        throw new DescriptorValidationException((GenericDescriptor)this, '\"' + this.proto.getTypeName() + "\" is not a message type.");
                    }
                    this.messageType = (Descriptor)genericDescriptor;
                    if (this.proto.hasDefaultValue()) {
                        throw new DescriptorValidationException((GenericDescriptor)this, "Messages can't have default values.");
                    }
                } else {
                    if (this.getJavaType() != JavaType.ENUM) throw new DescriptorValidationException((GenericDescriptor)this, "Field with primitive type has type_name.");
                    if (!(genericDescriptor instanceof EnumDescriptor)) {
                        throw new DescriptorValidationException((GenericDescriptor)this, '\"' + this.proto.getTypeName() + "\" is not an enum type.");
                    }
                    this.enumType = (EnumDescriptor)genericDescriptor;
                }
            } else if (this.getJavaType() == JavaType.MESSAGE || this.getJavaType() == JavaType.ENUM) {
                throw new DescriptorValidationException((GenericDescriptor)this, "Field with message or enum type missing type_name.");
            }
            if (this.proto.getOptions().getPacked() && !this.isPackable()) {
                throw new DescriptorValidationException((GenericDescriptor)this, "[packed = true] can only be specified for repeated primitive fields.");
            }
            if (this.proto.hasDefaultValue()) {
                if (this.isRepeated()) {
                    throw new DescriptorValidationException((GenericDescriptor)this, "Repeated fields cannot have default values.");
                }
                try {
                    switch (this.getType()) {
                        case INT32: 
                        case SINT32: 
                        case SFIXED32: {
                            this.defaultValue = TextFormat.parseInt32(this.proto.getDefaultValue());
                            break;
                        }
                        case UINT32: 
                        case FIXED32: {
                            this.defaultValue = TextFormat.parseUInt32(this.proto.getDefaultValue());
                            break;
                        }
                        case INT64: 
                        case SINT64: 
                        case SFIXED64: {
                            this.defaultValue = TextFormat.parseInt64(this.proto.getDefaultValue());
                            break;
                        }
                        case UINT64: 
                        case FIXED64: {
                            this.defaultValue = TextFormat.parseUInt64(this.proto.getDefaultValue());
                            break;
                        }
                        case FLOAT: {
                            if (this.proto.getDefaultValue().equals("inf")) {
                                this.defaultValue = Float.valueOf(Float.POSITIVE_INFINITY);
                                break;
                            }
                            if (this.proto.getDefaultValue().equals("-inf")) {
                                this.defaultValue = Float.valueOf(Float.NEGATIVE_INFINITY);
                                break;
                            }
                            if (this.proto.getDefaultValue().equals("nan")) {
                                this.defaultValue = Float.valueOf(Float.NaN);
                                break;
                            }
                            this.defaultValue = Float.valueOf(this.proto.getDefaultValue());
                            break;
                        }
                        case DOUBLE: {
                            if (this.proto.getDefaultValue().equals("inf")) {
                                this.defaultValue = Double.POSITIVE_INFINITY;
                                break;
                            }
                            if (this.proto.getDefaultValue().equals("-inf")) {
                                this.defaultValue = Double.NEGATIVE_INFINITY;
                                break;
                            }
                            if (this.proto.getDefaultValue().equals("nan")) {
                                this.defaultValue = Double.NaN;
                                break;
                            }
                            this.defaultValue = Double.valueOf(this.proto.getDefaultValue());
                            break;
                        }
                        case BOOL: {
                            this.defaultValue = Boolean.valueOf(this.proto.getDefaultValue());
                            break;
                        }
                        case STRING: {
                            this.defaultValue = this.proto.getDefaultValue();
                            break;
                        }
                        case BYTES: {
                            try {
                                this.defaultValue = TextFormat.unescapeBytes(this.proto.getDefaultValue());
                                break;
                            }
                            catch (TextFormat.InvalidEscapeSequenceException invalidEscapeSequenceException) {
                                throw new DescriptorValidationException(this, "Couldn't parse default value: " + invalidEscapeSequenceException.getMessage(), invalidEscapeSequenceException);
                            }
                        }
                        case ENUM: {
                            this.defaultValue = this.enumType.findValueByName(this.proto.getDefaultValue());
                            if (this.defaultValue != null) break;
                            throw new DescriptorValidationException((GenericDescriptor)this, "Unknown enum default value: \"" + this.proto.getDefaultValue() + '\"');
                        }
                        case MESSAGE: 
                        case GROUP: {
                            throw new DescriptorValidationException((GenericDescriptor)this, "Message type had default value.");
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new DescriptorValidationException(this, "Could not parse default value: \"" + this.proto.getDefaultValue() + '\"', numberFormatException);
                }
            } else if (this.isRepeated()) {
                this.defaultValue = Collections.emptyList();
            } else {
                switch (this.getJavaType()) {
                    case ENUM: {
                        this.defaultValue = this.enumType.getValues().get(0);
                        break;
                    }
                    case MESSAGE: {
                        this.defaultValue = null;
                        break;
                    }
                    default: {
                        this.defaultValue = this.getJavaType().defaultDefault;
                    }
                }
            }
            if (!this.isExtension()) {
                this.file.pool.addFieldByNumber(this);
            }
            if (this.containingType == null || !this.containingType.getOptions().getMessageSetWireFormat()) return;
            if (!this.isExtension()) throw new DescriptorValidationException((GenericDescriptor)this, "MessageSets cannot have fields, only extensions.");
            if (this.isOptional() && this.getType() == Type.MESSAGE) return;
            throw new DescriptorValidationException((GenericDescriptor)this, "Extensions of MessageSets must be optional messages.");
        }

        private void setProto(DescriptorProtos.FieldDescriptorProto fieldDescriptorProto) {
            this.proto = fieldDescriptorProto;
        }

        @Override
        public MessageLite.Builder internalMergeFrom(MessageLite.Builder builder, MessageLite messageLite) {
            return ((Message.Builder)builder).mergeFrom((Message)messageLite);
        }

        static {
            if (Type.values().length != DescriptorProtos.FieldDescriptorProto.Type.values().length) {
                throw new RuntimeException("descriptor.proto has a new declared type but Descriptors.java wasn't updated.");
            }
        }

        public static enum JavaType {
            INT(0),
            LONG(0L),
            FLOAT(Float.valueOf(0.0f)),
            DOUBLE(0.0),
            BOOLEAN(false),
            STRING(""),
            BYTE_STRING(ByteString.EMPTY),
            ENUM(null),
            MESSAGE(null);

            private final Object defaultDefault;

            private JavaType(Object object) {
                this.defaultDefault = object;
            }
        }

        public static enum Type {
            DOUBLE(JavaType.DOUBLE),
            FLOAT(JavaType.FLOAT),
            INT64(JavaType.LONG),
            UINT64(JavaType.LONG),
            INT32(JavaType.INT),
            FIXED64(JavaType.LONG),
            FIXED32(JavaType.INT),
            BOOL(JavaType.BOOLEAN),
            STRING(JavaType.STRING),
            GROUP(JavaType.MESSAGE),
            MESSAGE(JavaType.MESSAGE),
            BYTES(JavaType.BYTE_STRING),
            UINT32(JavaType.INT),
            ENUM(JavaType.ENUM),
            SFIXED32(JavaType.INT),
            SFIXED64(JavaType.LONG),
            SINT32(JavaType.INT),
            SINT64(JavaType.LONG);

            private JavaType javaType;

            private Type(JavaType javaType) {
                this.javaType = javaType;
            }

            public DescriptorProtos.FieldDescriptorProto.Type toProto() {
                return DescriptorProtos.FieldDescriptorProto.Type.forNumber(this.ordinal() + 1);
            }

            public JavaType getJavaType() {
                return this.javaType;
            }

            public static Type valueOf(DescriptorProtos.FieldDescriptorProto.Type type) {
                return Type.values()[type.getNumber() - 1];
            }
        }
    }

    public static final class Descriptor
    extends GenericDescriptor {
        private final int index;
        private DescriptorProtos.DescriptorProto proto;
        private final String fullName;
        private final FileDescriptor file;
        private final Descriptor containingType;
        private final Descriptor[] nestedTypes;
        private final EnumDescriptor[] enumTypes;
        private final FieldDescriptor[] fields;
        private final FieldDescriptor[] extensions;
        private final OneofDescriptor[] oneofs;
        private final int realOneofCount;

        public int getIndex() {
            return this.index;
        }

        @Override
        public DescriptorProtos.DescriptorProto toProto() {
            return this.proto;
        }

        @Override
        public String getName() {
            return this.proto.getName();
        }

        @Override
        public String getFullName() {
            return this.fullName;
        }

        @Override
        public FileDescriptor getFile() {
            return this.file;
        }

        public Descriptor getContainingType() {
            return this.containingType;
        }

        public DescriptorProtos.MessageOptions getOptions() {
            return this.proto.getOptions();
        }

        public List<FieldDescriptor> getFields() {
            return Collections.unmodifiableList(Arrays.asList(this.fields));
        }

        public List<OneofDescriptor> getOneofs() {
            return Collections.unmodifiableList(Arrays.asList(this.oneofs));
        }

        public List<OneofDescriptor> getRealOneofs() {
            return Collections.unmodifiableList(Arrays.asList(this.oneofs).subList(0, this.realOneofCount));
        }

        public List<FieldDescriptor> getExtensions() {
            return Collections.unmodifiableList(Arrays.asList(this.extensions));
        }

        public List<Descriptor> getNestedTypes() {
            return Collections.unmodifiableList(Arrays.asList(this.nestedTypes));
        }

        public List<EnumDescriptor> getEnumTypes() {
            return Collections.unmodifiableList(Arrays.asList(this.enumTypes));
        }

        public boolean isExtensionNumber(int n2) {
            for (DescriptorProtos.DescriptorProto.ExtensionRange extensionRange : this.proto.getExtensionRangeList()) {
                if (extensionRange.getStart() > n2 || n2 >= extensionRange.getEnd()) continue;
                return true;
            }
            return false;
        }

        public boolean isReservedNumber(int n2) {
            for (DescriptorProtos.DescriptorProto.ReservedRange reservedRange : this.proto.getReservedRangeList()) {
                if (reservedRange.getStart() > n2 || n2 >= reservedRange.getEnd()) continue;
                return true;
            }
            return false;
        }

        public boolean isReservedName(String string2) {
            Internal.checkNotNull(string2);
            for (String string3 : this.proto.getReservedNameList()) {
                if (!string3.equals(string2)) continue;
                return true;
            }
            return false;
        }

        public boolean isExtendable() {
            return this.proto.getExtensionRangeList().size() != 0;
        }

        public FieldDescriptor findFieldByName(String string2) {
            GenericDescriptor genericDescriptor = this.file.pool.findSymbol(this.fullName + '.' + string2);
            if (genericDescriptor != null && genericDescriptor instanceof FieldDescriptor) {
                return (FieldDescriptor)genericDescriptor;
            }
            return null;
        }

        public FieldDescriptor findFieldByNumber(int n2) {
            return (FieldDescriptor)this.file.pool.fieldsByNumber.get(new DescriptorPool.DescriptorIntPair(this, n2));
        }

        public Descriptor findNestedTypeByName(String string2) {
            GenericDescriptor genericDescriptor = this.file.pool.findSymbol(this.fullName + '.' + string2);
            if (genericDescriptor != null && genericDescriptor instanceof Descriptor) {
                return (Descriptor)genericDescriptor;
            }
            return null;
        }

        public EnumDescriptor findEnumTypeByName(String string2) {
            GenericDescriptor genericDescriptor = this.file.pool.findSymbol(this.fullName + '.' + string2);
            if (genericDescriptor != null && genericDescriptor instanceof EnumDescriptor) {
                return (EnumDescriptor)genericDescriptor;
            }
            return null;
        }

        Descriptor(String string2) throws DescriptorValidationException {
            String string3 = string2;
            String string4 = "";
            int n2 = string2.lastIndexOf(46);
            if (n2 != -1) {
                string3 = string2.substring(n2 + 1);
                string4 = string2.substring(0, n2);
            }
            this.index = 0;
            this.proto = DescriptorProtos.DescriptorProto.newBuilder().setName(string3).addExtensionRange(DescriptorProtos.DescriptorProto.ExtensionRange.newBuilder().setStart(1).setEnd(0x20000000).build()).build();
            this.fullName = string2;
            this.containingType = null;
            this.nestedTypes = new Descriptor[0];
            this.enumTypes = new EnumDescriptor[0];
            this.fields = new FieldDescriptor[0];
            this.extensions = new FieldDescriptor[0];
            this.oneofs = new OneofDescriptor[0];
            this.realOneofCount = 0;
            this.file = new FileDescriptor(string4, this);
        }

        private Descriptor(DescriptorProtos.DescriptorProto descriptorProto, FileDescriptor fileDescriptor, Descriptor descriptor, int n2) throws DescriptorValidationException {
            int n3;
            this.index = n2;
            this.proto = descriptorProto;
            this.fullName = Descriptors.computeFullName(fileDescriptor, descriptor, descriptorProto.getName());
            this.file = fileDescriptor;
            this.containingType = descriptor;
            this.oneofs = new OneofDescriptor[descriptorProto.getOneofDeclCount()];
            for (n3 = 0; n3 < descriptorProto.getOneofDeclCount(); ++n3) {
                this.oneofs[n3] = new OneofDescriptor(descriptorProto.getOneofDecl(n3), fileDescriptor, this, n3);
            }
            this.nestedTypes = new Descriptor[descriptorProto.getNestedTypeCount()];
            for (n3 = 0; n3 < descriptorProto.getNestedTypeCount(); ++n3) {
                this.nestedTypes[n3] = new Descriptor(descriptorProto.getNestedType(n3), fileDescriptor, this, n3);
            }
            this.enumTypes = new EnumDescriptor[descriptorProto.getEnumTypeCount()];
            for (n3 = 0; n3 < descriptorProto.getEnumTypeCount(); ++n3) {
                this.enumTypes[n3] = new EnumDescriptor(descriptorProto.getEnumType(n3), fileDescriptor, this, n3);
            }
            this.fields = new FieldDescriptor[descriptorProto.getFieldCount()];
            for (n3 = 0; n3 < descriptorProto.getFieldCount(); ++n3) {
                this.fields[n3] = new FieldDescriptor(descriptorProto.getField(n3), fileDescriptor, this, n3, false);
            }
            this.extensions = new FieldDescriptor[descriptorProto.getExtensionCount()];
            for (n3 = 0; n3 < descriptorProto.getExtensionCount(); ++n3) {
                this.extensions[n3] = new FieldDescriptor(descriptorProto.getExtension(n3), fileDescriptor, this, n3, true);
            }
            for (n3 = 0; n3 < descriptorProto.getOneofDeclCount(); ++n3) {
                OneofDescriptor.access$1902(this.oneofs[n3], new FieldDescriptor[this.oneofs[n3].getFieldCount()]);
                this.oneofs[n3].fieldCount = 0;
            }
            for (n3 = 0; n3 < descriptorProto.getFieldCount(); ++n3) {
                OneofDescriptor object = this.fields[n3].getContainingOneof();
                if (object == null) continue;
                ((OneofDescriptor)object).fields[((OneofDescriptor)object).fieldCount++] = this.fields[n3];
            }
            n3 = 0;
            for (OneofDescriptor oneofDescriptor : this.oneofs) {
                if (oneofDescriptor.isSynthetic()) {
                    ++n3;
                    continue;
                }
                if (n3 <= 0) continue;
                throw new DescriptorValidationException((GenericDescriptor)this, "Synthetic oneofs must come last.");
            }
            this.realOneofCount = this.oneofs.length - n3;
            fileDescriptor.pool.addSymbol(this);
        }

        private void crossLink() throws DescriptorValidationException {
            for (Descriptor genericDescriptor : this.nestedTypes) {
                genericDescriptor.crossLink();
            }
            for (GenericDescriptor genericDescriptor : this.fields) {
                ((FieldDescriptor)genericDescriptor).crossLink();
            }
            for (GenericDescriptor genericDescriptor : this.extensions) {
                ((FieldDescriptor)genericDescriptor).crossLink();
            }
        }

        private void setProto(DescriptorProtos.DescriptorProto descriptorProto) {
            int n2;
            this.proto = descriptorProto;
            for (n2 = 0; n2 < this.nestedTypes.length; ++n2) {
                this.nestedTypes[n2].setProto(descriptorProto.getNestedType(n2));
            }
            for (n2 = 0; n2 < this.oneofs.length; ++n2) {
                this.oneofs[n2].setProto(descriptorProto.getOneofDecl(n2));
            }
            for (n2 = 0; n2 < this.enumTypes.length; ++n2) {
                this.enumTypes[n2].setProto(descriptorProto.getEnumType(n2));
            }
            for (n2 = 0; n2 < this.fields.length; ++n2) {
                this.fields[n2].setProto(descriptorProto.getField(n2));
            }
            for (n2 = 0; n2 < this.extensions.length; ++n2) {
                this.extensions[n2].setProto(descriptorProto.getExtension(n2));
            }
        }
    }

    public static final class FileDescriptor
    extends GenericDescriptor {
        private DescriptorProtos.FileDescriptorProto proto;
        private final Descriptor[] messageTypes;
        private final EnumDescriptor[] enumTypes;
        private final ServiceDescriptor[] services;
        private final FieldDescriptor[] extensions;
        private final FileDescriptor[] dependencies;
        private final FileDescriptor[] publicDependencies;
        private final DescriptorPool pool;

        @Override
        public DescriptorProtos.FileDescriptorProto toProto() {
            return this.proto;
        }

        @Override
        public String getName() {
            return this.proto.getName();
        }

        @Override
        public FileDescriptor getFile() {
            return this;
        }

        @Override
        public String getFullName() {
            return this.proto.getName();
        }

        public String getPackage() {
            return this.proto.getPackage();
        }

        public DescriptorProtos.FileOptions getOptions() {
            return this.proto.getOptions();
        }

        public List<Descriptor> getMessageTypes() {
            return Collections.unmodifiableList(Arrays.asList(this.messageTypes));
        }

        public List<EnumDescriptor> getEnumTypes() {
            return Collections.unmodifiableList(Arrays.asList(this.enumTypes));
        }

        public List<ServiceDescriptor> getServices() {
            return Collections.unmodifiableList(Arrays.asList(this.services));
        }

        public List<FieldDescriptor> getExtensions() {
            return Collections.unmodifiableList(Arrays.asList(this.extensions));
        }

        public List<FileDescriptor> getDependencies() {
            return Collections.unmodifiableList(Arrays.asList(this.dependencies));
        }

        public List<FileDescriptor> getPublicDependencies() {
            return Collections.unmodifiableList(Arrays.asList(this.publicDependencies));
        }

        public Syntax getSyntax() {
            if (Syntax.PROTO3.name.equals(this.proto.getSyntax())) {
                return Syntax.PROTO3;
            }
            return Syntax.PROTO2;
        }

        public Descriptor findMessageTypeByName(String string2) {
            GenericDescriptor genericDescriptor;
            if (string2.indexOf(46) != -1) {
                return null;
            }
            String string3 = this.getPackage();
            if (!string3.isEmpty()) {
                string2 = string3 + '.' + string2;
            }
            if ((genericDescriptor = this.pool.findSymbol(string2)) != null && genericDescriptor instanceof Descriptor && genericDescriptor.getFile() == this) {
                return (Descriptor)genericDescriptor;
            }
            return null;
        }

        public EnumDescriptor findEnumTypeByName(String string2) {
            GenericDescriptor genericDescriptor;
            if (string2.indexOf(46) != -1) {
                return null;
            }
            String string3 = this.getPackage();
            if (!string3.isEmpty()) {
                string2 = string3 + '.' + string2;
            }
            if ((genericDescriptor = this.pool.findSymbol(string2)) != null && genericDescriptor instanceof EnumDescriptor && genericDescriptor.getFile() == this) {
                return (EnumDescriptor)genericDescriptor;
            }
            return null;
        }

        public ServiceDescriptor findServiceByName(String string2) {
            GenericDescriptor genericDescriptor;
            if (string2.indexOf(46) != -1) {
                return null;
            }
            String string3 = this.getPackage();
            if (!string3.isEmpty()) {
                string2 = string3 + '.' + string2;
            }
            if ((genericDescriptor = this.pool.findSymbol(string2)) != null && genericDescriptor instanceof ServiceDescriptor && genericDescriptor.getFile() == this) {
                return (ServiceDescriptor)genericDescriptor;
            }
            return null;
        }

        public FieldDescriptor findExtensionByName(String string2) {
            GenericDescriptor genericDescriptor;
            if (string2.indexOf(46) != -1) {
                return null;
            }
            String string3 = this.getPackage();
            if (!string3.isEmpty()) {
                string2 = string3 + '.' + string2;
            }
            if ((genericDescriptor = this.pool.findSymbol(string2)) != null && genericDescriptor instanceof FieldDescriptor && genericDescriptor.getFile() == this) {
                return (FieldDescriptor)genericDescriptor;
            }
            return null;
        }

        public static FileDescriptor buildFrom(DescriptorProtos.FileDescriptorProto fileDescriptorProto, FileDescriptor[] fileDescriptorArray) throws DescriptorValidationException {
            return FileDescriptor.buildFrom(fileDescriptorProto, fileDescriptorArray, false);
        }

        public static FileDescriptor buildFrom(DescriptorProtos.FileDescriptorProto fileDescriptorProto, FileDescriptor[] fileDescriptorArray, boolean bl2) throws DescriptorValidationException {
            DescriptorPool descriptorPool = new DescriptorPool(fileDescriptorArray, bl2);
            FileDescriptor fileDescriptor = new FileDescriptor(fileDescriptorProto, fileDescriptorArray, descriptorPool, bl2);
            fileDescriptor.crossLink();
            return fileDescriptor;
        }

        private static byte[] latin1Cat(String[] stringArray) {
            if (stringArray.length == 1) {
                return stringArray[0].getBytes(Internal.ISO_8859_1);
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (String string2 : stringArray) {
                stringBuilder.append(string2);
            }
            return stringBuilder.toString().getBytes(Internal.ISO_8859_1);
        }

        private static FileDescriptor[] findDescriptors(Class<?> clazz, String[] stringArray, String[] stringArray2) {
            ArrayList<FileDescriptor> arrayList = new ArrayList<FileDescriptor>();
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                try {
                    Class<?> clazz2 = clazz.getClassLoader().loadClass(stringArray[i2]);
                    arrayList.add((FileDescriptor)clazz2.getField("descriptor").get(null));
                    continue;
                }
                catch (Exception exception) {
                    logger.warning("Descriptors for \"" + stringArray2[i2] + "\" can not be found.");
                }
            }
            return arrayList.toArray(new FileDescriptor[0]);
        }

        @Deprecated
        public static void internalBuildGeneratedFileFrom(String[] stringArray, FileDescriptor[] fileDescriptorArray, InternalDescriptorAssigner internalDescriptorAssigner) {
            FileDescriptor fileDescriptor;
            DescriptorProtos.FileDescriptorProto fileDescriptorProto;
            byte[] byArray = FileDescriptor.latin1Cat(stringArray);
            try {
                fileDescriptorProto = DescriptorProtos.FileDescriptorProto.parseFrom(byArray);
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                throw new IllegalArgumentException("Failed to parse protocol buffer descriptor for generated code.", invalidProtocolBufferException);
            }
            try {
                fileDescriptor = FileDescriptor.buildFrom(fileDescriptorProto, fileDescriptorArray, true);
            }
            catch (DescriptorValidationException descriptorValidationException) {
                throw new IllegalArgumentException("Invalid embedded descriptor for \"" + fileDescriptorProto.getName() + "\".", descriptorValidationException);
            }
            ExtensionRegistry extensionRegistry = internalDescriptorAssigner.assignDescriptors(fileDescriptor);
            if (extensionRegistry != null) {
                try {
                    fileDescriptorProto = DescriptorProtos.FileDescriptorProto.parseFrom(byArray, (ExtensionRegistryLite)extensionRegistry);
                }
                catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                    throw new IllegalArgumentException("Failed to parse protocol buffer descriptor for generated code.", invalidProtocolBufferException);
                }
                fileDescriptor.setProto(fileDescriptorProto);
            }
        }

        public static FileDescriptor internalBuildGeneratedFileFrom(String[] stringArray, FileDescriptor[] fileDescriptorArray) {
            DescriptorProtos.FileDescriptorProto fileDescriptorProto;
            byte[] byArray = FileDescriptor.latin1Cat(stringArray);
            try {
                fileDescriptorProto = DescriptorProtos.FileDescriptorProto.parseFrom(byArray);
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                throw new IllegalArgumentException("Failed to parse protocol buffer descriptor for generated code.", invalidProtocolBufferException);
            }
            try {
                return FileDescriptor.buildFrom(fileDescriptorProto, fileDescriptorArray, true);
            }
            catch (DescriptorValidationException descriptorValidationException) {
                throw new IllegalArgumentException("Invalid embedded descriptor for \"" + fileDescriptorProto.getName() + "\".", descriptorValidationException);
            }
        }

        @Deprecated
        public static void internalBuildGeneratedFileFrom(String[] stringArray, Class<?> clazz, String[] stringArray2, String[] stringArray3, InternalDescriptorAssigner internalDescriptorAssigner) {
            FileDescriptor[] fileDescriptorArray = FileDescriptor.findDescriptors(clazz, stringArray2, stringArray3);
            FileDescriptor.internalBuildGeneratedFileFrom(stringArray, fileDescriptorArray, internalDescriptorAssigner);
        }

        public static FileDescriptor internalBuildGeneratedFileFrom(String[] stringArray, Class<?> clazz, String[] stringArray2, String[] stringArray3) {
            FileDescriptor[] fileDescriptorArray = FileDescriptor.findDescriptors(clazz, stringArray2, stringArray3);
            return FileDescriptor.internalBuildGeneratedFileFrom(stringArray, fileDescriptorArray);
        }

        public static void internalUpdateFileDescriptor(FileDescriptor fileDescriptor, ExtensionRegistry extensionRegistry) {
            DescriptorProtos.FileDescriptorProto fileDescriptorProto;
            ByteString byteString = fileDescriptor.proto.toByteString();
            try {
                fileDescriptorProto = DescriptorProtos.FileDescriptorProto.parseFrom(byteString, (ExtensionRegistryLite)extensionRegistry);
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                throw new IllegalArgumentException("Failed to parse protocol buffer descriptor for generated code.", invalidProtocolBufferException);
            }
            fileDescriptor.setProto(fileDescriptorProto);
        }

        private FileDescriptor(DescriptorProtos.FileDescriptorProto fileDescriptorProto, FileDescriptor[] fileDescriptorArray, DescriptorPool descriptorPool, boolean bl2) throws DescriptorValidationException {
            int n2;
            this.pool = descriptorPool;
            this.proto = fileDescriptorProto;
            this.dependencies = (FileDescriptor[])fileDescriptorArray.clone();
            HashMap<String, FileDescriptor> hashMap = new HashMap<String, FileDescriptor>();
            for (FileDescriptor object : fileDescriptorArray) {
                hashMap.put(object.getName(), object);
            }
            ArrayList arrayList = new ArrayList();
            for (n2 = 0; n2 < fileDescriptorProto.getPublicDependencyCount(); ++n2) {
                int n3 = fileDescriptorProto.getPublicDependency(n2);
                if (n3 < 0 || n3 >= fileDescriptorProto.getDependencyCount()) {
                    throw new DescriptorValidationException(this, "Invalid public dependency index.");
                }
                String string2 = fileDescriptorProto.getDependency(n3);
                FileDescriptor fileDescriptor = (FileDescriptor)hashMap.get(string2);
                if (fileDescriptor == null) {
                    if (bl2) continue;
                    throw new DescriptorValidationException(this, "Invalid public dependency: " + string2);
                }
                arrayList.add(fileDescriptor);
            }
            this.publicDependencies = new FileDescriptor[arrayList.size()];
            arrayList.toArray(this.publicDependencies);
            descriptorPool.addPackage(this.getPackage(), this);
            this.messageTypes = new Descriptor[fileDescriptorProto.getMessageTypeCount()];
            for (n2 = 0; n2 < fileDescriptorProto.getMessageTypeCount(); ++n2) {
                this.messageTypes[n2] = new Descriptor(fileDescriptorProto.getMessageType(n2), this, null, n2);
            }
            this.enumTypes = new EnumDescriptor[fileDescriptorProto.getEnumTypeCount()];
            for (n2 = 0; n2 < fileDescriptorProto.getEnumTypeCount(); ++n2) {
                this.enumTypes[n2] = new EnumDescriptor(fileDescriptorProto.getEnumType(n2), this, null, n2);
            }
            this.services = new ServiceDescriptor[fileDescriptorProto.getServiceCount()];
            for (n2 = 0; n2 < fileDescriptorProto.getServiceCount(); ++n2) {
                this.services[n2] = new ServiceDescriptor(fileDescriptorProto.getService(n2), this, n2);
            }
            this.extensions = new FieldDescriptor[fileDescriptorProto.getExtensionCount()];
            for (n2 = 0; n2 < fileDescriptorProto.getExtensionCount(); ++n2) {
                this.extensions[n2] = new FieldDescriptor(fileDescriptorProto.getExtension(n2), this, null, n2, true);
            }
        }

        FileDescriptor(String string2, Descriptor descriptor) throws DescriptorValidationException {
            this.pool = new DescriptorPool(new FileDescriptor[0], true);
            this.proto = DescriptorProtos.FileDescriptorProto.newBuilder().setName(descriptor.getFullName() + ".placeholder.proto").setPackage(string2).addMessageType(descriptor.toProto()).build();
            this.dependencies = new FileDescriptor[0];
            this.publicDependencies = new FileDescriptor[0];
            this.messageTypes = new Descriptor[]{descriptor};
            this.enumTypes = new EnumDescriptor[0];
            this.services = new ServiceDescriptor[0];
            this.extensions = new FieldDescriptor[0];
            this.pool.addPackage(string2, this);
            this.pool.addSymbol(descriptor);
        }

        private void crossLink() throws DescriptorValidationException {
            for (Descriptor genericDescriptor : this.messageTypes) {
                genericDescriptor.crossLink();
            }
            for (GenericDescriptor genericDescriptor : this.services) {
                ((ServiceDescriptor)genericDescriptor).crossLink();
            }
            for (GenericDescriptor genericDescriptor : this.extensions) {
                ((FieldDescriptor)genericDescriptor).crossLink();
            }
        }

        private void setProto(DescriptorProtos.FileDescriptorProto fileDescriptorProto) {
            int n2;
            this.proto = fileDescriptorProto;
            for (n2 = 0; n2 < this.messageTypes.length; ++n2) {
                this.messageTypes[n2].setProto(fileDescriptorProto.getMessageType(n2));
            }
            for (n2 = 0; n2 < this.enumTypes.length; ++n2) {
                this.enumTypes[n2].setProto(fileDescriptorProto.getEnumType(n2));
            }
            for (n2 = 0; n2 < this.services.length; ++n2) {
                this.services[n2].setProto(fileDescriptorProto.getService(n2));
            }
            for (n2 = 0; n2 < this.extensions.length; ++n2) {
                this.extensions[n2].setProto(fileDescriptorProto.getExtension(n2));
            }
        }

        boolean supportsUnknownEnumValue() {
            return this.getSyntax() == Syntax.PROTO3;
        }

        @Deprecated
        public static interface InternalDescriptorAssigner {
            public ExtensionRegistry assignDescriptors(FileDescriptor var1);
        }

        public static enum Syntax {
            UNKNOWN("unknown"),
            PROTO2("proto2"),
            PROTO3("proto3");

            private final String name;

            private Syntax(String string3) {
                this.name = string3;
            }
        }
    }
}

