/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.JavaType;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.List;

public enum FieldType {
    DOUBLE(0, Collection.SCALAR, JavaType.DOUBLE),
    FLOAT(1, Collection.SCALAR, JavaType.FLOAT),
    INT64(2, Collection.SCALAR, JavaType.LONG),
    UINT64(3, Collection.SCALAR, JavaType.LONG),
    INT32(4, Collection.SCALAR, JavaType.INT),
    FIXED64(5, Collection.SCALAR, JavaType.LONG),
    FIXED32(6, Collection.SCALAR, JavaType.INT),
    BOOL(7, Collection.SCALAR, JavaType.BOOLEAN),
    STRING(8, Collection.SCALAR, JavaType.STRING),
    MESSAGE(9, Collection.SCALAR, JavaType.MESSAGE),
    BYTES(10, Collection.SCALAR, JavaType.BYTE_STRING),
    UINT32(11, Collection.SCALAR, JavaType.INT),
    ENUM(12, Collection.SCALAR, JavaType.ENUM),
    SFIXED32(13, Collection.SCALAR, JavaType.INT),
    SFIXED64(14, Collection.SCALAR, JavaType.LONG),
    SINT32(15, Collection.SCALAR, JavaType.INT),
    SINT64(16, Collection.SCALAR, JavaType.LONG),
    GROUP(17, Collection.SCALAR, JavaType.MESSAGE),
    DOUBLE_LIST(18, Collection.VECTOR, JavaType.DOUBLE),
    FLOAT_LIST(19, Collection.VECTOR, JavaType.FLOAT),
    INT64_LIST(20, Collection.VECTOR, JavaType.LONG),
    UINT64_LIST(21, Collection.VECTOR, JavaType.LONG),
    INT32_LIST(22, Collection.VECTOR, JavaType.INT),
    FIXED64_LIST(23, Collection.VECTOR, JavaType.LONG),
    FIXED32_LIST(24, Collection.VECTOR, JavaType.INT),
    BOOL_LIST(25, Collection.VECTOR, JavaType.BOOLEAN),
    STRING_LIST(26, Collection.VECTOR, JavaType.STRING),
    MESSAGE_LIST(27, Collection.VECTOR, JavaType.MESSAGE),
    BYTES_LIST(28, Collection.VECTOR, JavaType.BYTE_STRING),
    UINT32_LIST(29, Collection.VECTOR, JavaType.INT),
    ENUM_LIST(30, Collection.VECTOR, JavaType.ENUM),
    SFIXED32_LIST(31, Collection.VECTOR, JavaType.INT),
    SFIXED64_LIST(32, Collection.VECTOR, JavaType.LONG),
    SINT32_LIST(33, Collection.VECTOR, JavaType.INT),
    SINT64_LIST(34, Collection.VECTOR, JavaType.LONG),
    DOUBLE_LIST_PACKED(35, Collection.PACKED_VECTOR, JavaType.DOUBLE),
    FLOAT_LIST_PACKED(36, Collection.PACKED_VECTOR, JavaType.FLOAT),
    INT64_LIST_PACKED(37, Collection.PACKED_VECTOR, JavaType.LONG),
    UINT64_LIST_PACKED(38, Collection.PACKED_VECTOR, JavaType.LONG),
    INT32_LIST_PACKED(39, Collection.PACKED_VECTOR, JavaType.INT),
    FIXED64_LIST_PACKED(40, Collection.PACKED_VECTOR, JavaType.LONG),
    FIXED32_LIST_PACKED(41, Collection.PACKED_VECTOR, JavaType.INT),
    BOOL_LIST_PACKED(42, Collection.PACKED_VECTOR, JavaType.BOOLEAN),
    UINT32_LIST_PACKED(43, Collection.PACKED_VECTOR, JavaType.INT),
    ENUM_LIST_PACKED(44, Collection.PACKED_VECTOR, JavaType.ENUM),
    SFIXED32_LIST_PACKED(45, Collection.PACKED_VECTOR, JavaType.INT),
    SFIXED64_LIST_PACKED(46, Collection.PACKED_VECTOR, JavaType.LONG),
    SINT32_LIST_PACKED(47, Collection.PACKED_VECTOR, JavaType.INT),
    SINT64_LIST_PACKED(48, Collection.PACKED_VECTOR, JavaType.LONG),
    GROUP_LIST(49, Collection.VECTOR, JavaType.MESSAGE),
    MAP(50, Collection.MAP, JavaType.VOID);

    private final JavaType javaType;
    private final int id;
    private final Collection collection;
    private final Class<?> elementType;
    private final boolean primitiveScalar;
    private static final FieldType[] VALUES;
    private static final Type[] EMPTY_TYPES;

    private FieldType(int n3, Collection collection, JavaType javaType) {
        this.id = n3;
        this.collection = collection;
        this.javaType = javaType;
        switch (collection) {
            case MAP: {
                this.elementType = javaType.getBoxedType();
                break;
            }
            case VECTOR: {
                this.elementType = javaType.getBoxedType();
                break;
            }
            default: {
                this.elementType = null;
            }
        }
        boolean bl2 = false;
        if (collection == Collection.SCALAR) {
            switch (javaType) {
                case BYTE_STRING: 
                case MESSAGE: 
                case STRING: {
                    break;
                }
                default: {
                    bl2 = true;
                }
            }
        }
        this.primitiveScalar = bl2;
    }

    public int id() {
        return this.id;
    }

    public JavaType getJavaType() {
        return this.javaType;
    }

    public boolean isPacked() {
        return Collection.PACKED_VECTOR.equals((Object)this.collection);
    }

    public boolean isPrimitiveScalar() {
        return this.primitiveScalar;
    }

    public boolean isScalar() {
        return this.collection == Collection.SCALAR;
    }

    public boolean isList() {
        return this.collection.isList();
    }

    public boolean isMap() {
        return this.collection == Collection.MAP;
    }

    public boolean isValidForField(Field field) {
        if (Collection.VECTOR.equals((Object)this.collection)) {
            return this.isValidForList(field);
        }
        return this.javaType.getType().isAssignableFrom(field.getType());
    }

    private boolean isValidForList(Field field) {
        Type type;
        Class<?> clazz = field.getType();
        if (!this.javaType.getType().isAssignableFrom(clazz)) {
            return false;
        }
        Type[] typeArray = EMPTY_TYPES;
        Type type2 = field.getGenericType();
        if (type2 instanceof ParameterizedType) {
            typeArray = ((ParameterizedType)field.getGenericType()).getActualTypeArguments();
        }
        if (!((type = FieldType.getListParameter(clazz, typeArray)) instanceof Class)) {
            return true;
        }
        return this.elementType.isAssignableFrom((Class)type);
    }

    public static FieldType forId(int n2) {
        if (n2 < 0 || n2 >= VALUES.length) {
            return null;
        }
        return VALUES[n2];
    }

    private static Type getGenericSuperList(Class<?> clazz) {
        ParameterizedType parameterizedType;
        Class clazz2;
        Type[] typeArray;
        for (Type type : typeArray = clazz.getGenericInterfaces()) {
            ParameterizedType parameterizedType2;
            Class clazz3;
            if (!(type instanceof ParameterizedType) || !List.class.isAssignableFrom(clazz3 = (Class)(parameterizedType2 = (ParameterizedType)type).getRawType())) continue;
            return type;
        }
        Type type = clazz.getGenericSuperclass();
        if (type instanceof ParameterizedType && List.class.isAssignableFrom(clazz2 = (Class)(parameterizedType = (ParameterizedType)type).getRawType())) {
            return type;
        }
        return null;
    }

    private static Type getListParameter(Class<?> clazz, Type[] typeArray) {
        block0: while (clazz != List.class) {
            Type type = FieldType.getGenericSuperList(clazz);
            if (type instanceof ParameterizedType) {
                Class<?>[] classArray = (Class<?>[])type;
                Type[] typeArray2 = classArray.getActualTypeArguments();
                for (int i2 = 0; i2 < typeArray2.length; ++i2) {
                    Class<?> clazz2 = typeArray2[i2];
                    if (!(clazz2 instanceof TypeVariable)) continue;
                    TypeVariable<Class<T>>[] typeVariableArray = clazz.getTypeParameters();
                    if (typeArray.length != typeVariableArray.length) {
                        throw new RuntimeException("Type array mismatch");
                    }
                    boolean bl2 = false;
                    for (int i3 = 0; i3 < typeVariableArray.length; ++i3) {
                        Type type2;
                        if (clazz2 != typeVariableArray[i3]) continue;
                        typeArray2[i2] = type2 = typeArray[i3];
                        bl2 = true;
                        break;
                    }
                    if (bl2) continue;
                    throw new RuntimeException("Unable to find replacement for " + clazz2);
                }
                Class<?> clazz3 = (Class<?>)classArray.getRawType();
                typeArray = typeArray2;
                clazz = clazz3;
                continue;
            }
            typeArray = EMPTY_TYPES;
            for (Class<?> clazz2 : clazz.getInterfaces()) {
                if (!List.class.isAssignableFrom(clazz2)) continue;
                clazz = clazz2;
                continue block0;
            }
            clazz = clazz.getSuperclass();
        }
        if (typeArray.length != 1) {
            throw new RuntimeException("Unable to identify parameter type for List<T>");
        }
        return typeArray[0];
    }

    static {
        EMPTY_TYPES = new Type[0];
        FieldType[] fieldTypeArray = FieldType.values();
        VALUES = new FieldType[fieldTypeArray.length];
        FieldType[] fieldTypeArray2 = fieldTypeArray;
        int n2 = fieldTypeArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            FieldType fieldType;
            FieldType.VALUES[fieldType.id] = fieldType = fieldTypeArray2[i2];
        }
    }

    static enum Collection {
        SCALAR(false),
        VECTOR(true),
        PACKED_VECTOR(true),
        MAP(false);

        private final boolean isList;

        private Collection(boolean bl2) {
            this.isList = bl2;
        }

        public boolean isList() {
            return this.isList;
        }
    }
}

