/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.Internal;
import com.google.protobuf.LazyStringArrayList;
import com.google.protobuf.LazyStringList;
import com.google.protobuf.PrimitiveNonBoxingCollection;
import com.google.protobuf.UnmodifiableLazyStringList;
import com.google.protobuf.UnsafeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

abstract class ListFieldSchema {
    private static final ListFieldSchema FULL_INSTANCE = new ListFieldSchemaFull();
    private static final ListFieldSchema LITE_INSTANCE = new ListFieldSchemaLite();

    private ListFieldSchema() {
    }

    abstract <L> List<L> mutableListAt(Object var1, long var2);

    abstract void makeImmutableListAt(Object var1, long var2);

    abstract <L> void mergeListsAt(Object var1, Object var2, long var3);

    static ListFieldSchema full() {
        return FULL_INSTANCE;
    }

    static ListFieldSchema lite() {
        return LITE_INSTANCE;
    }

    private static final class ListFieldSchemaLite
    extends ListFieldSchema {
        private ListFieldSchemaLite() {
        }

        @Override
        <L> List<L> mutableListAt(Object object, long l2) {
            Internal.ProtobufList protobufList = ListFieldSchemaLite.getProtobufList(object, l2);
            if (!protobufList.isModifiable()) {
                int n2 = protobufList.size();
                protobufList = protobufList.mutableCopyWithCapacity(n2 == 0 ? 10 : n2 * 2);
                UnsafeUtil.putObject(object, l2, protobufList);
            }
            return protobufList;
        }

        @Override
        void makeImmutableListAt(Object object, long l2) {
            Internal.ProtobufList protobufList = ListFieldSchemaLite.getProtobufList(object, l2);
            protobufList.makeImmutable();
        }

        @Override
        <E> void mergeListsAt(Object object, Object object2, long l2) {
            Internal.ProtobufList<E> protobufList = ListFieldSchemaLite.getProtobufList(object, l2);
            Internal.ProtobufList<E> protobufList2 = ListFieldSchemaLite.getProtobufList(object2, l2);
            int n2 = protobufList.size();
            int n3 = protobufList2.size();
            if (n2 > 0 && n3 > 0) {
                if (!protobufList.isModifiable()) {
                    protobufList = protobufList.mutableCopyWithCapacity(n2 + n3);
                }
                protobufList.addAll(protobufList2);
            }
            Internal.ProtobufList<E> protobufList3 = n2 > 0 ? protobufList : protobufList2;
            UnsafeUtil.putObject(object, l2, protobufList3);
        }

        static <E> Internal.ProtobufList<E> getProtobufList(Object object, long l2) {
            return (Internal.ProtobufList)UnsafeUtil.getObject(object, l2);
        }
    }

    private static final class ListFieldSchemaFull
    extends ListFieldSchema {
        private static final Class<?> UNMODIFIABLE_LIST_CLASS = Collections.unmodifiableList(Collections.emptyList()).getClass();

        private ListFieldSchemaFull() {
        }

        @Override
        <L> List<L> mutableListAt(Object object, long l2) {
            return ListFieldSchemaFull.mutableListAt(object, l2, 10);
        }

        @Override
        void makeImmutableListAt(Object object, long l2) {
            List list = (List)UnsafeUtil.getObject(object, l2);
            List<String> list2 = null;
            if (list instanceof LazyStringList) {
                list2 = ((LazyStringList)list).getUnmodifiableView();
            } else {
                if (UNMODIFIABLE_LIST_CLASS.isAssignableFrom(list.getClass())) {
                    return;
                }
                if (list instanceof PrimitiveNonBoxingCollection && list instanceof Internal.ProtobufList) {
                    if (((Internal.ProtobufList)list).isModifiable()) {
                        ((Internal.ProtobufList)list).makeImmutable();
                    }
                    return;
                }
                list2 = Collections.unmodifiableList(list);
            }
            UnsafeUtil.putObject(object, l2, (Object)list2);
        }

        private static <L> List<L> mutableListAt(Object object, long l2, int n2) {
            List<String> list = ListFieldSchemaFull.getList(object, l2);
            if (list.isEmpty()) {
                list = list instanceof LazyStringList ? new LazyStringArrayList(n2) : (list instanceof PrimitiveNonBoxingCollection && list instanceof Internal.ProtobufList ? ((Internal.ProtobufList)list).mutableCopyWithCapacity(n2) : new ArrayList(n2));
                UnsafeUtil.putObject(object, l2, (Object)list);
            } else if (UNMODIFIABLE_LIST_CLASS.isAssignableFrom(list.getClass())) {
                ArrayList<String> arrayList = new ArrayList<String>(list.size() + n2);
                arrayList.addAll(list);
                list = arrayList;
                UnsafeUtil.putObject(object, l2, list);
            } else if (list instanceof UnmodifiableLazyStringList) {
                LazyStringArrayList lazyStringArrayList = new LazyStringArrayList(list.size() + n2);
                lazyStringArrayList.addAll((UnmodifiableLazyStringList)list);
                list = lazyStringArrayList;
                UnsafeUtil.putObject(object, l2, list);
            } else if (list instanceof PrimitiveNonBoxingCollection && list instanceof Internal.ProtobufList && !((Internal.ProtobufList)list).isModifiable()) {
                list = ((Internal.ProtobufList)list).mutableCopyWithCapacity(list.size() + n2);
                UnsafeUtil.putObject(object, l2, list);
            }
            return list;
        }

        @Override
        <E> void mergeListsAt(Object object, Object object2, long l2) {
            List<E> list = ListFieldSchemaFull.getList(object2, l2);
            List list2 = ListFieldSchemaFull.mutableListAt(object, l2, list.size());
            int n2 = list2.size();
            int n3 = list.size();
            if (n2 > 0 && n3 > 0) {
                list2.addAll(list);
            }
            List<Object> list3 = n2 > 0 ? list2 : list;
            UnsafeUtil.putObject(object, l2, list3);
        }

        static <E> List<E> getList(Object object, long l2) {
            return (List)UnsafeUtil.getObject(object, l2);
        }
    }
}

