/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MapEntryLite;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.UnknownFieldSet;
import com.google.protobuf.WireFormat;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

public final class MapEntry<K, V>
extends AbstractMessage {
    private final K key;
    private final V value;
    private final Metadata<K, V> metadata;
    private volatile int cachedSerializedSize = -1;

    private MapEntry(Descriptors.Descriptor descriptor, WireFormat.FieldType fieldType, K k2, WireFormat.FieldType fieldType2, V v2) {
        this.key = k2;
        this.value = v2;
        this.metadata = new Metadata(descriptor, this, fieldType, fieldType2);
    }

    private MapEntry(Metadata metadata, K k2, V v2) {
        this.key = k2;
        this.value = v2;
        this.metadata = metadata;
    }

    private MapEntry(Metadata<K, V> metadata, CodedInputStream codedInputStream, ExtensionRegistryLite extensionRegistryLite) throws InvalidProtocolBufferException {
        try {
            this.metadata = metadata;
            Map.Entry<K, V> entry = MapEntryLite.parseEntry(codedInputStream, metadata, extensionRegistryLite);
            this.key = entry.getKey();
            this.value = entry.getValue();
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            throw invalidProtocolBufferException.setUnfinishedMessage(this);
        }
        catch (IOException iOException) {
            throw new InvalidProtocolBufferException(iOException).setUnfinishedMessage(this);
        }
    }

    public static <K, V> MapEntry<K, V> newDefaultInstance(Descriptors.Descriptor descriptor, WireFormat.FieldType fieldType, K k2, WireFormat.FieldType fieldType2, V v2) {
        return new MapEntry<K, V>(descriptor, fieldType, k2, fieldType2, v2);
    }

    public K getKey() {
        return this.key;
    }

    public V getValue() {
        return this.value;
    }

    @Override
    public int getSerializedSize() {
        int n2;
        if (this.cachedSerializedSize != -1) {
            return this.cachedSerializedSize;
        }
        this.cachedSerializedSize = n2 = MapEntryLite.computeSerializedSize(this.metadata, this.key, this.value);
        return n2;
    }

    @Override
    public void writeTo(CodedOutputStream codedOutputStream) throws IOException {
        MapEntryLite.writeTo(codedOutputStream, this.metadata, this.key, this.value);
    }

    @Override
    public boolean isInitialized() {
        return MapEntry.isInitialized(this.metadata, this.value);
    }

    public Parser<MapEntry<K, V>> getParserForType() {
        return this.metadata.parser;
    }

    @Override
    public Builder<K, V> newBuilderForType() {
        return new Builder(this.metadata);
    }

    @Override
    public Builder<K, V> toBuilder() {
        return new Builder(this.metadata, this.key, this.value, true, true);
    }

    @Override
    public MapEntry<K, V> getDefaultInstanceForType() {
        return new MapEntry<Object, Object>(this.metadata, this.metadata.defaultKey, this.metadata.defaultValue);
    }

    @Override
    public Descriptors.Descriptor getDescriptorForType() {
        return this.metadata.descriptor;
    }

    @Override
    public Map<Descriptors.FieldDescriptor, Object> getAllFields() {
        TreeMap<Descriptors.FieldDescriptor, Object> treeMap = new TreeMap<Descriptors.FieldDescriptor, Object>();
        for (Descriptors.FieldDescriptor fieldDescriptor : this.metadata.descriptor.getFields()) {
            if (!this.hasField(fieldDescriptor)) continue;
            treeMap.put(fieldDescriptor, this.getField(fieldDescriptor));
        }
        return Collections.unmodifiableMap(treeMap);
    }

    private void checkFieldDescriptor(Descriptors.FieldDescriptor fieldDescriptor) {
        if (fieldDescriptor.getContainingType() != this.metadata.descriptor) {
            throw new RuntimeException("Wrong FieldDescriptor \"" + fieldDescriptor.getFullName() + "\" used in message \"" + this.metadata.descriptor.getFullName());
        }
    }

    @Override
    public boolean hasField(Descriptors.FieldDescriptor fieldDescriptor) {
        this.checkFieldDescriptor(fieldDescriptor);
        return true;
    }

    @Override
    public Object getField(Descriptors.FieldDescriptor fieldDescriptor) {
        Object object;
        this.checkFieldDescriptor(fieldDescriptor);
        Object object2 = object = fieldDescriptor.getNumber() == 1 ? this.getKey() : this.getValue();
        if (fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.ENUM) {
            object = fieldDescriptor.getEnumType().findValueByNumberCreatingIfUnknown((Integer)object);
        }
        return object;
    }

    @Override
    public int getRepeatedFieldCount(Descriptors.FieldDescriptor fieldDescriptor) {
        throw new RuntimeException("There is no repeated field in a map entry message.");
    }

    @Override
    public Object getRepeatedField(Descriptors.FieldDescriptor fieldDescriptor, int n2) {
        throw new RuntimeException("There is no repeated field in a map entry message.");
    }

    @Override
    public UnknownFieldSet getUnknownFields() {
        return UnknownFieldSet.getDefaultInstance();
    }

    private static <V> boolean isInitialized(Metadata metadata, V v2) {
        if (metadata.valueType.getJavaType() == WireFormat.JavaType.MESSAGE) {
            return ((MessageLite)v2).isInitialized();
        }
        return true;
    }

    final Metadata<K, V> getMetadata() {
        return this.metadata;
    }

    public static class Builder<K, V>
    extends AbstractMessage.Builder<Builder<K, V>> {
        private final Metadata<K, V> metadata;
        private K key;
        private V value;
        private boolean hasKey;
        private boolean hasValue;

        private Builder(Metadata<K, V> metadata) {
            this(metadata, metadata.defaultKey, metadata.defaultValue, false, false);
        }

        private Builder(Metadata<K, V> metadata, K k2, V v2, boolean bl2, boolean bl3) {
            this.metadata = metadata;
            this.key = k2;
            this.value = v2;
            this.hasKey = bl2;
            this.hasValue = bl3;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        public Builder<K, V> setKey(K k2) {
            this.key = k2;
            this.hasKey = true;
            return this;
        }

        public Builder<K, V> clearKey() {
            this.key = this.metadata.defaultKey;
            this.hasKey = false;
            return this;
        }

        public Builder<K, V> setValue(V v2) {
            this.value = v2;
            this.hasValue = true;
            return this;
        }

        public Builder<K, V> clearValue() {
            this.value = this.metadata.defaultValue;
            this.hasValue = false;
            return this;
        }

        @Override
        public MapEntry<K, V> build() {
            Message message = this.buildPartial();
            if (!((MapEntry)message).isInitialized()) {
                throw Builder.newUninitializedMessageException(message);
            }
            return message;
        }

        @Override
        public MapEntry<K, V> buildPartial() {
            return new MapEntry(this.metadata, this.key, this.value);
        }

        @Override
        public Descriptors.Descriptor getDescriptorForType() {
            return this.metadata.descriptor;
        }

        private void checkFieldDescriptor(Descriptors.FieldDescriptor fieldDescriptor) {
            if (fieldDescriptor.getContainingType() != this.metadata.descriptor) {
                throw new RuntimeException("Wrong FieldDescriptor \"" + fieldDescriptor.getFullName() + "\" used in message \"" + this.metadata.descriptor.getFullName());
            }
        }

        @Override
        public Message.Builder newBuilderForField(Descriptors.FieldDescriptor fieldDescriptor) {
            this.checkFieldDescriptor(fieldDescriptor);
            if (fieldDescriptor.getNumber() != 2 || fieldDescriptor.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                throw new RuntimeException("\"" + fieldDescriptor.getFullName() + "\" is not a message value field.");
            }
            return ((Message)this.value).newBuilderForType();
        }

        @Override
        public Builder<K, V> setField(Descriptors.FieldDescriptor fieldDescriptor, Object object) {
            this.checkFieldDescriptor(fieldDescriptor);
            if (fieldDescriptor.getNumber() == 1) {
                this.setKey(object);
            } else {
                if (fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.ENUM) {
                    object = ((Descriptors.EnumValueDescriptor)object).getNumber();
                } else if (fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.MESSAGE && object != null && !this.metadata.defaultValue.getClass().isInstance(object)) {
                    object = ((Message)this.metadata.defaultValue).toBuilder().mergeFrom((Message)object).build();
                }
                this.setValue(object);
            }
            return this;
        }

        @Override
        public Builder<K, V> clearField(Descriptors.FieldDescriptor fieldDescriptor) {
            this.checkFieldDescriptor(fieldDescriptor);
            if (fieldDescriptor.getNumber() == 1) {
                this.clearKey();
            } else {
                this.clearValue();
            }
            return this;
        }

        @Override
        public Builder<K, V> setRepeatedField(Descriptors.FieldDescriptor fieldDescriptor, int n2, Object object) {
            throw new RuntimeException("There is no repeated field in a map entry message.");
        }

        @Override
        public Builder<K, V> addRepeatedField(Descriptors.FieldDescriptor fieldDescriptor, Object object) {
            throw new RuntimeException("There is no repeated field in a map entry message.");
        }

        @Override
        public Builder<K, V> setUnknownFields(UnknownFieldSet unknownFieldSet) {
            return this;
        }

        @Override
        public MapEntry<K, V> getDefaultInstanceForType() {
            return new MapEntry(this.metadata, this.metadata.defaultKey, this.metadata.defaultValue);
        }

        @Override
        public boolean isInitialized() {
            return MapEntry.isInitialized(this.metadata, this.value);
        }

        @Override
        public Map<Descriptors.FieldDescriptor, Object> getAllFields() {
            TreeMap<Descriptors.FieldDescriptor, Object> treeMap = new TreeMap<Descriptors.FieldDescriptor, Object>();
            for (Descriptors.FieldDescriptor fieldDescriptor : this.metadata.descriptor.getFields()) {
                if (!this.hasField(fieldDescriptor)) continue;
                treeMap.put(fieldDescriptor, this.getField(fieldDescriptor));
            }
            return Collections.unmodifiableMap(treeMap);
        }

        @Override
        public boolean hasField(Descriptors.FieldDescriptor fieldDescriptor) {
            this.checkFieldDescriptor(fieldDescriptor);
            return fieldDescriptor.getNumber() == 1 ? this.hasKey : this.hasValue;
        }

        @Override
        public Object getField(Descriptors.FieldDescriptor fieldDescriptor) {
            Object object;
            this.checkFieldDescriptor(fieldDescriptor);
            Object object2 = object = fieldDescriptor.getNumber() == 1 ? this.getKey() : this.getValue();
            if (fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.ENUM) {
                object = fieldDescriptor.getEnumType().findValueByNumberCreatingIfUnknown((Integer)object);
            }
            return object;
        }

        @Override
        public int getRepeatedFieldCount(Descriptors.FieldDescriptor fieldDescriptor) {
            throw new RuntimeException("There is no repeated field in a map entry message.");
        }

        @Override
        public Object getRepeatedField(Descriptors.FieldDescriptor fieldDescriptor, int n2) {
            throw new RuntimeException("There is no repeated field in a map entry message.");
        }

        @Override
        public UnknownFieldSet getUnknownFields() {
            return UnknownFieldSet.getDefaultInstance();
        }

        @Override
        public Builder<K, V> clone() {
            return new Builder<K, V>(this.metadata, this.key, this.value, this.hasKey, this.hasValue);
        }
    }

    private static final class Metadata<K, V>
    extends MapEntryLite.Metadata<K, V> {
        public final Descriptors.Descriptor descriptor;
        public final Parser<MapEntry<K, V>> parser;

        public Metadata(Descriptors.Descriptor descriptor, MapEntry<K, V> mapEntry, WireFormat.FieldType fieldType, WireFormat.FieldType fieldType2) {
            super(fieldType, ((MapEntry)mapEntry).key, fieldType2, ((MapEntry)mapEntry).value);
            this.descriptor = descriptor;
            this.parser = new AbstractParser<MapEntry<K, V>>(){

                @Override
                public MapEntry<K, V> parsePartialFrom(CodedInputStream codedInputStream, ExtensionRegistryLite extensionRegistryLite) throws InvalidProtocolBufferException {
                    return new MapEntry(Metadata.this, codedInputStream, extensionRegistryLite);
                }
            };
        }
    }
}

