/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.Internal;
import com.google.protobuf.MapEntry;
import com.google.protobuf.MapFieldLite;
import com.google.protobuf.Message;
import com.google.protobuf.MutabilityOracle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MapField<K, V>
implements MutabilityOracle {
    private volatile boolean isMutable;
    private volatile StorageMode mode;
    private MutatabilityAwareMap<K, V> mapData;
    private List<Message> listData;
    private final Converter<K, V> converter;

    private MapField(Converter<K, V> converter, StorageMode storageMode, Map<K, V> map) {
        this.converter = converter;
        this.isMutable = true;
        this.mode = storageMode;
        this.mapData = new MutatabilityAwareMap<K, V>(this, map);
        this.listData = null;
    }

    private MapField(MapEntry<K, V> mapEntry, StorageMode storageMode, Map<K, V> map) {
        this(new ImmutableMessageConverter<K, V>(mapEntry), storageMode, map);
    }

    public static <K, V> MapField<K, V> emptyMapField(MapEntry<K, V> mapEntry) {
        return new MapField<K, V>(mapEntry, StorageMode.MAP, Collections.emptyMap());
    }

    public static <K, V> MapField<K, V> newMapField(MapEntry<K, V> mapEntry) {
        return new MapField<K, V>(mapEntry, StorageMode.MAP, new LinkedHashMap());
    }

    private Message convertKeyAndValueToMessage(K k2, V v2) {
        return this.converter.convertKeyAndValueToMessage(k2, v2);
    }

    private void convertMessageToKeyAndValue(Message message, Map<K, V> map) {
        this.converter.convertMessageToKeyAndValue(message, map);
    }

    private List<Message> convertMapToList(MutatabilityAwareMap<K, V> mutatabilityAwareMap) {
        ArrayList<Message> arrayList = new ArrayList<Message>();
        for (Map.Entry<K, V> entry : mutatabilityAwareMap.entrySet()) {
            arrayList.add(this.convertKeyAndValueToMessage(entry.getKey(), entry.getValue()));
        }
        return arrayList;
    }

    private MutatabilityAwareMap<K, V> convertListToMap(List<Message> list) {
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (Message message : list) {
            this.convertMessageToKeyAndValue(message, linkedHashMap);
        }
        return new MutatabilityAwareMap(this, linkedHashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<K, V> getMap() {
        if (this.mode == StorageMode.LIST) {
            MapField mapField = this;
            synchronized (mapField) {
                if (this.mode == StorageMode.LIST) {
                    this.mapData = this.convertListToMap(this.listData);
                    this.mode = StorageMode.BOTH;
                }
            }
        }
        return Collections.unmodifiableMap(this.mapData);
    }

    public Map<K, V> getMutableMap() {
        if (this.mode != StorageMode.MAP) {
            if (this.mode == StorageMode.LIST) {
                this.mapData = this.convertListToMap(this.listData);
            }
            this.listData = null;
            this.mode = StorageMode.MAP;
        }
        return this.mapData;
    }

    public void mergeFrom(MapField<K, V> mapField) {
        this.getMutableMap().putAll(MapFieldLite.copy(mapField.getMap()));
    }

    public void clear() {
        this.mapData = new MutatabilityAwareMap(this, new LinkedHashMap());
        this.mode = StorageMode.MAP;
    }

    public boolean equals(Object object) {
        if (!(object instanceof MapField)) {
            return false;
        }
        MapField mapField = (MapField)object;
        return MapFieldLite.equals(this.getMap(), mapField.getMap());
    }

    public int hashCode() {
        return MapFieldLite.calculateHashCodeForMap(this.getMap());
    }

    public MapField<K, V> copy() {
        return new MapField<K, V>(this.converter, StorageMode.MAP, MapFieldLite.copy(this.getMap()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Message> getList() {
        if (this.mode == StorageMode.MAP) {
            MapField mapField = this;
            synchronized (mapField) {
                if (this.mode == StorageMode.MAP) {
                    this.listData = this.convertMapToList(this.mapData);
                    this.mode = StorageMode.BOTH;
                }
            }
        }
        return Collections.unmodifiableList(this.listData);
    }

    List<Message> getMutableList() {
        if (this.mode != StorageMode.LIST) {
            if (this.mode == StorageMode.MAP) {
                this.listData = this.convertMapToList(this.mapData);
            }
            this.mapData = null;
            this.mode = StorageMode.LIST;
        }
        return this.listData;
    }

    Message getMapEntryMessageDefaultInstance() {
        return this.converter.getMessageDefaultInstance();
    }

    public void makeImmutable() {
        this.isMutable = false;
    }

    public boolean isMutable() {
        return this.isMutable;
    }

    @Override
    public void ensureMutable() {
        if (!this.isMutable()) {
            throw new UnsupportedOperationException();
        }
    }

    private static class MutatabilityAwareMap<K, V>
    implements Map<K, V> {
        private final MutabilityOracle mutabilityOracle;
        private final Map<K, V> delegate;

        MutatabilityAwareMap(MutabilityOracle mutabilityOracle, Map<K, V> map) {
            this.mutabilityOracle = mutabilityOracle;
            this.delegate = map;
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public boolean containsKey(Object object) {
            return this.delegate.containsKey(object);
        }

        @Override
        public boolean containsValue(Object object) {
            return this.delegate.containsValue(object);
        }

        @Override
        public V get(Object object) {
            return this.delegate.get(object);
        }

        @Override
        public V put(K k2, V v2) {
            this.mutabilityOracle.ensureMutable();
            Internal.checkNotNull(k2);
            Internal.checkNotNull(v2);
            return this.delegate.put(k2, v2);
        }

        @Override
        public V remove(Object object) {
            this.mutabilityOracle.ensureMutable();
            return this.delegate.remove(object);
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            this.mutabilityOracle.ensureMutable();
            for (K k2 : map.keySet()) {
                Internal.checkNotNull(k2);
                Internal.checkNotNull(map.get(k2));
            }
            this.delegate.putAll(map);
        }

        @Override
        public void clear() {
            this.mutabilityOracle.ensureMutable();
            this.delegate.clear();
        }

        @Override
        public Set<K> keySet() {
            return new MutatabilityAwareSet<K>(this.mutabilityOracle, this.delegate.keySet());
        }

        @Override
        public Collection<V> values() {
            return new MutatabilityAwareCollection<V>(this.mutabilityOracle, this.delegate.values());
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return new MutatabilityAwareSet<Map.Entry<K, V>>(this.mutabilityOracle, this.delegate.entrySet());
        }

        @Override
        public boolean equals(Object object) {
            return this.delegate.equals(object);
        }

        @Override
        public int hashCode() {
            return this.delegate.hashCode();
        }

        public String toString() {
            return this.delegate.toString();
        }

        private static class MutatabilityAwareIterator<E>
        implements Iterator<E> {
            private final MutabilityOracle mutabilityOracle;
            private final Iterator<E> delegate;

            MutatabilityAwareIterator(MutabilityOracle mutabilityOracle, Iterator<E> iterator) {
                this.mutabilityOracle = mutabilityOracle;
                this.delegate = iterator;
            }

            @Override
            public boolean hasNext() {
                return this.delegate.hasNext();
            }

            @Override
            public E next() {
                return this.delegate.next();
            }

            @Override
            public void remove() {
                this.mutabilityOracle.ensureMutable();
                this.delegate.remove();
            }

            public boolean equals(Object object) {
                return this.delegate.equals(object);
            }

            public int hashCode() {
                return this.delegate.hashCode();
            }

            public String toString() {
                return this.delegate.toString();
            }
        }

        private static class MutatabilityAwareSet<E>
        implements Set<E> {
            private final MutabilityOracle mutabilityOracle;
            private final Set<E> delegate;

            MutatabilityAwareSet(MutabilityOracle mutabilityOracle, Set<E> set) {
                this.mutabilityOracle = mutabilityOracle;
                this.delegate = set;
            }

            @Override
            public int size() {
                return this.delegate.size();
            }

            @Override
            public boolean isEmpty() {
                return this.delegate.isEmpty();
            }

            @Override
            public boolean contains(Object object) {
                return this.delegate.contains(object);
            }

            @Override
            public Iterator<E> iterator() {
                return new MutatabilityAwareIterator<E>(this.mutabilityOracle, this.delegate.iterator());
            }

            @Override
            public Object[] toArray() {
                return this.delegate.toArray();
            }

            @Override
            public <T> T[] toArray(T[] TArray) {
                return this.delegate.toArray(TArray);
            }

            @Override
            public boolean add(E e2) {
                this.mutabilityOracle.ensureMutable();
                return this.delegate.add(e2);
            }

            @Override
            public boolean remove(Object object) {
                this.mutabilityOracle.ensureMutable();
                return this.delegate.remove(object);
            }

            @Override
            public boolean containsAll(Collection<?> collection) {
                return this.delegate.containsAll(collection);
            }

            @Override
            public boolean addAll(Collection<? extends E> collection) {
                this.mutabilityOracle.ensureMutable();
                return this.delegate.addAll(collection);
            }

            @Override
            public boolean retainAll(Collection<?> collection) {
                this.mutabilityOracle.ensureMutable();
                return this.delegate.retainAll(collection);
            }

            @Override
            public boolean removeAll(Collection<?> collection) {
                this.mutabilityOracle.ensureMutable();
                return this.delegate.removeAll(collection);
            }

            @Override
            public void clear() {
                this.mutabilityOracle.ensureMutable();
                this.delegate.clear();
            }

            @Override
            public boolean equals(Object object) {
                return this.delegate.equals(object);
            }

            @Override
            public int hashCode() {
                return this.delegate.hashCode();
            }

            public String toString() {
                return this.delegate.toString();
            }
        }

        private static class MutatabilityAwareCollection<E>
        implements Collection<E> {
            private final MutabilityOracle mutabilityOracle;
            private final Collection<E> delegate;

            MutatabilityAwareCollection(MutabilityOracle mutabilityOracle, Collection<E> collection) {
                this.mutabilityOracle = mutabilityOracle;
                this.delegate = collection;
            }

            @Override
            public int size() {
                return this.delegate.size();
            }

            @Override
            public boolean isEmpty() {
                return this.delegate.isEmpty();
            }

            @Override
            public boolean contains(Object object) {
                return this.delegate.contains(object);
            }

            @Override
            public Iterator<E> iterator() {
                return new MutatabilityAwareIterator<E>(this.mutabilityOracle, this.delegate.iterator());
            }

            @Override
            public Object[] toArray() {
                return this.delegate.toArray();
            }

            @Override
            public <T> T[] toArray(T[] TArray) {
                return this.delegate.toArray(TArray);
            }

            @Override
            public boolean add(E e2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object object) {
                this.mutabilityOracle.ensureMutable();
                return this.delegate.remove(object);
            }

            @Override
            public boolean containsAll(Collection<?> collection) {
                return this.delegate.containsAll(collection);
            }

            @Override
            public boolean addAll(Collection<? extends E> collection) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeAll(Collection<?> collection) {
                this.mutabilityOracle.ensureMutable();
                return this.delegate.removeAll(collection);
            }

            @Override
            public boolean retainAll(Collection<?> collection) {
                this.mutabilityOracle.ensureMutable();
                return this.delegate.retainAll(collection);
            }

            @Override
            public void clear() {
                this.mutabilityOracle.ensureMutable();
                this.delegate.clear();
            }

            @Override
            public boolean equals(Object object) {
                return this.delegate.equals(object);
            }

            @Override
            public int hashCode() {
                return this.delegate.hashCode();
            }

            public String toString() {
                return this.delegate.toString();
            }
        }
    }

    private static class ImmutableMessageConverter<K, V>
    implements Converter<K, V> {
        private final MapEntry<K, V> defaultEntry;

        public ImmutableMessageConverter(MapEntry<K, V> mapEntry) {
            this.defaultEntry = mapEntry;
        }

        @Override
        public Message convertKeyAndValueToMessage(K k2, V v2) {
            return ((MapEntry.Builder)this.defaultEntry.newBuilderForType()).setKey(k2).setValue(v2).buildPartial();
        }

        @Override
        public void convertMessageToKeyAndValue(Message message, Map<K, V> map) {
            MapEntry mapEntry = (MapEntry)message;
            map.put(mapEntry.getKey(), mapEntry.getValue());
        }

        @Override
        public Message getMessageDefaultInstance() {
            return this.defaultEntry;
        }
    }

    private static interface Converter<K, V> {
        public Message convertKeyAndValueToMessage(K var1, V var2);

        public void convertMessageToKeyAndValue(Message var1, Map<K, V> var2);

        public Message getMessageDefaultInstance();
    }

    private static enum StorageMode {
        MAP,
        LIST,
        BOTH;

    }
}

