/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.Internal;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public final class MapFieldLite<K, V>
extends LinkedHashMap<K, V> {
    private boolean isMutable = true;
    private static final MapFieldLite EMPTY_MAP_FIELD = new MapFieldLite();

    private MapFieldLite() {
    }

    private MapFieldLite(Map<K, V> map) {
        super(map);
    }

    public static <K, V> MapFieldLite<K, V> emptyMapField() {
        return EMPTY_MAP_FIELD;
    }

    public void mergeFrom(MapFieldLite<K, V> mapFieldLite) {
        this.ensureMutable();
        if (!mapFieldLite.isEmpty()) {
            this.putAll(mapFieldLite);
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.isEmpty() ? Collections.emptySet() : super.entrySet();
    }

    @Override
    public void clear() {
        this.ensureMutable();
        super.clear();
    }

    @Override
    public V put(K k2, V v2) {
        this.ensureMutable();
        Internal.checkNotNull(k2);
        Internal.checkNotNull(v2);
        return super.put(k2, v2);
    }

    public V put(Map.Entry<K, V> entry) {
        return this.put(entry.getKey(), entry.getValue());
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.ensureMutable();
        MapFieldLite.checkForNullKeysAndValues(map);
        super.putAll(map);
    }

    @Override
    public V remove(Object object) {
        this.ensureMutable();
        return super.remove(object);
    }

    private static void checkForNullKeysAndValues(Map<?, ?> map) {
        for (Object obj : map.keySet()) {
            Internal.checkNotNull(obj);
            Internal.checkNotNull(map.get(obj));
        }
    }

    private static boolean equals(Object object, Object object2) {
        if (object instanceof byte[] && object2 instanceof byte[]) {
            return Arrays.equals((byte[])object, (byte[])object2);
        }
        return object.equals(object2);
    }

    static <K, V> boolean equals(Map<K, V> map, Map<K, V> map2) {
        if (map == map2) {
            return true;
        }
        if (map.size() != map2.size()) {
            return false;
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (!map2.containsKey(entry.getKey())) {
                return false;
            }
            if (MapFieldLite.equals(entry.getValue(), map2.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof Map && MapFieldLite.equals(this, (Map)object);
    }

    private static int calculateHashCodeForObject(Object object) {
        if (object instanceof byte[]) {
            return Internal.hashCode((byte[])object);
        }
        if (object instanceof Internal.EnumLite) {
            throw new UnsupportedOperationException();
        }
        return object.hashCode();
    }

    static <K, V> int calculateHashCodeForMap(Map<K, V> map) {
        int n2 = 0;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            n2 += MapFieldLite.calculateHashCodeForObject(entry.getKey()) ^ MapFieldLite.calculateHashCodeForObject(entry.getValue());
        }
        return n2;
    }

    @Override
    public int hashCode() {
        return MapFieldLite.calculateHashCodeForMap(this);
    }

    private static Object copy(Object object) {
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            return Arrays.copyOf(byArray, byArray.length);
        }
        return object;
    }

    static <K, V> Map<K, V> copy(Map<K, V> map) {
        LinkedHashMap<K, Object> linkedHashMap = new LinkedHashMap<K, Object>();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            linkedHashMap.put(entry.getKey(), MapFieldLite.copy(entry.getValue()));
        }
        return linkedHashMap;
    }

    public MapFieldLite<K, V> mutableCopy() {
        return this.isEmpty() ? new MapFieldLite<K, V>() : new MapFieldLite<K, V>(this);
    }

    public void makeImmutable() {
        this.isMutable = false;
    }

    public boolean isMutable() {
        return this.isMutable;
    }

    private void ensureMutable() {
        if (!this.isMutable()) {
            throw new UnsupportedOperationException();
        }
    }

    static {
        EMPTY_MAP_FIELD.makeImmutable();
    }
}

