/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.GeneratedMessageLite;
import com.google.protobuf.MessageLite;
import com.google.protobuf.TextFormatEscaper;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

final class MessageLiteToString {
    private static final String LIST_SUFFIX = "List";
    private static final String BUILDER_LIST_SUFFIX = "OrBuilderList";
    private static final String MAP_SUFFIX = "Map";
    private static final String BYTES_SUFFIX = "Bytes";

    MessageLiteToString() {
    }

    static String toString(MessageLite messageLite, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("# ").append(string2);
        MessageLiteToString.reflectivePrintWithIndent(messageLite, stringBuilder, 0);
        return stringBuilder.toString();
    }

    private static void reflectivePrintWithIndent(MessageLite messageLite, StringBuilder stringBuilder, int n2) {
        HashMap<String, Method> hashMap = new HashMap<String, Method>();
        HashMap<String, Method> hashMap2 = new HashMap<String, Method>();
        TreeSet<String> treeSet = new TreeSet<String>();
        for (Method object2 : messageLite.getClass().getDeclaredMethods()) {
            hashMap2.put(object2.getName(), object2);
            if (object2.getParameterTypes().length != 0) continue;
            hashMap.put(object2.getName(), object2);
            if (!object2.getName().startsWith("get")) continue;
            treeSet.add(object2.getName());
        }
        for (String string2 : treeSet) {
            Method method;
            Object object;
            String string3;
            String string4 = string3 = string2.startsWith("get") ? string2.substring(3) : string2;
            if (string3.endsWith(LIST_SUFFIX) && !string3.endsWith(BUILDER_LIST_SUFFIX) && !string3.equals(LIST_SUFFIX)) {
                String string5 = string3.substring(0, 1).toLowerCase() + string3.substring(1, string3.length() - LIST_SUFFIX.length());
                object = (Method)hashMap.get(string2);
                if (object != null && ((Method)object).getReturnType().equals(List.class)) {
                    MessageLiteToString.printField(stringBuilder, n2, MessageLiteToString.camelCaseToSnakeCase(string5), GeneratedMessageLite.invokeOrDie((Method)object, messageLite, new Object[0]));
                    continue;
                }
            }
            if (string3.endsWith(MAP_SUFFIX) && !string3.equals(MAP_SUFFIX)) {
                String string6 = string3.substring(0, 1).toLowerCase() + string3.substring(1, string3.length() - MAP_SUFFIX.length());
                object = (Method)hashMap.get(string2);
                if (object != null && ((Method)object).getReturnType().equals(Map.class) && !((AccessibleObject)object).isAnnotationPresent(Deprecated.class) && Modifier.isPublic(((Method)object).getModifiers())) {
                    MessageLiteToString.printField(stringBuilder, n2, MessageLiteToString.camelCaseToSnakeCase(string6), GeneratedMessageLite.invokeOrDie((Method)object, messageLite, new Object[0]));
                    continue;
                }
            }
            if ((method = (Method)hashMap2.get("set" + string3)) == null || string3.endsWith(BYTES_SUFFIX) && hashMap.containsKey("get" + string3.substring(0, string3.length() - BYTES_SUFFIX.length()))) continue;
            object = string3.substring(0, 1).toLowerCase() + string3.substring(1);
            Method method2 = (Method)hashMap.get("get" + string3);
            Method method3 = (Method)hashMap.get("has" + string3);
            if (method2 == null) continue;
            Object object2 = GeneratedMessageLite.invokeOrDie(method2, messageLite, new Object[0]);
            boolean bl2 = method3 == null ? !MessageLiteToString.isDefaultValue(object2) : (Boolean)GeneratedMessageLite.invokeOrDie(method3, messageLite, new Object[0]);
            boolean bl3 = bl2;
            if (!bl3) continue;
            MessageLiteToString.printField(stringBuilder, n2, MessageLiteToString.camelCaseToSnakeCase((String)object), object2);
        }
        if (messageLite instanceof GeneratedMessageLite.ExtendableMessage) {
            Iterator<Map.Entry<GeneratedMessageLite.ExtensionDescriptor, Object>> iterator = ((GeneratedMessageLite.ExtendableMessage)messageLite).extensions.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                MessageLiteToString.printField(stringBuilder, n2, "[" + ((GeneratedMessageLite.ExtensionDescriptor)entry.getKey()).getNumber() + "]", entry.getValue());
            }
        }
        if (((GeneratedMessageLite)messageLite).unknownFields != null) {
            ((GeneratedMessageLite)messageLite).unknownFields.printWithIndent(stringBuilder, n2);
        }
    }

    private static boolean isDefaultValue(Object object) {
        if (object instanceof Boolean) {
            return (Boolean)object == false;
        }
        if (object instanceof Integer) {
            return (Integer)object == 0;
        }
        if (object instanceof Float) {
            return ((Float)object).floatValue() == 0.0f;
        }
        if (object instanceof Double) {
            return (Double)object == 0.0;
        }
        if (object instanceof String) {
            return object.equals("");
        }
        if (object instanceof ByteString) {
            return object.equals(ByteString.EMPTY);
        }
        if (object instanceof MessageLite) {
            return object == ((MessageLite)object).getDefaultInstanceForType();
        }
        if (object instanceof Enum) {
            return ((Enum)object).ordinal() == 0;
        }
        return false;
    }

    static final void printField(StringBuilder stringBuilder, int n2, String string2, Object object) {
        int n3;
        if (object instanceof List) {
            List list = (List)object;
            for (Object e2 : list) {
                MessageLiteToString.printField(stringBuilder, n2, string2, e2);
            }
            return;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            for (Map.Entry entry : map.entrySet()) {
                MessageLiteToString.printField(stringBuilder, n2, string2, entry);
            }
            return;
        }
        stringBuilder.append('\n');
        for (n3 = 0; n3 < n2; ++n3) {
            stringBuilder.append(' ');
        }
        stringBuilder.append(string2);
        if (object instanceof String) {
            stringBuilder.append(": \"").append(TextFormatEscaper.escapeText((String)object)).append('\"');
        } else if (object instanceof ByteString) {
            stringBuilder.append(": \"").append(TextFormatEscaper.escapeBytes((ByteString)object)).append('\"');
        } else if (object instanceof GeneratedMessageLite) {
            stringBuilder.append(" {");
            MessageLiteToString.reflectivePrintWithIndent((GeneratedMessageLite)object, stringBuilder, n2 + 2);
            stringBuilder.append("\n");
            for (n3 = 0; n3 < n2; ++n3) {
                stringBuilder.append(' ');
            }
            stringBuilder.append("}");
        } else if (object instanceof Map.Entry) {
            stringBuilder.append(" {");
            Map.Entry entry = (Map.Entry)object;
            MessageLiteToString.printField(stringBuilder, n2 + 2, "key", entry.getKey());
            MessageLiteToString.printField(stringBuilder, n2 + 2, "value", entry.getValue());
            stringBuilder.append("\n");
            for (int i2 = 0; i2 < n2; ++i2) {
                stringBuilder.append(' ');
            }
            stringBuilder.append("}");
        } else {
            stringBuilder.append(": ").append(object.toString());
        }
    }

    private static final String camelCaseToSnakeCase(String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < string2.length(); ++i2) {
            char c2 = string2.charAt(i2);
            if (Character.isUpperCase(c2)) {
                stringBuilder.append("_");
            }
            stringBuilder.append(Character.toLowerCase(c2));
        }
        return stringBuilder.toString();
    }
}

