/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.ExtensionSchema;
import com.google.protobuf.FieldInfo;
import com.google.protobuf.FieldSet;
import com.google.protobuf.GeneratedMessageLite;
import com.google.protobuf.IntArrayList;
import com.google.protobuf.Internal;
import com.google.protobuf.LazyFieldLite;
import com.google.protobuf.LazyStringList;
import com.google.protobuf.LongArrayList;
import com.google.protobuf.MapFieldSchema;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Schema;
import com.google.protobuf.UnknownFieldSchema;
import com.google.protobuf.UnknownFieldSetLiteSchema;
import com.google.protobuf.UnsafeUtil;
import com.google.protobuf.Writer;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;

final class SchemaUtil {
    private static final Class<?> GENERATED_MESSAGE_CLASS = SchemaUtil.getGeneratedMessageClass();
    private static final UnknownFieldSchema<?, ?> PROTO2_UNKNOWN_FIELD_SET_SCHEMA = SchemaUtil.getUnknownFieldSetSchema(false);
    private static final UnknownFieldSchema<?, ?> PROTO3_UNKNOWN_FIELD_SET_SCHEMA = SchemaUtil.getUnknownFieldSetSchema(true);
    private static final UnknownFieldSchema<?, ?> UNKNOWN_FIELD_SET_LITE_SCHEMA = new UnknownFieldSetLiteSchema();
    private static final int DEFAULT_LOOK_UP_START_NUMBER = 40;

    private SchemaUtil() {
    }

    public static void requireGeneratedMessage(Class<?> clazz) {
        if (!GeneratedMessageLite.class.isAssignableFrom(clazz) && GENERATED_MESSAGE_CLASS != null && !GENERATED_MESSAGE_CLASS.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Message classes must extend GeneratedMessage or GeneratedMessageLite");
        }
    }

    public static void writeDouble(int n2, double d2, Writer writer) throws IOException {
        if (Double.compare(d2, 0.0) != 0) {
            writer.writeDouble(n2, d2);
        }
    }

    public static void writeFloat(int n2, float f2, Writer writer) throws IOException {
        if (Float.compare(f2, 0.0f) != 0) {
            writer.writeFloat(n2, f2);
        }
    }

    public static void writeInt64(int n2, long l2, Writer writer) throws IOException {
        if (l2 != 0L) {
            writer.writeInt64(n2, l2);
        }
    }

    public static void writeUInt64(int n2, long l2, Writer writer) throws IOException {
        if (l2 != 0L) {
            writer.writeUInt64(n2, l2);
        }
    }

    public static void writeSInt64(int n2, long l2, Writer writer) throws IOException {
        if (l2 != 0L) {
            writer.writeSInt64(n2, l2);
        }
    }

    public static void writeFixed64(int n2, long l2, Writer writer) throws IOException {
        if (l2 != 0L) {
            writer.writeFixed64(n2, l2);
        }
    }

    public static void writeSFixed64(int n2, long l2, Writer writer) throws IOException {
        if (l2 != 0L) {
            writer.writeSFixed64(n2, l2);
        }
    }

    public static void writeInt32(int n2, int n3, Writer writer) throws IOException {
        if (n3 != 0) {
            writer.writeInt32(n2, n3);
        }
    }

    public static void writeUInt32(int n2, int n3, Writer writer) throws IOException {
        if (n3 != 0) {
            writer.writeUInt32(n2, n3);
        }
    }

    public static void writeSInt32(int n2, int n3, Writer writer) throws IOException {
        if (n3 != 0) {
            writer.writeSInt32(n2, n3);
        }
    }

    public static void writeFixed32(int n2, int n3, Writer writer) throws IOException {
        if (n3 != 0) {
            writer.writeFixed32(n2, n3);
        }
    }

    public static void writeSFixed32(int n2, int n3, Writer writer) throws IOException {
        if (n3 != 0) {
            writer.writeSFixed32(n2, n3);
        }
    }

    public static void writeEnum(int n2, int n3, Writer writer) throws IOException {
        if (n3 != 0) {
            writer.writeEnum(n2, n3);
        }
    }

    public static void writeBool(int n2, boolean bl2, Writer writer) throws IOException {
        if (bl2) {
            writer.writeBool(n2, true);
        }
    }

    public static void writeString(int n2, Object object, Writer writer) throws IOException {
        if (object instanceof String) {
            SchemaUtil.writeStringInternal(n2, (String)object, writer);
        } else {
            SchemaUtil.writeBytes(n2, (ByteString)object, writer);
        }
    }

    private static void writeStringInternal(int n2, String string2, Writer writer) throws IOException {
        if (string2 != null && !string2.isEmpty()) {
            writer.writeString(n2, string2);
        }
    }

    public static void writeBytes(int n2, ByteString byteString, Writer writer) throws IOException {
        if (byteString != null && !byteString.isEmpty()) {
            writer.writeBytes(n2, byteString);
        }
    }

    public static void writeMessage(int n2, Object object, Writer writer) throws IOException {
        if (object != null) {
            writer.writeMessage(n2, object);
        }
    }

    public static void writeDoubleList(int n2, List<Double> list, Writer writer, boolean bl2) throws IOException {
        if (list != null && !list.isEmpty()) {
            writer.writeDoubleList(n2, list, bl2);
        }
    }

    public static void writeFloatList(int n2, List<Float> list, Writer writer, boolean bl2) throws IOException {
        if (list != null && !list.isEmpty()) {
            writer.writeFloatList(n2, list, bl2);
        }
    }

    public static void writeInt64List(int n2, List<Long> list, Writer writer, boolean bl2) throws IOException {
        if (list != null && !list.isEmpty()) {
            writer.writeInt64List(n2, list, bl2);
        }
    }

    public static void writeUInt64List(int n2, List<Long> list, Writer writer, boolean bl2) throws IOException {
        if (list != null && !list.isEmpty()) {
            writer.writeUInt64List(n2, list, bl2);
        }
    }

    public static void writeSInt64List(int n2, List<Long> list, Writer writer, boolean bl2) throws IOException {
        if (list != null && !list.isEmpty()) {
            writer.writeSInt64List(n2, list, bl2);
        }
    }

    public static void writeFixed64List(int n2, List<Long> list, Writer writer, boolean bl2) throws IOException {
        if (list != null && !list.isEmpty()) {
            writer.writeFixed64List(n2, list, bl2);
        }
    }

    public static void writeSFixed64List(int n2, List<Long> list, Writer writer, boolean bl2) throws IOException {
        if (list != null && !list.isEmpty()) {
            writer.writeSFixed64List(n2, list, bl2);
        }
    }

    public static void writeInt32List(int n2, List<Integer> list, Writer writer, boolean bl2) throws IOException {
        if (list != null && !list.isEmpty()) {
            writer.writeInt32List(n2, list, bl2);
        }
    }

    public static void writeUInt32List(int n2, List<Integer> list, Writer writer, boolean bl2) throws IOException {
        if (list != null && !list.isEmpty()) {
            writer.writeUInt32List(n2, list, bl2);
        }
    }

    public static void writeSInt32List(int n2, List<Integer> list, Writer writer, boolean bl2) throws IOException {
        if (list != null && !list.isEmpty()) {
            writer.writeSInt32List(n2, list, bl2);
        }
    }

    public static void writeFixed32List(int n2, List<Integer> list, Writer writer, boolean bl2) throws IOException {
        if (list != null && !list.isEmpty()) {
            writer.writeFixed32List(n2, list, bl2);
        }
    }

    public static void writeSFixed32List(int n2, List<Integer> list, Writer writer, boolean bl2) throws IOException {
        if (list != null && !list.isEmpty()) {
            writer.writeSFixed32List(n2, list, bl2);
        }
    }

    public static void writeEnumList(int n2, List<Integer> list, Writer writer, boolean bl2) throws IOException {
        if (list != null && !list.isEmpty()) {
            writer.writeEnumList(n2, list, bl2);
        }
    }

    public static void writeBoolList(int n2, List<Boolean> list, Writer writer, boolean bl2) throws IOException {
        if (list != null && !list.isEmpty()) {
            writer.writeBoolList(n2, list, bl2);
        }
    }

    public static void writeStringList(int n2, List<String> list, Writer writer) throws IOException {
        if (list != null && !list.isEmpty()) {
            writer.writeStringList(n2, list);
        }
    }

    public static void writeBytesList(int n2, List<ByteString> list, Writer writer) throws IOException {
        if (list != null && !list.isEmpty()) {
            writer.writeBytesList(n2, list);
        }
    }

    public static void writeMessageList(int n2, List<?> list, Writer writer) throws IOException {
        if (list != null && !list.isEmpty()) {
            writer.writeMessageList(n2, list);
        }
    }

    public static void writeMessageList(int n2, List<?> list, Writer writer, Schema schema) throws IOException {
        if (list != null && !list.isEmpty()) {
            writer.writeMessageList(n2, list, schema);
        }
    }

    public static void writeLazyFieldList(int n2, List<?> list, Writer writer) throws IOException {
        if (list != null && !list.isEmpty()) {
            for (Object obj : list) {
                ((LazyFieldLite)obj).writeTo(writer, n2);
            }
        }
    }

    public static void writeGroupList(int n2, List<?> list, Writer writer) throws IOException {
        if (list != null && !list.isEmpty()) {
            writer.writeGroupList(n2, list);
        }
    }

    public static void writeGroupList(int n2, List<?> list, Writer writer, Schema schema) throws IOException {
        if (list != null && !list.isEmpty()) {
            writer.writeGroupList(n2, list, schema);
        }
    }

    static int computeSizeInt64ListNoTag(List<Long> list) {
        int n2 = list.size();
        if (n2 == 0) {
            return 0;
        }
        int n3 = 0;
        if (list instanceof LongArrayList) {
            LongArrayList longArrayList = (LongArrayList)list;
            for (int i2 = 0; i2 < n2; ++i2) {
                n3 += CodedOutputStream.computeInt64SizeNoTag(longArrayList.getLong(i2));
            }
        } else {
            for (int i3 = 0; i3 < n2; ++i3) {
                n3 += CodedOutputStream.computeInt64SizeNoTag(list.get(i3));
            }
        }
        return n3;
    }

    static int computeSizeInt64List(int n2, List<Long> list, boolean bl2) {
        int n3 = list.size();
        if (n3 == 0) {
            return 0;
        }
        int n4 = SchemaUtil.computeSizeInt64ListNoTag(list);
        if (bl2) {
            return CodedOutputStream.computeTagSize(n2) + CodedOutputStream.computeLengthDelimitedFieldSize(n4);
        }
        return n4 + list.size() * CodedOutputStream.computeTagSize(n2);
    }

    static int computeSizeUInt64ListNoTag(List<Long> list) {
        int n2 = list.size();
        if (n2 == 0) {
            return 0;
        }
        int n3 = 0;
        if (list instanceof LongArrayList) {
            LongArrayList longArrayList = (LongArrayList)list;
            for (int i2 = 0; i2 < n2; ++i2) {
                n3 += CodedOutputStream.computeUInt64SizeNoTag(longArrayList.getLong(i2));
            }
        } else {
            for (int i3 = 0; i3 < n2; ++i3) {
                n3 += CodedOutputStream.computeUInt64SizeNoTag(list.get(i3));
            }
        }
        return n3;
    }

    static int computeSizeUInt64List(int n2, List<Long> list, boolean bl2) {
        int n3 = list.size();
        if (n3 == 0) {
            return 0;
        }
        int n4 = SchemaUtil.computeSizeUInt64ListNoTag(list);
        if (bl2) {
            return CodedOutputStream.computeTagSize(n2) + CodedOutputStream.computeLengthDelimitedFieldSize(n4);
        }
        return n4 + n3 * CodedOutputStream.computeTagSize(n2);
    }

    static int computeSizeSInt64ListNoTag(List<Long> list) {
        int n2 = list.size();
        if (n2 == 0) {
            return 0;
        }
        int n3 = 0;
        if (list instanceof LongArrayList) {
            LongArrayList longArrayList = (LongArrayList)list;
            for (int i2 = 0; i2 < n2; ++i2) {
                n3 += CodedOutputStream.computeSInt64SizeNoTag(longArrayList.getLong(i2));
            }
        } else {
            for (int i3 = 0; i3 < n2; ++i3) {
                n3 += CodedOutputStream.computeSInt64SizeNoTag(list.get(i3));
            }
        }
        return n3;
    }

    static int computeSizeSInt64List(int n2, List<Long> list, boolean bl2) {
        int n3 = list.size();
        if (n3 == 0) {
            return 0;
        }
        int n4 = SchemaUtil.computeSizeSInt64ListNoTag(list);
        if (bl2) {
            return CodedOutputStream.computeTagSize(n2) + CodedOutputStream.computeLengthDelimitedFieldSize(n4);
        }
        return n4 + n3 * CodedOutputStream.computeTagSize(n2);
    }

    static int computeSizeEnumListNoTag(List<Integer> list) {
        int n2 = list.size();
        if (n2 == 0) {
            return 0;
        }
        int n3 = 0;
        if (list instanceof IntArrayList) {
            IntArrayList intArrayList = (IntArrayList)list;
            for (int i2 = 0; i2 < n2; ++i2) {
                n3 += CodedOutputStream.computeEnumSizeNoTag(intArrayList.getInt(i2));
            }
        } else {
            for (int i3 = 0; i3 < n2; ++i3) {
                n3 += CodedOutputStream.computeEnumSizeNoTag(list.get(i3));
            }
        }
        return n3;
    }

    static int computeSizeEnumList(int n2, List<Integer> list, boolean bl2) {
        int n3 = list.size();
        if (n3 == 0) {
            return 0;
        }
        int n4 = SchemaUtil.computeSizeEnumListNoTag(list);
        if (bl2) {
            return CodedOutputStream.computeTagSize(n2) + CodedOutputStream.computeLengthDelimitedFieldSize(n4);
        }
        return n4 + n3 * CodedOutputStream.computeTagSize(n2);
    }

    static int computeSizeInt32ListNoTag(List<Integer> list) {
        int n2 = list.size();
        if (n2 == 0) {
            return 0;
        }
        int n3 = 0;
        if (list instanceof IntArrayList) {
            IntArrayList intArrayList = (IntArrayList)list;
            for (int i2 = 0; i2 < n2; ++i2) {
                n3 += CodedOutputStream.computeInt32SizeNoTag(intArrayList.getInt(i2));
            }
        } else {
            for (int i3 = 0; i3 < n2; ++i3) {
                n3 += CodedOutputStream.computeInt32SizeNoTag(list.get(i3));
            }
        }
        return n3;
    }

    static int computeSizeInt32List(int n2, List<Integer> list, boolean bl2) {
        int n3 = list.size();
        if (n3 == 0) {
            return 0;
        }
        int n4 = SchemaUtil.computeSizeInt32ListNoTag(list);
        if (bl2) {
            return CodedOutputStream.computeTagSize(n2) + CodedOutputStream.computeLengthDelimitedFieldSize(n4);
        }
        return n4 + n3 * CodedOutputStream.computeTagSize(n2);
    }

    static int computeSizeUInt32ListNoTag(List<Integer> list) {
        int n2 = list.size();
        if (n2 == 0) {
            return 0;
        }
        int n3 = 0;
        if (list instanceof IntArrayList) {
            IntArrayList intArrayList = (IntArrayList)list;
            for (int i2 = 0; i2 < n2; ++i2) {
                n3 += CodedOutputStream.computeUInt32SizeNoTag(intArrayList.getInt(i2));
            }
        } else {
            for (int i3 = 0; i3 < n2; ++i3) {
                n3 += CodedOutputStream.computeUInt32SizeNoTag(list.get(i3));
            }
        }
        return n3;
    }

    static int computeSizeUInt32List(int n2, List<Integer> list, boolean bl2) {
        int n3 = list.size();
        if (n3 == 0) {
            return 0;
        }
        int n4 = SchemaUtil.computeSizeUInt32ListNoTag(list);
        if (bl2) {
            return CodedOutputStream.computeTagSize(n2) + CodedOutputStream.computeLengthDelimitedFieldSize(n4);
        }
        return n4 + n3 * CodedOutputStream.computeTagSize(n2);
    }

    static int computeSizeSInt32ListNoTag(List<Integer> list) {
        int n2 = list.size();
        if (n2 == 0) {
            return 0;
        }
        int n3 = 0;
        if (list instanceof IntArrayList) {
            IntArrayList intArrayList = (IntArrayList)list;
            for (int i2 = 0; i2 < n2; ++i2) {
                n3 += CodedOutputStream.computeSInt32SizeNoTag(intArrayList.getInt(i2));
            }
        } else {
            for (int i3 = 0; i3 < n2; ++i3) {
                n3 += CodedOutputStream.computeSInt32SizeNoTag(list.get(i3));
            }
        }
        return n3;
    }

    static int computeSizeSInt32List(int n2, List<Integer> list, boolean bl2) {
        int n3 = list.size();
        if (n3 == 0) {
            return 0;
        }
        int n4 = SchemaUtil.computeSizeSInt32ListNoTag(list);
        if (bl2) {
            return CodedOutputStream.computeTagSize(n2) + CodedOutputStream.computeLengthDelimitedFieldSize(n4);
        }
        return n4 + n3 * CodedOutputStream.computeTagSize(n2);
    }

    static int computeSizeFixed32ListNoTag(List<?> list) {
        return list.size() * 4;
    }

    static int computeSizeFixed32List(int n2, List<?> list, boolean bl2) {
        int n3 = list.size();
        if (n3 == 0) {
            return 0;
        }
        if (bl2) {
            int n4 = n3 * 4;
            return CodedOutputStream.computeTagSize(n2) + CodedOutputStream.computeLengthDelimitedFieldSize(n4);
        }
        return n3 * CodedOutputStream.computeFixed32Size(n2, 0);
    }

    static int computeSizeFixed64ListNoTag(List<?> list) {
        return list.size() * 8;
    }

    static int computeSizeFixed64List(int n2, List<?> list, boolean bl2) {
        int n3 = list.size();
        if (n3 == 0) {
            return 0;
        }
        if (bl2) {
            int n4 = n3 * 8;
            return CodedOutputStream.computeTagSize(n2) + CodedOutputStream.computeLengthDelimitedFieldSize(n4);
        }
        return n3 * CodedOutputStream.computeFixed64Size(n2, 0L);
    }

    static int computeSizeBoolListNoTag(List<?> list) {
        return list.size();
    }

    static int computeSizeBoolList(int n2, List<?> list, boolean bl2) {
        int n3 = list.size();
        if (n3 == 0) {
            return 0;
        }
        if (bl2) {
            return CodedOutputStream.computeTagSize(n2) + CodedOutputStream.computeLengthDelimitedFieldSize(n3);
        }
        return n3 * CodedOutputStream.computeBoolSize(n2, true);
    }

    static int computeSizeStringList(int n2, List<?> list) {
        int n3 = list.size();
        if (n3 == 0) {
            return 0;
        }
        int n4 = n3 * CodedOutputStream.computeTagSize(n2);
        if (list instanceof LazyStringList) {
            LazyStringList lazyStringList = (LazyStringList)list;
            for (int i2 = 0; i2 < n3; ++i2) {
                Object object = lazyStringList.getRaw(i2);
                if (object instanceof ByteString) {
                    n4 += CodedOutputStream.computeBytesSizeNoTag((ByteString)object);
                    continue;
                }
                n4 += CodedOutputStream.computeStringSizeNoTag((String)object);
            }
        } else {
            for (int i3 = 0; i3 < n3; ++i3) {
                Object obj = list.get(i3);
                if (obj instanceof ByteString) {
                    n4 += CodedOutputStream.computeBytesSizeNoTag((ByteString)obj);
                    continue;
                }
                n4 += CodedOutputStream.computeStringSizeNoTag((String)obj);
            }
        }
        return n4;
    }

    static int computeSizeMessage(int n2, Object object, Schema schema) {
        if (object instanceof LazyFieldLite) {
            return CodedOutputStream.computeLazyFieldSize(n2, (LazyFieldLite)object);
        }
        return CodedOutputStream.computeMessageSize(n2, (MessageLite)object, schema);
    }

    static int computeSizeMessageList(int n2, List<?> list) {
        int n3 = list.size();
        if (n3 == 0) {
            return 0;
        }
        int n4 = n3 * CodedOutputStream.computeTagSize(n2);
        for (int i2 = 0; i2 < n3; ++i2) {
            Object obj = list.get(i2);
            if (obj instanceof LazyFieldLite) {
                n4 += CodedOutputStream.computeLazyFieldSizeNoTag((LazyFieldLite)obj);
                continue;
            }
            n4 += CodedOutputStream.computeMessageSizeNoTag((MessageLite)obj);
        }
        return n4;
    }

    static int computeSizeMessageList(int n2, List<?> list, Schema schema) {
        int n3 = list.size();
        if (n3 == 0) {
            return 0;
        }
        int n4 = n3 * CodedOutputStream.computeTagSize(n2);
        for (int i2 = 0; i2 < n3; ++i2) {
            Object obj = list.get(i2);
            if (obj instanceof LazyFieldLite) {
                n4 += CodedOutputStream.computeLazyFieldSizeNoTag((LazyFieldLite)obj);
                continue;
            }
            n4 += CodedOutputStream.computeMessageSizeNoTag((MessageLite)obj, schema);
        }
        return n4;
    }

    static int computeSizeByteStringList(int n2, List<ByteString> list) {
        int n3 = list.size();
        if (n3 == 0) {
            return 0;
        }
        int n4 = n3 * CodedOutputStream.computeTagSize(n2);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            n4 += CodedOutputStream.computeBytesSizeNoTag(list.get(i2));
        }
        return n4;
    }

    static int computeSizeGroupList(int n2, List<MessageLite> list) {
        int n3 = list.size();
        if (n3 == 0) {
            return 0;
        }
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            n4 += CodedOutputStream.computeGroupSize(n2, list.get(i2));
        }
        return n4;
    }

    static int computeSizeGroupList(int n2, List<MessageLite> list, Schema schema) {
        int n3 = list.size();
        if (n3 == 0) {
            return 0;
        }
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            n4 += CodedOutputStream.computeGroupSize(n2, list.get(i2), schema);
        }
        return n4;
    }

    public static boolean shouldUseTableSwitch(FieldInfo[] fieldInfoArray) {
        if (fieldInfoArray.length == 0) {
            return false;
        }
        int n2 = fieldInfoArray[0].getFieldNumber();
        int n3 = fieldInfoArray[fieldInfoArray.length - 1].getFieldNumber();
        return SchemaUtil.shouldUseTableSwitch(n2, n3, fieldInfoArray.length);
    }

    public static boolean shouldUseTableSwitch(int n2, int n3, int n4) {
        if (n3 < 40) {
            return true;
        }
        long l2 = (long)n3 - (long)n2 + 1L;
        long l3 = 3L;
        long l4 = 3L + 2L * (long)n4;
        long l5 = 3L + (long)n4;
        return l2 + 3L * l3 <= l4 + 3L * l5;
    }

    public static UnknownFieldSchema<?, ?> proto2UnknownFieldSetSchema() {
        return PROTO2_UNKNOWN_FIELD_SET_SCHEMA;
    }

    public static UnknownFieldSchema<?, ?> proto3UnknownFieldSetSchema() {
        return PROTO3_UNKNOWN_FIELD_SET_SCHEMA;
    }

    public static UnknownFieldSchema<?, ?> unknownFieldSetLiteSchema() {
        return UNKNOWN_FIELD_SET_LITE_SCHEMA;
    }

    private static UnknownFieldSchema<?, ?> getUnknownFieldSetSchema(boolean bl2) {
        try {
            Class<?> clazz = SchemaUtil.getUnknownFieldSetSchemaClass();
            if (clazz == null) {
                return null;
            }
            return (UnknownFieldSchema)clazz.getConstructor(Boolean.TYPE).newInstance(bl2);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static Class<?> getGeneratedMessageClass() {
        try {
            return Class.forName("com.google.protobuf.GeneratedMessageV3");
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static Class<?> getUnknownFieldSetSchemaClass() {
        try {
            return Class.forName("com.google.protobuf.UnknownFieldSetSchema");
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    static Object getMapDefaultEntry(Class<?> clazz, String string2) {
        try {
            Class<?> clazz2 = Class.forName(clazz.getName() + "$" + SchemaUtil.toCamelCase(string2, true) + "DefaultEntryHolder");
            Field[] fieldArray = clazz2.getDeclaredFields();
            if (fieldArray.length != 1) {
                throw new IllegalStateException("Unable to look up map field default entry holder class for " + string2 + " in " + clazz.getName());
            }
            return UnsafeUtil.getStaticObject(fieldArray[0]);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    static String toCamelCase(String string2, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < string2.length(); ++i2) {
            char c2 = string2.charAt(i2);
            if ('a' <= c2 && c2 <= 'z') {
                if (bl2) {
                    stringBuilder.append((char)(c2 + -32));
                } else {
                    stringBuilder.append(c2);
                }
                bl2 = false;
                continue;
            }
            if ('A' <= c2 && c2 <= 'Z') {
                if (i2 == 0 && !bl2) {
                    stringBuilder.append((char)(c2 - -32));
                } else {
                    stringBuilder.append(c2);
                }
                bl2 = false;
                continue;
            }
            if ('0' <= c2 && c2 <= '9') {
                stringBuilder.append(c2);
                bl2 = true;
                continue;
            }
            bl2 = true;
        }
        return stringBuilder.toString();
    }

    static boolean safeEquals(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    static <T> void mergeMap(MapFieldSchema mapFieldSchema, T t2, T t3, long l2) {
        Object object = mapFieldSchema.mergeFrom(UnsafeUtil.getObject(t2, l2), UnsafeUtil.getObject(t3, l2));
        UnsafeUtil.putObject(t2, l2, object);
    }

    static <T, FT extends FieldSet.FieldDescriptorLite<FT>> void mergeExtensions(ExtensionSchema<FT> extensionSchema, T t2, T t3) {
        FieldSet<FT> fieldSet = extensionSchema.getExtensions(t3);
        if (!fieldSet.isEmpty()) {
            FieldSet<FT> fieldSet2 = extensionSchema.getMutableExtensions(t2);
            fieldSet2.mergeFrom(fieldSet);
        }
    }

    static <T, UT, UB> void mergeUnknownFields(UnknownFieldSchema<UT, UB> unknownFieldSchema, T t2, T t3) {
        UT UT = unknownFieldSchema.getFromMessage(t2);
        UT UT2 = unknownFieldSchema.getFromMessage(t3);
        UT UT3 = unknownFieldSchema.merge(UT, UT2);
        unknownFieldSchema.setToMessage(t2, UT3);
    }

    static <UT, UB> UB filterUnknownEnumList(int n2, List<Integer> list, Internal.EnumLiteMap<?> enumLiteMap, UB UB, UnknownFieldSchema<UT, UB> unknownFieldSchema) {
        if (enumLiteMap == null) {
            return UB;
        }
        if (list instanceof RandomAccess) {
            int n3 = 0;
            int n4 = list.size();
            for (int i2 = 0; i2 < n4; ++i2) {
                int n5 = list.get(i2);
                if (enumLiteMap.findValueByNumber(n5) != null) {
                    if (i2 != n3) {
                        list.set(n3, n5);
                    }
                    ++n3;
                    continue;
                }
                UB = SchemaUtil.storeUnknownEnum(n2, n5, UB, unknownFieldSchema);
            }
            if (n3 != n4) {
                list.subList(n3, n4).clear();
            }
        } else {
            Iterator<Integer> iterator = list.iterator();
            while (iterator.hasNext()) {
                int n6 = iterator.next();
                if (enumLiteMap.findValueByNumber(n6) != null) continue;
                UB = SchemaUtil.storeUnknownEnum(n2, n6, UB, unknownFieldSchema);
                iterator.remove();
            }
        }
        return UB;
    }

    static <UT, UB> UB filterUnknownEnumList(int n2, List<Integer> list, Internal.EnumVerifier enumVerifier, UB UB, UnknownFieldSchema<UT, UB> unknownFieldSchema) {
        if (enumVerifier == null) {
            return UB;
        }
        if (list instanceof RandomAccess) {
            int n3 = 0;
            int n4 = list.size();
            for (int i2 = 0; i2 < n4; ++i2) {
                int n5 = list.get(i2);
                if (enumVerifier.isInRange(n5)) {
                    if (i2 != n3) {
                        list.set(n3, n5);
                    }
                    ++n3;
                    continue;
                }
                UB = SchemaUtil.storeUnknownEnum(n2, n5, UB, unknownFieldSchema);
            }
            if (n3 != n4) {
                list.subList(n3, n4).clear();
            }
        } else {
            Iterator<Integer> iterator = list.iterator();
            while (iterator.hasNext()) {
                int n6 = iterator.next();
                if (enumVerifier.isInRange(n6)) continue;
                UB = SchemaUtil.storeUnknownEnum(n2, n6, UB, unknownFieldSchema);
                iterator.remove();
            }
        }
        return UB;
    }

    static <UT, UB> UB storeUnknownEnum(int n2, int n3, UB UB, UnknownFieldSchema<UT, UB> unknownFieldSchema) {
        if (UB == null) {
            UB = unknownFieldSchema.newBuilder();
        }
        unknownFieldSchema.addVarint(UB, n2, n3);
        return UB;
    }
}

