/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.FieldInfo;
import com.google.protobuf.Internal;
import com.google.protobuf.MessageInfo;
import com.google.protobuf.MessageLite;
import com.google.protobuf.ProtoSyntax;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

final class StructuralMessageInfo
implements MessageInfo {
    private final ProtoSyntax syntax;
    private final boolean messageSetWireFormat;
    private final int[] checkInitialized;
    private final FieldInfo[] fields;
    private final MessageLite defaultInstance;

    StructuralMessageInfo(ProtoSyntax protoSyntax, boolean bl2, int[] nArray, FieldInfo[] fieldInfoArray, Object object) {
        this.syntax = protoSyntax;
        this.messageSetWireFormat = bl2;
        this.checkInitialized = nArray;
        this.fields = fieldInfoArray;
        this.defaultInstance = (MessageLite)Internal.checkNotNull(object, "defaultInstance");
    }

    @Override
    public ProtoSyntax getSyntax() {
        return this.syntax;
    }

    @Override
    public boolean isMessageSetWireFormat() {
        return this.messageSetWireFormat;
    }

    public int[] getCheckInitialized() {
        return this.checkInitialized;
    }

    public FieldInfo[] getFields() {
        return this.fields;
    }

    @Override
    public MessageLite getDefaultInstance() {
        return this.defaultInstance;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(int n2) {
        return new Builder(n2);
    }

    public static final class Builder {
        private final List<FieldInfo> fields;
        private ProtoSyntax syntax;
        private boolean wasBuilt;
        private boolean messageSetWireFormat;
        private int[] checkInitialized = null;
        private Object defaultInstance;

        public Builder() {
            this.fields = new ArrayList<FieldInfo>();
        }

        public Builder(int n2) {
            this.fields = new ArrayList<FieldInfo>(n2);
        }

        public void withDefaultInstance(Object object) {
            this.defaultInstance = object;
        }

        public void withSyntax(ProtoSyntax protoSyntax) {
            this.syntax = Internal.checkNotNull(protoSyntax, "syntax");
        }

        public void withMessageSetWireFormat(boolean bl2) {
            this.messageSetWireFormat = bl2;
        }

        public void withCheckInitialized(int[] nArray) {
            this.checkInitialized = nArray;
        }

        public void withField(FieldInfo fieldInfo) {
            if (this.wasBuilt) {
                throw new IllegalStateException("Builder can only build once");
            }
            this.fields.add(fieldInfo);
        }

        public StructuralMessageInfo build() {
            if (this.wasBuilt) {
                throw new IllegalStateException("Builder can only build once");
            }
            if (this.syntax == null) {
                throw new IllegalStateException("Must specify a proto syntax");
            }
            this.wasBuilt = true;
            Collections.sort(this.fields);
            return new StructuralMessageInfo(this.syntax, this.messageSetWireFormat, this.checkInitialized, this.fields.toArray(new FieldInfo[0]), this.defaultInstance);
        }
    }
}

