/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.Descriptors;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class TypeRegistry {
    private static final Logger logger = Logger.getLogger(TypeRegistry.class.getName());
    private final Map<String, Descriptors.Descriptor> types;

    public static TypeRegistry getEmptyTypeRegistry() {
        return EmptyTypeRegistryHolder.EMPTY;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Descriptors.Descriptor find(String string2) {
        return this.types.get(string2);
    }

    public final Descriptors.Descriptor getDescriptorForTypeUrl(String string2) throws InvalidProtocolBufferException {
        return this.find(TypeRegistry.getTypeName(string2));
    }

    TypeRegistry(Map<String, Descriptors.Descriptor> map) {
        this.types = map;
    }

    private static String getTypeName(String string2) throws InvalidProtocolBufferException {
        String[] stringArray = string2.split("/");
        if (stringArray.length == 1) {
            throw new InvalidProtocolBufferException("Invalid type url found: " + string2);
        }
        return stringArray[stringArray.length - 1];
    }

    public static final class Builder {
        private final Set<String> files = new HashSet<String>();
        private Map<String, Descriptors.Descriptor> types = new HashMap<String, Descriptors.Descriptor>();

        private Builder() {
        }

        public Builder add(Descriptors.Descriptor descriptor) {
            if (this.types == null) {
                throw new IllegalStateException("A TypeRegistry.Builder can only be used once.");
            }
            this.addFile(descriptor.getFile());
            return this;
        }

        public Builder add(Iterable<Descriptors.Descriptor> iterable) {
            if (this.types == null) {
                throw new IllegalStateException("A TypeRegistry.Builder can only be used once.");
            }
            for (Descriptors.Descriptor descriptor : iterable) {
                this.addFile(descriptor.getFile());
            }
            return this;
        }

        public TypeRegistry build() {
            TypeRegistry typeRegistry = new TypeRegistry(this.types);
            this.types = null;
            return typeRegistry;
        }

        private void addFile(Descriptors.FileDescriptor fileDescriptor) {
            if (!this.files.add(fileDescriptor.getFullName())) {
                return;
            }
            for (Descriptors.FileDescriptor genericDescriptor : fileDescriptor.getDependencies()) {
                this.addFile(genericDescriptor);
            }
            for (Descriptors.Descriptor descriptor : fileDescriptor.getMessageTypes()) {
                this.addMessage(descriptor);
            }
        }

        private void addMessage(Descriptors.Descriptor descriptor) {
            for (Descriptors.Descriptor descriptor2 : descriptor.getNestedTypes()) {
                this.addMessage(descriptor2);
            }
            if (this.types.containsKey(descriptor.getFullName())) {
                logger.warning("Type " + descriptor.getFullName() + " is added multiple times.");
                return;
            }
            this.types.put(descriptor.getFullName(), descriptor);
        }
    }

    private static class EmptyTypeRegistryHolder {
        private static final TypeRegistry EMPTY = new TypeRegistry(Collections.emptyMap());

        private EmptyTypeRegistryHolder() {
        }
    }
}

