/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Reader;
import com.google.protobuf.WireFormat;
import com.google.protobuf.Writer;
import java.io.IOException;

abstract class UnknownFieldSchema<T, B> {
    UnknownFieldSchema() {
    }

    abstract boolean shouldDiscardUnknownFields(Reader var1);

    abstract void addVarint(B var1, int var2, long var3);

    abstract void addFixed32(B var1, int var2, int var3);

    abstract void addFixed64(B var1, int var2, long var3);

    abstract void addLengthDelimited(B var1, int var2, ByteString var3);

    abstract void addGroup(B var1, int var2, T var3);

    abstract B newBuilder();

    abstract T toImmutable(B var1);

    abstract void setToMessage(Object var1, T var2);

    abstract T getFromMessage(Object var1);

    abstract B getBuilderFromMessage(Object var1);

    abstract void setBuilderToMessage(Object var1, B var2);

    abstract void makeImmutable(Object var1);

    final boolean mergeOneFieldFrom(B b2, Reader reader) throws IOException {
        int n2 = reader.getTag();
        int n3 = WireFormat.getTagFieldNumber(n2);
        switch (WireFormat.getTagWireType(n2)) {
            case 0: {
                this.addVarint(b2, n3, reader.readInt64());
                return true;
            }
            case 5: {
                this.addFixed32(b2, n3, reader.readFixed32());
                return true;
            }
            case 1: {
                this.addFixed64(b2, n3, reader.readFixed64());
                return true;
            }
            case 2: {
                this.addLengthDelimited(b2, n3, reader.readBytes());
                return true;
            }
            case 3: {
                B b3 = this.newBuilder();
                int n4 = WireFormat.makeTag(n3, 4);
                this.mergeFrom(b3, reader);
                if (n4 != reader.getTag()) {
                    throw InvalidProtocolBufferException.invalidEndTag();
                }
                this.addGroup(b2, n3, this.toImmutable(b3));
                return true;
            }
            case 4: {
                return false;
            }
        }
        throw InvalidProtocolBufferException.invalidWireType();
    }

    final void mergeFrom(B b2, Reader reader) throws IOException {
        while (reader.getFieldNumber() != Integer.MAX_VALUE && this.mergeOneFieldFrom(b2, reader)) {
        }
    }

    abstract void writeTo(T var1, Writer var2) throws IOException;

    abstract void writeAsMessageSetTo(T var1, Writer var2) throws IOException;

    abstract T merge(T var1, T var2);

    abstract int getSerializedSizeAsMessageSet(T var1);

    abstract int getSerializedSize(T var1);
}

