/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing;

import com.google.zxing.InvertedLuminanceSource;

public abstract class LuminanceSource {
    private final int width;
    private final int height;

    protected LuminanceSource(int n2, int n3) {
        this.width = n2;
        this.height = n3;
    }

    public abstract byte[] getRow(int var1, byte[] var2);

    public abstract byte[] getMatrix();

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public boolean isCropSupported() {
        return false;
    }

    public LuminanceSource crop(int n2, int n3, int n4, int n5) {
        throw new UnsupportedOperationException("This luminance source does not support cropping.");
    }

    public boolean isRotateSupported() {
        return false;
    }

    public LuminanceSource invert() {
        return new InvertedLuminanceSource(this);
    }

    public LuminanceSource rotateCounterClockwise() {
        throw new UnsupportedOperationException("This luminance source does not support rotation by 90 degrees.");
    }

    public LuminanceSource rotateCounterClockwise45() {
        throw new UnsupportedOperationException("This luminance source does not support rotation by 45 degrees.");
    }

    public final String toString() {
        byte[] byArray = new byte[this.width];
        StringBuilder stringBuilder = new StringBuilder(this.height * (this.width + 1));
        for (int i2 = 0; i2 < this.height; ++i2) {
            byArray = this.getRow(i2, byArray);
            for (int i3 = 0; i3 < this.width; ++i3) {
                int n2 = byArray[i3] & 0xFF;
                int n3 = n2 < 64 ? 35 : (n2 < 128 ? 43 : (n2 < 192 ? 46 : 32));
                stringBuilder.append((char)n3);
            }
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }
}

