/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing;

import com.google.zxing.LuminanceSource;

public final class PlanarYUVLuminanceSource
extends LuminanceSource {
    private static final int THUMBNAIL_SCALE_FACTOR = 2;
    private final byte[] yuvData;
    private final int dataWidth;
    private final int dataHeight;
    private final int left;
    private final int top;

    public PlanarYUVLuminanceSource(byte[] byArray, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl2) {
        super(n6, n7);
        if (n4 + n6 > n2 || n5 + n7 > n3) {
            throw new IllegalArgumentException("Crop rectangle does not fit within image data.");
        }
        this.yuvData = byArray;
        this.dataWidth = n2;
        this.dataHeight = n3;
        this.left = n4;
        this.top = n5;
        if (bl2) {
            this.reverseHorizontal(n6, n7);
        }
    }

    @Override
    public byte[] getRow(int n2, byte[] byArray) {
        if (n2 < 0 || n2 >= this.getHeight()) {
            throw new IllegalArgumentException("Requested row is outside the image: " + n2);
        }
        int n3 = this.getWidth();
        if (byArray == null || byArray.length < n3) {
            byArray = new byte[n3];
        }
        int n4 = (n2 + this.top) * this.dataWidth + this.left;
        System.arraycopy(this.yuvData, n4, byArray, 0, n3);
        return byArray;
    }

    @Override
    public byte[] getMatrix() {
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        if (n2 == this.dataWidth && n3 == this.dataHeight) {
            return this.yuvData;
        }
        int n4 = n2 * n3;
        byte[] byArray = new byte[n4];
        int n5 = this.top * this.dataWidth + this.left;
        if (n2 == this.dataWidth) {
            System.arraycopy(this.yuvData, n5, byArray, 0, n4);
            return byArray;
        }
        byte[] byArray2 = this.yuvData;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n6 = i2 * n2;
            System.arraycopy(byArray2, n5, byArray, n6, n2);
            n5 += this.dataWidth;
        }
        return byArray;
    }

    @Override
    public boolean isCropSupported() {
        return true;
    }

    @Override
    public LuminanceSource crop(int n2, int n3, int n4, int n5) {
        return new PlanarYUVLuminanceSource(this.yuvData, this.dataWidth, this.dataHeight, this.left + n2, this.top + n3, n4, n5, false);
    }

    public int[] renderThumbnail() {
        int n2 = this.getWidth() / 2;
        int n3 = this.getHeight() / 2;
        int[] nArray = new int[n2 * n3];
        byte[] byArray = this.yuvData;
        int n4 = this.top * this.dataWidth + this.left;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n5 = i2 * n2;
            for (int i3 = 0; i3 < n2; ++i3) {
                int n6 = byArray[n4 + i3 * 2] & 0xFF;
                nArray[n5 + i3] = 0xFF000000 | n6 * 65793;
            }
            n4 += this.dataWidth * 2;
        }
        return nArray;
    }

    public int getThumbnailWidth() {
        return this.getWidth() / 2;
    }

    public int getThumbnailHeight() {
        return this.getHeight() / 2;
    }

    private void reverseHorizontal(int n2, int n3) {
        byte[] byArray = this.yuvData;
        int n4 = 0;
        int n5 = this.top * this.dataWidth + this.left;
        while (n4 < n3) {
            int n6 = n5 + n2 / 2;
            int n7 = n5;
            int n8 = n5 + n2 - 1;
            while (n7 < n6) {
                byte by2 = byArray[n7];
                byArray[n7] = byArray[n8];
                byArray[n8] = by2;
                ++n7;
                --n8;
            }
            ++n4;
            n5 += this.dataWidth;
        }
    }
}

