/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing;

import com.google.zxing.LuminanceSource;

public final class RGBLuminanceSource
extends LuminanceSource {
    private final byte[] luminances;
    private final int dataWidth;
    private final int dataHeight;
    private final int left;
    private final int top;

    public RGBLuminanceSource(int n2, int n3, int[] nArray) {
        super(n2, n3);
        this.dataWidth = n2;
        this.dataHeight = n3;
        this.left = 0;
        this.top = 0;
        this.luminances = new byte[n2 * n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = i2 * n2;
            for (int i3 = 0; i3 < n2; ++i3) {
                int n5 = nArray[n4 + i3];
                int n6 = n5 >> 16 & 0xFF;
                int n7 = n5 >> 8 & 0xFF;
                int n8 = n5 & 0xFF;
                this.luminances[n4 + i3] = n6 == n7 && n7 == n8 ? (byte)n6 : (byte)((n6 + 2 * n7 + n8) / 4);
            }
        }
    }

    private RGBLuminanceSource(byte[] byArray, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(n6, n7);
        if (n4 + n6 > n2 || n5 + n7 > n3) {
            throw new IllegalArgumentException("Crop rectangle does not fit within image data.");
        }
        this.luminances = byArray;
        this.dataWidth = n2;
        this.dataHeight = n3;
        this.left = n4;
        this.top = n5;
    }

    @Override
    public byte[] getRow(int n2, byte[] byArray) {
        if (n2 < 0 || n2 >= this.getHeight()) {
            throw new IllegalArgumentException("Requested row is outside the image: " + n2);
        }
        int n3 = this.getWidth();
        if (byArray == null || byArray.length < n3) {
            byArray = new byte[n3];
        }
        int n4 = (n2 + this.top) * this.dataWidth + this.left;
        System.arraycopy(this.luminances, n4, byArray, 0, n3);
        return byArray;
    }

    @Override
    public byte[] getMatrix() {
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        if (n2 == this.dataWidth && n3 == this.dataHeight) {
            return this.luminances;
        }
        int n4 = n2 * n3;
        byte[] byArray = new byte[n4];
        int n5 = this.top * this.dataWidth + this.left;
        if (n2 == this.dataWidth) {
            System.arraycopy(this.luminances, n5, byArray, 0, n4);
            return byArray;
        }
        byte[] byArray2 = this.luminances;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n6 = i2 * n2;
            System.arraycopy(byArray2, n5, byArray, n6, n2);
            n5 += this.dataWidth;
        }
        return byArray;
    }

    @Override
    public boolean isCropSupported() {
        return true;
    }

    @Override
    public LuminanceSource crop(int n2, int n3, int n4, int n5) {
        return new RGBLuminanceSource(this.luminances, this.dataWidth, this.dataHeight, this.left + n2, this.top + n3, n4, n5);
    }
}

