/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.aztec;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.NotFoundException;
import com.google.zxing.Reader;
import com.google.zxing.Result;
import com.google.zxing.ResultMetadataType;
import com.google.zxing.ResultPoint;
import com.google.zxing.ResultPointCallback;
import com.google.zxing.aztec.AztecDetectorResult;
import com.google.zxing.aztec.decoder.Decoder;
import com.google.zxing.aztec.detector.Detector;
import com.google.zxing.common.DecoderResult;
import com.google.zxing.common.DetectorResult;
import java.util.List;
import java.util.Map;

public final class AztecReader
implements Reader {
    @Override
    public Result decode(BinaryBitmap binaryBitmap) throws NotFoundException, FormatException {
        return this.decode(binaryBitmap, null);
    }

    @Override
    public Result decode(BinaryBitmap binaryBitmap, Map<DecodeHintType, ?> map) throws NotFoundException, FormatException {
        String string2;
        Object object;
        NotFoundException notFoundException = null;
        FormatException formatException = null;
        Detector detector = new Detector(binaryBitmap.getBlackMatrix());
        ResultPoint[] resultPointArray = null;
        DecoderResult decoderResult = null;
        try {
            object = detector.detect(false);
            resultPointArray = ((DetectorResult)object).getPoints();
            decoderResult = new Decoder().decode((AztecDetectorResult)object);
        }
        catch (NotFoundException notFoundException2) {
            notFoundException = notFoundException2;
        }
        catch (FormatException formatException2) {
            formatException = formatException2;
        }
        if (decoderResult == null) {
            try {
                object = detector.detect(true);
                resultPointArray = ((DetectorResult)object).getPoints();
                decoderResult = new Decoder().decode((AztecDetectorResult)object);
            }
            catch (FormatException | NotFoundException readerException) {
                if (notFoundException != null) {
                    throw notFoundException;
                }
                if (formatException != null) {
                    throw formatException;
                }
                throw readerException;
            }
        }
        if (map != null && (object = (ResultPointCallback)map.get((Object)DecodeHintType.NEED_RESULT_POINT_CALLBACK)) != null) {
            for (ResultPoint resultPoint : resultPointArray) {
                object.foundPossibleResultPoint(resultPoint);
            }
        }
        object = new Result(decoderResult.getText(), decoderResult.getRawBytes(), resultPointArray, BarcodeFormat.AZTEC);
        List<byte[]> list = decoderResult.getByteSegments();
        if (list != null) {
            ((Result)object).putMetadata(ResultMetadataType.BYTE_SEGMENTS, list);
        }
        if ((string2 = decoderResult.getECLevel()) != null) {
            ((Result)object).putMetadata(ResultMetadataType.ERROR_CORRECTION_LEVEL, string2);
        }
        return object;
    }

    @Override
    public void reset() {
    }
}

