/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.aztec;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.Writer;
import com.google.zxing.aztec.encoder.AztecCode;
import com.google.zxing.aztec.encoder.Encoder;
import com.google.zxing.common.BitMatrix;
import java.nio.charset.Charset;
import java.util.Map;

public final class AztecWriter
implements Writer {
    private static final Charset DEFAULT_CHARSET = Charset.forName("ISO-8859-1");

    @Override
    public BitMatrix encode(String string2, BarcodeFormat barcodeFormat, int n2, int n3) {
        return this.encode(string2, barcodeFormat, n2, n3, null);
    }

    @Override
    public BitMatrix encode(String string2, BarcodeFormat barcodeFormat, int n2, int n3, Map<EncodeHintType, ?> map) {
        String string3 = map == null ? null : (String)map.get((Object)EncodeHintType.CHARACTER_SET);
        Number number = map == null ? (Number)null : (Number)((Number)map.get((Object)EncodeHintType.ERROR_CORRECTION));
        Number number2 = map == null ? (Number)null : (Number)((Number)map.get((Object)EncodeHintType.AZTEC_LAYERS));
        return AztecWriter.encode(string2, barcodeFormat, n2, n3, string3 == null ? DEFAULT_CHARSET : Charset.forName(string3), number == null ? 33 : number.intValue(), number2 == null ? 0 : number2.intValue());
    }

    private static BitMatrix encode(String string2, BarcodeFormat barcodeFormat, int n2, int n3, Charset charset, int n4, int n5) {
        if (barcodeFormat != BarcodeFormat.AZTEC) {
            throw new IllegalArgumentException("Can only encode AZTEC, but got " + (Object)((Object)barcodeFormat));
        }
        AztecCode aztecCode = Encoder.encode(string2.getBytes(charset), n4, n5);
        return AztecWriter.renderResult(aztecCode, n2, n3);
    }

    private static BitMatrix renderResult(AztecCode aztecCode, int n2, int n3) {
        BitMatrix bitMatrix = aztecCode.getMatrix();
        if (bitMatrix == null) {
            throw new IllegalStateException();
        }
        int n4 = bitMatrix.getWidth();
        int n5 = bitMatrix.getHeight();
        int n6 = Math.max(n2, n4);
        int n7 = Math.max(n3, n5);
        int n8 = Math.min(n6 / n4, n7 / n5);
        int n9 = (n6 - n4 * n8) / 2;
        int n10 = (n7 - n5 * n8) / 2;
        BitMatrix bitMatrix2 = new BitMatrix(n6, n7);
        int n11 = 0;
        int n12 = n10;
        while (n11 < n5) {
            int n13 = 0;
            int n14 = n9;
            while (n13 < n4) {
                if (bitMatrix.get(n13, n11)) {
                    bitMatrix2.setRegion(n14, n12, n8, n8);
                }
                ++n13;
                n14 += n8;
            }
            ++n11;
            n12 += n8;
        }
        return bitMatrix2;
    }
}

