/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.aztec.decoder;

import com.google.zxing.FormatException;
import com.google.zxing.aztec.AztecDetectorResult;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.DecoderResult;
import com.google.zxing.common.reedsolomon.GenericGF;
import com.google.zxing.common.reedsolomon.ReedSolomonDecoder;
import com.google.zxing.common.reedsolomon.ReedSolomonException;
import java.util.Arrays;

public final class Decoder {
    private static final String[] UPPER_TABLE = new String[]{"CTRL_PS", " ", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "CTRL_LL", "CTRL_ML", "CTRL_DL", "CTRL_BS"};
    private static final String[] LOWER_TABLE = new String[]{"CTRL_PS", " ", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "CTRL_US", "CTRL_ML", "CTRL_DL", "CTRL_BS"};
    private static final String[] MIXED_TABLE = new String[]{"CTRL_PS", " ", "\u0001", "\u0002", "\u0003", "\u0004", "\u0005", "\u0006", "\u0007", "\b", "\t", "\n", "\u000b", "\f", "\r", "\u001b", "\u001c", "\u001d", "\u001e", "\u001f", "@", "\\", "^", "_", "`", "|", "~", "\u007f", "CTRL_LL", "CTRL_UL", "CTRL_PL", "CTRL_BS"};
    private static final String[] PUNCT_TABLE = new String[]{"", "\r", "\r\n", ". ", ", ", ": ", "!", "\"", "#", "$", "%", "&", "'", "(", ")", "*", "+", ",", "-", ".", "/", ":", ";", "<", "=", ">", "?", "[", "]", "{", "}", "CTRL_UL"};
    private static final String[] DIGIT_TABLE = new String[]{"CTRL_PS", " ", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", ",", ".", "CTRL_UL", "CTRL_US"};
    private AztecDetectorResult ddata;

    public DecoderResult decode(AztecDetectorResult aztecDetectorResult) throws FormatException {
        this.ddata = aztecDetectorResult;
        BitMatrix bitMatrix = aztecDetectorResult.getBits();
        boolean[] blArray = this.extractBits(bitMatrix);
        boolean[] blArray2 = this.correctBits(blArray);
        String string2 = Decoder.getEncodedData(blArray2);
        return new DecoderResult(null, string2, null, null);
    }

    public static String highLevelDecode(boolean[] blArray) {
        return Decoder.getEncodedData(blArray);
    }

    private static String getEncodedData(boolean[] blArray) {
        int n2 = blArray.length;
        Table table = Table.UPPER;
        Table table2 = Table.UPPER;
        StringBuilder stringBuilder = new StringBuilder(20);
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            int n5;
            if (table2 == Table.BINARY) {
                if (n2 - n3 < 5) break;
                n5 = Decoder.readCode(blArray, n3, 5);
                n3 += 5;
                if (n5 == 0) {
                    if (n2 - n3 < 11) break;
                    n5 = Decoder.readCode(blArray, n3, 11) + 31;
                    n3 += 11;
                }
                for (n4 = 0; n4 < n5; ++n4) {
                    if (n2 - n3 < 8) {
                        n3 = n2;
                        break;
                    }
                    int n6 = Decoder.readCode(blArray, n3, 8);
                    stringBuilder.append((char)n6);
                    n3 += 8;
                }
                table2 = table;
                continue;
            }
            int n7 = n5 = table2 == Table.DIGIT ? 4 : 5;
            if (n2 - n3 < n5) break;
            n4 = Decoder.readCode(blArray, n3, n5);
            n3 += n5;
            String string2 = Decoder.getCharacter(table2, n4);
            if (string2.startsWith("CTRL_")) {
                table2 = Decoder.getTable(string2.charAt(5));
                if (string2.charAt(6) != 'L') continue;
                table = table2;
                continue;
            }
            stringBuilder.append(string2);
            table2 = table;
        }
        return stringBuilder.toString();
    }

    private static Table getTable(char c2) {
        switch (c2) {
            case 'L': {
                return Table.LOWER;
            }
            case 'P': {
                return Table.PUNCT;
            }
            case 'M': {
                return Table.MIXED;
            }
            case 'D': {
                return Table.DIGIT;
            }
            case 'B': {
                return Table.BINARY;
            }
        }
        return Table.UPPER;
    }

    private static String getCharacter(Table table, int n2) {
        switch (table) {
            case UPPER: {
                return UPPER_TABLE[n2];
            }
            case LOWER: {
                return LOWER_TABLE[n2];
            }
            case MIXED: {
                return MIXED_TABLE[n2];
            }
            case PUNCT: {
                return PUNCT_TABLE[n2];
            }
            case DIGIT: {
                return DIGIT_TABLE[n2];
            }
        }
        throw new IllegalStateException("Bad table");
    }

    private boolean[] correctBits(boolean[] blArray) throws FormatException {
        int n2;
        GenericGF genericGF;
        int n3;
        if (this.ddata.getNbLayers() <= 2) {
            n3 = 6;
            genericGF = GenericGF.AZTEC_DATA_6;
        } else if (this.ddata.getNbLayers() <= 8) {
            n3 = 8;
            genericGF = GenericGF.AZTEC_DATA_8;
        } else if (this.ddata.getNbLayers() <= 22) {
            n3 = 10;
            genericGF = GenericGF.AZTEC_DATA_10;
        } else {
            n3 = 12;
            genericGF = GenericGF.AZTEC_DATA_12;
        }
        int n4 = this.ddata.getNbDatablocks();
        int n5 = blArray.length / n3;
        if (n5 < n4) {
            throw FormatException.getFormatInstance();
        }
        int n6 = blArray.length % n3;
        int n7 = n5 - n4;
        int[] nArray = new int[n5];
        int n8 = 0;
        while (n8 < n5) {
            nArray[n8] = Decoder.readCode(blArray, n6, n3);
            ++n8;
            n6 += n3;
        }
        try {
            ReedSolomonDecoder reedSolomonDecoder = new ReedSolomonDecoder(genericGF);
            reedSolomonDecoder.decode(nArray, n7);
        }
        catch (ReedSolomonException reedSolomonException) {
            throw FormatException.getFormatInstance();
        }
        int n9 = (1 << n3) - 1;
        int n10 = 0;
        for (int i2 = 0; i2 < n4; ++i2) {
            n2 = nArray[i2];
            if (n2 == 0 || n2 == n9) {
                throw FormatException.getFormatInstance();
            }
            if (n2 != 1 && n2 != n9 - 1) continue;
            ++n10;
        }
        boolean[] blArray2 = new boolean[n4 * n3 - n10];
        n2 = 0;
        for (int i3 = 0; i3 < n4; ++i3) {
            int n11 = nArray[i3];
            if (n11 == 1 || n11 == n9 - 1) {
                Arrays.fill(blArray2, n2, n2 + n3 - 1, n11 > 1);
                n2 += n3 - 1;
                continue;
            }
            for (int i4 = n3 - 1; i4 >= 0; --i4) {
                blArray2[n2++] = (n11 & 1 << i4) != 0;
            }
        }
        return blArray2;
    }

    boolean[] extractBits(BitMatrix bitMatrix) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        boolean bl2 = this.ddata.isCompact();
        int n7 = this.ddata.getNbLayers();
        int n8 = bl2 ? 11 + n7 * 4 : 14 + n7 * 4;
        int[] nArray = new int[n8];
        boolean[] blArray = new boolean[Decoder.totalBitsInLayer(n7, bl2)];
        if (bl2) {
            for (n6 = 0; n6 < nArray.length; ++n6) {
                nArray[n6] = n6;
            }
        } else {
            n6 = n8 + 1 + 2 * ((n8 / 2 - 1) / 15);
            n5 = n8 / 2;
            n4 = n6 / 2;
            for (n3 = 0; n3 < n5; ++n3) {
                n2 = n3 + n3 / 15;
                nArray[n5 - n3 - 1] = n4 - n2 - 1;
                nArray[n5 + n3] = n4 + n2 + 1;
            }
        }
        n5 = 0;
        for (n6 = 0; n6 < n7; ++n6) {
            n4 = bl2 ? (n7 - n6) * 4 + 9 : (n7 - n6) * 4 + 12;
            n3 = n6 * 2;
            n2 = n8 - 1 - n3;
            for (int i2 = 0; i2 < n4; ++i2) {
                int n9 = i2 * 2;
                for (int i3 = 0; i3 < 2; ++i3) {
                    blArray[n5 + n9 + i3] = bitMatrix.get(nArray[n3 + i3], nArray[n3 + i2]);
                    blArray[n5 + 2 * n4 + n9 + i3] = bitMatrix.get(nArray[n3 + i2], nArray[n2 - i3]);
                    blArray[n5 + 4 * n4 + n9 + i3] = bitMatrix.get(nArray[n2 - i3], nArray[n2 - i2]);
                    blArray[n5 + 6 * n4 + n9 + i3] = bitMatrix.get(nArray[n2 - i2], nArray[n3 + i3]);
                }
            }
            n5 += n4 * 8;
        }
        return blArray;
    }

    private static int readCode(boolean[] blArray, int n2, int n3) {
        int n4 = 0;
        for (int i2 = n2; i2 < n2 + n3; ++i2) {
            n4 <<= 1;
            if (!blArray[i2]) continue;
            n4 |= 1;
        }
        return n4;
    }

    private static int totalBitsInLayer(int n2, boolean bl2) {
        return ((bl2 ? 88 : 112) + 16 * n2) * n2;
    }

    private static enum Table {
        UPPER,
        LOWER,
        MIXED,
        DIGIT,
        PUNCT,
        BINARY;

    }
}

