/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.aztec.detector;

import com.google.zxing.NotFoundException;
import com.google.zxing.ResultPoint;
import com.google.zxing.aztec.AztecDetectorResult;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.GridSampler;
import com.google.zxing.common.detector.MathUtils;
import com.google.zxing.common.detector.WhiteRectangleDetector;
import com.google.zxing.common.reedsolomon.GenericGF;
import com.google.zxing.common.reedsolomon.ReedSolomonDecoder;
import com.google.zxing.common.reedsolomon.ReedSolomonException;

public final class Detector {
    private final BitMatrix image;
    private boolean compact;
    private int nbLayers;
    private int nbDataBlocks;
    private int nbCenterLayers;
    private int shift;
    private static final int[] EXPECTED_CORNER_BITS = new int[]{3808, 476, 2107, 1799};

    public Detector(BitMatrix bitMatrix) {
        this.image = bitMatrix;
    }

    public AztecDetectorResult detect() throws NotFoundException {
        return this.detect(false);
    }

    public AztecDetectorResult detect(boolean bl2) throws NotFoundException {
        Object object;
        Point point = this.getMatrixCenter();
        ResultPoint[] resultPointArray = this.getBullsEyeCorners(point);
        if (bl2) {
            object = resultPointArray[0];
            resultPointArray[0] = resultPointArray[2];
            resultPointArray[2] = object;
        }
        this.extractParameters(resultPointArray);
        object = this.sampleGrid(this.image, resultPointArray[this.shift % 4], resultPointArray[(this.shift + 1) % 4], resultPointArray[(this.shift + 2) % 4], resultPointArray[(this.shift + 3) % 4]);
        ResultPoint[] resultPointArray2 = this.getMatrixCornerPoints(resultPointArray);
        return new AztecDetectorResult((BitMatrix)object, resultPointArray2, this.compact, this.nbDataBlocks, this.nbLayers);
    }

    private void extractParameters(ResultPoint[] resultPointArray) throws NotFoundException {
        int n2;
        if (!(this.isValid(resultPointArray[0]) && this.isValid(resultPointArray[1]) && this.isValid(resultPointArray[2]) && this.isValid(resultPointArray[3]))) {
            throw NotFoundException.getNotFoundInstance();
        }
        int n3 = 2 * this.nbCenterLayers;
        int[] nArray = new int[]{this.sampleLine(resultPointArray[0], resultPointArray[1], n3), this.sampleLine(resultPointArray[1], resultPointArray[2], n3), this.sampleLine(resultPointArray[2], resultPointArray[3], n3), this.sampleLine(resultPointArray[3], resultPointArray[0], n3)};
        this.shift = Detector.getRotation(nArray, n3);
        long l2 = 0L;
        for (n2 = 0; n2 < 4; ++n2) {
            int n4 = nArray[(this.shift + n2) % 4];
            if (this.compact) {
                l2 <<= 7;
                l2 += (long)(n4 >> 1 & 0x7F);
                continue;
            }
            l2 <<= 10;
            l2 += (long)((n4 >> 2 & 0x3E0) + (n4 >> 1 & 0x1F));
        }
        n2 = Detector.getCorrectedParameterData(l2, this.compact);
        if (this.compact) {
            this.nbLayers = (n2 >> 6) + 1;
            this.nbDataBlocks = (n2 & 0x3F) + 1;
        } else {
            this.nbLayers = (n2 >> 11) + 1;
            this.nbDataBlocks = (n2 & 0x7FF) + 1;
        }
    }

    private static int getRotation(int[] nArray, int n2) throws NotFoundException {
        int n3 = 0;
        for (int n4 : nArray) {
            int n5 = (n4 >> n2 - 2 << 1) + (n4 & 1);
            n3 = (n3 << 3) + n5;
        }
        n3 = ((n3 & 1) << 11) + (n3 >> 1);
        for (int i2 = 0; i2 < 4; ++i2) {
            if (Integer.bitCount(n3 ^ EXPECTED_CORNER_BITS[i2]) > 2) continue;
            return i2;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static int getCorrectedParameterData(long l2, boolean bl2) throws NotFoundException {
        int n2;
        int n3;
        if (bl2) {
            n3 = 7;
            n2 = 2;
        } else {
            n3 = 10;
            n2 = 4;
        }
        int n4 = n3 - n2;
        int[] nArray = new int[n3];
        for (int i2 = n3 - 1; i2 >= 0; --i2) {
            nArray[i2] = (int)l2 & 0xF;
            l2 >>= 4;
        }
        try {
            ReedSolomonDecoder reedSolomonDecoder = new ReedSolomonDecoder(GenericGF.AZTEC_PARAM);
            reedSolomonDecoder.decode(nArray, n4);
        }
        catch (ReedSolomonException reedSolomonException) {
            throw NotFoundException.getNotFoundInstance();
        }
        int n5 = 0;
        for (int i3 = 0; i3 < n2; ++i3) {
            n5 = (n5 << 4) + nArray[i3];
        }
        return n5;
    }

    private ResultPoint[] getBullsEyeCorners(Point point) throws NotFoundException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5 = point;
        Point point2 = point;
        Point point3 = point;
        Point point4 = point;
        boolean bl2 = true;
        this.nbCenterLayers = 1;
        while (this.nbCenterLayers < 9) {
            float f2;
            object4 = this.getFirstDifferent((Point)object5, bl2, 1, -1);
            object3 = this.getFirstDifferent(point2, bl2, 1, 1);
            object2 = this.getFirstDifferent(point3, bl2, -1, 1);
            object = this.getFirstDifferent(point4, bl2, -1, -1);
            if (this.nbCenterLayers > 2 && ((double)(f2 = Detector.distance((Point)object, (Point)object4) * (float)this.nbCenterLayers / (Detector.distance(point4, (Point)object5) * (float)(this.nbCenterLayers + 2))) < 0.75 || (double)f2 > 1.25 || !this.isWhiteOrBlackRectangle((Point)object4, (Point)object3, (Point)object2, (Point)object))) break;
            object5 = object4;
            point2 = object3;
            point3 = object2;
            point4 = object;
            bl2 = !bl2;
            ++this.nbCenterLayers;
        }
        if (this.nbCenterLayers != 5 && this.nbCenterLayers != 7) {
            throw NotFoundException.getNotFoundInstance();
        }
        this.compact = this.nbCenterLayers == 5;
        object4 = new ResultPoint((float)((Point)object5).getX() + 0.5f, (float)((Point)object5).getY() - 0.5f);
        object3 = new ResultPoint((float)point2.getX() + 0.5f, (float)point2.getY() + 0.5f);
        object2 = new ResultPoint((float)point3.getX() - 0.5f, (float)point3.getY() + 0.5f);
        object = new ResultPoint((float)point4.getX() - 0.5f, (float)point4.getY() - 0.5f);
        return Detector.expandSquare(new ResultPoint[]{object4, object3, object2, object}, 2 * this.nbCenterLayers - 3, 2 * this.nbCenterLayers);
    }

    private Point getMatrixCenter() {
        int n2;
        ResultPoint resultPoint;
        ResultPoint resultPoint2;
        ResultPoint resultPoint3;
        ResultPoint resultPoint4;
        try {
            ResultPoint[] resultPointArray = new WhiteRectangleDetector(this.image).detect();
            resultPoint4 = resultPointArray[0];
            resultPoint3 = resultPointArray[1];
            resultPoint2 = resultPointArray[2];
            resultPoint = resultPointArray[3];
        }
        catch (NotFoundException notFoundException) {
            n2 = this.image.getWidth() / 2;
            int n3 = this.image.getHeight() / 2;
            resultPoint4 = this.getFirstDifferent(new Point(n2 + 7, n3 - 7), false, 1, -1).toResultPoint();
            resultPoint3 = this.getFirstDifferent(new Point(n2 + 7, n3 + 7), false, 1, 1).toResultPoint();
            resultPoint2 = this.getFirstDifferent(new Point(n2 - 7, n3 + 7), false, -1, 1).toResultPoint();
            resultPoint = this.getFirstDifferent(new Point(n2 - 7, n3 - 7), false, -1, -1).toResultPoint();
        }
        int n4 = MathUtils.round((resultPoint4.getX() + resultPoint.getX() + resultPoint3.getX() + resultPoint2.getX()) / 4.0f);
        n2 = MathUtils.round((resultPoint4.getY() + resultPoint.getY() + resultPoint3.getY() + resultPoint2.getY()) / 4.0f);
        try {
            ResultPoint[] resultPointArray = new WhiteRectangleDetector(this.image, 15, n4, n2).detect();
            resultPoint4 = resultPointArray[0];
            resultPoint3 = resultPointArray[1];
            resultPoint2 = resultPointArray[2];
            resultPoint = resultPointArray[3];
        }
        catch (NotFoundException notFoundException) {
            resultPoint4 = this.getFirstDifferent(new Point(n4 + 7, n2 - 7), false, 1, -1).toResultPoint();
            resultPoint3 = this.getFirstDifferent(new Point(n4 + 7, n2 + 7), false, 1, 1).toResultPoint();
            resultPoint2 = this.getFirstDifferent(new Point(n4 - 7, n2 + 7), false, -1, 1).toResultPoint();
            resultPoint = this.getFirstDifferent(new Point(n4 - 7, n2 - 7), false, -1, -1).toResultPoint();
        }
        n4 = MathUtils.round((resultPoint4.getX() + resultPoint.getX() + resultPoint3.getX() + resultPoint2.getX()) / 4.0f);
        n2 = MathUtils.round((resultPoint4.getY() + resultPoint.getY() + resultPoint3.getY() + resultPoint2.getY()) / 4.0f);
        return new Point(n4, n2);
    }

    private ResultPoint[] getMatrixCornerPoints(ResultPoint[] resultPointArray) {
        return Detector.expandSquare(resultPointArray, 2 * this.nbCenterLayers, this.getDimension());
    }

    private BitMatrix sampleGrid(BitMatrix bitMatrix, ResultPoint resultPoint, ResultPoint resultPoint2, ResultPoint resultPoint3, ResultPoint resultPoint4) throws NotFoundException {
        GridSampler gridSampler = GridSampler.getInstance();
        int n2 = this.getDimension();
        float f2 = (float)n2 / 2.0f - (float)this.nbCenterLayers;
        float f3 = (float)n2 / 2.0f + (float)this.nbCenterLayers;
        return gridSampler.sampleGrid(bitMatrix, n2, n2, f2, f2, f3, f2, f3, f3, f2, f3, resultPoint.getX(), resultPoint.getY(), resultPoint2.getX(), resultPoint2.getY(), resultPoint3.getX(), resultPoint3.getY(), resultPoint4.getX(), resultPoint4.getY());
    }

    private int sampleLine(ResultPoint resultPoint, ResultPoint resultPoint2, int n2) {
        int n3 = 0;
        float f2 = Detector.distance(resultPoint, resultPoint2);
        float f3 = f2 / (float)n2;
        float f4 = resultPoint.getX();
        float f5 = resultPoint.getY();
        float f6 = f3 * (resultPoint2.getX() - resultPoint.getX()) / f2;
        float f7 = f3 * (resultPoint2.getY() - resultPoint.getY()) / f2;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!this.image.get(MathUtils.round(f4 + (float)i2 * f6), MathUtils.round(f5 + (float)i2 * f7))) continue;
            n3 |= 1 << n2 - i2 - 1;
        }
        return n3;
    }

    private boolean isWhiteOrBlackRectangle(Point point, Point point2, Point point3, Point point4) {
        int n2 = 3;
        point = new Point(point.getX() - n2, point.getY() + n2);
        point2 = new Point(point2.getX() - n2, point2.getY() - n2);
        point3 = new Point(point3.getX() + n2, point3.getY() - n2);
        int n3 = this.getColor(point4 = new Point(point4.getX() + n2, point4.getY() + n2), point);
        if (n3 == 0) {
            return false;
        }
        int n4 = this.getColor(point, point2);
        if (n4 != n3) {
            return false;
        }
        n4 = this.getColor(point2, point3);
        if (n4 != n3) {
            return false;
        }
        n4 = this.getColor(point3, point4);
        return n4 == n3;
    }

    private int getColor(Point point, Point point2) {
        float f2 = Detector.distance(point, point2);
        float f3 = (float)(point2.getX() - point.getX()) / f2;
        float f4 = (float)(point2.getY() - point.getY()) / f2;
        int n2 = 0;
        float f5 = point.getX();
        float f6 = point.getY();
        boolean bl2 = this.image.get(point.getX(), point.getY());
        int n3 = 0;
        while ((float)n3 < f2) {
            if (this.image.get(MathUtils.round(f5 += f3), MathUtils.round(f6 += f4)) != bl2) {
                ++n2;
            }
            ++n3;
        }
        float f7 = (float)n2 / f2;
        if (f7 > 0.1f && f7 < 0.9f) {
            return 0;
        }
        return f7 <= 0.1f == bl2 ? 1 : -1;
    }

    private Point getFirstDifferent(Point point, boolean bl2, int n2, int n3) {
        int n4 = point.getX() + n2;
        int n5 = point.getY() + n3;
        while (this.isValid(n4, n5) && this.image.get(n4, n5) == bl2) {
            n4 += n2;
            n5 += n3;
        }
        n4 -= n2;
        n5 -= n3;
        while (this.isValid(n4, n5) && this.image.get(n4, n5) == bl2) {
            n4 += n2;
        }
        n4 -= n2;
        while (this.isValid(n4, n5) && this.image.get(n4, n5) == bl2) {
            n5 += n3;
        }
        return new Point(n4, n5 -= n3);
    }

    private static ResultPoint[] expandSquare(ResultPoint[] resultPointArray, float f2, float f3) {
        float f4 = f3 / (2.0f * f2);
        float f5 = resultPointArray[0].getX() - resultPointArray[2].getX();
        float f6 = resultPointArray[0].getY() - resultPointArray[2].getY();
        float f7 = (resultPointArray[0].getX() + resultPointArray[2].getX()) / 2.0f;
        float f8 = (resultPointArray[0].getY() + resultPointArray[2].getY()) / 2.0f;
        ResultPoint resultPoint = new ResultPoint(f7 + f4 * f5, f8 + f4 * f6);
        ResultPoint resultPoint2 = new ResultPoint(f7 - f4 * f5, f8 - f4 * f6);
        f5 = resultPointArray[1].getX() - resultPointArray[3].getX();
        f6 = resultPointArray[1].getY() - resultPointArray[3].getY();
        f7 = (resultPointArray[1].getX() + resultPointArray[3].getX()) / 2.0f;
        f8 = (resultPointArray[1].getY() + resultPointArray[3].getY()) / 2.0f;
        ResultPoint resultPoint3 = new ResultPoint(f7 + f4 * f5, f8 + f4 * f6);
        ResultPoint resultPoint4 = new ResultPoint(f7 - f4 * f5, f8 - f4 * f6);
        return new ResultPoint[]{resultPoint, resultPoint3, resultPoint2, resultPoint4};
    }

    private boolean isValid(int n2, int n3) {
        return n2 >= 0 && n2 < this.image.getWidth() && n3 > 0 && n3 < this.image.getHeight();
    }

    private boolean isValid(ResultPoint resultPoint) {
        int n2 = MathUtils.round(resultPoint.getX());
        int n3 = MathUtils.round(resultPoint.getY());
        return this.isValid(n2, n3);
    }

    private static float distance(Point point, Point point2) {
        return MathUtils.distance(point.getX(), point.getY(), point2.getX(), point2.getY());
    }

    private static float distance(ResultPoint resultPoint, ResultPoint resultPoint2) {
        return MathUtils.distance(resultPoint.getX(), resultPoint.getY(), resultPoint2.getX(), resultPoint2.getY());
    }

    private int getDimension() {
        if (this.compact) {
            return 4 * this.nbLayers + 11;
        }
        if (this.nbLayers <= 4) {
            return 4 * this.nbLayers + 15;
        }
        return 4 * this.nbLayers + 2 * ((this.nbLayers - 4) / 8 + 1) + 15;
    }

    static final class Point {
        private final int x;
        private final int y;

        ResultPoint toResultPoint() {
            return new ResultPoint(this.getX(), this.getY());
        }

        Point(int n2, int n3) {
            this.x = n2;
            this.y = n3;
        }

        int getX() {
            return this.x;
        }

        int getY() {
            return this.y;
        }

        public String toString() {
            return "<" + this.x + ' ' + this.y + '>';
        }
    }
}

