/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.aztec.encoder;

import com.google.zxing.aztec.encoder.Token;
import com.google.zxing.common.BitArray;

final class BinaryShiftToken
extends Token {
    private final short binaryShiftStart;
    private final short binaryShiftByteCount;

    BinaryShiftToken(Token token, int n2, int n3) {
        super(token);
        this.binaryShiftStart = (short)n2;
        this.binaryShiftByteCount = (short)n3;
    }

    @Override
    public void appendTo(BitArray bitArray, byte[] byArray) {
        for (int i2 = 0; i2 < this.binaryShiftByteCount; ++i2) {
            if (i2 == 0 || i2 == 31 && this.binaryShiftByteCount <= 62) {
                bitArray.appendBits(31, 5);
                if (this.binaryShiftByteCount > 62) {
                    bitArray.appendBits(this.binaryShiftByteCount - 31, 16);
                } else if (i2 == 0) {
                    bitArray.appendBits(Math.min(this.binaryShiftByteCount, 31), 5);
                } else {
                    bitArray.appendBits(this.binaryShiftByteCount - 31, 5);
                }
            }
            bitArray.appendBits(byArray[this.binaryShiftStart + i2], 8);
        }
    }

    public String toString() {
        return "<" + this.binaryShiftStart + "::" + (this.binaryShiftStart + this.binaryShiftByteCount - 1) + '>';
    }
}

