/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.aztec.encoder;

import com.google.zxing.aztec.encoder.AztecCode;
import com.google.zxing.aztec.encoder.HighLevelEncoder;
import com.google.zxing.common.BitArray;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.reedsolomon.GenericGF;
import com.google.zxing.common.reedsolomon.ReedSolomonEncoder;

public final class Encoder {
    public static final int DEFAULT_EC_PERCENT = 33;
    public static final int DEFAULT_AZTEC_LAYERS = 0;
    private static final int MAX_NB_BITS = 32;
    private static final int MAX_NB_BITS_COMPACT = 4;
    private static final int[] WORD_SIZE = new int[]{4, 6, 6, 8, 8, 8, 8, 8, 8, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12};

    private Encoder() {
    }

    public static AztecCode encode(byte[] byArray) {
        return Encoder.encode(byArray, 33, 0);
    }

    public static AztecCode encode(byte[] byArray, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        BitArray bitArray;
        int n10;
        int n11;
        int n12;
        int n13;
        boolean bl2;
        BitArray bitArray2 = new HighLevelEncoder(byArray).encode();
        int n14 = bitArray2.getSize() * n2 / 100 + 11;
        int n15 = bitArray2.getSize() + n14;
        if (n3 != 0) {
            bl2 = n3 < 0;
            n13 = Math.abs(n3);
            if (n13 > (bl2 ? 4 : 32)) {
                throw new IllegalArgumentException(String.format("Illegal value %s for layers", n3));
            }
            n12 = Encoder.totalBitsInLayer(n13, bl2);
            n11 = WORD_SIZE[n13];
            n10 = n12 - n12 % n11;
            bitArray = Encoder.stuffBits(bitArray2, n11);
            if (bitArray.getSize() + n14 > n10) {
                throw new IllegalArgumentException("Data to large for user specified layer");
            }
            if (bl2 && bitArray.getSize() > n11 * 64) {
                throw new IllegalArgumentException("Data to large for user specified layer");
            }
        } else {
            n11 = 0;
            bitArray = null;
            n10 = 0;
            while (true) {
                if (n10 > 32) {
                    throw new IllegalArgumentException("Data too large for an Aztec code");
                }
                bl2 = n10 <= 3;
                n13 = bl2 ? n10 + 1 : n10;
                n12 = Encoder.totalBitsInLayer(n13, bl2);
                if (n15 <= n12) {
                    if (n11 != WORD_SIZE[n13]) {
                        n11 = WORD_SIZE[n13];
                        bitArray = Encoder.stuffBits(bitArray2, n11);
                    }
                    n9 = n12 - n12 % n11;
                    if ((!bl2 || bitArray.getSize() <= n11 * 64) && bitArray.getSize() + n14 <= n9) break;
                }
                ++n10;
            }
        }
        BitArray bitArray3 = Encoder.generateCheckWords(bitArray, n12, n11);
        n9 = bitArray.getSize() / n11;
        BitArray bitArray4 = Encoder.generateModeMessage(bl2, n13, n9);
        int n16 = bl2 ? 11 + n13 * 4 : 14 + n13 * 4;
        int[] nArray = new int[n16];
        if (bl2) {
            n8 = n16;
            for (n7 = 0; n7 < nArray.length; ++n7) {
                nArray[n7] = n7;
            }
        } else {
            n8 = n16 + 1 + 2 * ((n16 / 2 - 1) / 15);
            n7 = n16 / 2;
            n6 = n8 / 2;
            for (n5 = 0; n5 < n7; ++n5) {
                n4 = n5 + n5 / 15;
                nArray[n7 - n5 - 1] = n6 - n4 - 1;
                nArray[n7 + n5] = n6 + n4 + 1;
            }
        }
        BitMatrix bitMatrix = new BitMatrix(n8);
        n5 = 0;
        for (n6 = 0; n6 < n13; ++n6) {
            n4 = bl2 ? (n13 - n6) * 4 + 9 : (n13 - n6) * 4 + 12;
            for (int i2 = 0; i2 < n4; ++i2) {
                int n17 = i2 * 2;
                for (int i3 = 0; i3 < 2; ++i3) {
                    if (bitArray3.get(n5 + n17 + i3)) {
                        bitMatrix.set(nArray[n6 * 2 + i3], nArray[n6 * 2 + i2]);
                    }
                    if (bitArray3.get(n5 + n4 * 2 + n17 + i3)) {
                        bitMatrix.set(nArray[n6 * 2 + i2], nArray[n16 - 1 - n6 * 2 - i3]);
                    }
                    if (bitArray3.get(n5 + n4 * 4 + n17 + i3)) {
                        bitMatrix.set(nArray[n16 - 1 - n6 * 2 - i3], nArray[n16 - 1 - n6 * 2 - i2]);
                    }
                    if (!bitArray3.get(n5 + n4 * 6 + n17 + i3)) continue;
                    bitMatrix.set(nArray[n16 - 1 - n6 * 2 - i2], nArray[n6 * 2 + i3]);
                }
            }
            n5 += n4 * 8;
        }
        Encoder.drawModeMessage(bitMatrix, bl2, n8, bitArray4);
        if (bl2) {
            Encoder.drawBullsEye(bitMatrix, n8 / 2, 5);
        } else {
            Encoder.drawBullsEye(bitMatrix, n8 / 2, 7);
            n6 = 0;
            n5 = 0;
            while (n6 < n16 / 2 - 1) {
                for (n4 = n8 / 2 & 1; n4 < n8; n4 += 2) {
                    bitMatrix.set(n8 / 2 - n5, n4);
                    bitMatrix.set(n8 / 2 + n5, n4);
                    bitMatrix.set(n4, n8 / 2 - n5);
                    bitMatrix.set(n4, n8 / 2 + n5);
                }
                n6 += 15;
                n5 += 16;
            }
        }
        AztecCode aztecCode = new AztecCode();
        aztecCode.setCompact(bl2);
        aztecCode.setSize(n8);
        aztecCode.setLayers(n13);
        aztecCode.setCodeWords(n9);
        aztecCode.setMatrix(bitMatrix);
        return aztecCode;
    }

    private static void drawBullsEye(BitMatrix bitMatrix, int n2, int n3) {
        for (int i2 = 0; i2 < n3; i2 += 2) {
            for (int i3 = n2 - i2; i3 <= n2 + i2; ++i3) {
                bitMatrix.set(i3, n2 - i2);
                bitMatrix.set(i3, n2 + i2);
                bitMatrix.set(n2 - i2, i3);
                bitMatrix.set(n2 + i2, i3);
            }
        }
        bitMatrix.set(n2 - n3, n2 - n3);
        bitMatrix.set(n2 - n3 + 1, n2 - n3);
        bitMatrix.set(n2 - n3, n2 - n3 + 1);
        bitMatrix.set(n2 + n3, n2 - n3);
        bitMatrix.set(n2 + n3, n2 - n3 + 1);
        bitMatrix.set(n2 + n3, n2 + n3 - 1);
    }

    static BitArray generateModeMessage(boolean bl2, int n2, int n3) {
        BitArray bitArray = new BitArray();
        if (bl2) {
            bitArray.appendBits(n2 - 1, 2);
            bitArray.appendBits(n3 - 1, 6);
            bitArray = Encoder.generateCheckWords(bitArray, 28, 4);
        } else {
            bitArray.appendBits(n2 - 1, 5);
            bitArray.appendBits(n3 - 1, 11);
            bitArray = Encoder.generateCheckWords(bitArray, 40, 4);
        }
        return bitArray;
    }

    private static void drawModeMessage(BitMatrix bitMatrix, boolean bl2, int n2, BitArray bitArray) {
        int n3 = n2 / 2;
        if (bl2) {
            for (int i2 = 0; i2 < 7; ++i2) {
                int n4 = n3 - 3 + i2;
                if (bitArray.get(i2)) {
                    bitMatrix.set(n4, n3 - 5);
                }
                if (bitArray.get(i2 + 7)) {
                    bitMatrix.set(n3 + 5, n4);
                }
                if (bitArray.get(20 - i2)) {
                    bitMatrix.set(n4, n3 + 5);
                }
                if (!bitArray.get(27 - i2)) continue;
                bitMatrix.set(n3 - 5, n4);
            }
        } else {
            for (int i3 = 0; i3 < 10; ++i3) {
                int n5 = n3 - 5 + i3 + i3 / 5;
                if (bitArray.get(i3)) {
                    bitMatrix.set(n5, n3 - 7);
                }
                if (bitArray.get(i3 + 10)) {
                    bitMatrix.set(n3 + 7, n5);
                }
                if (bitArray.get(29 - i3)) {
                    bitMatrix.set(n5, n3 + 7);
                }
                if (!bitArray.get(39 - i3)) continue;
                bitMatrix.set(n3 - 7, n5);
            }
        }
    }

    private static BitArray generateCheckWords(BitArray bitArray, int n2, int n3) {
        int n4 = bitArray.getSize() / n3;
        ReedSolomonEncoder reedSolomonEncoder = new ReedSolomonEncoder(Encoder.getGF(n3));
        int n5 = n2 / n3;
        int[] nArray = Encoder.bitsToWords(bitArray, n3, n5);
        reedSolomonEncoder.encode(nArray, n5 - n4);
        int n6 = n2 % n3;
        BitArray bitArray2 = new BitArray();
        bitArray2.appendBits(0, n6);
        for (int n7 : nArray) {
            bitArray2.appendBits(n7, n3);
        }
        return bitArray2;
    }

    private static int[] bitsToWords(BitArray bitArray, int n2, int n3) {
        int[] nArray = new int[n3];
        int n4 = bitArray.getSize() / n2;
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = 0;
            for (int i3 = 0; i3 < n2; ++i3) {
                n5 |= bitArray.get(i2 * n2 + i3) ? 1 << n2 - i3 - 1 : 0;
            }
            nArray[i2] = n5;
        }
        return nArray;
    }

    private static GenericGF getGF(int n2) {
        switch (n2) {
            case 4: {
                return GenericGF.AZTEC_PARAM;
            }
            case 6: {
                return GenericGF.AZTEC_DATA_6;
            }
            case 8: {
                return GenericGF.AZTEC_DATA_8;
            }
            case 10: {
                return GenericGF.AZTEC_DATA_10;
            }
            case 12: {
                return GenericGF.AZTEC_DATA_12;
            }
        }
        return null;
    }

    static BitArray stuffBits(BitArray bitArray, int n2) {
        BitArray bitArray2 = new BitArray();
        int n3 = bitArray.getSize();
        int n4 = (1 << n2) - 2;
        for (int i2 = 0; i2 < n3; i2 += n2) {
            int n5 = 0;
            for (int i3 = 0; i3 < n2; ++i3) {
                if (i2 + i3 < n3 && !bitArray.get(i2 + i3)) continue;
                n5 |= 1 << n2 - 1 - i3;
            }
            if ((n5 & n4) == n4) {
                bitArray2.appendBits(n5 & n4, n2);
                --i2;
                continue;
            }
            if ((n5 & n4) == 0) {
                bitArray2.appendBits(n5 | 1, n2);
                --i2;
                continue;
            }
            bitArray2.appendBits(n5, n2);
        }
        return bitArray2;
    }

    private static int totalBitsInLayer(int n2, boolean bl2) {
        return ((bl2 ? 88 : 112) + 16 * n2) * n2;
    }
}

