/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.result;

import com.google.zxing.client.result.ParsedResult;
import com.google.zxing.client.result.ParsedResultType;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class CalendarParsedResult
extends ParsedResult {
    private static final Pattern RFC2445_DURATION = Pattern.compile("P(?:(\\d+)W)?(?:(\\d+)D)?(?:T(?:(\\d+)H)?(?:(\\d+)M)?(?:(\\d+)S)?)?");
    private static final long[] RFC2445_DURATION_FIELD_UNITS = new long[]{604800000L, 86400000L, 3600000L, 60000L, 1000L};
    private static final Pattern DATE_TIME = Pattern.compile("[0-9]{8}(T[0-9]{6}Z?)?");
    private final String summary;
    private final Date start;
    private final boolean startAllDay;
    private final Date end;
    private final boolean endAllDay;
    private final String location;
    private final String organizer;
    private final String[] attendees;
    private final String description;
    private final double latitude;
    private final double longitude;

    public CalendarParsedResult(String string2, String string3, String string4, String string5, String string6, String string7, String[] stringArray, String string8, double d2, double d3) {
        super(ParsedResultType.CALENDAR);
        this.summary = string2;
        try {
            this.start = CalendarParsedResult.parseDate(string3);
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException(parseException.toString());
        }
        if (string4 == null) {
            long l2 = CalendarParsedResult.parseDurationMS(string5);
            this.end = l2 < 0L ? null : new Date(this.start.getTime() + l2);
        } else {
            try {
                this.end = CalendarParsedResult.parseDate(string4);
            }
            catch (ParseException parseException) {
                throw new IllegalArgumentException(parseException.toString());
            }
        }
        this.startAllDay = string3.length() == 8;
        this.endAllDay = string4 != null && string4.length() == 8;
        this.location = string6;
        this.organizer = string7;
        this.attendees = stringArray;
        this.description = string8;
        this.latitude = d2;
        this.longitude = d3;
    }

    public String getSummary() {
        return this.summary;
    }

    public Date getStart() {
        return this.start;
    }

    public boolean isStartAllDay() {
        return this.startAllDay;
    }

    public Date getEnd() {
        return this.end;
    }

    public boolean isEndAllDay() {
        return this.endAllDay;
    }

    public String getLocation() {
        return this.location;
    }

    public String getOrganizer() {
        return this.organizer;
    }

    public String[] getAttendees() {
        return this.attendees;
    }

    public String getDescription() {
        return this.description;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    @Override
    public String getDisplayResult() {
        StringBuilder stringBuilder = new StringBuilder(100);
        CalendarParsedResult.maybeAppend(this.summary, stringBuilder);
        CalendarParsedResult.maybeAppend(CalendarParsedResult.format(this.startAllDay, this.start), stringBuilder);
        CalendarParsedResult.maybeAppend(CalendarParsedResult.format(this.endAllDay, this.end), stringBuilder);
        CalendarParsedResult.maybeAppend(this.location, stringBuilder);
        CalendarParsedResult.maybeAppend(this.organizer, stringBuilder);
        CalendarParsedResult.maybeAppend(this.attendees, stringBuilder);
        CalendarParsedResult.maybeAppend(this.description, stringBuilder);
        return stringBuilder.toString();
    }

    private static Date parseDate(String string2) throws ParseException {
        Date date;
        if (!DATE_TIME.matcher(string2).matches()) {
            throw new ParseException(string2, 0);
        }
        if (string2.length() == 8) {
            return CalendarParsedResult.buildDateFormat().parse(string2);
        }
        if (string2.length() == 16 && string2.charAt(15) == 'Z') {
            date = CalendarParsedResult.buildDateTimeFormat().parse(string2.substring(0, 15));
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            long l2 = date.getTime();
            gregorianCalendar.setTime(new Date(l2 += (long)gregorianCalendar.get(15)));
            date = new Date(l2 += (long)gregorianCalendar.get(16));
        } else {
            date = CalendarParsedResult.buildDateTimeFormat().parse(string2);
        }
        return date;
    }

    private static String format(boolean bl2, Date date) {
        if (date == null) {
            return null;
        }
        DateFormat dateFormat = bl2 ? DateFormat.getDateInstance(2) : DateFormat.getDateTimeInstance(2, 2);
        return dateFormat.format(date);
    }

    private static long parseDurationMS(CharSequence charSequence) {
        if (charSequence == null) {
            return -1L;
        }
        Matcher matcher = RFC2445_DURATION.matcher(charSequence);
        if (!matcher.matches()) {
            return -1L;
        }
        long l2 = 0L;
        for (int i2 = 0; i2 < RFC2445_DURATION_FIELD_UNITS.length; ++i2) {
            String string2 = matcher.group(i2 + 1);
            if (string2 == null) continue;
            l2 += RFC2445_DURATION_FIELD_UNITS[i2] * (long)Integer.parseInt(string2);
        }
        return l2;
    }

    private static DateFormat buildDateFormat() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd", Locale.ENGLISH);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return simpleDateFormat;
    }

    private static DateFormat buildDateTimeFormat() {
        return new SimpleDateFormat("yyyyMMdd'T'HHmmss", Locale.ENGLISH);
    }
}

