/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.result;

import com.google.zxing.Result;
import com.google.zxing.client.result.AbstractDoCoMoResultParser;
import com.google.zxing.client.result.EmailAddressParsedResult;
import java.util.regex.Pattern;

public final class EmailDoCoMoResultParser
extends AbstractDoCoMoResultParser {
    private static final Pattern ATEXT_ALPHANUMERIC = Pattern.compile("[a-zA-Z0-9@.!#$%&'*+\\-/=?^_`{|}~]+");

    @Override
    public EmailAddressParsedResult parse(Result result) {
        String string2 = EmailDoCoMoResultParser.getMassagedText(result);
        if (!string2.startsWith("MATMSG:")) {
            return null;
        }
        String[] stringArray = EmailDoCoMoResultParser.matchDoCoMoPrefixedField("TO:", string2, true);
        if (stringArray == null) {
            return null;
        }
        String string3 = stringArray[0];
        if (!EmailDoCoMoResultParser.isBasicallyValidEmailAddress(string3)) {
            return null;
        }
        String string4 = EmailDoCoMoResultParser.matchSingleDoCoMoPrefixedField("SUB:", string2, false);
        String string5 = EmailDoCoMoResultParser.matchSingleDoCoMoPrefixedField("BODY:", string2, false);
        return new EmailAddressParsedResult(string3, string4, string5, "mailto:" + string3);
    }

    static boolean isBasicallyValidEmailAddress(String string2) {
        return string2 != null && ATEXT_ALPHANUMERIC.matcher(string2).matches() && string2.indexOf(64) >= 0;
    }
}

