/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.result;

import com.google.zxing.Result;
import com.google.zxing.client.result.AddressBookAUResultParser;
import com.google.zxing.client.result.AddressBookDoCoMoResultParser;
import com.google.zxing.client.result.BizcardResultParser;
import com.google.zxing.client.result.BookmarkDoCoMoResultParser;
import com.google.zxing.client.result.EmailAddressResultParser;
import com.google.zxing.client.result.EmailDoCoMoResultParser;
import com.google.zxing.client.result.ExpandedProductResultParser;
import com.google.zxing.client.result.GeoResultParser;
import com.google.zxing.client.result.ISBNResultParser;
import com.google.zxing.client.result.ParsedResult;
import com.google.zxing.client.result.ProductResultParser;
import com.google.zxing.client.result.SMSMMSResultParser;
import com.google.zxing.client.result.SMSTOMMSTOResultParser;
import com.google.zxing.client.result.SMTPResultParser;
import com.google.zxing.client.result.TelResultParser;
import com.google.zxing.client.result.TextParsedResult;
import com.google.zxing.client.result.URIResultParser;
import com.google.zxing.client.result.URLTOResultParser;
import com.google.zxing.client.result.VCardResultParser;
import com.google.zxing.client.result.VEventResultParser;
import com.google.zxing.client.result.VINResultParser;
import com.google.zxing.client.result.WifiResultParser;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public abstract class ResultParser {
    private static final ResultParser[] PARSERS = new ResultParser[]{new BookmarkDoCoMoResultParser(), new AddressBookDoCoMoResultParser(), new EmailDoCoMoResultParser(), new AddressBookAUResultParser(), new VCardResultParser(), new BizcardResultParser(), new VEventResultParser(), new EmailAddressResultParser(), new SMTPResultParser(), new TelResultParser(), new SMSMMSResultParser(), new SMSTOMMSTOResultParser(), new GeoResultParser(), new WifiResultParser(), new URLTOResultParser(), new URIResultParser(), new ISBNResultParser(), new ProductResultParser(), new ExpandedProductResultParser(), new VINResultParser()};
    private static final Pattern DIGITS = Pattern.compile("\\d+");
    private static final Pattern AMPERSAND = Pattern.compile("&");
    private static final Pattern EQUALS = Pattern.compile("=");
    private static final String BYTE_ORDER_MARK = "\ufeff";

    public abstract ParsedResult parse(Result var1);

    protected static String getMassagedText(Result result) {
        String string2 = result.getText();
        if (string2.startsWith(BYTE_ORDER_MARK)) {
            string2 = string2.substring(1);
        }
        return string2;
    }

    public static ParsedResult parseResult(Result result) {
        for (ResultParser resultParser : PARSERS) {
            ParsedResult parsedResult = resultParser.parse(result);
            if (parsedResult == null) continue;
            return parsedResult;
        }
        return new TextParsedResult(result.getText(), null);
    }

    protected static void maybeAppend(String string2, StringBuilder stringBuilder) {
        if (string2 != null) {
            stringBuilder.append('\n');
            stringBuilder.append(string2);
        }
    }

    protected static void maybeAppend(String[] stringArray, StringBuilder stringBuilder) {
        if (stringArray != null) {
            for (String string2 : stringArray) {
                stringBuilder.append('\n');
                stringBuilder.append(string2);
            }
        }
    }

    protected static String[] maybeWrap(String string2) {
        String[] stringArray;
        if (string2 == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = string2;
        }
        return stringArray;
    }

    protected static String unescapeBackslash(String string2) {
        int n2 = string2.indexOf(92);
        if (n2 < 0) {
            return string2;
        }
        int n3 = string2.length();
        StringBuilder stringBuilder = new StringBuilder(n3 - 1);
        stringBuilder.append(string2.toCharArray(), 0, n2);
        boolean bl2 = false;
        for (int i2 = n2; i2 < n3; ++i2) {
            char c2 = string2.charAt(i2);
            if (bl2 || c2 != '\\') {
                stringBuilder.append(c2);
                bl2 = false;
                continue;
            }
            bl2 = true;
        }
        return stringBuilder.toString();
    }

    protected static int parseHexDigit(char c2) {
        if (c2 >= '0' && c2 <= '9') {
            return c2 - 48;
        }
        if (c2 >= 'a' && c2 <= 'f') {
            return 10 + (c2 - 97);
        }
        if (c2 >= 'A' && c2 <= 'F') {
            return 10 + (c2 - 65);
        }
        return -1;
    }

    protected static boolean isStringOfDigits(CharSequence charSequence, int n2) {
        return charSequence != null && n2 > 0 && n2 == charSequence.length() && DIGITS.matcher(charSequence).matches();
    }

    protected static boolean isSubstringOfDigits(CharSequence charSequence, int n2, int n3) {
        if (charSequence == null || n3 <= 0) {
            return false;
        }
        int n4 = n2 + n3;
        return charSequence.length() >= n4 && DIGITS.matcher(charSequence.subSequence(n2, n4)).matches();
    }

    static Map<String, String> parseNameValuePairs(String string2) {
        int n2 = string2.indexOf(63);
        if (n2 < 0) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(3);
        for (String string3 : AMPERSAND.split(string2.substring(n2 + 1))) {
            ResultParser.appendKeyValue(string3, hashMap);
        }
        return hashMap;
    }

    private static void appendKeyValue(CharSequence charSequence, Map<String, String> map) {
        String[] stringArray = EQUALS.split(charSequence, 2);
        if (stringArray.length == 2) {
            String string2 = stringArray[0];
            String string3 = stringArray[1];
            try {
                string3 = ResultParser.urlDecode(string3);
                map.put(string2, string3);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    static String urlDecode(String string2) {
        try {
            return URLDecoder.decode(string2, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException(unsupportedEncodingException);
        }
    }

    static String[] matchPrefixedField(String string2, String string3, char c2, boolean bl2) {
        ArrayList<String> arrayList = null;
        int n2 = 0;
        int n3 = string3.length();
        while (n2 < n3 && (n2 = string3.indexOf(string2, n2)) >= 0) {
            int n4 = n2 += string2.length();
            boolean bl3 = true;
            while (bl3) {
                if ((n2 = string3.indexOf(c2, n2)) < 0) {
                    n2 = string3.length();
                    bl3 = false;
                    continue;
                }
                if (string3.charAt(n2 - 1) == '\\') {
                    ++n2;
                    continue;
                }
                if (arrayList == null) {
                    arrayList = new ArrayList<String>(3);
                }
                String string4 = ResultParser.unescapeBackslash(string3.substring(n4, n2));
                if (bl2) {
                    string4 = string4.trim();
                }
                if (!string4.isEmpty()) {
                    arrayList.add(string4);
                }
                ++n2;
                bl3 = false;
            }
        }
        if (arrayList == null || arrayList.isEmpty()) {
            return null;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    static String matchSinglePrefixedField(String string2, String string3, char c2, boolean bl2) {
        String[] stringArray = ResultParser.matchPrefixedField(string2, string3, c2, bl2);
        return stringArray == null ? null : stringArray[0];
    }
}

