/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.result;

import com.google.zxing.client.result.ParsedResult;
import com.google.zxing.client.result.ParsedResultType;
import com.google.zxing.client.result.ResultParser;
import java.util.regex.Pattern;

public final class URIParsedResult
extends ParsedResult {
    private static final Pattern USER_IN_HOST = Pattern.compile(":/*([^/@]+)@[^/]+");
    private final String uri;
    private final String title;

    public URIParsedResult(String string2, String string3) {
        super(ParsedResultType.URI);
        this.uri = URIParsedResult.massageURI(string2);
        this.title = string3;
    }

    public String getURI() {
        return this.uri;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isPossiblyMaliciousURI() {
        return USER_IN_HOST.matcher(this.uri).find();
    }

    @Override
    public String getDisplayResult() {
        StringBuilder stringBuilder = new StringBuilder(30);
        URIParsedResult.maybeAppend(this.title, stringBuilder);
        URIParsedResult.maybeAppend(this.uri, stringBuilder);
        return stringBuilder.toString();
    }

    private static String massageURI(String string2) {
        int n2 = (string2 = string2.trim()).indexOf(58);
        if (n2 < 0) {
            string2 = "http://" + string2;
        } else if (URIParsedResult.isColonFollowedByPortNumber(string2, n2)) {
            string2 = "http://" + string2;
        }
        return string2;
    }

    private static boolean isColonFollowedByPortNumber(String string2, int n2) {
        int n3 = n2 + 1;
        int n4 = string2.indexOf(47, n3);
        if (n4 < 0) {
            n4 = string2.length();
        }
        return ResultParser.isSubstringOfDigits(string2, n3, n4 - n3);
    }
}

