/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.result;

import com.google.zxing.Result;
import com.google.zxing.client.result.ResultParser;
import com.google.zxing.client.result.URIParsedResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class URIResultParser
extends ResultParser {
    private static final Pattern URL_WITH_PROTOCOL_PATTERN = Pattern.compile("[a-zA-Z0-9]{2,}:");
    private static final Pattern URL_WITHOUT_PROTOCOL_PATTERN = Pattern.compile("([a-zA-Z0-9\\-]+\\.)+[a-zA-Z]{2,}(:\\d{1,5})?(/|\\?|$)");

    @Override
    public URIParsedResult parse(Result result) {
        String string2 = URIResultParser.getMassagedText(result);
        if (string2.startsWith("URL:") || string2.startsWith("URI:")) {
            return new URIParsedResult(string2.substring(4).trim(), null);
        }
        return URIResultParser.isBasicallyValidURI(string2 = string2.trim()) ? new URIParsedResult(string2, null) : null;
    }

    static boolean isBasicallyValidURI(String string2) {
        if (string2.contains(" ")) {
            return false;
        }
        Matcher matcher = URL_WITH_PROTOCOL_PATTERN.matcher(string2);
        if (matcher.find() && matcher.start() == 0) {
            return true;
        }
        matcher = URL_WITHOUT_PROTOCOL_PATTERN.matcher(string2);
        return matcher.find() && matcher.start() == 0;
    }
}

