/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.result;

import com.google.zxing.Result;
import com.google.zxing.client.result.AddressBookParsedResult;
import com.google.zxing.client.result.ResultParser;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class VCardResultParser
extends ResultParser {
    private static final Pattern BEGIN_VCARD = Pattern.compile("BEGIN:VCARD", 2);
    private static final Pattern VCARD_LIKE_DATE = Pattern.compile("\\d{4}-?\\d{2}-?\\d{2}");
    private static final Pattern CR_LF_SPACE_TAB = Pattern.compile("\r\n[ \t]");
    private static final Pattern NEWLINE_ESCAPE = Pattern.compile("\\\\[nN]");
    private static final Pattern VCARD_ESCAPES = Pattern.compile("\\\\([,;\\\\])");
    private static final Pattern EQUALS = Pattern.compile("=");
    private static final Pattern SEMICOLON = Pattern.compile(";");
    private static final Pattern UNESCAPED_SEMICOLONS = Pattern.compile("(?<!\\\\);+");
    private static final Pattern COMMA = Pattern.compile(",");
    private static final Pattern SEMICOLON_OR_COMMA = Pattern.compile("[;,]");

    @Override
    public AddressBookParsedResult parse(Result result) {
        String[] stringArray;
        List<String> list;
        String string2 = VCardResultParser.getMassagedText(result);
        Matcher matcher = BEGIN_VCARD.matcher(string2);
        if (!matcher.find() || matcher.start() != 0) {
            return null;
        }
        List<List<String>> list2 = VCardResultParser.matchVCardPrefixedField("FN", string2, true, false);
        if (list2 == null) {
            list2 = VCardResultParser.matchVCardPrefixedField("N", string2, true, false);
            VCardResultParser.formatNames(list2);
        }
        String[] stringArray2 = (list = VCardResultParser.matchSingleVCardPrefixedField("NICKNAME", string2, true, false)) == null ? null : COMMA.split(list.get(0));
        List<List<String>> list3 = VCardResultParser.matchVCardPrefixedField("TEL", string2, true, false);
        List<List<String>> list4 = VCardResultParser.matchVCardPrefixedField("EMAIL", string2, true, false);
        List<String> list5 = VCardResultParser.matchSingleVCardPrefixedField("NOTE", string2, false, false);
        List<List<String>> list6 = VCardResultParser.matchVCardPrefixedField("ADR", string2, true, true);
        List<String> list7 = VCardResultParser.matchSingleVCardPrefixedField("ORG", string2, true, true);
        List<String> list8 = VCardResultParser.matchSingleVCardPrefixedField("BDAY", string2, true, false);
        if (list8 != null && !VCardResultParser.isLikeVCardDate(list8.get(0))) {
            list8 = null;
        }
        List<String> list9 = VCardResultParser.matchSingleVCardPrefixedField("TITLE", string2, true, false);
        List<List<String>> list10 = VCardResultParser.matchVCardPrefixedField("URL", string2, true, false);
        List<String> list11 = VCardResultParser.matchSingleVCardPrefixedField("IMPP", string2, true, false);
        List<String> list12 = VCardResultParser.matchSingleVCardPrefixedField("GEO", string2, true, false);
        String[] stringArray3 = stringArray = list12 == null ? null : SEMICOLON_OR_COMMA.split(list12.get(0));
        if (stringArray != null && stringArray.length != 2) {
            stringArray = null;
        }
        return new AddressBookParsedResult(VCardResultParser.toPrimaryValues(list2), stringArray2, null, VCardResultParser.toPrimaryValues(list3), VCardResultParser.toTypes(list3), VCardResultParser.toPrimaryValues(list4), VCardResultParser.toTypes(list4), VCardResultParser.toPrimaryValue(list11), VCardResultParser.toPrimaryValue(list5), VCardResultParser.toPrimaryValues(list6), VCardResultParser.toTypes(list6), VCardResultParser.toPrimaryValue(list7), VCardResultParser.toPrimaryValue(list8), VCardResultParser.toPrimaryValue(list9), VCardResultParser.toPrimaryValues(list10), stringArray);
    }

    static List<List<String>> matchVCardPrefixedField(CharSequence charSequence, String string2, boolean bl2, boolean bl3) {
        ArrayList arrayList = null;
        int n2 = 0;
        int n3 = string2.length();
        while (n2 < n3) {
            Matcher matcher = Pattern.compile("(?:^|\n)" + charSequence + "(?:;([^:]*))?:", 2).matcher(string2);
            if (n2 > 0) {
                --n2;
            }
            if (!matcher.find(n2)) break;
            n2 = matcher.end(0);
            String string3 = matcher.group(1);
            ArrayList<String> arrayList2 = null;
            boolean bl4 = false;
            String string4 = null;
            if (string3 != null) {
                for (String string5 : SEMICOLON.split(string3)) {
                    if (arrayList2 == null) {
                        arrayList2 = new ArrayList<String>(1);
                    }
                    arrayList2.add(string5);
                    String[] stringArray = EQUALS.split(string5, 2);
                    if (stringArray.length <= 1) continue;
                    String string6 = stringArray[0];
                    String string7 = stringArray[1];
                    if ("ENCODING".equalsIgnoreCase(string6) && "QUOTED-PRINTABLE".equalsIgnoreCase(string7)) {
                        bl4 = true;
                        continue;
                    }
                    if (!"CHARSET".equalsIgnoreCase(string6)) continue;
                    string4 = string7;
                }
            }
            int n4 = n2;
            while ((n2 = string2.indexOf(10, n2)) >= 0) {
                if (n2 < string2.length() - 1 && (string2.charAt(n2 + 1) == ' ' || string2.charAt(n2 + 1) == '\t')) {
                    n2 += 2;
                    continue;
                }
                if (!bl4 || (n2 < 1 || string2.charAt(n2 - 1) != '=') && (n2 < 2 || string2.charAt(n2 - 2) != '=')) break;
                ++n2;
            }
            if (n2 < 0) {
                n2 = n3;
                continue;
            }
            if (n2 > n4) {
                if (arrayList == null) {
                    arrayList = new ArrayList(1);
                }
                if (n2 >= 1 && string2.charAt(n2 - 1) == '\r') {
                    --n2;
                }
                String string8 = string2.substring(n4, n2);
                if (bl2) {
                    string8 = string8.trim();
                }
                if (bl4) {
                    string8 = VCardResultParser.decodeQuotedPrintable(string8, string4);
                    if (bl3) {
                        string8 = UNESCAPED_SEMICOLONS.matcher(string8).replaceAll("\n").trim();
                    }
                } else {
                    if (bl3) {
                        string8 = UNESCAPED_SEMICOLONS.matcher(string8).replaceAll("\n").trim();
                    }
                    string8 = CR_LF_SPACE_TAB.matcher(string8).replaceAll("");
                    string8 = NEWLINE_ESCAPE.matcher(string8).replaceAll("\n");
                    string8 = VCARD_ESCAPES.matcher(string8).replaceAll("$1");
                }
                if (arrayList2 == null) {
                    ArrayList<String> arrayList3 = new ArrayList<String>(1);
                    arrayList3.add(string8);
                    arrayList.add(arrayList3);
                } else {
                    arrayList2.add(0, string8);
                    arrayList.add(arrayList2);
                }
                ++n2;
                continue;
            }
            ++n2;
        }
        return arrayList;
    }

    private static String decodeQuotedPrintable(CharSequence charSequence, String string2) {
        int n2 = charSequence.length();
        StringBuilder stringBuilder = new StringBuilder(n2);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        block4: for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = charSequence.charAt(i2);
            switch (c2) {
                case '\n': 
                case '\r': {
                    continue block4;
                }
                case '=': {
                    char c3;
                    if (i2 >= n2 - 2 || (c3 = charSequence.charAt(i2 + 1)) == '\r' || c3 == '\n') continue block4;
                    char c4 = charSequence.charAt(i2 + 2);
                    int n3 = VCardResultParser.parseHexDigit(c3);
                    int n4 = VCardResultParser.parseHexDigit(c4);
                    if (n3 >= 0 && n4 >= 0) {
                        byteArrayOutputStream.write((n3 << 4) + n4);
                    }
                    i2 += 2;
                    continue block4;
                }
                default: {
                    VCardResultParser.maybeAppendFragment(byteArrayOutputStream, string2, stringBuilder);
                    stringBuilder.append(c2);
                }
            }
        }
        VCardResultParser.maybeAppendFragment(byteArrayOutputStream, string2, stringBuilder);
        return stringBuilder.toString();
    }

    private static void maybeAppendFragment(ByteArrayOutputStream byteArrayOutputStream, String string2, StringBuilder stringBuilder) {
        if (byteArrayOutputStream.size() > 0) {
            String string3;
            byte[] byArray = byteArrayOutputStream.toByteArray();
            if (string2 == null) {
                string3 = new String(byArray, Charset.forName("UTF-8"));
            } else {
                try {
                    string3 = new String(byArray, string2);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    string3 = new String(byArray, Charset.forName("UTF-8"));
                }
            }
            byteArrayOutputStream.reset();
            stringBuilder.append(string3);
        }
    }

    static List<String> matchSingleVCardPrefixedField(CharSequence charSequence, String string2, boolean bl2, boolean bl3) {
        List<List<String>> list = VCardResultParser.matchVCardPrefixedField(charSequence, string2, bl2, bl3);
        return list == null || list.isEmpty() ? null : list.get(0);
    }

    private static String toPrimaryValue(List<String> list) {
        return list == null || list.isEmpty() ? null : list.get(0);
    }

    private static String[] toPrimaryValues(Collection<List<String>> collection) {
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>(collection.size());
        for (List<String> list : collection) {
            String string2 = list.get(0);
            if (string2 == null || string2.isEmpty()) continue;
            arrayList.add(string2);
        }
        return arrayList.toArray(new String[collection.size()]);
    }

    private static String[] toTypes(Collection<List<String>> collection) {
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>(collection.size());
        for (List<String> list : collection) {
            String string2 = null;
            for (int i2 = 1; i2 < list.size(); ++i2) {
                String string3 = list.get(i2);
                int n2 = string3.indexOf(61);
                if (n2 < 0) {
                    string2 = string3;
                    break;
                }
                if (!"TYPE".equalsIgnoreCase(string3.substring(0, n2))) continue;
                string2 = string3.substring(n2 + 1);
                break;
            }
            arrayList.add(string2);
        }
        return arrayList.toArray(new String[collection.size()]);
    }

    private static boolean isLikeVCardDate(CharSequence charSequence) {
        return charSequence == null || VCARD_LIKE_DATE.matcher(charSequence).matches();
    }

    private static void formatNames(Iterable<List<String>> iterable) {
        if (iterable != null) {
            for (List<String> list : iterable) {
                int n2;
                String string2 = list.get(0);
                String[] stringArray = new String[5];
                int n3 = 0;
                for (int i2 = 0; i2 < stringArray.length - 1 && (n2 = string2.indexOf(59, n3)) >= 0; ++i2) {
                    stringArray[i2] = string2.substring(n3, n2);
                    n3 = n2 + 1;
                }
                stringArray[i2] = string2.substring(n3);
                StringBuilder stringBuilder = new StringBuilder(100);
                VCardResultParser.maybeAppendComponent(stringArray, 3, stringBuilder);
                VCardResultParser.maybeAppendComponent(stringArray, 1, stringBuilder);
                VCardResultParser.maybeAppendComponent(stringArray, 2, stringBuilder);
                VCardResultParser.maybeAppendComponent(stringArray, 0, stringBuilder);
                VCardResultParser.maybeAppendComponent(stringArray, 4, stringBuilder);
                list.set(0, stringBuilder.toString().trim());
            }
        }
    }

    private static void maybeAppendComponent(String[] stringArray, int n2, StringBuilder stringBuilder) {
        if (stringArray[n2] != null && !stringArray[n2].isEmpty()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(stringArray[n2]);
        }
    }
}

