/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.result;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.Result;
import com.google.zxing.client.result.ResultParser;
import com.google.zxing.client.result.VINParsedResult;
import java.util.regex.Pattern;

public final class VINResultParser
extends ResultParser {
    private static final Pattern IOQ = Pattern.compile("[IOQ]");
    private static final Pattern AZ09 = Pattern.compile("[A-Z0-9]{17}");

    @Override
    public VINParsedResult parse(Result result) {
        if (result.getBarcodeFormat() != BarcodeFormat.CODE_39) {
            return null;
        }
        String string2 = result.getText();
        if (!AZ09.matcher(string2 = IOQ.matcher(string2).replaceAll("").trim()).matches()) {
            return null;
        }
        try {
            if (!VINResultParser.checkChecksum(string2)) {
                return null;
            }
            String string3 = string2.substring(0, 3);
            return new VINParsedResult(string2, string3, string2.substring(3, 9), string2.substring(9, 17), VINResultParser.countryCode(string3), string2.substring(3, 8), VINResultParser.modelYear(string2.charAt(9)), string2.charAt(10), string2.substring(11));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    private static boolean checkChecksum(CharSequence charSequence) {
        char c2;
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < charSequence.length(); ++n2) {
            n3 += VINResultParser.vinPositionWeight(n2 + 1) * VINResultParser.vinCharValue(charSequence.charAt(n2));
        }
        n2 = charSequence.charAt(8);
        return n2 == (c2 = VINResultParser.checkChar(n3 % 11));
    }

    private static int vinCharValue(char c2) {
        if (c2 >= 'A' && c2 <= 'I') {
            return c2 - 65 + 1;
        }
        if (c2 >= 'J' && c2 <= 'R') {
            return c2 - 74 + 1;
        }
        if (c2 >= 'S' && c2 <= 'Z') {
            return c2 - 83 + 2;
        }
        if (c2 >= '0' && c2 <= '9') {
            return c2 - 48;
        }
        throw new IllegalArgumentException();
    }

    private static int vinPositionWeight(int n2) {
        if (n2 >= 1 && n2 <= 7) {
            return 9 - n2;
        }
        if (n2 == 8) {
            return 10;
        }
        if (n2 == 9) {
            return 0;
        }
        if (n2 >= 10 && n2 <= 17) {
            return 19 - n2;
        }
        throw new IllegalArgumentException();
    }

    private static char checkChar(int n2) {
        if (n2 < 10) {
            return (char)(48 + n2);
        }
        if (n2 == 10) {
            return 'X';
        }
        throw new IllegalArgumentException();
    }

    private static int modelYear(char c2) {
        if (c2 >= 'E' && c2 <= 'H') {
            return c2 - 69 + 1984;
        }
        if (c2 >= 'J' && c2 <= 'N') {
            return c2 - 74 + 1988;
        }
        if (c2 == 'P') {
            return 1993;
        }
        if (c2 >= 'R' && c2 <= 'T') {
            return c2 - 82 + 1994;
        }
        if (c2 >= 'V' && c2 <= 'Y') {
            return c2 - 86 + 1997;
        }
        if (c2 >= '1' && c2 <= '9') {
            return c2 - 49 + 2001;
        }
        if (c2 >= 'A' && c2 <= 'D') {
            return c2 - 65 + 2010;
        }
        throw new IllegalArgumentException();
    }

    private static String countryCode(CharSequence charSequence) {
        char c2 = charSequence.charAt(0);
        char c3 = charSequence.charAt(1);
        switch (c2) {
            case '1': 
            case '4': 
            case '5': {
                return "US";
            }
            case '2': {
                return "CA";
            }
            case '3': {
                if (c3 < 'A' || c3 > 'W') break;
                return "MX";
            }
            case '9': {
                if ((c3 < 'A' || c3 > 'E') && (c3 < '3' || c3 > '9')) break;
                return "BR";
            }
            case 'J': {
                if (c3 < 'A' || c3 > 'T') break;
                return "JP";
            }
            case 'K': {
                if (c3 < 'L' || c3 > 'R') break;
                return "KO";
            }
            case 'L': {
                return "CN";
            }
            case 'M': {
                if (c3 < 'A' || c3 > 'E') break;
                return "IN";
            }
            case 'S': {
                if (c3 >= 'A' && c3 <= 'M') {
                    return "UK";
                }
                if (c3 < 'N' || c3 > 'T') break;
                return "DE";
            }
            case 'V': {
                if (c3 >= 'F' && c3 <= 'R') {
                    return "FR";
                }
                if (c3 < 'S' || c3 > 'W') break;
                return "ES";
            }
            case 'W': {
                return "DE";
            }
            case 'X': {
                if (c3 != '0' && (c3 < '3' || c3 > '9')) break;
                return "RU";
            }
            case 'Z': {
                if (c3 < 'A' || c3 > 'R') break;
                return "IT";
            }
        }
        return null;
    }
}

