/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.common;

import java.util.Arrays;

public final class BitArray
implements Cloneable {
    private int[] bits;
    private int size;

    public BitArray() {
        this.size = 0;
        this.bits = new int[1];
    }

    public BitArray(int n2) {
        this.size = n2;
        this.bits = BitArray.makeArray(n2);
    }

    BitArray(int[] nArray, int n2) {
        this.bits = nArray;
        this.size = n2;
    }

    public int getSize() {
        return this.size;
    }

    public int getSizeInBytes() {
        return (this.size + 7) / 8;
    }

    private void ensureCapacity(int n2) {
        if (n2 > this.bits.length * 32) {
            int[] nArray = BitArray.makeArray(n2);
            System.arraycopy(this.bits, 0, nArray, 0, this.bits.length);
            this.bits = nArray;
        }
    }

    public boolean get(int n2) {
        return (this.bits[n2 / 32] & 1 << (n2 & 0x1F)) != 0;
    }

    public void set(int n2) {
        int n3 = n2 / 32;
        this.bits[n3] = this.bits[n3] | 1 << (n2 & 0x1F);
    }

    public void flip(int n2) {
        int n3 = n2 / 32;
        this.bits[n3] = this.bits[n3] ^ 1 << (n2 & 0x1F);
    }

    public int getNextSet(int n2) {
        if (n2 >= this.size) {
            return this.size;
        }
        int n3 = n2 / 32;
        int n4 = this.bits[n3];
        n4 &= ~((1 << (n2 & 0x1F)) - 1);
        while (n4 == 0) {
            if (++n3 == this.bits.length) {
                return this.size;
            }
            n4 = this.bits[n3];
        }
        int n5 = n3 * 32 + Integer.numberOfTrailingZeros(n4);
        return n5 > this.size ? this.size : n5;
    }

    public int getNextUnset(int n2) {
        if (n2 >= this.size) {
            return this.size;
        }
        int n3 = n2 / 32;
        int n4 = ~this.bits[n3];
        n4 &= ~((1 << (n2 & 0x1F)) - 1);
        while (n4 == 0) {
            if (++n3 == this.bits.length) {
                return this.size;
            }
            n4 = ~this.bits[n3];
        }
        int n5 = n3 * 32 + Integer.numberOfTrailingZeros(n4);
        return n5 > this.size ? this.size : n5;
    }

    public void setBulk(int n2, int n3) {
        this.bits[n2 / 32] = n3;
    }

    public void setRange(int n2, int n3) {
        if (n3 < n2) {
            throw new IllegalArgumentException();
        }
        if (n3 == n2) {
            return;
        }
        int n4 = n2 / 32;
        int n5 = --n3 / 32;
        int n6 = n4;
        while (n6 <= n5) {
            int n7;
            int n8;
            int n9 = n6 > n4 ? 0 : n2 & 0x1F;
            int n10 = n8 = n6 < n5 ? 31 : n3 & 0x1F;
            if (n9 == 0 && n8 == 31) {
                n7 = -1;
            } else {
                n7 = 0;
                for (int i2 = n9; i2 <= n8; ++i2) {
                    n7 |= 1 << i2;
                }
            }
            int n11 = n6++;
            this.bits[n11] = this.bits[n11] | n7;
        }
    }

    public void clear() {
        int n2 = this.bits.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.bits[i2] = 0;
        }
    }

    public boolean isRange(int n2, int n3, boolean bl2) {
        if (n3 < n2) {
            throw new IllegalArgumentException();
        }
        if (n3 == n2) {
            return true;
        }
        int n4 = n2 / 32;
        int n5 = --n3 / 32;
        for (int i2 = n4; i2 <= n5; ++i2) {
            int n6;
            int n7;
            int n8 = i2 > n4 ? 0 : n2 & 0x1F;
            int n9 = n7 = i2 < n5 ? 31 : n3 & 0x1F;
            if (n8 == 0 && n7 == 31) {
                n6 = -1;
            } else {
                n6 = 0;
                for (int i3 = n8; i3 <= n7; ++i3) {
                    n6 |= 1 << i3;
                }
            }
            if ((this.bits[i2] & n6) == (bl2 ? n6 : 0)) continue;
            return false;
        }
        return true;
    }

    public void appendBit(boolean bl2) {
        this.ensureCapacity(this.size + 1);
        if (bl2) {
            int n2 = this.size / 32;
            this.bits[n2] = this.bits[n2] | 1 << (this.size & 0x1F);
        }
        ++this.size;
    }

    public void appendBits(int n2, int n3) {
        if (n3 < 0 || n3 > 32) {
            throw new IllegalArgumentException("Num bits must be between 0 and 32");
        }
        this.ensureCapacity(this.size + n3);
        for (int i2 = n3; i2 > 0; --i2) {
            this.appendBit((n2 >> i2 - 1 & 1) == 1);
        }
    }

    public void appendBitArray(BitArray bitArray) {
        int n2 = bitArray.size;
        this.ensureCapacity(this.size + n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.appendBit(bitArray.get(i2));
        }
    }

    public void xor(BitArray bitArray) {
        if (this.bits.length != bitArray.bits.length) {
            throw new IllegalArgumentException("Sizes don't match");
        }
        for (int i2 = 0; i2 < this.bits.length; ++i2) {
            int n2 = i2;
            this.bits[n2] = this.bits[n2] ^ bitArray.bits[i2];
        }
    }

    public void toBytes(int n2, byte[] byArray, int n3, int n4) {
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = 0;
            for (int i3 = 0; i3 < 8; ++i3) {
                if (this.get(n2)) {
                    n5 |= 1 << 7 - i3;
                }
                ++n2;
            }
            byArray[n3 + i2] = (byte)n5;
        }
    }

    public int[] getBitArray() {
        return this.bits;
    }

    public void reverse() {
        int n2;
        int[] nArray = new int[this.bits.length];
        int n3 = (this.size - 1) / 32;
        int n4 = n3 + 1;
        for (n2 = 0; n2 < n4; ++n2) {
            long l2 = this.bits[n2];
            l2 = l2 >> 1 & 0x55555555L | (l2 & 0x55555555L) << 1;
            l2 = l2 >> 2 & 0x33333333L | (l2 & 0x33333333L) << 2;
            l2 = l2 >> 4 & 0xF0F0F0FL | (l2 & 0xF0F0F0FL) << 4;
            l2 = l2 >> 8 & 0xFF00FFL | (l2 & 0xFF00FFL) << 8;
            l2 = l2 >> 16 & 0xFFFFL | (l2 & 0xFFFFL) << 16;
            nArray[n3 - n2] = (int)l2;
        }
        if (this.size != n4 * 32) {
            int n5;
            n2 = n4 * 32 - this.size;
            int n6 = 1;
            for (n5 = 0; n5 < 31 - n2; ++n5) {
                n6 = n6 << 1 | 1;
            }
            n5 = nArray[0] >> n2 & n6;
            for (int i2 = 1; i2 < n4; ++i2) {
                int n7 = nArray[i2];
                nArray[i2 - 1] = n5 |= n7 << 32 - n2;
                n5 = n7 >> n2 & n6;
            }
            nArray[n4 - 1] = n5;
        }
        this.bits = nArray;
    }

    private static int[] makeArray(int n2) {
        return new int[(n2 + 31) / 32];
    }

    public boolean equals(Object object) {
        if (!(object instanceof BitArray)) {
            return false;
        }
        BitArray bitArray = (BitArray)object;
        return this.size == bitArray.size && Arrays.equals(this.bits, bitArray.bits);
    }

    public int hashCode() {
        return 31 * this.size + Arrays.hashCode(this.bits);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.size);
        for (int i2 = 0; i2 < this.size; ++i2) {
            if ((i2 & 7) == 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(this.get(i2) ? (char)'X' : '.');
        }
        return stringBuilder.toString();
    }

    public BitArray clone() {
        return new BitArray((int[])this.bits.clone(), this.size);
    }
}

