/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.common;

import com.google.zxing.common.BitArray;
import java.util.Arrays;

public final class BitMatrix
implements Cloneable {
    private final int width;
    private final int height;
    private final int rowSize;
    private final int[] bits;

    public BitMatrix(int n2) {
        this(n2, n2);
    }

    public BitMatrix(int n2, int n3) {
        if (n2 < 1 || n3 < 1) {
            throw new IllegalArgumentException("Both dimensions must be greater than 0");
        }
        this.width = n2;
        this.height = n3;
        this.rowSize = (n2 + 31) / 32;
        this.bits = new int[this.rowSize * n3];
    }

    private BitMatrix(int n2, int n3, int n4, int[] nArray) {
        this.width = n2;
        this.height = n3;
        this.rowSize = n4;
        this.bits = nArray;
    }

    public boolean get(int n2, int n3) {
        int n4 = n3 * this.rowSize + n2 / 32;
        return (this.bits[n4] >>> (n2 & 0x1F) & 1) != 0;
    }

    public void set(int n2, int n3) {
        int n4;
        int n5 = n4 = n3 * this.rowSize + n2 / 32;
        this.bits[n5] = this.bits[n5] | 1 << (n2 & 0x1F);
    }

    public void flip(int n2, int n3) {
        int n4;
        int n5 = n4 = n3 * this.rowSize + n2 / 32;
        this.bits[n5] = this.bits[n5] ^ 1 << (n2 & 0x1F);
    }

    public void clear() {
        int n2 = this.bits.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.bits[i2] = 0;
        }
    }

    public void setRegion(int n2, int n3, int n4, int n5) {
        if (n3 < 0 || n2 < 0) {
            throw new IllegalArgumentException("Left and top must be nonnegative");
        }
        if (n5 < 1 || n4 < 1) {
            throw new IllegalArgumentException("Height and width must be at least 1");
        }
        int n6 = n2 + n4;
        int n7 = n3 + n5;
        if (n7 > this.height || n6 > this.width) {
            throw new IllegalArgumentException("The region must fit inside the matrix");
        }
        for (int i2 = n3; i2 < n7; ++i2) {
            int n8 = i2 * this.rowSize;
            for (int i3 = n2; i3 < n6; ++i3) {
                int n9 = n8 + i3 / 32;
                this.bits[n9] = this.bits[n9] | 1 << (i3 & 0x1F);
            }
        }
    }

    public BitArray getRow(int n2, BitArray bitArray) {
        if (bitArray == null || bitArray.getSize() < this.width) {
            bitArray = new BitArray(this.width);
        } else {
            bitArray.clear();
        }
        int n3 = n2 * this.rowSize;
        for (int i2 = 0; i2 < this.rowSize; ++i2) {
            bitArray.setBulk(i2 * 32, this.bits[n3 + i2]);
        }
        return bitArray;
    }

    public void setRow(int n2, BitArray bitArray) {
        System.arraycopy(bitArray.getBitArray(), 0, this.bits, n2 * this.rowSize, this.rowSize);
    }

    public void rotate180() {
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        BitArray bitArray = new BitArray(n2);
        BitArray bitArray2 = new BitArray(n2);
        for (int i2 = 0; i2 < (n3 + 1) / 2; ++i2) {
            bitArray = this.getRow(i2, bitArray);
            bitArray2 = this.getRow(n3 - 1 - i2, bitArray2);
            bitArray.reverse();
            bitArray2.reverse();
            this.setRow(i2, bitArray2);
            this.setRow(n3 - 1 - i2, bitArray);
        }
    }

    public int[] getEnclosingRectangle() {
        int n2;
        int n3;
        int n4 = this.width;
        int n5 = this.height;
        int n6 = -1;
        int n7 = -1;
        for (n3 = 0; n3 < this.height; ++n3) {
            for (n2 = 0; n2 < this.rowSize; ++n2) {
                int n8;
                int n9 = this.bits[n3 * this.rowSize + n2];
                if (n9 == 0) continue;
                if (n3 < n5) {
                    n5 = n3;
                }
                if (n3 > n7) {
                    n7 = n3;
                }
                if (n2 * 32 < n4) {
                    n8 = 0;
                    while (n9 << 31 - n8 == 0) {
                        ++n8;
                    }
                    if (n2 * 32 + n8 < n4) {
                        n4 = n2 * 32 + n8;
                    }
                }
                if (n2 * 32 + 31 <= n6) continue;
                n8 = 31;
                while (n9 >>> n8 == 0) {
                    --n8;
                }
                if (n2 * 32 + n8 <= n6) continue;
                n6 = n2 * 32 + n8;
            }
        }
        n3 = n6 - n4;
        n2 = n7 - n5;
        if (n3 < 0 || n2 < 0) {
            return null;
        }
        return new int[]{n4, n5, n3, n2};
    }

    public int[] getTopLeftOnBit() {
        int n2;
        for (n2 = 0; n2 < this.bits.length && this.bits[n2] == 0; ++n2) {
        }
        if (n2 == this.bits.length) {
            return null;
        }
        int n3 = n2 / this.rowSize;
        int n4 = n2 % this.rowSize * 32;
        int n5 = this.bits[n2];
        int n6 = 0;
        while (n5 << 31 - n6 == 0) {
            ++n6;
        }
        return new int[]{n4 += n6, n3};
    }

    public int[] getBottomRightOnBit() {
        int n2;
        for (n2 = this.bits.length - 1; n2 >= 0 && this.bits[n2] == 0; --n2) {
        }
        if (n2 < 0) {
            return null;
        }
        int n3 = n2 / this.rowSize;
        int n4 = n2 % this.rowSize * 32;
        int n5 = this.bits[n2];
        int n6 = 31;
        while (n5 >>> n6 == 0) {
            --n6;
        }
        return new int[]{n4 += n6, n3};
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean equals(Object object) {
        if (!(object instanceof BitMatrix)) {
            return false;
        }
        BitMatrix bitMatrix = (BitMatrix)object;
        return this.width == bitMatrix.width && this.height == bitMatrix.height && this.rowSize == bitMatrix.rowSize && Arrays.equals(this.bits, bitMatrix.bits);
    }

    public int hashCode() {
        int n2 = this.width;
        n2 = 31 * n2 + this.width;
        n2 = 31 * n2 + this.height;
        n2 = 31 * n2 + this.rowSize;
        n2 = 31 * n2 + Arrays.hashCode(this.bits);
        return n2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.height * (this.width + 1));
        for (int i2 = 0; i2 < this.height; ++i2) {
            for (int i3 = 0; i3 < this.width; ++i3) {
                stringBuilder.append(this.get(i3, i2) ? "X " : "  ");
            }
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    public BitMatrix clone() {
        return new BitMatrix(this.width, this.height, this.rowSize, (int[])this.bits.clone());
    }
}

