/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.common;

public final class BitSource {
    private final byte[] bytes;
    private int byteOffset;
    private int bitOffset;

    public BitSource(byte[] byArray) {
        this.bytes = byArray;
    }

    public int getBitOffset() {
        return this.bitOffset;
    }

    public int getByteOffset() {
        return this.byteOffset;
    }

    public int readBits(int n2) {
        int n3;
        int n4;
        if (n2 < 1 || n2 > 32 || n2 > this.available()) {
            throw new IllegalArgumentException(String.valueOf(n2));
        }
        int n5 = 0;
        if (this.bitOffset > 0) {
            n4 = 8 - this.bitOffset;
            n3 = n2 < n4 ? n2 : n4;
            int n6 = n4 - n3;
            int n7 = 255 >> 8 - n3 << n6;
            n5 = (this.bytes[this.byteOffset] & n7) >> n6;
            n2 -= n3;
            this.bitOffset += n3;
            if (this.bitOffset == 8) {
                this.bitOffset = 0;
                ++this.byteOffset;
            }
        }
        if (n2 > 0) {
            while (n2 >= 8) {
                n5 = n5 << 8 | this.bytes[this.byteOffset] & 0xFF;
                ++this.byteOffset;
                n2 -= 8;
            }
            if (n2 > 0) {
                n4 = 8 - n2;
                n3 = 255 >> n4 << n4;
                n5 = n5 << n2 | (this.bytes[this.byteOffset] & n3) >> n4;
                this.bitOffset += n2;
            }
        }
        return n5;
    }

    public int available() {
        return 8 * (this.bytes.length - this.byteOffset) - this.bitOffset;
    }
}

