/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.common;

import com.google.zxing.Binarizer;
import com.google.zxing.LuminanceSource;
import com.google.zxing.NotFoundException;
import com.google.zxing.common.BitArray;
import com.google.zxing.common.BitMatrix;

public class GlobalHistogramBinarizer
extends Binarizer {
    private static final int LUMINANCE_BITS = 5;
    private static final int LUMINANCE_SHIFT = 3;
    private static final int LUMINANCE_BUCKETS = 32;
    private static final byte[] EMPTY = new byte[0];
    private byte[] luminances = EMPTY;
    private final int[] buckets = new int[32];

    public GlobalHistogramBinarizer(LuminanceSource luminanceSource) {
        super(luminanceSource);
    }

    @Override
    public BitArray getBlackRow(int n2, BitArray bitArray) throws NotFoundException {
        int n3;
        int n4;
        LuminanceSource luminanceSource = this.getLuminanceSource();
        int n5 = luminanceSource.getWidth();
        if (bitArray == null || bitArray.getSize() < n5) {
            bitArray = new BitArray(n5);
        } else {
            bitArray.clear();
        }
        this.initArrays(n5);
        byte[] byArray = luminanceSource.getRow(n2, this.luminances);
        int[] nArray = this.buckets;
        for (n4 = 0; n4 < n5; ++n4) {
            n3 = byArray[n4] & 0xFF;
            int n6 = n3 >> 3;
            nArray[n6] = nArray[n6] + 1;
        }
        n4 = GlobalHistogramBinarizer.estimateBlackPoint(nArray);
        n3 = byArray[0] & 0xFF;
        int n7 = byArray[1] & 0xFF;
        for (int i2 = 1; i2 < n5 - 1; ++i2) {
            int n8 = byArray[i2 + 1] & 0xFF;
            int n9 = (n7 * 4 - n3 - n8) / 2;
            if (n9 < n4) {
                bitArray.set(i2);
            }
            n3 = n7;
            n7 = n8;
        }
        return bitArray;
    }

    @Override
    public BitMatrix getBlackMatrix() throws NotFoundException {
        int n2;
        int n3;
        int n4;
        int n5;
        LuminanceSource luminanceSource = this.getLuminanceSource();
        int n6 = luminanceSource.getWidth();
        int n7 = luminanceSource.getHeight();
        BitMatrix bitMatrix = new BitMatrix(n6, n7);
        this.initArrays(n6);
        int[] nArray = this.buckets;
        for (n5 = 1; n5 < 5; ++n5) {
            int n8 = n7 * n5 / 5;
            byte[] byArray = luminanceSource.getRow(n8, this.luminances);
            n4 = n6 * 4 / 5;
            for (n3 = n6 / 5; n3 < n4; ++n3) {
                n2 = byArray[n3] & 0xFF;
                int n9 = n2 >> 3;
                nArray[n9] = nArray[n9] + 1;
            }
        }
        n5 = GlobalHistogramBinarizer.estimateBlackPoint(nArray);
        byte[] byArray = luminanceSource.getMatrix();
        for (int i2 = 0; i2 < n7; ++i2) {
            n4 = i2 * n6;
            for (n3 = 0; n3 < n6; ++n3) {
                n2 = byArray[n4 + n3] & 0xFF;
                if (n2 >= n5) continue;
                bitMatrix.set(n3, i2);
            }
        }
        return bitMatrix;
    }

    @Override
    public Binarizer createBinarizer(LuminanceSource luminanceSource) {
        return new GlobalHistogramBinarizer(luminanceSource);
    }

    private void initArrays(int n2) {
        if (this.luminances.length < n2) {
            this.luminances = new byte[n2];
        }
        for (int i2 = 0; i2 < 32; ++i2) {
            this.buckets[i2] = 0;
        }
    }

    private static int estimateBlackPoint(int[] nArray) throws NotFoundException {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = nArray.length;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        for (n5 = 0; n5 < n6; ++n5) {
            if (nArray[n5] > n9) {
                n8 = n5;
                n9 = nArray[n5];
            }
            if (nArray[n5] <= n7) continue;
            n7 = nArray[n5];
        }
        n5 = 0;
        int n10 = 0;
        for (n4 = 0; n4 < n6; ++n4) {
            n3 = n4 - n8;
            n2 = nArray[n4] * n3 * n3;
            if (n2 <= n10) continue;
            n5 = n4;
            n10 = n2;
        }
        if (n8 > n5) {
            n4 = n8;
            n8 = n5;
            n5 = n4;
        }
        if (n5 - n8 <= n6 / 16) {
            throw NotFoundException.getNotFoundInstance();
        }
        n4 = n5 - 1;
        n3 = -1;
        for (n2 = n5 - 1; n2 > n8; --n2) {
            int n11 = n2 - n8;
            int n12 = n11 * n11 * (n5 - n2) * (n7 - nArray[n2]);
            if (n12 <= n3) continue;
            n4 = n2;
            n3 = n12;
        }
        return n4 << 3;
    }
}

