/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.common;

import com.google.zxing.Binarizer;
import com.google.zxing.LuminanceSource;
import com.google.zxing.NotFoundException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.GlobalHistogramBinarizer;

public final class HybridBinarizer
extends GlobalHistogramBinarizer {
    private static final int BLOCK_SIZE_POWER = 3;
    private static final int BLOCK_SIZE = 8;
    private static final int BLOCK_SIZE_MASK = 7;
    private static final int MINIMUM_DIMENSION = 40;
    private static final int MIN_DYNAMIC_RANGE = 24;
    private BitMatrix matrix;

    public HybridBinarizer(LuminanceSource luminanceSource) {
        super(luminanceSource);
    }

    @Override
    public BitMatrix getBlackMatrix() throws NotFoundException {
        if (this.matrix != null) {
            return this.matrix;
        }
        LuminanceSource luminanceSource = this.getLuminanceSource();
        int n2 = luminanceSource.getWidth();
        int n3 = luminanceSource.getHeight();
        if (n2 >= 40 && n3 >= 40) {
            byte[] byArray = luminanceSource.getMatrix();
            int n4 = n2 >> 3;
            if ((n2 & 7) != 0) {
                ++n4;
            }
            int n5 = n3 >> 3;
            if ((n3 & 7) != 0) {
                ++n5;
            }
            int[][] nArray = HybridBinarizer.calculateBlackPoints(byArray, n4, n5, n2, n3);
            BitMatrix bitMatrix = new BitMatrix(n2, n3);
            HybridBinarizer.calculateThresholdForBlock(byArray, n4, n5, n2, n3, nArray, bitMatrix);
            this.matrix = bitMatrix;
        } else {
            this.matrix = super.getBlackMatrix();
        }
        return this.matrix;
    }

    @Override
    public Binarizer createBinarizer(LuminanceSource luminanceSource) {
        return new HybridBinarizer(luminanceSource);
    }

    private static void calculateThresholdForBlock(byte[] byArray, int n2, int n3, int n4, int n5, int[][] nArray, BitMatrix bitMatrix) {
        for (int i2 = 0; i2 < n3; ++i2) {
            int n6 = i2 << 3;
            int n7 = n5 - 8;
            if (n6 > n7) {
                n6 = n7;
            }
            for (int i3 = 0; i3 < n2; ++i3) {
                int n8;
                int n9 = i3 << 3;
                int n10 = n4 - 8;
                if (n9 > n10) {
                    n9 = n10;
                }
                int n11 = HybridBinarizer.cap(i3, 2, n2 - 3);
                int n12 = HybridBinarizer.cap(i2, 2, n3 - 3);
                int n13 = 0;
                for (n8 = -2; n8 <= 2; ++n8) {
                    int[] nArray2 = nArray[n12 + n8];
                    n13 += nArray2[n11 - 2] + nArray2[n11 - 1] + nArray2[n11] + nArray2[n11 + 1] + nArray2[n11 + 2];
                }
                n8 = n13 / 25;
                HybridBinarizer.thresholdBlock(byArray, n9, n6, n8, n4, bitMatrix);
            }
        }
    }

    private static int cap(int n2, int n3, int n4) {
        return n2 < n3 ? n3 : (n2 > n4 ? n4 : n2);
    }

    private static void thresholdBlock(byte[] byArray, int n2, int n3, int n4, int n5, BitMatrix bitMatrix) {
        int n6 = 0;
        int n7 = n3 * n5 + n2;
        while (n6 < 8) {
            for (int i2 = 0; i2 < 8; ++i2) {
                if ((byArray[n7 + i2] & 0xFF) > n4) continue;
                bitMatrix.set(n2 + i2, n3 + n6);
            }
            ++n6;
            n7 += n5;
        }
    }

    private static int[][] calculateBlackPoints(byte[] byArray, int n2, int n3, int n4, int n5) {
        int[][] nArray = new int[n3][n2];
        for (int i2 = 0; i2 < n3; ++i2) {
            int n6 = i2 << 3;
            int n7 = n5 - 8;
            if (n6 > n7) {
                n6 = n7;
            }
            for (int i3 = 0; i3 < n2; ++i3) {
                int n8 = i3 << 3;
                int n9 = n4 - 8;
                if (n8 > n9) {
                    n8 = n9;
                }
                int n10 = 0;
                int n11 = 255;
                int n12 = 0;
                int n13 = 0;
                int n14 = n6 * n4 + n8;
                while (n13 < 8) {
                    int n15;
                    for (n15 = 0; n15 < 8; ++n15) {
                        int n16 = byArray[n14 + n15] & 0xFF;
                        n10 += n16;
                        if (n16 < n11) {
                            n11 = n16;
                        }
                        if (n16 <= n12) continue;
                        n12 = n16;
                    }
                    if (n12 - n11 > 24) {
                        ++n13;
                        n14 += n4;
                        while (n13 < 8) {
                            for (n15 = 0; n15 < 8; ++n15) {
                                n10 += byArray[n14 + n15] & 0xFF;
                            }
                            ++n13;
                            n14 += n4;
                        }
                    }
                    ++n13;
                    n14 += n4;
                }
                n13 = n10 >> 6;
                if (n12 - n11 <= 24) {
                    n13 = n11 / 2;
                    if (i2 > 0 && i3 > 0 && n11 < (n14 = (nArray[i2 - 1][i3] + 2 * nArray[i2][i3 - 1] + nArray[i2 - 1][i3 - 1]) / 4)) {
                        n13 = n14;
                    }
                }
                nArray[i2][i3] = n13;
            }
        }
        return nArray;
    }
}

