/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.common;

import com.google.zxing.DecodeHintType;
import java.nio.charset.Charset;
import java.util.Map;

public final class StringUtils {
    private static final String PLATFORM_DEFAULT_ENCODING = Charset.defaultCharset().name();
    public static final String SHIFT_JIS = "SJIS";
    public static final String GB2312 = "GB2312";
    private static final String EUC_JP = "EUC_JP";
    private static final String UTF8 = "UTF8";
    private static final String ISO88591 = "ISO8859_1";
    private static final boolean ASSUME_SHIFT_JIS = "SJIS".equalsIgnoreCase(PLATFORM_DEFAULT_ENCODING) || "EUC_JP".equalsIgnoreCase(PLATFORM_DEFAULT_ENCODING);

    private StringUtils() {
    }

    public static String guessEncoding(byte[] byArray, Map<DecodeHintType, ?> map) {
        String string2;
        if (map != null && (string2 = (String)map.get((Object)DecodeHintType.CHARACTER_SET)) != null) {
            return string2;
        }
        int n2 = byArray.length;
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = true;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        boolean bl5 = byArray.length > 3 && byArray[0] == -17 && byArray[1] == -69 && byArray[2] == -65;
        for (int i2 = 0; i2 < n2 && (bl2 || bl3 || bl4); ++i2) {
            int n14 = byArray[i2] & 0xFF;
            if (bl4) {
                if (n3 > 0) {
                    if ((n14 & 0x80) == 0) {
                        bl4 = false;
                    } else {
                        --n3;
                    }
                } else if ((n14 & 0x80) != 0) {
                    if ((n14 & 0x40) == 0) {
                        bl4 = false;
                    } else {
                        ++n3;
                        if ((n14 & 0x20) == 0) {
                            ++n4;
                        } else {
                            ++n3;
                            if ((n14 & 0x10) == 0) {
                                ++n5;
                            } else {
                                ++n3;
                                if ((n14 & 8) == 0) {
                                    ++n6;
                                } else {
                                    bl4 = false;
                                }
                            }
                        }
                    }
                }
            }
            if (bl2) {
                if (n14 > 127 && n14 < 160) {
                    bl2 = false;
                } else if (n14 > 159 && (n14 < 192 || n14 == 215 || n14 == 247)) {
                    ++n13;
                }
            }
            if (!bl3) continue;
            if (n7 > 0) {
                if (n14 < 64 || n14 == 127 || n14 > 252) {
                    bl3 = false;
                    continue;
                }
                --n7;
                continue;
            }
            if (n14 == 128 || n14 == 160 || n14 > 239) {
                bl3 = false;
                continue;
            }
            if (n14 > 160 && n14 < 224) {
                ++n8;
                n10 = 0;
                if (++n9 <= n11) continue;
                n11 = n9;
                continue;
            }
            if (n14 > 127) {
                ++n7;
                n9 = 0;
                if (++n10 <= n12) continue;
                n12 = n10;
                continue;
            }
            n9 = 0;
            n10 = 0;
        }
        if (bl4 && n3 > 0) {
            bl4 = false;
        }
        if (bl3 && n7 > 0) {
            bl3 = false;
        }
        if (bl4 && (bl5 || n4 + n5 + n6 > 0)) {
            return UTF8;
        }
        if (bl3 && (ASSUME_SHIFT_JIS || n11 >= 3 || n12 >= 3)) {
            return SHIFT_JIS;
        }
        if (bl2 && bl3) {
            return n11 == 2 && n8 == 2 || n13 * 10 >= n2 ? SHIFT_JIS : ISO88591;
        }
        if (bl2) {
            return ISO88591;
        }
        if (bl3) {
            return SHIFT_JIS;
        }
        if (bl4) {
            return UTF8;
        }
        return PLATFORM_DEFAULT_ENCODING;
    }
}

