/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.common.detector;

import com.google.zxing.NotFoundException;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitMatrix;

public final class MonochromeRectangleDetector {
    private static final int MAX_MODULES = 32;
    private final BitMatrix image;

    public MonochromeRectangleDetector(BitMatrix bitMatrix) {
        this.image = bitMatrix;
    }

    public ResultPoint[] detect() throws NotFoundException {
        int n2 = this.image.getHeight();
        int n3 = this.image.getWidth();
        int n4 = n2 / 2;
        int n5 = n3 / 2;
        int n6 = Math.max(1, n2 / 256);
        int n7 = Math.max(1, n3 / 256);
        int n8 = 0;
        int n9 = n2;
        int n10 = 0;
        int n11 = n3;
        ResultPoint resultPoint = this.findCornerFromCenter(n5, 0, n10, n11, n4, -n6, n8, n9, n5 / 2);
        n8 = (int)resultPoint.getY() - 1;
        ResultPoint resultPoint2 = this.findCornerFromCenter(n5, -n7, n10, n11, n4, 0, n8, n9, n4 / 2);
        n10 = (int)resultPoint2.getX() - 1;
        ResultPoint resultPoint3 = this.findCornerFromCenter(n5, n7, n10, n11, n4, 0, n8, n9, n4 / 2);
        n11 = (int)resultPoint3.getX() + 1;
        ResultPoint resultPoint4 = this.findCornerFromCenter(n5, 0, n10, n11, n4, n6, n8, n9, n5 / 2);
        n9 = (int)resultPoint4.getY() + 1;
        resultPoint = this.findCornerFromCenter(n5, 0, n10, n11, n4, -n6, n8, n9, n5 / 4);
        return new ResultPoint[]{resultPoint, resultPoint2, resultPoint3, resultPoint4};
    }

    private ResultPoint findCornerFromCenter(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) throws NotFoundException {
        int[] nArray = null;
        int n11 = n6;
        for (int i2 = n2; n11 < n9 && n11 >= n8 && i2 < n5 && i2 >= n4; n11 += n7, i2 += n3) {
            int[] nArray2 = n3 == 0 ? this.blackWhiteRange(n11, n10, n4, n5, true) : this.blackWhiteRange(i2, n10, n8, n9, false);
            if (nArray2 == null) {
                if (nArray == null) {
                    throw NotFoundException.getNotFoundInstance();
                }
                if (n3 == 0) {
                    int n12 = n11 - n7;
                    if (nArray[0] < n2) {
                        if (nArray[1] > n2) {
                            return new ResultPoint(n7 > 0 ? (float)nArray[0] : (float)nArray[1], n12);
                        }
                        return new ResultPoint(nArray[0], n12);
                    }
                    return new ResultPoint(nArray[1], n12);
                }
                int n13 = i2 - n3;
                if (nArray[0] < n6) {
                    if (nArray[1] > n6) {
                        return new ResultPoint(n13, n3 < 0 ? (float)nArray[0] : (float)nArray[1]);
                    }
                    return new ResultPoint(n13, nArray[0]);
                }
                return new ResultPoint(n13, nArray[1]);
            }
            nArray = nArray2;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private int[] blackWhiteRange(int n2, int n3, int n4, int n5, boolean bl2) {
        int[] nArray;
        int n6;
        int n7;
        int n8;
        int n9 = n8 = (n4 + n5) / 2;
        while (n9 >= n4) {
            if (bl2 ? this.image.get(n9, n2) : this.image.get(n2, n9)) {
                --n9;
                continue;
            }
            n7 = n9;
            while (--n9 >= n4 && !(bl2 ? this.image.get(n9, n2) : this.image.get(n2, n9))) {
            }
            n6 = n7 - n9;
            if (n9 >= n4 && n6 <= n3) continue;
            n9 = n7;
            break;
        }
        ++n9;
        n7 = n8;
        while (n7 < n5) {
            if (bl2 ? this.image.get(n7, n2) : this.image.get(n2, n7)) {
                ++n7;
                continue;
            }
            n6 = n7;
            while (++n7 < n5 && !(bl2 ? this.image.get(n7, n2) : this.image.get(n2, n7))) {
            }
            int n10 = n7 - n6;
            if (n7 < n5 && n10 <= n3) continue;
            n7 = n6;
            break;
        }
        if (--n7 > n9) {
            int[] nArray2 = new int[2];
            nArray2[0] = n9;
            nArray = nArray2;
            nArray2[1] = n7;
        } else {
            nArray = null;
        }
        return nArray;
    }
}

