/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.common.detector;

import com.google.zxing.NotFoundException;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.detector.MathUtils;

public final class WhiteRectangleDetector {
    private static final int INIT_SIZE = 10;
    private static final int CORR = 1;
    private final BitMatrix image;
    private final int height;
    private final int width;
    private final int leftInit;
    private final int rightInit;
    private final int downInit;
    private final int upInit;

    public WhiteRectangleDetector(BitMatrix bitMatrix) throws NotFoundException {
        this(bitMatrix, 10, bitMatrix.getWidth() / 2, bitMatrix.getHeight() / 2);
    }

    public WhiteRectangleDetector(BitMatrix bitMatrix, int n2, int n3, int n4) throws NotFoundException {
        this.image = bitMatrix;
        this.height = bitMatrix.getHeight();
        this.width = bitMatrix.getWidth();
        int n5 = n2 / 2;
        this.leftInit = n3 - n5;
        this.rightInit = n3 + n5;
        this.upInit = n4 - n5;
        this.downInit = n4 + n5;
        if (this.upInit < 0 || this.leftInit < 0 || this.downInit >= this.height || this.rightInit >= this.width) {
            throw NotFoundException.getNotFoundInstance();
        }
    }

    public ResultPoint[] detect() throws NotFoundException {
        int n2;
        int n3;
        int n4;
        int n5 = this.leftInit;
        int n6 = this.rightInit;
        int n7 = this.upInit;
        int n8 = this.downInit;
        boolean bl2 = false;
        boolean bl3 = true;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        while (bl3) {
            bl3 = false;
            n4 = 1;
            while (!(n4 == 0 && bl5 || n6 >= this.width)) {
                n4 = this.containsBlackPoint(n7, n8, n6, false) ? 1 : 0;
                if (n4 != 0) {
                    ++n6;
                    bl3 = true;
                    bl5 = true;
                    continue;
                }
                if (bl5) continue;
                ++n6;
            }
            if (n6 >= this.width) {
                bl2 = true;
                break;
            }
            boolean bl9 = true;
            while ((bl9 || !bl6) && n8 < this.height) {
                bl9 = this.containsBlackPoint(n5, n6, n8, true);
                if (bl9) {
                    ++n8;
                    bl3 = true;
                    bl6 = true;
                    continue;
                }
                if (bl6) continue;
                ++n8;
            }
            if (n8 >= this.height) {
                bl2 = true;
                break;
            }
            n3 = 1;
            while (!(n3 == 0 && bl7 || n5 < 0)) {
                n3 = this.containsBlackPoint(n7, n8, n5, false) ? 1 : 0;
                if (n3 != 0) {
                    --n5;
                    bl3 = true;
                    bl7 = true;
                    continue;
                }
                if (bl7) continue;
                --n5;
            }
            if (n5 < 0) {
                bl2 = true;
                break;
            }
            n2 = 1;
            while (!(n2 == 0 && bl8 || n7 < 0)) {
                n2 = this.containsBlackPoint(n5, n6, n7, true) ? 1 : 0;
                if (n2 != 0) {
                    --n7;
                    bl3 = true;
                    bl8 = true;
                    continue;
                }
                if (bl8) continue;
                --n7;
            }
            if (n7 < 0) {
                bl2 = true;
                break;
            }
            if (!bl3) continue;
            bl4 = true;
        }
        if (!bl2 && bl4) {
            n4 = n6 - n5;
            ResultPoint resultPoint = null;
            for (n3 = 1; n3 < n4 && (resultPoint = this.getBlackPointOnSegment(n5, n8 - n3, n5 + n3, n8)) == null; ++n3) {
            }
            if (resultPoint == null) {
                throw NotFoundException.getNotFoundInstance();
            }
            ResultPoint resultPoint2 = null;
            for (n2 = 1; n2 < n4 && (resultPoint2 = this.getBlackPointOnSegment(n5, n7 + n2, n5 + n2, n7)) == null; ++n2) {
            }
            if (resultPoint2 == null) {
                throw NotFoundException.getNotFoundInstance();
            }
            ResultPoint resultPoint3 = null;
            for (int i2 = 1; i2 < n4 && (resultPoint3 = this.getBlackPointOnSegment(n6, n7 + i2, n6 - i2, n7)) == null; ++i2) {
            }
            if (resultPoint3 == null) {
                throw NotFoundException.getNotFoundInstance();
            }
            ResultPoint resultPoint4 = null;
            for (int i3 = 1; i3 < n4 && (resultPoint4 = this.getBlackPointOnSegment(n6, n8 - i3, n6 - i3, n8)) == null; ++i3) {
            }
            if (resultPoint4 == null) {
                throw NotFoundException.getNotFoundInstance();
            }
            return this.centerEdges(resultPoint4, resultPoint, resultPoint3, resultPoint2);
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private ResultPoint getBlackPointOnSegment(float f2, float f3, float f4, float f5) {
        int n2 = MathUtils.round(MathUtils.distance(f2, f3, f4, f5));
        float f6 = (f4 - f2) / (float)n2;
        float f7 = (f5 - f3) / (float)n2;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3;
            int n4 = MathUtils.round(f2 + (float)i2 * f6);
            if (!this.image.get(n4, n3 = MathUtils.round(f3 + (float)i2 * f7))) continue;
            return new ResultPoint(n4, n3);
        }
        return null;
    }

    private ResultPoint[] centerEdges(ResultPoint resultPoint, ResultPoint resultPoint2, ResultPoint resultPoint3, ResultPoint resultPoint4) {
        float f2 = resultPoint.getX();
        float f3 = resultPoint.getY();
        float f4 = resultPoint2.getX();
        float f5 = resultPoint2.getY();
        float f6 = resultPoint3.getX();
        float f7 = resultPoint3.getY();
        float f8 = resultPoint4.getX();
        float f9 = resultPoint4.getY();
        if (f2 < (float)this.width / 2.0f) {
            return new ResultPoint[]{new ResultPoint(f8 - 1.0f, f9 + 1.0f), new ResultPoint(f4 + 1.0f, f5 + 1.0f), new ResultPoint(f6 - 1.0f, f7 - 1.0f), new ResultPoint(f2 + 1.0f, f3 - 1.0f)};
        }
        return new ResultPoint[]{new ResultPoint(f8 + 1.0f, f9 + 1.0f), new ResultPoint(f4 + 1.0f, f5 - 1.0f), new ResultPoint(f6 - 1.0f, f7 + 1.0f), new ResultPoint(f2 - 1.0f, f3 - 1.0f)};
    }

    private boolean containsBlackPoint(int n2, int n3, int n4, boolean bl2) {
        if (bl2) {
            for (int i2 = n2; i2 <= n3; ++i2) {
                if (!this.image.get(i2, n4)) continue;
                return true;
            }
        } else {
            for (int i3 = n2; i3 <= n3; ++i3) {
                if (!this.image.get(n4, i3)) continue;
                return true;
            }
        }
        return false;
    }
}

