/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.common.reedsolomon;

import com.google.zxing.common.reedsolomon.GenericGF;

final class GenericGFPoly {
    private final GenericGF field;
    private final int[] coefficients;

    GenericGFPoly(GenericGF genericGF, int[] nArray) {
        if (nArray.length == 0) {
            throw new IllegalArgumentException();
        }
        this.field = genericGF;
        int n2 = nArray.length;
        if (n2 > 1 && nArray[0] == 0) {
            int n3;
            for (n3 = 1; n3 < n2 && nArray[n3] == 0; ++n3) {
            }
            if (n3 == n2) {
                this.coefficients = new int[]{0};
            } else {
                this.coefficients = new int[n2 - n3];
                System.arraycopy(nArray, n3, this.coefficients, 0, this.coefficients.length);
            }
        } else {
            this.coefficients = nArray;
        }
    }

    int[] getCoefficients() {
        return this.coefficients;
    }

    int getDegree() {
        return this.coefficients.length - 1;
    }

    boolean isZero() {
        return this.coefficients[0] == 0;
    }

    int getCoefficient(int n2) {
        return this.coefficients[this.coefficients.length - 1 - n2];
    }

    int evaluateAt(int n2) {
        if (n2 == 0) {
            return this.getCoefficient(0);
        }
        int n3 = this.coefficients.length;
        if (n2 == 1) {
            int n4 = 0;
            for (int n5 : this.coefficients) {
                n4 = GenericGF.addOrSubtract(n4, n5);
            }
            return n4;
        }
        int n6 = this.coefficients[0];
        for (int i2 = 1; i2 < n3; ++i2) {
            n6 = GenericGF.addOrSubtract(this.field.multiply(n2, n6), this.coefficients[i2]);
        }
        return n6;
    }

    GenericGFPoly addOrSubtract(GenericGFPoly genericGFPoly) {
        int[] nArray;
        if (!this.field.equals(genericGFPoly.field)) {
            throw new IllegalArgumentException("GenericGFPolys do not have same GenericGF field");
        }
        if (this.isZero()) {
            return genericGFPoly;
        }
        if (genericGFPoly.isZero()) {
            return this;
        }
        int[] nArray2 = this.coefficients;
        int[] nArray3 = genericGFPoly.coefficients;
        if (nArray2.length > nArray3.length) {
            nArray = nArray2;
            nArray2 = nArray3;
            nArray3 = nArray;
        }
        nArray = new int[nArray3.length];
        int n2 = nArray3.length - nArray2.length;
        System.arraycopy(nArray3, 0, nArray, 0, n2);
        for (int i2 = n2; i2 < nArray3.length; ++i2) {
            nArray[i2] = GenericGF.addOrSubtract(nArray2[i2 - n2], nArray3[i2]);
        }
        return new GenericGFPoly(this.field, nArray);
    }

    GenericGFPoly multiply(GenericGFPoly genericGFPoly) {
        if (!this.field.equals(genericGFPoly.field)) {
            throw new IllegalArgumentException("GenericGFPolys do not have same GenericGF field");
        }
        if (this.isZero() || genericGFPoly.isZero()) {
            return this.field.getZero();
        }
        int[] nArray = this.coefficients;
        int n2 = nArray.length;
        int[] nArray2 = genericGFPoly.coefficients;
        int n3 = nArray2.length;
        int[] nArray3 = new int[n2 + n3 - 1];
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4 = nArray[i2];
            for (int i3 = 0; i3 < n3; ++i3) {
                nArray3[i2 + i3] = GenericGF.addOrSubtract(nArray3[i2 + i3], this.field.multiply(n4, nArray2[i3]));
            }
        }
        return new GenericGFPoly(this.field, nArray3);
    }

    GenericGFPoly multiply(int n2) {
        if (n2 == 0) {
            return this.field.getZero();
        }
        if (n2 == 1) {
            return this;
        }
        int n3 = this.coefficients.length;
        int[] nArray = new int[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            nArray[i2] = this.field.multiply(this.coefficients[i2], n2);
        }
        return new GenericGFPoly(this.field, nArray);
    }

    GenericGFPoly multiplyByMonomial(int n2, int n3) {
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        if (n3 == 0) {
            return this.field.getZero();
        }
        int n4 = this.coefficients.length;
        int[] nArray = new int[n4 + n2];
        for (int i2 = 0; i2 < n4; ++i2) {
            nArray[i2] = this.field.multiply(this.coefficients[i2], n3);
        }
        return new GenericGFPoly(this.field, nArray);
    }

    GenericGFPoly[] divide(GenericGFPoly genericGFPoly) {
        if (!this.field.equals(genericGFPoly.field)) {
            throw new IllegalArgumentException("GenericGFPolys do not have same GenericGF field");
        }
        if (genericGFPoly.isZero()) {
            throw new IllegalArgumentException("Divide by 0");
        }
        GenericGFPoly genericGFPoly2 = this.field.getZero();
        GenericGFPoly genericGFPoly3 = this;
        int n2 = genericGFPoly.getCoefficient(genericGFPoly.getDegree());
        int n3 = this.field.inverse(n2);
        while (genericGFPoly3.getDegree() >= genericGFPoly.getDegree() && !genericGFPoly3.isZero()) {
            int n4 = genericGFPoly3.getDegree() - genericGFPoly.getDegree();
            int n5 = this.field.multiply(genericGFPoly3.getCoefficient(genericGFPoly3.getDegree()), n3);
            GenericGFPoly genericGFPoly4 = genericGFPoly.multiplyByMonomial(n4, n5);
            GenericGFPoly genericGFPoly5 = this.field.buildMonomial(n4, n5);
            genericGFPoly2 = genericGFPoly2.addOrSubtract(genericGFPoly5);
            genericGFPoly3 = genericGFPoly3.addOrSubtract(genericGFPoly4);
        }
        return new GenericGFPoly[]{genericGFPoly2, genericGFPoly3};
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(8 * this.getDegree());
        for (int i2 = this.getDegree(); i2 >= 0; --i2) {
            int n2 = this.getCoefficient(i2);
            if (n2 == 0) continue;
            if (n2 < 0) {
                stringBuilder.append(" - ");
                n2 = -n2;
            } else if (stringBuilder.length() > 0) {
                stringBuilder.append(" + ");
            }
            if (i2 == 0 || n2 != 1) {
                int n3 = this.field.log(n2);
                if (n3 == 0) {
                    stringBuilder.append('1');
                } else if (n3 == 1) {
                    stringBuilder.append('a');
                } else {
                    stringBuilder.append("a^");
                    stringBuilder.append(n3);
                }
            }
            if (i2 == 0) continue;
            if (i2 == 1) {
                stringBuilder.append('x');
                continue;
            }
            stringBuilder.append("x^");
            stringBuilder.append(i2);
        }
        return stringBuilder.toString();
    }
}

