/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.common.reedsolomon;

import com.google.zxing.common.reedsolomon.GenericGF;
import com.google.zxing.common.reedsolomon.GenericGFPoly;
import com.google.zxing.common.reedsolomon.ReedSolomonException;

public final class ReedSolomonDecoder {
    private final GenericGF field;

    public ReedSolomonDecoder(GenericGF genericGF) {
        this.field = genericGF;
    }

    public void decode(int[] nArray, int n2) throws ReedSolomonException {
        GenericGFPoly genericGFPoly = new GenericGFPoly(this.field, nArray);
        int[] nArray2 = new int[n2];
        boolean bl2 = true;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3;
            nArray2[nArray2.length - 1 - i2] = n3 = genericGFPoly.evaluateAt(this.field.exp(i2 + this.field.getGeneratorBase()));
            if (n3 == 0) continue;
            bl2 = false;
        }
        if (bl2) {
            return;
        }
        GenericGFPoly genericGFPoly2 = new GenericGFPoly(this.field, nArray2);
        GenericGFPoly[] genericGFPolyArray = this.runEuclideanAlgorithm(this.field.buildMonomial(n2, 1), genericGFPoly2, n2);
        GenericGFPoly genericGFPoly3 = genericGFPolyArray[0];
        GenericGFPoly genericGFPoly4 = genericGFPolyArray[1];
        int[] nArray3 = this.findErrorLocations(genericGFPoly3);
        int[] nArray4 = this.findErrorMagnitudes(genericGFPoly4, nArray3);
        for (int i3 = 0; i3 < nArray3.length; ++i3) {
            int n4 = nArray.length - 1 - this.field.log(nArray3[i3]);
            if (n4 < 0) {
                throw new ReedSolomonException("Bad error location");
            }
            nArray[n4] = GenericGF.addOrSubtract(nArray[n4], nArray4[i3]);
        }
    }

    private GenericGFPoly[] runEuclideanAlgorithm(GenericGFPoly genericGFPoly, GenericGFPoly genericGFPoly2, int n2) throws ReedSolomonException {
        GenericGFPoly genericGFPoly3;
        GenericGFPoly genericGFPoly4;
        if (genericGFPoly.getDegree() < genericGFPoly2.getDegree()) {
            genericGFPoly4 = genericGFPoly;
            genericGFPoly = genericGFPoly2;
            genericGFPoly2 = genericGFPoly4;
        }
        genericGFPoly4 = genericGFPoly;
        GenericGFPoly genericGFPoly5 = genericGFPoly2;
        GenericGFPoly genericGFPoly6 = this.field.getZero();
        GenericGFPoly genericGFPoly7 = this.field.getOne();
        while (genericGFPoly5.getDegree() >= n2 / 2) {
            GenericGFPoly genericGFPoly8 = genericGFPoly4;
            GenericGFPoly genericGFPoly9 = genericGFPoly6;
            genericGFPoly4 = genericGFPoly5;
            genericGFPoly6 = genericGFPoly7;
            if (genericGFPoly4.isZero()) {
                throw new ReedSolomonException("r_{i-1} was zero");
            }
            genericGFPoly5 = genericGFPoly8;
            genericGFPoly3 = this.field.getZero();
            int n3 = genericGFPoly4.getCoefficient(genericGFPoly4.getDegree());
            int n4 = this.field.inverse(n3);
            while (genericGFPoly5.getDegree() >= genericGFPoly4.getDegree() && !genericGFPoly5.isZero()) {
                int n5 = genericGFPoly5.getDegree() - genericGFPoly4.getDegree();
                int n6 = this.field.multiply(genericGFPoly5.getCoefficient(genericGFPoly5.getDegree()), n4);
                genericGFPoly3 = genericGFPoly3.addOrSubtract(this.field.buildMonomial(n5, n6));
                genericGFPoly5 = genericGFPoly5.addOrSubtract(genericGFPoly4.multiplyByMonomial(n5, n6));
            }
            genericGFPoly7 = genericGFPoly3.multiply(genericGFPoly6).addOrSubtract(genericGFPoly9);
            if (genericGFPoly5.getDegree() < genericGFPoly4.getDegree()) continue;
            throw new IllegalStateException("Division algorithm failed to reduce polynomial?");
        }
        int n7 = genericGFPoly7.getCoefficient(0);
        if (n7 == 0) {
            throw new ReedSolomonException("sigmaTilde(0) was zero");
        }
        int n8 = this.field.inverse(n7);
        genericGFPoly3 = genericGFPoly7.multiply(n8);
        GenericGFPoly genericGFPoly10 = genericGFPoly5.multiply(n8);
        return new GenericGFPoly[]{genericGFPoly3, genericGFPoly10};
    }

    private int[] findErrorLocations(GenericGFPoly genericGFPoly) throws ReedSolomonException {
        int n2 = genericGFPoly.getDegree();
        if (n2 == 1) {
            return new int[]{genericGFPoly.getCoefficient(1)};
        }
        int[] nArray = new int[n2];
        int n3 = 0;
        for (int i2 = 1; i2 < this.field.getSize() && n3 < n2; ++i2) {
            if (genericGFPoly.evaluateAt(i2) != 0) continue;
            nArray[n3] = this.field.inverse(i2);
            ++n3;
        }
        if (n3 != n2) {
            throw new ReedSolomonException("Error locator degree does not match number of roots");
        }
        return nArray;
    }

    private int[] findErrorMagnitudes(GenericGFPoly genericGFPoly, int[] nArray) {
        int n2 = nArray.length;
        int[] nArray2 = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = this.field.inverse(nArray[i2]);
            int n4 = 1;
            for (int i3 = 0; i3 < n2; ++i3) {
                if (i2 == i3) continue;
                int n5 = this.field.multiply(nArray[i3], n3);
                int n6 = (n5 & 1) == 0 ? n5 | 1 : n5 & 0xFFFFFFFE;
                n4 = this.field.multiply(n4, n6);
            }
            nArray2[i2] = this.field.multiply(genericGFPoly.evaluateAt(n3), this.field.inverse(n4));
            if (this.field.getGeneratorBase() == 0) continue;
            nArray2[i2] = this.field.multiply(nArray2[i2], n3);
        }
        return nArray2;
    }
}

