/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.common.reedsolomon;

import com.google.zxing.common.reedsolomon.GenericGF;
import com.google.zxing.common.reedsolomon.GenericGFPoly;
import java.util.ArrayList;
import java.util.List;

public final class ReedSolomonEncoder {
    private final GenericGF field;
    private final List<GenericGFPoly> cachedGenerators;

    public ReedSolomonEncoder(GenericGF genericGF) {
        this.field = genericGF;
        this.cachedGenerators = new ArrayList<GenericGFPoly>();
        this.cachedGenerators.add(new GenericGFPoly(genericGF, new int[]{1}));
    }

    private GenericGFPoly buildGenerator(int n2) {
        if (n2 >= this.cachedGenerators.size()) {
            GenericGFPoly genericGFPoly = this.cachedGenerators.get(this.cachedGenerators.size() - 1);
            for (int i2 = this.cachedGenerators.size(); i2 <= n2; ++i2) {
                GenericGFPoly genericGFPoly2 = genericGFPoly.multiply(new GenericGFPoly(this.field, new int[]{1, this.field.exp(i2 - 1 + this.field.getGeneratorBase())}));
                this.cachedGenerators.add(genericGFPoly2);
                genericGFPoly = genericGFPoly2;
            }
        }
        return this.cachedGenerators.get(n2);
    }

    public void encode(int[] nArray, int n2) {
        if (n2 == 0) {
            throw new IllegalArgumentException("No error correction bytes");
        }
        int n3 = nArray.length - n2;
        if (n3 <= 0) {
            throw new IllegalArgumentException("No data bytes provided");
        }
        GenericGFPoly genericGFPoly = this.buildGenerator(n2);
        int[] nArray2 = new int[n3];
        System.arraycopy(nArray, 0, nArray2, 0, n3);
        GenericGFPoly genericGFPoly2 = new GenericGFPoly(this.field, nArray2);
        genericGFPoly2 = genericGFPoly2.multiplyByMonomial(n2, 1);
        GenericGFPoly genericGFPoly3 = genericGFPoly2.divide(genericGFPoly)[1];
        int[] nArray3 = genericGFPoly3.getCoefficients();
        int n4 = n2 - nArray3.length;
        for (int i2 = 0; i2 < n4; ++i2) {
            nArray[n3 + i2] = 0;
        }
        System.arraycopy(nArray3, 0, nArray, n3 + n4, nArray3.length);
    }
}

