/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.datamatrix;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.ChecksumException;
import com.google.zxing.DecodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.NotFoundException;
import com.google.zxing.Reader;
import com.google.zxing.Result;
import com.google.zxing.ResultMetadataType;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.DecoderResult;
import com.google.zxing.common.DetectorResult;
import com.google.zxing.datamatrix.decoder.Decoder;
import com.google.zxing.datamatrix.detector.Detector;
import java.util.List;
import java.util.Map;

public final class DataMatrixReader
implements Reader {
    private static final ResultPoint[] NO_POINTS = new ResultPoint[0];
    private final Decoder decoder = new Decoder();

    @Override
    public Result decode(BinaryBitmap binaryBitmap) throws NotFoundException, ChecksumException, FormatException {
        return this.decode(binaryBitmap, null);
    }

    @Override
    public Result decode(BinaryBitmap binaryBitmap, Map<DecodeHintType, ?> map) throws NotFoundException, ChecksumException, FormatException {
        String string2;
        ResultPoint[] resultPointArray;
        DecoderResult decoderResult;
        Object object;
        if (map != null && map.containsKey((Object)DecodeHintType.PURE_BARCODE)) {
            object = DataMatrixReader.extractPureBits(binaryBitmap.getBlackMatrix());
            decoderResult = this.decoder.decode((BitMatrix)object);
            resultPointArray = NO_POINTS;
        } else {
            object = new Detector(binaryBitmap.getBlackMatrix()).detect();
            decoderResult = this.decoder.decode(((DetectorResult)object).getBits());
            resultPointArray = ((DetectorResult)object).getPoints();
        }
        object = new Result(decoderResult.getText(), decoderResult.getRawBytes(), resultPointArray, BarcodeFormat.DATA_MATRIX);
        List<byte[]> list = decoderResult.getByteSegments();
        if (list != null) {
            ((Result)object).putMetadata(ResultMetadataType.BYTE_SEGMENTS, list);
        }
        if ((string2 = decoderResult.getECLevel()) != null) {
            ((Result)object).putMetadata(ResultMetadataType.ERROR_CORRECTION_LEVEL, string2);
        }
        return object;
    }

    @Override
    public void reset() {
    }

    private static BitMatrix extractPureBits(BitMatrix bitMatrix) throws NotFoundException {
        int[] nArray = bitMatrix.getTopLeftOnBit();
        int[] nArray2 = bitMatrix.getBottomRightOnBit();
        if (nArray == null || nArray2 == null) {
            throw NotFoundException.getNotFoundInstance();
        }
        int n2 = DataMatrixReader.moduleSize(nArray, bitMatrix);
        int n3 = nArray[1];
        int n4 = nArray2[1];
        int n5 = nArray[0];
        int n6 = nArray2[0];
        int n7 = (n6 - n5 + 1) / n2;
        int n8 = (n4 - n3 + 1) / n2;
        if (n7 <= 0 || n8 <= 0) {
            throw NotFoundException.getNotFoundInstance();
        }
        int n9 = n2 / 2;
        n3 += n9;
        n5 += n9;
        BitMatrix bitMatrix2 = new BitMatrix(n7, n8);
        for (int i2 = 0; i2 < n8; ++i2) {
            int n10 = n3 + i2 * n2;
            for (int i3 = 0; i3 < n7; ++i3) {
                if (!bitMatrix.get(n5 + i3 * n2, n10)) continue;
                bitMatrix2.set(i3, i2);
            }
        }
        return bitMatrix2;
    }

    private static int moduleSize(int[] nArray, BitMatrix bitMatrix) throws NotFoundException {
        int n2;
        int n3 = bitMatrix.getWidth();
        int n4 = nArray[1];
        for (n2 = nArray[0]; n2 < n3 && bitMatrix.get(n2, n4); ++n2) {
        }
        if (n2 == n3) {
            throw NotFoundException.getNotFoundInstance();
        }
        int n5 = n2 - nArray[0];
        if (n5 == 0) {
            throw NotFoundException.getNotFoundInstance();
        }
        return n5;
    }
}

