/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.datamatrix;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.Dimension;
import com.google.zxing.EncodeHintType;
import com.google.zxing.Writer;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.datamatrix.encoder.DefaultPlacement;
import com.google.zxing.datamatrix.encoder.ErrorCorrection;
import com.google.zxing.datamatrix.encoder.HighLevelEncoder;
import com.google.zxing.datamatrix.encoder.SymbolInfo;
import com.google.zxing.datamatrix.encoder.SymbolShapeHint;
import com.google.zxing.qrcode.encoder.ByteMatrix;
import java.util.Map;

public final class DataMatrixWriter
implements Writer {
    @Override
    public BitMatrix encode(String string2, BarcodeFormat barcodeFormat, int n2, int n3) {
        return this.encode(string2, barcodeFormat, n2, n3, null);
    }

    @Override
    public BitMatrix encode(String string2, BarcodeFormat barcodeFormat, int n2, int n3, Map<EncodeHintType, ?> map) {
        Object object;
        Object object2;
        Object object3;
        if (string2.isEmpty()) {
            throw new IllegalArgumentException("Found empty contents");
        }
        if (barcodeFormat != BarcodeFormat.DATA_MATRIX) {
            throw new IllegalArgumentException("Can only encode DATA_MATRIX, but got " + (Object)((Object)barcodeFormat));
        }
        if (n2 < 0 || n3 < 0) {
            throw new IllegalArgumentException("Requested dimensions are too small: " + n2 + 'x' + n3);
        }
        Object object4 = SymbolShapeHint.FORCE_NONE;
        Object object5 = null;
        Object object6 = null;
        if (map != null) {
            object3 = (SymbolShapeHint)((Object)map.get((Object)EncodeHintType.DATA_MATRIX_SHAPE));
            if (object3 != null) {
                object4 = object3;
            }
            if ((object2 = (Dimension)map.get((Object)EncodeHintType.MIN_SIZE)) != null) {
                object5 = object2;
            }
            if ((object = (Dimension)map.get((Object)EncodeHintType.MAX_SIZE)) != null) {
                object6 = object;
            }
        }
        object3 = HighLevelEncoder.encodeHighLevel(string2, object4, object5, object6);
        object2 = SymbolInfo.lookup(((String)object3).length(), object4, object5, object6, true);
        object = ErrorCorrection.encodeECC200((String)object3, (SymbolInfo)object2);
        DefaultPlacement defaultPlacement = new DefaultPlacement((CharSequence)object, ((SymbolInfo)object2).getSymbolDataWidth(), ((SymbolInfo)object2).getSymbolDataHeight());
        defaultPlacement.place();
        return DataMatrixWriter.encodeLowLevel(defaultPlacement, (SymbolInfo)object2);
    }

    private static BitMatrix encodeLowLevel(DefaultPlacement defaultPlacement, SymbolInfo symbolInfo) {
        int n2 = symbolInfo.getSymbolDataWidth();
        int n3 = symbolInfo.getSymbolDataHeight();
        ByteMatrix byteMatrix = new ByteMatrix(symbolInfo.getSymbolWidth(), symbolInfo.getSymbolHeight());
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n5;
            int n6;
            if (i2 % symbolInfo.matrixHeight == 0) {
                n6 = 0;
                for (n5 = 0; n5 < symbolInfo.getSymbolWidth(); ++n5) {
                    byteMatrix.set(n6, n4, n5 % 2 == 0);
                    ++n6;
                }
                ++n4;
            }
            n6 = 0;
            for (n5 = 0; n5 < n2; ++n5) {
                if (n5 % symbolInfo.matrixWidth == 0) {
                    byteMatrix.set(n6, n4, true);
                    ++n6;
                }
                byteMatrix.set(n6, n4, defaultPlacement.getBit(n5, i2));
                ++n6;
                if (n5 % symbolInfo.matrixWidth != symbolInfo.matrixWidth - 1) continue;
                byteMatrix.set(n6, n4, i2 % 2 == 0);
                ++n6;
            }
            ++n4;
            if (i2 % symbolInfo.matrixHeight != symbolInfo.matrixHeight - 1) continue;
            n6 = 0;
            for (n5 = 0; n5 < symbolInfo.getSymbolWidth(); ++n5) {
                byteMatrix.set(n6, n4, true);
                ++n6;
            }
            ++n4;
        }
        return DataMatrixWriter.convertByteMatrixToBitMatrix(byteMatrix);
    }

    private static BitMatrix convertByteMatrixToBitMatrix(ByteMatrix byteMatrix) {
        int n2 = byteMatrix.getWidth();
        int n3 = byteMatrix.getHeight();
        BitMatrix bitMatrix = new BitMatrix(n2, n3);
        bitMatrix.clear();
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = 0; i3 < n3; ++i3) {
                if (byteMatrix.get(i2, i3) != 1) continue;
                bitMatrix.set(i2, i3);
            }
        }
        return bitMatrix;
    }
}

