/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.datamatrix.decoder;

import com.google.zxing.FormatException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.datamatrix.decoder.Version;

final class BitMatrixParser {
    private final BitMatrix mappingBitMatrix;
    private final BitMatrix readMappingMatrix;
    private final Version version;

    BitMatrixParser(BitMatrix bitMatrix) throws FormatException {
        int n2 = bitMatrix.getHeight();
        if (n2 < 8 || n2 > 144 || (n2 & 1) != 0) {
            throw FormatException.getFormatInstance();
        }
        this.version = BitMatrixParser.readVersion(bitMatrix);
        this.mappingBitMatrix = this.extractDataRegion(bitMatrix);
        this.readMappingMatrix = new BitMatrix(this.mappingBitMatrix.getWidth(), this.mappingBitMatrix.getHeight());
    }

    Version getVersion() {
        return this.version;
    }

    private static Version readVersion(BitMatrix bitMatrix) throws FormatException {
        int n2 = bitMatrix.getHeight();
        int n3 = bitMatrix.getWidth();
        return Version.getVersionForDimensions(n2, n3);
    }

    byte[] readCodewords() throws FormatException {
        byte[] byArray = new byte[this.version.getTotalCodewords()];
        int n2 = 0;
        int n3 = 4;
        int n4 = 0;
        int n5 = this.mappingBitMatrix.getHeight();
        int n6 = this.mappingBitMatrix.getWidth();
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        do {
            if (n3 == n5 && n4 == 0 && !bl2) {
                byArray[n2++] = (byte)this.readCorner1(n5, n6);
                n3 -= 2;
                n4 += 2;
                bl2 = true;
                continue;
            }
            if (n3 == n5 - 2 && n4 == 0 && (n6 & 3) != 0 && !bl3) {
                byArray[n2++] = (byte)this.readCorner2(n5, n6);
                n3 -= 2;
                n4 += 2;
                bl3 = true;
                continue;
            }
            if (n3 == n5 + 4 && n4 == 2 && (n6 & 7) == 0 && !bl4) {
                byArray[n2++] = (byte)this.readCorner3(n5, n6);
                n3 -= 2;
                n4 += 2;
                bl4 = true;
                continue;
            }
            if (n3 == n5 - 2 && n4 == 0 && (n6 & 7) == 4 && !bl5) {
                byArray[n2++] = (byte)this.readCorner4(n5, n6);
                n3 -= 2;
                n4 += 2;
                bl5 = true;
                continue;
            }
            do {
                if (n3 >= n5 || n4 < 0 || this.readMappingMatrix.get(n4, n3)) continue;
                byArray[n2++] = (byte)this.readUtah(n3, n4, n5, n6);
            } while ((n3 -= 2) >= 0 && (n4 += 2) < n6);
            ++n3;
            n4 += 3;
            do {
                if (n3 < 0 || n4 >= n6 || this.readMappingMatrix.get(n4, n3)) continue;
                byArray[n2++] = (byte)this.readUtah(n3, n4, n5, n6);
            } while ((n3 += 2) < n5 && (n4 -= 2) >= 0);
            n3 += 3;
            ++n4;
        } while (n3 < n5 || n4 < n6);
        if (n2 != this.version.getTotalCodewords()) {
            throw FormatException.getFormatInstance();
        }
        return byArray;
    }

    boolean readModule(int n2, int n3, int n4, int n5) {
        if (n2 < 0) {
            n2 += n4;
            n3 += 4 - (n4 + 4 & 7);
        }
        if (n3 < 0) {
            n3 += n5;
            n2 += 4 - (n5 + 4 & 7);
        }
        this.readMappingMatrix.set(n3, n2);
        return this.mappingBitMatrix.get(n3, n2);
    }

    int readUtah(int n2, int n3, int n4, int n5) {
        int n6 = 0;
        if (this.readModule(n2 - 2, n3 - 2, n4, n5)) {
            n6 |= 1;
        }
        n6 <<= 1;
        if (this.readModule(n2 - 2, n3 - 1, n4, n5)) {
            n6 |= 1;
        }
        n6 <<= 1;
        if (this.readModule(n2 - 1, n3 - 2, n4, n5)) {
            n6 |= 1;
        }
        n6 <<= 1;
        if (this.readModule(n2 - 1, n3 - 1, n4, n5)) {
            n6 |= 1;
        }
        n6 <<= 1;
        if (this.readModule(n2 - 1, n3, n4, n5)) {
            n6 |= 1;
        }
        n6 <<= 1;
        if (this.readModule(n2, n3 - 2, n4, n5)) {
            n6 |= 1;
        }
        n6 <<= 1;
        if (this.readModule(n2, n3 - 1, n4, n5)) {
            n6 |= 1;
        }
        n6 <<= 1;
        if (this.readModule(n2, n3, n4, n5)) {
            n6 |= 1;
        }
        return n6;
    }

    int readCorner1(int n2, int n3) {
        int n4 = 0;
        if (this.readModule(n2 - 1, 0, n2, n3)) {
            n4 |= 1;
        }
        n4 <<= 1;
        if (this.readModule(n2 - 1, 1, n2, n3)) {
            n4 |= 1;
        }
        n4 <<= 1;
        if (this.readModule(n2 - 1, 2, n2, n3)) {
            n4 |= 1;
        }
        n4 <<= 1;
        if (this.readModule(0, n3 - 2, n2, n3)) {
            n4 |= 1;
        }
        n4 <<= 1;
        if (this.readModule(0, n3 - 1, n2, n3)) {
            n4 |= 1;
        }
        n4 <<= 1;
        if (this.readModule(1, n3 - 1, n2, n3)) {
            n4 |= 1;
        }
        n4 <<= 1;
        if (this.readModule(2, n3 - 1, n2, n3)) {
            n4 |= 1;
        }
        n4 <<= 1;
        if (this.readModule(3, n3 - 1, n2, n3)) {
            n4 |= 1;
        }
        return n4;
    }

    int readCorner2(int n2, int n3) {
        int n4 = 0;
        if (this.readModule(n2 - 3, 0, n2, n3)) {
            n4 |= 1;
        }
        n4 <<= 1;
        if (this.readModule(n2 - 2, 0, n2, n3)) {
            n4 |= 1;
        }
        n4 <<= 1;
        if (this.readModule(n2 - 1, 0, n2, n3)) {
            n4 |= 1;
        }
        n4 <<= 1;
        if (this.readModule(0, n3 - 4, n2, n3)) {
            n4 |= 1;
        }
        n4 <<= 1;
        if (this.readModule(0, n3 - 3, n2, n3)) {
            n4 |= 1;
        }
        n4 <<= 1;
        if (this.readModule(0, n3 - 2, n2, n3)) {
            n4 |= 1;
        }
        n4 <<= 1;
        if (this.readModule(0, n3 - 1, n2, n3)) {
            n4 |= 1;
        }
        n4 <<= 1;
        if (this.readModule(1, n3 - 1, n2, n3)) {
            n4 |= 1;
        }
        return n4;
    }

    int readCorner3(int n2, int n3) {
        int n4 = 0;
        if (this.readModule(n2 - 1, 0, n2, n3)) {
            n4 |= 1;
        }
        n4 <<= 1;
        if (this.readModule(n2 - 1, n3 - 1, n2, n3)) {
            n4 |= 1;
        }
        n4 <<= 1;
        if (this.readModule(0, n3 - 3, n2, n3)) {
            n4 |= 1;
        }
        n4 <<= 1;
        if (this.readModule(0, n3 - 2, n2, n3)) {
            n4 |= 1;
        }
        n4 <<= 1;
        if (this.readModule(0, n3 - 1, n2, n3)) {
            n4 |= 1;
        }
        n4 <<= 1;
        if (this.readModule(1, n3 - 3, n2, n3)) {
            n4 |= 1;
        }
        n4 <<= 1;
        if (this.readModule(1, n3 - 2, n2, n3)) {
            n4 |= 1;
        }
        n4 <<= 1;
        if (this.readModule(1, n3 - 1, n2, n3)) {
            n4 |= 1;
        }
        return n4;
    }

    int readCorner4(int n2, int n3) {
        int n4 = 0;
        if (this.readModule(n2 - 3, 0, n2, n3)) {
            n4 |= 1;
        }
        n4 <<= 1;
        if (this.readModule(n2 - 2, 0, n2, n3)) {
            n4 |= 1;
        }
        n4 <<= 1;
        if (this.readModule(n2 - 1, 0, n2, n3)) {
            n4 |= 1;
        }
        n4 <<= 1;
        if (this.readModule(0, n3 - 2, n2, n3)) {
            n4 |= 1;
        }
        n4 <<= 1;
        if (this.readModule(0, n3 - 1, n2, n3)) {
            n4 |= 1;
        }
        n4 <<= 1;
        if (this.readModule(1, n3 - 1, n2, n3)) {
            n4 |= 1;
        }
        n4 <<= 1;
        if (this.readModule(2, n3 - 1, n2, n3)) {
            n4 |= 1;
        }
        n4 <<= 1;
        if (this.readModule(3, n3 - 1, n2, n3)) {
            n4 |= 1;
        }
        return n4;
    }

    BitMatrix extractDataRegion(BitMatrix bitMatrix) {
        int n2 = this.version.getSymbolSizeRows();
        int n3 = this.version.getSymbolSizeColumns();
        if (bitMatrix.getHeight() != n2) {
            throw new IllegalArgumentException("Dimension of bitMarix must match the version size");
        }
        int n4 = this.version.getDataRegionSizeRows();
        int n5 = this.version.getDataRegionSizeColumns();
        int n6 = n2 / n4;
        int n7 = n3 / n5;
        int n8 = n6 * n4;
        int n9 = n7 * n5;
        BitMatrix bitMatrix2 = new BitMatrix(n9, n8);
        for (int i2 = 0; i2 < n6; ++i2) {
            int n10 = i2 * n4;
            for (int i3 = 0; i3 < n7; ++i3) {
                int n11 = i3 * n5;
                for (int i4 = 0; i4 < n4; ++i4) {
                    int n12 = i2 * (n4 + 2) + 1 + i4;
                    int n13 = n10 + i4;
                    for (int i5 = 0; i5 < n5; ++i5) {
                        int n14 = i3 * (n5 + 2) + 1 + i5;
                        if (!bitMatrix.get(n14, n12)) continue;
                        int n15 = n11 + i5;
                        bitMatrix2.set(n15, n13);
                    }
                }
            }
        }
        return bitMatrix2;
    }
}

