/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.datamatrix.decoder;

import com.google.zxing.FormatException;
import com.google.zxing.common.BitSource;
import com.google.zxing.common.DecoderResult;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;

final class DecodedBitStreamParser {
    private static final char[] C40_BASIC_SET_CHARS = new char[]{'*', '*', '*', ' ', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    private static final char[] C40_SHIFT2_SET_CHARS = new char[]{'!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', ':', ';', '<', '=', '>', '?', '@', '[', '\\', ']', '^', '_'};
    private static final char[] TEXT_BASIC_SET_CHARS = new char[]{'*', '*', '*', ' ', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private static final char[] TEXT_SHIFT3_SET_CHARS = new char[]{'`', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '{', '|', '}', '~', '\u007f'};

    private DecodedBitStreamParser() {
    }

    static DecoderResult decode(byte[] byArray) throws FormatException {
        BitSource bitSource = new BitSource(byArray);
        StringBuilder stringBuilder = new StringBuilder(100);
        StringBuilder stringBuilder2 = new StringBuilder(0);
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(1);
        Mode mode = Mode.ASCII_ENCODE;
        do {
            if (mode == Mode.ASCII_ENCODE) {
                mode = DecodedBitStreamParser.decodeAsciiSegment(bitSource, stringBuilder, stringBuilder2);
                continue;
            }
            switch (mode) {
                case C40_ENCODE: {
                    DecodedBitStreamParser.decodeC40Segment(bitSource, stringBuilder);
                    break;
                }
                case TEXT_ENCODE: {
                    DecodedBitStreamParser.decodeTextSegment(bitSource, stringBuilder);
                    break;
                }
                case ANSIX12_ENCODE: {
                    DecodedBitStreamParser.decodeAnsiX12Segment(bitSource, stringBuilder);
                    break;
                }
                case EDIFACT_ENCODE: {
                    DecodedBitStreamParser.decodeEdifactSegment(bitSource, stringBuilder);
                    break;
                }
                case BASE256_ENCODE: {
                    DecodedBitStreamParser.decodeBase256Segment(bitSource, stringBuilder, arrayList);
                    break;
                }
                default: {
                    throw FormatException.getFormatInstance();
                }
            }
            mode = Mode.ASCII_ENCODE;
        } while (mode != Mode.PAD_ENCODE && bitSource.available() > 0);
        if (stringBuilder2.length() > 0) {
            stringBuilder.append((CharSequence)stringBuilder2);
        }
        return new DecoderResult(byArray, stringBuilder.toString(), arrayList.isEmpty() ? null : arrayList, null);
    }

    private static Mode decodeAsciiSegment(BitSource bitSource, StringBuilder stringBuilder, StringBuilder stringBuilder2) throws FormatException {
        boolean bl2 = false;
        do {
            int n2;
            if ((n2 = bitSource.readBits(8)) == 0) {
                throw FormatException.getFormatInstance();
            }
            if (n2 <= 128) {
                if (bl2) {
                    n2 += 128;
                }
                stringBuilder.append((char)(n2 - 1));
                return Mode.ASCII_ENCODE;
            }
            if (n2 == 129) {
                return Mode.PAD_ENCODE;
            }
            if (n2 <= 229) {
                int n3 = n2 - 130;
                if (n3 < 10) {
                    stringBuilder.append('0');
                }
                stringBuilder.append(n3);
                continue;
            }
            if (n2 == 230) {
                return Mode.C40_ENCODE;
            }
            if (n2 == 231) {
                return Mode.BASE256_ENCODE;
            }
            if (n2 == 232) {
                stringBuilder.append('\u001d');
                continue;
            }
            if (n2 == 233 || n2 == 234) continue;
            if (n2 == 235) {
                bl2 = true;
                continue;
            }
            if (n2 == 236) {
                stringBuilder.append("[)>\u001e05\u001d");
                stringBuilder2.insert(0, "\u001e\u0004");
                continue;
            }
            if (n2 == 237) {
                stringBuilder.append("[)>\u001e06\u001d");
                stringBuilder2.insert(0, "\u001e\u0004");
                continue;
            }
            if (n2 == 238) {
                return Mode.ANSIX12_ENCODE;
            }
            if (n2 == 239) {
                return Mode.TEXT_ENCODE;
            }
            if (n2 == 240) {
                return Mode.EDIFACT_ENCODE;
            }
            if (n2 == 241 || n2 < 242 || n2 == 254 && bitSource.available() == 0) continue;
            throw FormatException.getFormatInstance();
        } while (bitSource.available() > 0);
        return Mode.ASCII_ENCODE;
    }

    private static void decodeC40Segment(BitSource bitSource, StringBuilder stringBuilder) throws FormatException {
        boolean bl2 = false;
        int[] nArray = new int[3];
        int n2 = 0;
        do {
            if (bitSource.available() == 8) {
                return;
            }
            int n3 = bitSource.readBits(8);
            if (n3 == 254) {
                return;
            }
            DecodedBitStreamParser.parseTwoBytes(n3, bitSource.readBits(8), nArray);
            block7: for (int i2 = 0; i2 < 3; ++i2) {
                int n4 = nArray[i2];
                switch (n2) {
                    case 0: {
                        char c2;
                        if (n4 < 3) {
                            n2 = n4 + 1;
                            continue block7;
                        }
                        if (n4 < C40_BASIC_SET_CHARS.length) {
                            c2 = C40_BASIC_SET_CHARS[n4];
                            if (bl2) {
                                stringBuilder.append((char)(c2 + 128));
                                bl2 = false;
                                continue block7;
                            }
                            stringBuilder.append(c2);
                            continue block7;
                        }
                        throw FormatException.getFormatInstance();
                    }
                    case 1: {
                        if (bl2) {
                            stringBuilder.append((char)(n4 + 128));
                            bl2 = false;
                        } else {
                            stringBuilder.append((char)n4);
                        }
                        n2 = 0;
                        continue block7;
                    }
                    case 2: {
                        char c2;
                        if (n4 < C40_SHIFT2_SET_CHARS.length) {
                            c2 = C40_SHIFT2_SET_CHARS[n4];
                            if (bl2) {
                                stringBuilder.append((char)(c2 + 128));
                                bl2 = false;
                            } else {
                                stringBuilder.append(c2);
                            }
                        } else if (n4 == 27) {
                            stringBuilder.append('\u001d');
                        } else if (n4 == 30) {
                            bl2 = true;
                        } else {
                            throw FormatException.getFormatInstance();
                        }
                        n2 = 0;
                        continue block7;
                    }
                    case 3: {
                        if (bl2) {
                            stringBuilder.append((char)(n4 + 224));
                            bl2 = false;
                        } else {
                            stringBuilder.append((char)(n4 + 96));
                        }
                        n2 = 0;
                        continue block7;
                    }
                    default: {
                        throw FormatException.getFormatInstance();
                    }
                }
            }
        } while (bitSource.available() > 0);
    }

    private static void decodeTextSegment(BitSource bitSource, StringBuilder stringBuilder) throws FormatException {
        boolean bl2 = false;
        int[] nArray = new int[3];
        int n2 = 0;
        do {
            if (bitSource.available() == 8) {
                return;
            }
            int n3 = bitSource.readBits(8);
            if (n3 == 254) {
                return;
            }
            DecodedBitStreamParser.parseTwoBytes(n3, bitSource.readBits(8), nArray);
            block7: for (int i2 = 0; i2 < 3; ++i2) {
                int n4 = nArray[i2];
                switch (n2) {
                    case 0: {
                        char c2;
                        if (n4 < 3) {
                            n2 = n4 + 1;
                            continue block7;
                        }
                        if (n4 < TEXT_BASIC_SET_CHARS.length) {
                            c2 = TEXT_BASIC_SET_CHARS[n4];
                            if (bl2) {
                                stringBuilder.append((char)(c2 + 128));
                                bl2 = false;
                                continue block7;
                            }
                            stringBuilder.append(c2);
                            continue block7;
                        }
                        throw FormatException.getFormatInstance();
                    }
                    case 1: {
                        if (bl2) {
                            stringBuilder.append((char)(n4 + 128));
                            bl2 = false;
                        } else {
                            stringBuilder.append((char)n4);
                        }
                        n2 = 0;
                        continue block7;
                    }
                    case 2: {
                        char c2;
                        if (n4 < C40_SHIFT2_SET_CHARS.length) {
                            c2 = C40_SHIFT2_SET_CHARS[n4];
                            if (bl2) {
                                stringBuilder.append((char)(c2 + 128));
                                bl2 = false;
                            } else {
                                stringBuilder.append(c2);
                            }
                        } else if (n4 == 27) {
                            stringBuilder.append('\u001d');
                        } else if (n4 == 30) {
                            bl2 = true;
                        } else {
                            throw FormatException.getFormatInstance();
                        }
                        n2 = 0;
                        continue block7;
                    }
                    case 3: {
                        char c2;
                        if (n4 < TEXT_SHIFT3_SET_CHARS.length) {
                            c2 = TEXT_SHIFT3_SET_CHARS[n4];
                            if (bl2) {
                                stringBuilder.append((char)(c2 + 128));
                                bl2 = false;
                            } else {
                                stringBuilder.append(c2);
                            }
                            n2 = 0;
                            continue block7;
                        }
                        throw FormatException.getFormatInstance();
                    }
                    default: {
                        throw FormatException.getFormatInstance();
                    }
                }
            }
        } while (bitSource.available() > 0);
    }

    private static void decodeAnsiX12Segment(BitSource bitSource, StringBuilder stringBuilder) throws FormatException {
        int[] nArray = new int[3];
        do {
            if (bitSource.available() == 8) {
                return;
            }
            int n2 = bitSource.readBits(8);
            if (n2 == 254) {
                return;
            }
            DecodedBitStreamParser.parseTwoBytes(n2, bitSource.readBits(8), nArray);
            for (int i2 = 0; i2 < 3; ++i2) {
                int n3 = nArray[i2];
                if (n3 == 0) {
                    stringBuilder.append('\r');
                    continue;
                }
                if (n3 == 1) {
                    stringBuilder.append('*');
                    continue;
                }
                if (n3 == 2) {
                    stringBuilder.append('>');
                    continue;
                }
                if (n3 == 3) {
                    stringBuilder.append(' ');
                    continue;
                }
                if (n3 < 14) {
                    stringBuilder.append((char)(n3 + 44));
                    continue;
                }
                if (n3 < 40) {
                    stringBuilder.append((char)(n3 + 51));
                    continue;
                }
                throw FormatException.getFormatInstance();
            }
        } while (bitSource.available() > 0);
    }

    private static void parseTwoBytes(int n2, int n3, int[] nArray) {
        int n4;
        int n5 = (n2 << 8) + n3 - 1;
        nArray[0] = n4 = n5 / 1600;
        n5 -= n4 * 1600;
        nArray[1] = n4 = n5 / 40;
        nArray[2] = n5 - n4 * 40;
    }

    private static void decodeEdifactSegment(BitSource bitSource, StringBuilder stringBuilder) {
        do {
            if (bitSource.available() <= 16) {
                return;
            }
            for (int i2 = 0; i2 < 4; ++i2) {
                int n2 = bitSource.readBits(6);
                if (n2 == 31) {
                    int n3 = 8 - bitSource.getBitOffset();
                    if (n3 != 8) {
                        bitSource.readBits(n3);
                    }
                    return;
                }
                if ((n2 & 0x20) == 0) {
                    n2 |= 0x40;
                }
                stringBuilder.append((char)n2);
            }
        } while (bitSource.available() > 0);
    }

    private static void decodeBase256Segment(BitSource bitSource, StringBuilder stringBuilder, Collection<byte[]> collection) throws FormatException {
        int n2 = 1 + bitSource.getByteOffset();
        int n3 = DecodedBitStreamParser.unrandomize255State(bitSource.readBits(8), n2++);
        int n4 = n3 == 0 ? bitSource.available() / 8 : (n3 < 250 ? n3 : 250 * (n3 - 249) + DecodedBitStreamParser.unrandomize255State(bitSource.readBits(8), n2++));
        if (n4 < 0) {
            throw FormatException.getFormatInstance();
        }
        byte[] byArray = new byte[n4];
        for (int i2 = 0; i2 < n4; ++i2) {
            if (bitSource.available() < 8) {
                throw FormatException.getFormatInstance();
            }
            byArray[i2] = (byte)DecodedBitStreamParser.unrandomize255State(bitSource.readBits(8), n2++);
        }
        collection.add(byArray);
        try {
            stringBuilder.append(new String(byArray, "ISO8859_1"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException("Platform does not support required encoding: " + unsupportedEncodingException);
        }
    }

    private static int unrandomize255State(int n2, int n3) {
        int n4 = 149 * n3 % 255 + 1;
        int n5 = n2 - n4;
        return n5 >= 0 ? n5 : n5 + 256;
    }

    private static enum Mode {
        PAD_ENCODE,
        ASCII_ENCODE,
        C40_ENCODE,
        TEXT_ENCODE,
        ANSIX12_ENCODE,
        EDIFACT_ENCODE,
        BASE256_ENCODE;

    }
}

